/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import javax.swing.Icon;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.StopwatchProfilingPoint;
import org.netbeans.modules.profiler.ppoints.Utils;
import org.netbeans.modules.profiler.ppoints.ui.StopwatchCustomizer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class StopwatchProfilingPointFactory
extends CodeProfilingPointFactory {
    private static final String PP_TYPE = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpType");
    private static final String PP_DESCR = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpDescr");
    private static final String PP_DEFAULT_NAME = NbBundle.getMessage(StopwatchProfilingPointFactory.class, (String)"StopwatchProfilingPointFactory_PpDefaultName");
    public static final String RESET_RESULTS_PP_TYPE = PP_TYPE;
    public static final String RESET_RESULTS_PP_DESCR = PP_DESCR;
    private static final String START_LOCATION_PREFIX = "start_";
    private static final String END_LOCATION_PREFIX = "end_";

    @Override
    public String getDescription() {
        return RESET_RESULTS_PP_DESCR;
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.Stopwatch");
    }

    @Override
    public Icon getDisabledIcon() {
        return Icons.getIcon((String)"ProfilingPointsIcons.StopwatchDisabled");
    }

    @Override
    public int getScope() {
        return 1;
    }

    @Override
    public String getType() {
        return RESET_RESULTS_PP_TYPE;
    }

    @Override
    public ProfilingPoint create(Lookup.Provider project) {
        CodeProfilingPoint.Location[] selectionLocations;
        if (project == null) {
            project = Utils.getCurrentProject();
        }
        if ((selectionLocations = Utils.getCurrentSelectionLocations()).length != 2) {
            CodeProfilingPoint.Location location = Utils.getCurrentLocation(Integer.MIN_VALUE);
            if (location.equals(CodeProfilingPoint.Location.EMPTY)) {
                String filename = "";
                String name = Utils.getUniqueName(this.getType(), "", project);
                return new StopwatchProfilingPoint(name, location, null, project, this);
            }
            File file = FileUtil.normalizeFile((File)new File(location.getFile()));
            String filename = FileUtil.toFileObject((File)file).getName();
            String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", filename, location.getLine()), project);
            return new StopwatchProfilingPoint(name, location, null, project, this);
        }
        CodeProfilingPoint.Location startLocation = selectionLocations[0];
        CodeProfilingPoint.Location endLocation = selectionLocations[1];
        File file = FileUtil.normalizeFile((File)new File(startLocation.getFile()));
        String filename = FileUtil.toFileObject((File)file).getName();
        String name = Utils.getUniqueName(this.getType(), MessageFormat.format(PP_DEFAULT_NAME, "", filename, startLocation.getLine()), project);
        return new StopwatchProfilingPoint(name, startLocation, endLocation, project, this);
    }

    @Override
    public boolean supportsCPU() {
        return true;
    }

    @Override
    public boolean supportsMemory() {
        return true;
    }

    @Override
    public boolean supportsMonitor() {
        return false;
    }

    @Override
    protected Class getProfilingPointsClass() {
        return StopwatchProfilingPoint.class;
    }

    @Override
    protected String getServerHandlerClassName() {
        return "org.netbeans.lib.profiler.global.ProfilingPointServerHandler";
    }

    @Override
    protected StopwatchCustomizer createCustomizer() {
        return new StopwatchCustomizer(this.getType(), this.getIcon());
    }

    @Override
    protected ProfilingPoint loadProfilingPoint(Lookup.Provider project, Properties properties, int index) {
        String name = properties.getProperty(index + "_" + "p_name", null);
        String enabledStr = properties.getProperty(index + "_" + "p_enabled", null);
        CodeProfilingPoint.Location startLocation = CodeProfilingPoint.Location.load(project, index, START_LOCATION_PREFIX, properties);
        CodeProfilingPoint.Location endLocation = CodeProfilingPoint.Location.load(project, index, END_LOCATION_PREFIX, properties);
        if (name == null || enabledStr == null || startLocation == null) {
            return null;
        }
        StopwatchProfilingPoint profilingPoint = null;
        try {
            profilingPoint = new StopwatchProfilingPoint(name, startLocation, endLocation, project, this);
            profilingPoint.setEnabled(Boolean.parseBoolean(enabledStr));
        }
        catch (Exception e) {
            ErrorManager.getDefault().log(65536, e.getMessage());
        }
        return profilingPoint;
    }

    @Override
    protected void storeProfilingPoint(ProfilingPoint profilingPoint, int index, Properties properties) {
        StopwatchProfilingPoint stopwatch = (StopwatchProfilingPoint)profilingPoint;
        properties.put(index + "_" + "p_name", stopwatch.getName());
        properties.put(index + "_" + "p_enabled", Boolean.toString(stopwatch.isEnabled()));
        stopwatch.getStartLocation().store(stopwatch.getProject(), index, START_LOCATION_PREFIX, properties);
        if (stopwatch.usesEndLocation()) {
            stopwatch.getEndLocation().store(stopwatch.getProject(), index, END_LOCATION_PREFIX, properties);
        }
    }
}

