/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.tag;

import java.awt.EventQueue;
import java.io.File;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.tag.ManageTags;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class ManageTagsAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(ManageTagsAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.showTagManager(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void showTagManager(final File repository, final String preselectedTag) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    Map tags = client.getTags((ProgressMonitor)this, true);
                    final ManageTags createTag = new ManageTags(repository, tags, preselectedTag);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            createTag.show();
                        }
                    });
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(ManageTagsAction.class, (String)"LBL_ManageTagsAction.listingTags.progressName"));
    }
}

