/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.tag;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.tag.CreateTag;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class CreateTagAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateTagAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createTag(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createTag(File repository, String preselectedRevision) {
        final CreateTag createTag = new CreateTag(repository, preselectedRevision);
        if (createTag.show()) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        LOG.log(Level.FINE, "Creating a tag: {0}/{1}", new Object[]{createTag.getTagName(), createTag.getRevision()});
                        GitTag tag = client.createTag(createTag.getTagName(), createTag.getRevision(), createTag.getTagMessage(), false, createTag.isForceUpdate(), (ProgressMonitor)this);
                        this.log(tag);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private void log(GitTag tag) {
                    OutputLogger logger = this.getLogger();
                    logger.output(NbBundle.getMessage(CreateTagAction.class, (String)"MSG_CreateTagAction.tagCreated", (Object[])new Object[]{tag.getTagName(), tag.getTaggedObjectId(), tag.getTagId(), tag.getTagger().toString(), tag.getMessage()}));
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction.progressName"));
        }
    }
}

