/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.fetch.FetchWizard;
import org.netbeans.modules.git.ui.fetch.GetRemoteChangesAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class FetchAction
extends GetRemoteChangesAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        this.fetch(repository);
    }

    public void fetch(final File repository, GitRemoteConfig remote) {
        if (remote.getUris().size() != 1) {
            Utils.post((Runnable)new Runnable(){

                @Override
                public void run() {
                    FetchAction.this.fetch(repository);
                }
            });
        } else {
            this.fetch(repository, (String)remote.getUris().get(0), remote.getFetchRefSpecs());
        }
    }

    private void fetch(File repository) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refreshRemotes();
        Map<String, GitRemoteConfig> remotes = info.getRemotes();
        FetchWizard wiz = new FetchWizard(repository, remotes);
        if (wiz.show()) {
            Utils.logVCSExternalRepository((String)"GIT", (String)wiz.getFetchUri());
            this.fetch(repository, wiz.getFetchUri(), wiz.getFetchRefSpecs());
        }
    }

    public void fetch(File repository, final String remote, final List<String> fetchRefSpecs) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    GitClient client = this.getClient();
                    Map updates = client.fetch(remote, fetchRefSpecs, (ProgressMonitor)this);
                    FetchAction.this.log(updates, this.getLogger());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction.progressName"));
    }
}

