/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.diff.DiffFileTable;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.MultiDiffPanel;
import org.netbeans.modules.git.ui.diff.Setup;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class MultiDiffPanelController
implements ActionListener,
PropertyChangeListener {
    private final VCSContext context;
    private EnumSet<FileInformation.Status> displayStatuses;
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private FileInformation.Mode mode;
    private final MultiDiffPanel panel;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private final PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    static final Logger LOG = Logger.getLogger(MultiDiffPanelController.class.getName());
    private DiffFileTable fileTable;
    private static final RequestProcessor RP = new RequestProcessor("GitDiffWindow", 1, true);
    private RequestProcessor.Task refreshNodesTask = RP.create((Runnable)new RefreshNodesTask());
    private final ApplyChangesTask applyChangeTask = new ApplyChangesTask();
    private RequestProcessor.Task changeTask = RP.create((Runnable)this.applyChangeTask);
    private boolean dividerSet;
    private final Map<File, Setup> setups = new HashMap<File, Setup>();
    private final Map<File, EditorCookie> editorCookies = new HashMap<File, EditorCookie>();
    private JComponent diffView;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private File currentFile;
    private boolean fileTableSetSelectedIndexContext;
    private final DiffLookup lookup = new DiffLookup();
    private GitProgressSupport statusRefreshSupport;
    PropertyChangeListener list;
    private final Map<File, FileStatusCache.ChangedEvent> changes = new HashMap<File, FileStatusCache.ChangedEvent>();

    public MultiDiffPanelController(VCSContext context) {
        this.context = context;
        this.panel = new MultiDiffPanel();
        this.diffViewPanel = null;
        this.initFileTable();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.initPanelMode();
        this.attachListeners();
        this.refreshComponents();
    }

    public MultiDiffPanelController(File file) {
        this.context = null;
        this.panel = new MultiDiffPanel();
        this.currentFile = file;
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.initPanelMode();
        this.attachListeners();
        this.refreshComponents();
    }

    public MultiDiffPanelController(File file, String rev1, String rev2) {
        this.context = null;
        this.currentFile = file;
        this.panel = new MultiDiffPanel();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        this.initToolbarButtons();
        this.initNextPrevActions();
        for (JComponent c : new JComponent[]{this.panel.tgbHeadVsIndex, this.panel.tgbHeadVsWorking, this.panel.tgbIndexVsWorking}) {
            c.setVisible(false);
        }
        Map<File, Setup> localSetups = Collections.singletonMap(this.currentFile, new Setup(file, rev1, rev2));
        this.setSetups(localSetups, Collections.<File, EditorCookie>emptyMap());
        this.setDiffIndex(file, 0, false);
        this.dpt = new DiffPrepareTask(this.setups.values().toArray(new Setup[this.setups.size()]));
        this.prepareTask = Utils.createTask((Runnable)this.dpt);
        this.prepareTask.schedule(0);
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.panel.removeAll();
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.panel.controlToolbar, "North");
        this.panel.add((Component)replacement, "Center");
    }

    void setActions(JComponent comp) {
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        comp.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        comp.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.panel.getActionMap().put("prevInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onNextInnerView();
            }
        });
        this.panel.getActionMap().put("nextInnerView", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onPrevInnerView();
            }
        });
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void attachListeners() {
        this.panel.tgbHeadVsWorking.addActionListener(this);
        this.panel.tgbHeadVsIndex.addActionListener(this);
        this.panel.tgbIndexVsWorking.addActionListener(this);
        this.panel.btnCommit.addActionListener(this);
        this.panel.btnRevert.addActionListener(this);
        this.panel.btnRefresh.addActionListener(this);
        this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)Git.getInstance().getFileStatusCache());
        Git.getInstance().getFileStatusCache().addPropertyChangeListener(this.list);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    boolean canClose() {
        if (this.setups.isEmpty()) {
            return true;
        }
        SaveCookie[] saveCookies = this.getSaveCookies(true);
        return saveCookies.length == 0 || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies);
    }

    public SaveCookie[] getSaveCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        SaveCookie[] saveCookies = this.getSaveCookies(editorCookiesCopy);
        return saveCookies;
    }

    public EditorCookie[] getEditorCookies(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.getEditorCookiesIntern(ommitOpened);
        int count = 0;
        int length = editorCookiesCopy.length;
        Object[] editorCookiesShorten = new EditorCookie[length];
        for (int i = 0; i < length; ++i) {
            EditorCookie editorCookie = editorCookiesCopy[i];
            if (editorCookie == null) continue;
            editorCookiesShorten[count++] = editorCookie;
        }
        return (EditorCookie[])CollectionUtils.shortenArray((Object[])editorCookiesShorten, (int)count);
    }

    private EditorCookie[] getEditorCookiesIntern(boolean ommitOpened) {
        EditorCookie[] editorCookiesCopy = this.editorCookies.values().toArray(new EditorCookie[this.editorCookies.values().size()]);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        if (ommitOpened) {
            DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        }
        return editorCookiesCopy;
    }

    private SaveCookie[] getSaveCookies(EditorCookie[] editorCookies) {
        LinkedList<EditorSaveCookie> proResult = new LinkedList<EditorSaveCookie>();
        HashSet<EditorCookie> editorCookieSet = new HashSet<EditorCookie>(Arrays.asList(editorCookies));
        for (Map.Entry<File, EditorCookie> e : this.editorCookies.entrySet()) {
            File baseFile;
            FileObject fileObj;
            if (!editorCookieSet.contains(e.getValue()) || (fileObj = FileUtil.toFileObject((File)(baseFile = e.getKey()))) == null) continue;
            proResult.add(new EditorSaveCookie(e.getValue(), fileObj.getNameExt()));
        }
        return proResult.toArray(new SaveCookie[proResult.size()]);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    public void componentClosed() {
        this.setSetups(Collections.<File, Setup>emptyMap(), Collections.<File, EditorCookie>emptyMap());
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
        this.setups.clear();
        this.editorCookies.clear();
    }

    private void cancelBackgroundTasks() {
        GitProgressSupport supp;
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        if ((supp = this.statusRefreshSupport) != null) {
            supp.cancel();
        }
    }

    void focus() {
        if (this.fileTable != null) {
            this.fileTable.focus();
        }
    }

    private void displayDiffView() {
        if (this.context != null) {
            int gg = this.panel.splitPane.getDividerLocation();
            this.panel.splitPane.setBottomComponent(this.diffView);
            this.panel.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.nextButton.toolTipText"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", NbBundle.getMessage(MultiDiffPanel.class, (String)"MultiDiffPanel.prevButton.toolTipText"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanelController.this.onPrevButton();
            }
        };
        this.panel.nextButton.setAction(this.nextAction);
        this.panel.prevButton.setAction(this.prevAction);
    }

    private void initFileTable() {
        this.fileTable = new DiffFileTable((VCSStatusTableModel<DiffNode>)new VCSStatusTableModel((VCSStatusNode[])new DiffNode[0]));
        this.fileTable.addPropertyChangeListener(this);
        this.panel.splitPane.setTopComponent(this.fileTable.getComponent());
        this.panel.splitPane.setBottomComponent(this.getInfoPanelLoading());
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.panel.btnCommit.setEnabled(false);
            this.panel.btnRevert.setEnabled(false);
        } else {
            this.panel.btnCommit.setVisible(false);
            this.panel.btnRevert.setVisible(false);
            this.panel.btnRefresh.setVisible(false);
        }
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        Setup setup = this.setups.get(this.currentFile);
        DiffController view = setup == null ? null : setup.getView();
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(currentDifferenceIndex < view.getDifferenceCount() - 1 || this.fileTable != null && this.fileTable.getNextFile(this.currentFile) != null);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(currentDifferenceIndex > 0 || this.fileTable != null && this.fileTable.getPrevFile(this.currentFile) != null);
    }

    private void onPrevInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.panel.tgbIndexVsWorking.setSelected(true);
        } else if (this.panel.tgbIndexVsWorking.isSelected()) {
            this.panel.tgbHeadVsIndex.setSelected(true);
        } else {
            this.panel.tgbHeadVsWorking.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onDisplayedStatusChanged() {
        if (this.panel.tgbHeadVsWorking.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_WORKING_TREE;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
            if (this.fileTable != null) {
                this.fileTable.setSelectedMode(GitClient.DiffMode.HEAD_VS_WORKINGTREE);
            }
        } else if (this.panel.tgbHeadVsIndex.isSelected()) {
            this.mode = FileInformation.Mode.HEAD_VS_INDEX;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
            if (this.fileTable != null) {
                this.fileTable.setSelectedMode(GitClient.DiffMode.HEAD_VS_INDEX);
            }
        } else {
            this.mode = FileInformation.Mode.INDEX_VS_WORKING_TREE;
            this.setDisplayStatuses(FileInformation.STATUS_MODIFIED_INDEX_VS_WORKING);
            if (this.context != null) {
                GitModuleConfig.getDefault().setLastUsedModificationContext(this.mode);
            }
            if (this.fileTable != null) {
                this.fileTable.setSelectedMode(GitClient.DiffMode.INDEX_VS_WORKINGTREE);
            }
        }
    }

    private void setDisplayStatuses(EnumSet<FileInformation.Status> displayStatuses) {
        this.displayStatuses = displayStatuses;
        if (this.context != null) {
            this.refreshNodes();
        } else {
            Map<File, Setup> localSetups = Collections.singletonMap(this.currentFile, new Setup(this.currentFile, this.mode, false));
            Map<File, EditorCookie> localCookies = MultiDiffPanelController.getCookiesFromSetups(localSetups);
            this.setSetups(localSetups, localCookies);
            this.dpt = new DiffPrepareTask(this.setups.values().toArray(new Setup[this.setups.size()]));
            this.prepareTask = Utils.createTask((Runnable)this.dpt);
            this.prepareTask.schedule(0);
        }
    }

    private void setSetups(Map<File, Setup> setups, Map<File, EditorCookie> editorCookies) {
        for (Map.Entry<File, Setup> e : this.setups.entrySet()) {
            Setup setup = e.getValue();
            if (setup == null) continue;
            setup.getFirstSource().close();
            setup.getSecondSource().close();
        }
        this.setups.clear();
        this.setups.putAll(setups);
        this.editorCookies.clear();
        this.editorCookies.putAll(editorCookies);
    }

    private void onNextButton() {
        DiffController view = this.setups.get(this.currentFile).getView();
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (++currentDifferenceIndex >= view.getDifferenceCount()) {
                File nextFile = this.fileTable.getNextFile(this.currentFile);
                if (nextFile != null) {
                    this.setDiffIndex(nextFile, 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else assert (false) : "Whats this?";
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController view = this.setups.get(this.currentFile).getView();
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (--currentDifferenceIndex < 0) {
                File prevFile = this.fileTable.getPrevFile(this.currentFile);
                if (prevFile != null) {
                    this.setDiffIndex(prevFile, -1, true);
                }
            } else if (currentDifferenceIndex < view.getDifferenceCount()) {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else assert (false) : "Whats this?";
        this.refreshComponents();
    }

    private void setDiffIndex(File file, int location, boolean restartPrepareTask) {
        this.currentFile = file;
        Setup setup = this.setups.get(this.currentFile);
        DiffController view = null;
        if (setup != null) {
            EditorCookie editorCookie;
            if (restartPrepareTask) {
                if (this.dpt != null) {
                    this.dpt.cancel();
                }
                this.startPrepareTask();
            }
            view = setup.getView();
            FileObject fileObj = FileUtil.toFileObject((File)this.currentFile);
            EditorCookie.Observable observableEditorCookie = null;
            TopComponent tc = (TopComponent)this.panel.getClientProperty(TopComponent.class);
            if (tc != null) {
                DiffNode node = setup.getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            if ((editorCookie = this.editorCookies.get(this.currentFile)) instanceof EditorCookie.Observable) {
                observableEditorCookie = (EditorCookie.Observable)editorCookie;
            }
            this.diffView = null;
            if (view != null) {
                if (this.fileTable != null) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedNodes(new File[]{this.currentFile});
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
            this.lookup.setData(new Object[]{fileObj, observableEditorCookie, this.diffView.getActionMap()});
        } else {
            this.lookup.setData(new Object[0]);
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.lookup.setData(new Object[]{this.diffView.getActionMap()});
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (e.getSource() == this.panel.tgbHeadVsIndex || e.getSource() == this.panel.tgbHeadVsWorking || e.getSource() == this.panel.tgbIndexVsWorking) {
            this.onDisplayedStatusChanged();
        } else {
            Utils.postParallel((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (e.getSource() == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRevert) {
                        ((RevertChangesAction)SystemAction.get(RevertChangesAction.class)).performAction(MultiDiffPanelController.this.context);
                    } else if (e.getSource() == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnCommit) {
                        ((CommitAction.GitViewCommitAction)SystemAction.get(CommitAction.GitViewCommitAction.class)).performAction(MultiDiffPanelController.this.context);
                    } else if (e.getSource() == ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRefresh) {
                        MultiDiffPanelController.this.statusRefreshSupport = ((StatusAction)SystemAction.get(StatusAction.class)).scanStatus(MultiDiffPanelController.this.context);
                        if (MultiDiffPanelController.this.statusRefreshSupport != null) {
                            MultiDiffPanelController.this.statusRefreshSupport.getTask().waitFinished();
                            if (!MultiDiffPanelController.this.statusRefreshSupport.isCanceled()) {
                                MultiDiffPanelController.this.refreshNodes();
                            }
                        }
                    }
                }
            }, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChange(FileStatusCache.ChangedEvent event) {
        if (this.context != null) {
            Map<File, FileStatusCache.ChangedEvent> map = this.changes;
            synchronized (map) {
                this.changes.put(event.getFile(), event);
            }
            this.changeTask.schedule(1000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("status.changed".equals(evt.getPropertyName())) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)evt.getNewValue();
            if (this.affectsView((FileStatusCache.ChangedEvent)evt.getNewValue())) {
                this.applyChange(changedEvent);
            }
            return;
        }
        if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            this.refreshComponents();
        } else if ("selectedFiles".equals(evt.getPropertyName())) {
            this.tableRowSelected((File[])evt.getNewValue());
        }
    }

    private boolean affectsView(FileStatusCache.ChangedEvent changedEvent) {
        File file = changedEvent.getFile();
        FileInformation oldInfo = changedEvent.getOldInfo();
        FileInformation newInfo = changedEvent.getNewInfo();
        if (oldInfo == null ? !newInfo.containsStatus(this.displayStatuses) : !oldInfo.containsStatus(this.displayStatuses) && !newInfo.containsStatus(this.displayStatuses)) {
            return false;
        }
        return this.context == null ? false : this.context.contains(file);
    }

    private void initPanelMode() {
        this.mode = GitModuleConfig.getDefault().getLastUsedModificationContext();
        this.panel.tgbHeadVsWorking.setSelected(true);
        switch (this.mode) {
            case HEAD_VS_WORKING_TREE: {
                this.panel.tgbHeadVsWorking.setSelected(true);
                break;
            }
            case HEAD_VS_INDEX: {
                this.panel.tgbHeadVsIndex.setSelected(true);
                break;
            }
            case INDEX_VS_WORKING_TREE: {
                this.panel.tgbIndexVsWorking.setSelected(true);
            }
        }
        this.onDisplayedStatusChanged();
    }

    private void updateSplitLocation() {
        Dimension dim;
        JComponent parent = (JComponent)this.panel.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanelController.this.updateSplitLocation();
                }
            });
            return;
        }
        JTable jt = this.fileTable.getDiffTable();
        int optimalLocation = jt.getPreferredSize().height + jt.getTableHeader().getPreferredSize().height;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= jt.getTableHeader().getPreferredSize().height) {
            optimalLocation = jt.getTableHeader().getPreferredSize().height * 3;
        }
        if (this.dividerSet && this.panel.splitPane.getDividerLocation() <= optimalLocation) {
            return;
        }
        this.panel.splitPane.setDividerLocation(optimalLocation);
        this.dividerSet = true;
    }

    public void tableRowSelected(File[] selectedFiles) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(selectedFiles.length == 1 ? selectedFiles[0] : null, 0, true);
    }

    private void refreshNodes() {
        if (this.context != null) {
            this.refreshNodesTask.cancel();
            this.refreshNodesTask.schedule(0);
        }
    }

    private void startPrepareTask() {
        Setup[] toInitialize = this.getSetupsToRefresh();
        if (toInitialize.length > 0) {
            this.dpt = new DiffPrepareTask(toInitialize);
            this.prepareTask = Utils.createTask((Runnable)this.dpt);
            this.prepareTask.schedule(0);
        }
    }

    private Setup[] getSetupsToRefresh() {
        LinkedList<Setup> toRefresh = new LinkedList<Setup>(Collections.singletonList(this.setups.get(this.currentFile)));
        for (int i = 1; i <= 2; ++i) {
            for (int sign : new int[]{1, -1}) {
                File file = this.fileTable.getNeighbouringFile(this.currentFile, sign * i);
                if (file == null) continue;
                toRefresh.add(this.setups.get(file));
            }
        }
        return toRefresh.toArray(new Setup[toRefresh.size()]);
    }

    private static Map<File, EditorCookie> getCookiesFromSetups(Map<File, Setup> localSetups) {
        AbstractDiffSetup[] retSetups = localSetups.values().toArray(new Setup[localSetups.values().size()]);
        EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])retSetups);
        HashMap<File, EditorCookie> map = new HashMap<File, EditorCookie>();
        for (int i = 0; i < cookies.length; ++i) {
            if (cookies[i] == null) continue;
            map.put(retSetups[i].getBaseFile(), cookies[i]);
        }
        return map;
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            assert (EventQueue.isDispatchThread());
            this.prepareSetups = prepareSetups;
        }

        @Override
        public void run() {
            this.canceled = false;
            IOException exception = null;
            for (final Setup setup : this.prepareSetups) {
                if (setup.getView() != null) continue;
                if (Thread.interrupted() || this.canceled) {
                    return;
                }
                try {
                    setup.initSources();
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    StreamSource ss1 = setup.getFirstSource();
                    StreamSource ss2 = setup.getSecondSource();
                    DiffController view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanelController.this);
                    if (Thread.interrupted() || this.canceled) {
                        return;
                    }
                    setup.setView(view);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (setup.getBaseFile().equals(MultiDiffPanelController.this.currentFile)) {
                                MultiDiffPanelController.this.setDiffIndex(setup.getBaseFile(), 0, false);
                            }
                        }
                    });
                }
                catch (IOException e) {
                    if (GitClientExceptionHandler.isCancelledAction(e)) continue;
                    LOG.log(Level.INFO, null, e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
            if (exception != null) {
                GitClientExceptionHandler.notifyException(exception, true);
            }
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }
    }

    private final class ApplyChangesTask
    extends RefreshViewTask
    implements Runnable {
        private ApplyChangesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet events;
            Map map = MultiDiffPanelController.this.changes;
            synchronized (map) {
                events = new HashSet(MultiDiffPanelController.this.changes.values());
                MultiDiffPanelController.this.changes.clear();
            }
            Iterator it = events.iterator();
            while (it.hasNext()) {
                FileStatusCache.ChangedEvent evt = (FileStatusCache.ChangedEvent)it.next();
                if (MultiDiffPanelController.this.affectsView(evt)) continue;
                it.remove();
            }
            Git git = Git.getInstance();
            Map nodes = (Map)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Map<File, DiffNode>>(){

                public Map<File, DiffNode> run() {
                    return MultiDiffPanelController.this.fileTable.getNodes();
                }
            });
            final LinkedList<DiffNode> toRemove = new LinkedList<DiffNode>();
            final LinkedList<DiffNode> toRefresh = new LinkedList<DiffNode>();
            final LinkedList<DiffNode> toAdd = new LinkedList<DiffNode>();
            for (FileStatusCache.ChangedEvent evt : events) {
                FileInformation newInfo = evt.getNewInfo();
                DiffNode node = (DiffNode)((Object)nodes.get(evt.getFile()));
                if (newInfo.containsStatus(MultiDiffPanelController.this.displayStatuses)) {
                    if (node != null) {
                        toRefresh.add(node);
                        continue;
                    }
                    File root = git.getRepositoryRoot(evt.getFile());
                    if (root == null) continue;
                    toAdd.add(new DiffNode(new GitFileNode(root, evt.getFile()), MultiDiffPanelController.this.mode));
                    continue;
                }
                if (node == null) continue;
                toRemove.add(node);
            }
            final Map<File, Setup> localSetups = this.computeSetups(toAdd);
            localSetups.putAll(this.computeSetups(toRefresh));
            final Map cookies = MultiDiffPanelController.getCookiesFromSetups(localSetups);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    for (DiffNode node : toAdd) {
                        MultiDiffPanelController.this.setups.put(node.getFile(), localSetups.get(node.getFile()));
                        EditorCookie cookie = (EditorCookie)cookies.get(node.getFile());
                        if (cookie == null) continue;
                        MultiDiffPanelController.this.editorCookies.put(node.getFile(), cookie);
                    }
                    for (DiffNode node : toRemove) {
                        MultiDiffPanelController.this.setups.remove(node.getFile());
                        MultiDiffPanelController.this.editorCookies.remove(node.getFile());
                    }
                    MultiDiffPanelController.this.fileTable.updateNodes(new HashMap<File, EditorCookie>(MultiDiffPanelController.this.editorCookies), toRemove, toRefresh, toAdd);
                    ApplyChangesTask.this.updateView();
                }
            });
        }
    }

    private final class RefreshNodesTask
    extends RefreshViewTask
    implements Runnable {
        private RefreshNodesTask() {
        }

        @Override
        public void run() {
            File[] interestingFiles;
            final LinkedList<DiffNode> nodes = new LinkedList<DiffNode>();
            Git git = Git.getInstance();
            for (File f : interestingFiles = git.getFileStatusCache().listFiles(MultiDiffPanelController.this.context.getRootFiles(), (EnumSet<FileInformation.Status>)MultiDiffPanelController.this.displayStatuses)) {
                File root = git.getRepositoryRoot(f);
                if (root == null) continue;
                nodes.add(new DiffNode(new GitFileNode(root, f), MultiDiffPanelController.this.mode));
            }
            final Map<File, Setup> localSetups = this.computeSetups(nodes);
            final Map cookies = MultiDiffPanelController.getCookiesFromSetups(localSetups);
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanelController.this.dividerSet = false;
                    MultiDiffPanelController.this.setSetups(localSetups, cookies);
                    MultiDiffPanelController.this.fileTable.setNodes(new HashMap<File, EditorCookie>(cookies), nodes.toArray(new DiffNode[nodes.size()]));
                    RefreshNodesTask.this.updateView();
                }
            });
        }
    }

    private class RefreshViewTask {
        private RefreshViewTask() {
        }

        protected void updateView() {
            if (MultiDiffPanelController.this.setups.isEmpty()) {
                String noContentLabel = "";
                switch (MultiDiffPanelController.this.mode) {
                    case HEAD_VS_WORKING_TREE: {
                        noContentLabel = NbBundle.getMessage(MultiDiffPanelController.class, (String)"MSG_No_Changes_HeadWorking");
                        break;
                    }
                    case HEAD_VS_INDEX: {
                        noContentLabel = NbBundle.getMessage(MultiDiffPanelController.class, (String)"MSG_No_Changes_HeadIndex");
                        break;
                    }
                    case INDEX_VS_WORKING_TREE: {
                        noContentLabel = NbBundle.getMessage(MultiDiffPanelController.class, (String)"MSG_No_Changes_IndexWorking");
                    }
                }
                MultiDiffPanelController.this.fileTable.getComponent().setEnabled(false);
                MultiDiffPanelController.this.fileTable.getComponent().setPreferredSize(null);
                Dimension dim = MultiDiffPanelController.this.fileTable.getComponent().getPreferredSize();
                MultiDiffPanelController.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                MultiDiffPanelController.this.diffView = (JComponent)new NoContentPanel(noContentLabel);
                MultiDiffPanelController.this.displayDiffView();
                MultiDiffPanelController.this.nextAction.setEnabled(false);
                MultiDiffPanelController.this.prevAction.setEnabled(false);
                ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnCommit.setEnabled(false);
                ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRevert.setEnabled(false);
            } else {
                MultiDiffPanelController.this.fileTable.getComponent().setEnabled(true);
                MultiDiffPanelController.this.fileTable.getComponent().setPreferredSize(null);
                Dimension dim = MultiDiffPanelController.this.fileTable.getComponent().getPreferredSize();
                MultiDiffPanelController.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnCommit.setEnabled(true);
                ((MultiDiffPanelController)MultiDiffPanelController.this).panel.btnRevert.setEnabled(true);
            }
            if (((MultiDiffPanelController)MultiDiffPanelController.this).panel.splitPane != null) {
                MultiDiffPanelController.this.updateSplitLocation();
            }
            MultiDiffPanelController.this.panel.revalidate();
            MultiDiffPanelController.this.panel.repaint();
        }

        protected Map<File, Setup> computeSetups(List<DiffNode> nodes) {
            HashMap<File, Setup> newSetups = new HashMap<File, Setup>(nodes.size());
            for (DiffNode node : nodes) {
                newSetups.put(node.getFile(), new Setup(node, MultiDiffPanelController.this.mode));
            }
            return newSetups;
        }
    }
}

