/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.utils.GitURI;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.ui.clone.RepositoryStepPanel;
import org.netbeans.modules.git.ui.repository.remote.RemoteRepository;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.netbeans.modules.git.utils.WizardStepProgressSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RepositoryStep
extends AbstractWizardPanel
implements ActionListener,
ChangeListener,
WizardDescriptor.AsynchronousValidatingPanel<WizardDescriptor> {
    private RepositoryStepProgressSupport support;
    private Map<String, GitBranch> branches;
    private Map<String, GitBranch> remoteBranches;
    private final RepositoryStepPanel panel;
    private final RemoteRepository repository;

    public RepositoryStep(String forPath) {
        this.repository = new RemoteRepository(forPath);
        this.repository.addChangeListener(this);
        this.panel = new RepositoryStepPanel(this.repository.getPanel());
        this.validateRepository();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void validateBeforeNext() {
        try {
            this.branches = null;
            if (!this.validateRepository()) {
                return;
            }
            File tempRepository = Utils.getTempFolder();
            GitURI uri = this.repository.getURI();
            if (uri != null) {
                this.repository.store();
                this.support = new RepositoryStepProgressSupport(this.panel.progressPanel, uri);
                RequestProcessor.Task task = this.support.start(Git.getInstance().getRequestProcessor(tempRepository), tempRepository, NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
                task.waitFinished();
                GitModuleConfig.getDefault().removeConnectionSettings(this.repository.getURI());
                final AbstractWizardPanel.Message message = this.support.message;
                if (message != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryStep.this.setValid(true, message);
                        }
                    });
                }
            }
        }
        finally {
            this.support = null;
            this.repository.setEnabled(true);
        }
    }

    private boolean validateRepository() {
        boolean valid = this.repository.isValid();
        this.setValid(valid, this.repository.getMessage());
        return valid;
    }

    public Map<String, GitBranch> getBranches() {
        return this.branches;
    }

    public GitURI getURI() {
        return this.repository.getURI();
    }

    @Override
    protected JComponent getJComponent() {
        return this.panel;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx(RepositoryStep.class);
    }

    public void prepareValidation() {
        this.repository.setEnabled(false);
    }

    public void cancelBackgroundTasks() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    public Map<String, GitBranch> getRemoteBranches() {
        return this.remoteBranches;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        this.setValid(this.repository.isValid(), this.repository.getMessage());
    }

    void store() {
        this.repository.store();
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        private final GitURI uri;
        private AbstractWizardPanel.Message message;

        public RepositoryStepProgressSupport(JPanel panel, GitURI uri) {
            super(panel, true);
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform() {
            try {
                GitClient client = Git.getInstance().getClient(this.getRepositoryRoot(), this, false);
                client.init((ProgressMonitor)this);
                RepositoryStep.this.branches = new HashMap();
                RepositoryStep.this.branches.putAll(client.listRemoteBranches(this.uri.toPrivateString(), (ProgressMonitor)this));
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                this.message = new AbstractWizardPanel.Message(ex.getMessage(), false);
                RepositoryStep.this.setValid(false, this.message);
            }
            finally {
                Utils.deleteRecursively((File)this.getRepositoryRoot());
                if (this.message == null && this.isCanceled()) {
                    this.message = new AbstractWizardPanel.Message(NbBundle.getMessage(RepositoryStep.class, (String)"MSG_RepositoryStep.validationCanceled"), true);
                    RepositoryStep.this.setValid(false, this.message);
                }
            }
        }

        @Override
        public void setEnabled(boolean editable) {
            RepositoryStep.this.repository.setEnabled(editable);
        }
    }
}

