/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.clone;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.utils.GitURI;
import org.netbeans.modules.git.ui.clone.CloneDestinationStep;
import org.netbeans.modules.git.ui.clone.FetchBranchesStep;
import org.netbeans.modules.git.ui.clone.RepositoryStep;
import org.netbeans.modules.git.ui.wizards.AbstractWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

class CloneWizard
implements ChangeListener {
    private PanelsIterator wizardIterator;
    private WizardDescriptor wizardDescriptor;
    private final String forPath;

    public CloneWizard(String forPath) {
        this.forPath = forPath;
    }

    boolean show() {
        boolean finnished;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CloneWizard.class, (String)"LBL_CloneWizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        this.setErrorMessage(this.wizardIterator.repositoryStep.getErrorMessage());
        dialog.setVisible(true);
        dialog.toFront();
        Object value = this.wizardDescriptor.getValue();
        boolean bl = finnished = value == WizardDescriptor.FINISH_OPTION;
        if (!(finnished || value != WizardDescriptor.CLOSED_OPTION && value != WizardDescriptor.CANCEL_OPTION)) {
            this.wizardIterator.repositoryStep.cancelBackgroundTasks();
        }
        return finnished;
    }

    private void setErrorMessage(AbstractWizardPanel.Message msg) {
        if (this.wizardDescriptor != null) {
            if (msg == null) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
            } else if (msg.isInfo()) {
                this.wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)msg.getMessage());
            } else {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg.getMessage());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        AbstractWizardPanel step = (AbstractWizardPanel)e.getSource();
        this.setErrorMessage(step.getErrorMessage());
    }

    GitURI getRemoteURI() {
        return this.wizardIterator.repositoryStep.getURI();
    }

    List<? extends GitBranch> getBranches() {
        return this.wizardIterator.fetchBranchesStep.getSelectedBranches();
    }

    File getDestination() {
        return this.wizardIterator.cloneDestinationStep.getDestination();
    }

    String getRemoteName() {
        return this.wizardIterator.cloneDestinationStep.getRemoteName();
    }

    GitBranch getBranch() {
        return this.wizardIterator.cloneDestinationStep.getBranch();
    }

    boolean scanForProjects() {
        return this.wizardIterator.cloneDestinationStep.scanForProjects();
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator<WizardDescriptor> {
        private RepositoryStep repositoryStep;
        private FetchBranchesStep fetchBranchesStep;
        private CloneDestinationStep cloneDestinationStep;

        private PanelsIterator() {
        }

        protected WizardDescriptor.Panel<WizardDescriptor>[] initializePanels() {
            this.repositoryStep = new RepositoryStep(CloneWizard.this.forPath);
            this.repositoryStep.addChangeListener(CloneWizard.this);
            this.fetchBranchesStep = new FetchBranchesStep();
            this.fetchBranchesStep.addChangeListener(CloneWizard.this);
            this.cloneDestinationStep = new CloneDestinationStep();
            this.cloneDestinationStep.addChangeListener(CloneWizard.this);
            WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{this.repositoryStep, this.fetchBranchesStep, this.cloneDestinationStep};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; ++i) {
                Component c = panels[i].getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panels;
        }

        public synchronized void nextPanel() {
            if (this.current() == this.repositoryStep) {
                Map<String, GitBranch> branches = this.repositoryStep.getBranches();
                this.fetchBranchesStep.fillRemoteBranches(branches.values());
                this.repositoryStep.store();
            } else if (this.current() == this.fetchBranchesStep) {
                this.cloneDestinationStep.setBranches(this.fetchBranchesStep.getSelectedBranches());
                this.cloneDestinationStep.initCloneName(this.repositoryStep.getURI());
            }
            super.nextPanel();
        }

        public synchronized void previousPanel() {
            super.previousPanel();
        }
    }
}

