/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class LogContext {
    private final EventType eventType;
    private final String message;
    private final StackTraceElement[] stackTrace;
    private final LogContext parent;
    private Queue<LogContext> absorbed;
    private static final Logger LOG = Logger.getLogger(LogContext.class.getName());
    private static final String LOG_MESSAGE = "SCAN_CANCELLED";

    public static LogContext create(@NonNull EventType eventType, @NullAllowed String message) {
        return LogContext.create(eventType, message, null);
    }

    public static LogContext create(@NonNull EventType eventType, @NullAllowed String message, @NullAllowed LogContext parent) {
        return new LogContext(eventType, Thread.currentThread().getStackTrace(), message, parent);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        this.createLogMessage(msg);
        return msg.toString();
    }

    void log() {
        LogRecord r = new LogRecord(Level.INFO, LOG_MESSAGE);
        r.setParameters(new Object[]{this});
        r.setResourceBundle(NbBundle.getBundle(LogContext.class));
        r.setResourceBundleName(LogContext.class.getPackage().getName() + ".Bundle");
        r.setLoggerName(LOG.getName());
        Exception e = new Exception("Scan canceled.");
        e.setStackTrace(this.stackTrace);
        r.setThrown(e);
        LOG.log(r);
    }

    synchronized void absorb(@NonNull LogContext other) {
        Parameters.notNull((CharSequence)"other", (Object)other);
        if (this.absorbed == null) {
            this.absorbed = new ArrayDeque<LogContext>();
        }
        this.absorbed.add(other);
    }

    private LogContext(@NonNull EventType eventType, @NonNull StackTraceElement[] stackTrace, @NullAllowed String message, @NullAllowed LogContext parent) {
        Parameters.notNull((CharSequence)"eventType", (Object)((Object)eventType));
        Parameters.notNull((CharSequence)"stackTrace", (Object)stackTrace);
        this.eventType = eventType;
        this.stackTrace = stackTrace;
        this.message = message;
        this.parent = parent;
    }

    private synchronized void createLogMessage(@NonNull StringBuilder sb) {
        sb.append("Type:").append((Object)this.eventType);
        if (this.message != null) {
            sb.append(" Description:").append(this.message);
        }
        sb.append('\n');
        for (StackTraceElement se : this.stackTrace) {
            sb.append(se).append('\n');
        }
        if (this.parent != null) {
            sb.append("Parent {");
            this.parent.createLogMessage(sb);
            sb.append("}\n");
        }
        if (this.absorbed != null) {
            sb.append("Absorbed {");
            for (LogContext a : this.absorbed) {
                a.createLogMessage(sb);
            }
            sb.append("}\n");
        }
    }

    public static enum EventType {
        PATH,
        FILE,
        INDEXER,
        MANAGER,
        UI;

    }
}

