/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nbform.project;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ClassSourceResolver
implements ClassSource.Resolver {
    private static final String TYPE_JAR = "jar";
    private static final String TYPE_LIBRARY = "library";
    private static final String TYPE_PROJECT = "project";

    public ClassSource.Entry resolve(String type, String name) {
        if (type.equals(TYPE_JAR)) {
            return new JarEntry(new File(name));
        }
        if (type.equals(TYPE_LIBRARY)) {
            Library lib;
            int hash = name.indexOf(35);
            if (hash != -1) {
                try {
                    lib = LibraryManager.forLocation((URL)new URL(name.substring(0, hash))).getLibrary(name.substring(hash + 1));
                }
                catch (IllegalArgumentException x) {
                    Exceptions.printStackTrace((Throwable)x);
                    return null;
                }
                catch (MalformedURLException x) {
                    Exceptions.printStackTrace((Throwable)x);
                    return null;
                }
            } else {
                lib = LibraryManager.getDefault().getLibrary(name);
            }
            return lib != null ? new LibraryEntry(lib) : null;
        }
        if (type.equals(TYPE_PROJECT)) {
            Project project;
            FileObject fob;
            File file = new File(name);
            if ((file = FileUtil.normalizeFile((File)file)).isDirectory() && (fob = FileUtil.toFileObject((File)file)) != null) {
                try {
                    project = ProjectManager.getDefault().findProject(fob);
                    if (project != null) {
                        return new ProjectEntry(project);
                    }
                }
                catch (IOException ioex) {
                    Exceptions.printStackTrace((Throwable)ioex);
                    return null;
                }
            }
            while (file != null && !file.exists()) {
                file = file.getParentFile();
            }
            if (file != null && (fob = FileUtil.toFileObject((File)file)) != null && (project = FileOwnerQuery.getOwner((FileObject)fob)) != null) {
                return new ProjectEntry(project);
            }
            return null;
        }
        return null;
    }

    private static URL translateURL(URL u) {
        if (FileUtil.isArchiveFile((URL)u)) {
            return FileUtil.getArchiveRoot((URL)u);
        }
        return u;
    }

    public static final class ProjectEntry
    extends ClassSource.Entry {
        private final Project project;

        public ProjectEntry(Project project) {
            assert (project != null);
            this.project = project;
        }

        public List<URL> getClasspath() {
            Sources sources = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] sgs = sources.getSourceGroups("java");
            ArrayList<URL> list = new ArrayList<URL>();
            for (SourceGroup sg : sgs) {
                try {
                    ClassPath cp = ClassPath.getClassPath((FileObject)sg.getRootFolder(), (String)"classpath/source");
                    if (cp == null) continue;
                    for (FileObject fob : cp.getRoots()) {
                        URL[] urls = UnitTestForSourceQuery.findSources((FileObject)fob);
                        if (urls.length != 0) continue;
                        BinaryForSourceQuery.Result result = BinaryForSourceQuery.findBinaryRoots((URL)fob.getURL());
                        list.addAll(Arrays.asList(result.getRoots()));
                    }
                }
                catch (FileStateInvalidException fsiex) {
                    FormUtils.LOGGER.log(Level.INFO, fsiex.getMessage(), fsiex);
                }
            }
            return list;
        }

        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            if (this.project != FileOwnerQuery.getOwner((FileObject)projectArtifact)) {
                return ProjectClassPathModifier.addProjects((Project[])new Project[]{this.project}, (FileObject)projectArtifact, (String)classPathType);
            }
            return Boolean.FALSE;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_ProjectSource", (Object)FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
        }

        public String getPicklingType() {
            return ClassSourceResolver.TYPE_PROJECT;
        }

        public String getPicklingName() {
            return FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
    }

    public static final class LibraryEntry
    extends ClassSource.Entry {
        private final Library lib;

        public LibraryEntry(Library lib) {
            assert (lib != null);
            this.lib = lib;
        }

        public Library getLibrary() {
            return this.lib;
        }

        public List<URL> getClasspath() {
            return this.lib.getContent("classpath");
        }

        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            return ProjectClassPathModifier.addLibraries((Library[])new Library[]{this.lib}, (FileObject)projectArtifact, (String)classPathType);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_LibrarySource", (Object)this.lib.getDisplayName());
        }

        public String getPicklingType() {
            return ClassSourceResolver.TYPE_LIBRARY;
        }

        public String getPicklingName() {
            LibraryManager mgr = this.lib.getManager();
            if (mgr == LibraryManager.getDefault()) {
                return this.lib.getName();
            }
            return mgr.getLocation() + "#" + this.lib.getName();
        }
    }

    public static final class JarEntry
    extends ClassSource.Entry {
        private final File jar;

        public JarEntry(File jar) {
            assert (jar != null);
            this.jar = jar;
        }

        public File getJar() {
            return this.jar;
        }

        public List<URL> getClasspath() {
            try {
                return Collections.singletonList(ClassSourceResolver.translateURL(this.jar.toURI().toURL()));
            }
            catch (MalformedURLException x) {
                assert (false) : x;
                return Collections.emptyList();
            }
        }

        public Boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
            URL u = this.jar.toURI().toURL();
            FileObject jarFile = FileUtil.toFileObject((File)this.jar);
            if (jarFile == null) {
                return Boolean.FALSE;
            }
            if (FileUtil.isArchiveFile((FileObject)jarFile)) {
                u = FileUtil.getArchiveRoot((URL)u);
            }
            return ProjectClassPathModifier.addRoots((URL[])new URL[]{u}, (FileObject)projectArtifact, (String)classPathType);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ClassSource.class, (String)"FMT_JarSource", (Object)this.jar.getAbsolutePath());
        }

        public String getPicklingType() {
            return ClassSourceResolver.TYPE_JAR;
        }

        public String getPicklingName() {
            return this.jar.getAbsolutePath();
        }
    }
}

