/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.api.jaxws.project.LogUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.projects.RestApplicationsPanel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebProjectRestSupport
extends WebRestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    String[] classPathTypes = new String[]{"classpath/compile"};

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject == null) {
                return;
            }
            WebApp webApp = this.findWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = this.getRestServletAdaptorByName(webApp, "ServletAdaptor");
            if (servlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servlet.getServletClass())) {
                boolean bl = this.hasSpringSupport();
                if (bl) {
                    servlet.setServletClass("com.sun.jersey.spi.spring.container.servlet.SpringServlet");
                    InitParam initParam = (InitParam)servlet.findBeanByName("InitParam", "ParamName", "com.sun.jersey.config.property.packages");
                    if (initParam == null) {
                        try {
                            initParam = (InitParam)servlet.createBean("InitParam");
                            initParam.setParamName("com.sun.jersey.config.property.packages");
                            initParam.setParamValue(".");
                            initParam.setDescription("Multiple packages, separated by semicolon(;), can be specified in param-value");
                            servlet.addInitParam(initParam);
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                } else {
                    servlet.setServletClass("com.sun.jersey.spi.container.servlet.ServletContainer");
                }
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void extendBuildScripts() throws IOException {
        new AntFilesHelper((RestSupport)this).initRestBuildExtension();
    }

    public void ensureRestDevelopmentReady() throws IOException {
        FileObject fileObject;
        JaxRsStackSupport jaxRsStackSupport;
        boolean bl = false;
        WebRestSupport.RestConfig restConfig = null;
        if (!this.isRestSupportOn()) {
            bl = true;
            restConfig = this.setApplicationConfigProperty(RestUtils.isAnnotationConfigAvailable(this.project));
        }
        this.extendBuildScripts();
        String string = this.getProjectProperty("rest.config.type");
        if (!RestUtils.isJSR_311OnClasspath(this.project)) {
            boolean bl2 = false;
            if (restConfig != null && restConfig.isServerJerseyLibSelected() && (jaxRsStackSupport = this.getJaxRsStackSupport()) != null) {
                bl2 = jaxRsStackSupport.addJsr311Api(this.project);
            }
            if (!bl2) {
                JaxRsStackSupport.getDefault().addJsr311Api(this.project);
            }
        }
        if (string == null || "dd".equals(string)) {
            String string2 = null;
            string2 = restConfig != null ? restConfig.getResourcePath() : this.getApplicationPathFromDD();
            if (string2 == null) {
                string2 = "/resources/*";
            }
            this.addResourceConfigToWebApp(string2);
        }
        if ("ide".equals(string) && (fileObject = Utils.findBuildXml(this.project)) != null) {
            ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"generate-rest-config"}, null);
        }
        boolean bl3 = false;
        if (restConfig != null) {
            if (restConfig.isServerJerseyLibSelected() && (jaxRsStackSupport = this.getJaxRsStackSupport()) != null) {
                bl3 = jaxRsStackSupport.extendsJerseyProjectClasspath(this.project);
            }
            if (!bl3) {
                JaxRsStackSupport.getDefault().extendsJerseyProjectClasspath(this.project);
            }
        }
        if (this.hasSpringSupport()) {
            this.addJerseySpringJar();
        }
        ProjectManager.getDefault().saveProject(this.getProject());
        if (bl) {
            this.refreshRestServicesMetadataModel();
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        this.removeProjectProperties(new String[]{"rest.config.type", "rest.resources.path"});
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    public J2eePlatform getPlatform() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        try {
            String string = j2eeModuleProvider.getServerInstanceID();
            if (string == null) {
                return null;
            }
            return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
        }
        catch (InstanceRemovedException instanceRemovedException) {
            return null;
        }
    }

    private J2eePlatform getJ2eePlatform(J2eeModuleProvider j2eeModuleProvider) {
        String string = j2eeModuleProvider.getServerInstanceID();
        if (string != null && string.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(WebProjectRestSupport.class.getName()).log(Level.INFO, "Failed to find J2eePlatform");
            }
        }
        return null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public Datasource getDatasource(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return j2eeModuleProvider.getConfigSupport().findDatasource(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setDirectoryDeploymentProperty(Properties properties) {
        String string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(J2EE_SERVER_INSTANCE);
        if (string != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String string2 = j2eeModuleProvider.getServerInstanceID();
            J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
            if (string2 != null && j2eeModule != null) {
                boolean bl = Deployment.getDefault().canFileDeploy(string, j2eeModule);
                properties.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, String.valueOf(bl));
            }
        }
    }

    public File getLocalTargetTestRest() {
        String string = "build/generated-sources/rest-test";
        AntProjectHelper antProjectHelper = this.getAntProjectHelper();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string2 = editableProperties.getProperty("restbeans.test.dir");
        if (string2 != null) {
            string = string2;
        }
        return antProjectHelper.resolveFile(string);
    }

    public FileObject generateTestClient(File file, String string) throws IOException {
        FileObject fileObject = this.generateTestClient(file);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("___BASE_URL___", string);
        WebProjectRestSupport.modifyFile((FileObject)fileObject, hashMap);
        return fileObject;
    }

    public String getBaseURL() throws IOException {
        String string = this.getApplicationPath();
        if (string != null && !string.startsWith("/")) {
            string = "/" + string;
        }
        return this.getContextRootURL() + "||" + string;
    }

    public void deploy() throws IOException {
        FileObject fileObject = Utils.findBuildXml(this.getProject());
        if (fileObject != null) {
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"run-deploy"}, (Properties)new Properties());
            executorTask.waitFinished();
        }
    }

    protected void logResourceCreation(Project project) {
        Object[] objectArray = new Object[]{"JAX-RS", this.project.getClass().getName(), "REST RESOURCE"};
        LogUtils.logWsDetect((Object[])objectArray);
    }

    public String getApplicationPath() throws IOException {
        String string = this.getApplicationPathFromDD();
        String string2 = this.getApplicationPathFromAnnotations(string);
        return string2 == null ? super.getApplicationPath() : string2;
    }

    private String getApplicationPathFromAnnotations(final String string) {
        List list = this.getRestApplications();
        if (string == null) {
            if (list.size() == 0) {
                return null;
            }
            return WebProjectRestSupport.getApplicationPathFromDialog(list);
        }
        if (list.size() == 0) {
            return string;
        }
        boolean bl = false;
        for (RestApplication restApplication : list) {
            if (!string.equals(restApplication.getApplicationPath())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            list.add(new RestApplication(){

                public String getApplicationPath() {
                    return string;
                }

                public String getApplicationClass() {
                    return "web.xml";
                }
            });
        }
        return WebProjectRestSupport.getApplicationPathFromDialog(list);
    }

    public static String getApplicationPathFromDialog(List<RestApplication> list) {
        if (list.size() == 1) {
            return list.get(0).getApplicationPath();
        }
        RestApplicationsPanel restApplicationsPanel = new RestApplicationsPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)restApplicationsPanel, NbBundle.getMessage(WebProjectRestSupport.class, (String)"TTL_RestResourcesPath"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            return restApplicationsPanel.getApplicationPath();
        }
        return null;
    }
}

