/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QuerySupportFactory;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.FindUsageSupport;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelFactory;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.refactoring.php.findusages.WarningFileElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class WhereUsedSupport {
    private ASTNode node;
    private FileObject fo;
    private int offset;
    private PhpElementKind kind;
    private final Set<ModelElement> declarations;
    private ModelElement modelElement;
    private Results results;
    private Set<FileObject> unopenedFiles;
    private Set<Modifier> modifier;
    private FindUsageSupport usageSupport;
    private ElementQuery.Index idx;

    private WhereUsedSupport(ElementQuery.Index idx, Set<ModelElement> declarations, ASTNode node, FileObject fo) {
        this(idx, declarations, node.getStartOffset(), fo);
        this.node = node;
    }

    private WhereUsedSupport(ElementQuery.Index idx, Set<ModelElement> declarations, int offset, FileObject fo) {
        this.fo = fo;
        this.declarations = declarations;
        this.offset = offset;
        this.idx = idx;
        this.setModelElement((ModelElement)ModelUtils.getFirst(declarations));
        this.kind = this.modelElement.getPhpElementKind();
        this.results = new Results();
    }

    void setModelElement(ModelElement modelElement) {
        this.modelElement = modelElement;
        this.usageSupport = FindUsageSupport.getInstance((ElementQuery.Index)this.idx, (ModelElement)this.modelElement);
    }

    public String getName() {
        return this.modelElement.getName();
    }

    public ASTNode getASTNode() {
        return this.node;
    }

    public int getOffset() {
        return this.offset;
    }

    public void clearResults() {
        if (this.results != null) {
            this.results.clear();
        }
    }

    public PhpElementKind getKind() {
        return this.kind;
    }

    public ElementKind getElementKind() {
        return this.modelElement.getPHPElement().getKind();
    }

    public Set<Modifier> getModifiers() {
        ModelElement attributeElement = this.getModelElement();
        return this.getModifiers(attributeElement);
    }

    public Results getResults() {
        return this.results;
    }

    void overridingMethods() {
        Collection methods = this.usageSupport.overridingMethods();
        for (MethodElement meth : methods) {
            this.results.addEntry((PhpElement)meth);
        }
    }

    void collectSubclasses() {
        Collection subclasses = this.usageSupport.subclasses();
        for (TypeElement typeElement : subclasses) {
            this.results.addEntry((PhpElement)typeElement);
        }
    }

    void collectDirectSubclasses() {
        Collection subclasses = this.usageSupport.directSubclasses();
        for (TypeElement typeElement : subclasses) {
            this.results.addEntry((PhpElement)typeElement);
        }
    }

    void collectUsages(FileObject fileObject) {
        Collection occurences = this.usageSupport.occurences(fileObject);
        for (Occurence occurence : occurences) {
            this.results.addEntry(fileObject, occurence);
        }
    }

    public static WhereUsedSupport getInstance(PHPParseResult info, int offset) {
        boolean canContinue;
        Model model = ModelFactory.getModel((PHPParseResult)info);
        Occurence occurence = model.getOccurencesSupport(offset).getOccurence();
        final HashSet<ModelElement> declarations = new HashSet<ModelElement>();
        Collection<Object> allDeclarations = occurence != null ? occurence.getAllDeclarations() : Collections.emptyList();
        boolean bl = canContinue = occurence != null && allDeclarations.size() > 0 && allDeclarations.size() < 5;
        if (canContinue && EnumSet.of(Occurence.Accuracy.EXACT, Occurence.Accuracy.MORE, Occurence.Accuracy.UNIQUE).contains(occurence.degreeOfAccuracy())) {
            for (final PhpElement phpElement : allDeclarations) {
                try {
                    FileObject fileObject = phpElement.getFileObject();
                    FileObject parserFo = info.getSnapshot().getSource().getFileObject();
                    if (fileObject != null && parserFo != fileObject) {
                        ParserManager.parse(Collections.singleton(Source.create((FileObject)fileObject)), (UserTask)new UserTask(){

                            public void run(ResultIterator resultIterator) throws Exception {
                                Parser.Result parserResult = resultIterator.getParserResult();
                                if (parserResult instanceof PHPParseResult) {
                                    Model modelForDeclaration = ModelFactory.getModel((PHPParseResult)((PHPParseResult)parserResult));
                                    declarations.add(modelForDeclaration.findDeclaration(phpElement));
                                }
                            }
                        });
                        continue;
                    }
                    declarations.add(model.findDeclaration(phpElement));
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
            ElementQuery.Index indexQuery = ElementQueryFactory.createIndexQuery((QuerySupport)QuerySupportFactory.get((ParserResult)info));
            FileObject fileObject = info.getSnapshot().getSource().getFileObject();
            return WhereUsedSupport.getInstance(declarations, indexQuery, fileObject, offset);
        }
        return null;
    }

    public static WhereUsedSupport getInstance(Set<ModelElement> declarations, ElementQuery.Index indexQuery, FileObject fileObject, int offset) {
        ModelElement declaration = (ModelElement)ModelUtils.getFirst(declarations);
        return declaration != null && declarations.size() > 0 ? new WhereUsedSupport(indexQuery, declarations, offset, fileObject) : null;
    }

    public ModelElement getModelElement() {
        return this.modelElement;
    }

    public List<ModelElement> getModelElements() {
        return new ArrayList<ModelElement>(this.declarations);
    }

    Set<FileObject> getRelevantFiles() {
        VariableName variable;
        ModelElement mElement = this.getModelElement();
        if (mElement instanceof VariableName ? !(variable = (VariableName)mElement).isGloballyVisible() : mElement != null && mElement.getPhpModifiers().isPrivate()) {
            return Collections.singleton(mElement.getFileObject());
        }
        return this.usageSupport.inFiles();
    }

    private Set<Modifier> getModifiers(ModelElement mElement) {
        if (this.modifier == null) {
            Set retval = Collections.emptySet();
            if (mElement != null && mElement.getInScope() instanceof TypeScope) {
                retval = new HashSet();
                if (mElement.getPhpModifiers().isPrivate()) {
                    retval.add(Modifier.PRIVATE);
                } else if (mElement.getPhpModifiers().isProtected()) {
                    retval.add(Modifier.PROTECTED);
                }
                if (mElement.getPhpModifiers().isPublic()) {
                    retval.add(Modifier.PUBLIC);
                }
                if (mElement.getPhpModifiers().isStatic()) {
                    retval.add(Modifier.STATIC);
                }
            }
            this.modifier = retval;
        }
        return this.modifier;
    }

    public static boolean isAlreadyInResults(ASTNode node, Set<ASTNode> results) {
        OffsetRange newOne = new OffsetRange(node.getStartOffset(), node.getEndOffset());
        for (ASTNode aSTNode : results) {
            OffsetRange oldOne = new OffsetRange(aSTNode.getStartOffset(), aSTNode.getEndOffset());
            if (!newOne.containsInclusive(oldOne.getStart()) && !oldOne.containsInclusive(newOne.getStart())) continue;
            return true;
        }
        return false;
    }

    public class Results {
        Collection<WhereUsedElement> elements = new TreeSet<WhereUsedElement>(new Comparator<WhereUsedElement>(){

            @Override
            public int compare(WhereUsedElement o1, WhereUsedElement o2) {
                String path2;
                String path1 = o1.getFile() != null ? o1.getFile().getPath() : "";
                int retval = path1.compareTo(path2 = o2.getFile() != null ? o2.getFile().getPath() : "");
                if (retval == 0) {
                    int offset2;
                    int offset1 = o1.getPosition().getBegin().getOffset();
                    retval = offset1 < (offset2 = o2.getPosition().getBegin().getOffset()) ? -1 : 1;
                }
                return retval;
            }
        });
        Map<FileObject, WarningFileElement> warningElements = new HashMap<FileObject, WarningFileElement>();

        private Results() {
        }

        private void clear() {
            this.elements.clear();
            this.warningElements.clear();
        }

        private void addEntry(PhpElement decl) {
            ImageIcon icon = UiUtils.getElementIcon((ElementKind)WhereUsedSupport.this.getElementKind(), (Collection)decl.getModifiers());
            this.elements.add(WhereUsedElement.create(decl.getName(), decl.getFileObject(), new OffsetRange(decl.getOffset(), decl.getOffset() + decl.getName().length()), icon));
        }

        private void addEntry(FileObject fo, Occurence occurence) {
            Collection allDeclarations = occurence.getAllDeclarations();
            if (allDeclarations.size() > 0) {
                PhpElement decl = (PhpElement)allDeclarations.iterator().next();
                ImageIcon icon = UiUtils.getElementIcon((ElementKind)WhereUsedSupport.this.getElementKind(), (Collection)decl.getModifiers());
                WhereUsedElement wue = WhereUsedElement.create(decl.getName(), fo, occurence.getOccurenceRange(), icon);
                if (wue != null) {
                    this.elements.add(wue);
                } else if (!this.warningElements.containsKey(fo)) {
                    this.warningElements.put(fo, new WarningFileElement(fo));
                }
            }
        }

        public Collection<WhereUsedElement> getResultElements() {
            return this.elements;
        }

        public Collection<WarningFileElement> getWarningElements() {
            return this.warningElements.values();
        }
    }
}

