/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedPanel;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedQueryUI
implements RefactoringUI {
    private final WhereUsedQuery query;
    private final String name;
    private WhereUsedPanel panel;
    private final WhereUsedSupport element;
    private ElementKind kind;
    private AbstractRefactoring delegate;
    private ResourceBundle bundle;

    public WhereUsedQueryUI(WhereUsedSupport usage) {
        this.query = new WhereUsedQuery(Lookups.singleton((Object)usage));
        this.element = usage;
        this.name = usage.getName();
        this.kind = usage.getElementKind();
    }

    public boolean isQuery() {
        return true;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new WhereUsedPanel(this.name, this.element, parent);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.query.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.panel.isSearchInComments());
        ModelElement element1 = this.panel.getElement();
        this.element.setModelElement(element1);
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.checkParameters();
        }
        if (this.kind == ElementKind.MODULE || this.kind == ElementKind.CLASS || this.kind == ElementKind.INTERFACE) {
            this.setForClass();
            return this.query.checkParameters();
        }
        return null;
    }

    private void setForMethod() {
        if (this.panel.isMethodFromBaseClass()) {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.panel.getBaseMethod()));
        } else {
            this.query.setRefactoringSource(Lookups.singleton((Object)this.element));
        }
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)this.panel.isMethodOverriders());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isMethodFindUsages());
    }

    private void setForClass() {
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES, (Object)this.panel.isClassSubTypesDirectOnly());
        this.query.putValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES, (Object)this.panel.isClassSubTypes());
        this.query.putValue((Object)"FIND_REFERENCES", (Object)this.panel.isClassFindUsages());
    }

    public Problem checkParameters() {
        if (this.kind == ElementKind.METHOD) {
            this.setForMethod();
            return this.query.fastCheckParameters();
        }
        if (this.kind == ElementKind.CLASS || this.kind == ElementKind.MODULE) {
            this.setForClass();
            return this.query.fastCheckParameters();
        }
        return null;
    }

    public AbstractRefactoring getRefactoring() {
        return this.query != null ? this.query : this.delegate;
    }

    public String getDescription() {
        String nameText = this.name;
        String bundleKey = this.panel != null && this.panel.isClassSubTypesDirectOnly() ? "DSC_WhereUsedFindDirectSubTypes" : "DSC_WhereUsed";
        return this.getString(bundleKey, nameText);
    }

    private String getString(String key) {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(WhereUsedQueryUI.class);
        }
        return this.bundle.getString(key);
    }

    private String getString(String key, String value) {
        return new MessageFormat(this.getString(key)).format(new Object[]{value});
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(WhereUsedPanel.class, (String)"LBL_WhereUsed")).format(new Object[]{this.name});
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WhereUsedQueryUI.class);
    }
}

