/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.findusages.WarningFileElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public class PhpWhereUsedQueryPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    protected AbstractRefactoring refactoring;
    private WhereUsedSupport usages;

    public PhpWhereUsedQueryPlugin(AbstractRefactoring refactoring) {
        this.refactoring = refactoring;
        this.usages = (WhereUsedSupport)refactoring.getRefactoringSource().lookup(WhereUsedSupport.class);
    }

    public Problem prepare(RefactoringElementsBag elementsBag) {
        this.usages.clearResults();
        if (this.isFindOverridingMethods()) {
            this.usages.overridingMethods();
        }
        if (this.isFindSubclasses()) {
            this.usages.collectSubclasses();
        } else if (this.isFindDirectSubclassesOnly()) {
            this.usages.collectDirectSubclasses();
        } else if (this.isFindUsages()) {
            Set<FileObject> relevantFiles = this.usages.getRelevantFiles();
            this.fireProgressListenerStart(1, relevantFiles.size());
            for (FileObject fileObject : relevantFiles) {
                if (fileObject == null) continue;
                this.usages.collectUsages(fileObject);
                this.fireProgressListenerStep();
            }
        }
        WhereUsedSupport.Results results = this.usages.getResults();
        this.refactorResults(results, elementsBag);
        this.fireProgressListenerStop();
        return null;
    }

    protected void refactorResults(WhereUsedSupport.Results results, RefactoringElementsBag elementsBag) {
        Collection<WhereUsedElement> resultElements = results.getResultElements();
        for (WhereUsedElement whereUsedElement : resultElements) {
            elementsBag.add(this.refactoring, (RefactoringElementImplementation)whereUsedElement);
        }
        Collection<WarningFileElement> warningElements = results.getWarningElements();
        for (WarningFileElement warningElement : warningElements) {
            elementsBag.add(this.refactoring, (RefactoringElementImplementation)warningElement);
        }
    }

    private boolean isFindSubclasses() {
        return this.refactoring instanceof WhereUsedQuery ? ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES) : false;
    }

    private boolean isFindUsages() {
        return this.refactoring instanceof WhereUsedQuery ? ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)"FIND_REFERENCES") : true;
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring instanceof WhereUsedQuery ? ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES) : false;
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring instanceof WhereUsedQuery ? ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS) : false;
    }

    protected boolean isSearchInComments() {
        return this.refactoring instanceof WhereUsedQuery ? ((WhereUsedQuery)this.refactoring).getBooleanValue((Object)"SEARCH_IN_COMMENTS") : false;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public WhereUsedSupport getUsages() {
        return this.usages;
    }
}

