/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.lucene.search.BooleanQuery;
import org.apache.maven.model.Dependency;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.ui.nodes.ArtifactNode;
import org.netbeans.modules.maven.hints.ui.nodes.VersionNode;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class SearchDependencyUI
extends JPanel
implements ExplorerManager.Provider,
Observer {
    private ExplorerManager explorerManager = new ExplorerManager();
    private JButton addButton = new JButton(NbBundle.getMessage(SearchDependencyUI.class, (String)"BTN_Add"));
    private BeanTreeView beanTreeView;
    private NBVersionInfo nbvi;
    private static RequestProcessor.Task task = null;
    private static final RequestProcessor RP = new RequestProcessor(SearchDependencyUI.class.getName(), 10);
    private boolean retrigger = false;
    private Project project;
    private QueryRequest queryRequest;
    private ResultsRootNode resultsRootNode;
    private JLabel lblClassName;
    private JLabel lblMatchingArtifacts;
    private JLabel lblSelected;
    private JScrollPane treeView;
    private JTextField txtClassName;
    private static Node noResultsNode;
    private static Node searchingNode;
    private static Node tooGeneralNode;

    public SearchDependencyUI(String clazz, Project mavProj) {
        this.initComponents();
        this.project = mavProj;
        this.beanTreeView = (BeanTreeView)this.treeView;
        this.beanTreeView.setPopupAllowed(false);
        this.beanTreeView.setRootVisible(false);
        this.beanTreeView.setDefaultActionAllowed(true);
        this.beanTreeView.setUseSubstringInQuickSearch(true);
        this.addButton.setEnabled(false);
        this.txtClassName.setText(clazz);
        this.txtClassName.selectAll();
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                if (arg0.getPropertyName().equals("selectedNodes")) {
                    Node[] selectedNodes;
                    for (Node node : selectedNodes = SearchDependencyUI.this.explorerManager.getSelectedNodes()) {
                        if (node instanceof VersionNode) {
                            SearchDependencyUI.this.nbvi = ((VersionNode)node).getNBVersionInfo();
                            break;
                        }
                        if (!(node instanceof ArtifactNode)) continue;
                        ArtifactNode an = (ArtifactNode)node;
                        List<NBVersionInfo> infos = an.getVersionInfos();
                        SearchDependencyUI.this.nbvi = infos.isEmpty() ? null : infos.get(0);
                    }
                    if (SearchDependencyUI.this.nbvi != null) {
                        SearchDependencyUI.this.lblSelected.setText(SearchDependencyUI.this.nbvi.getGroupId() + " : " + SearchDependencyUI.this.nbvi.getArtifactId() + " : " + SearchDependencyUI.this.nbvi.getVersion() + " [ " + SearchDependencyUI.this.nbvi.getType() + (SearchDependencyUI.this.nbvi.getClassifier() != null ? "," + SearchDependencyUI.this.nbvi.getClassifier() : "") + " ]");
                    } else {
                        SearchDependencyUI.this.lblSelected.setText(null);
                    }
                    SearchDependencyUI.this.addButton.setEnabled(SearchDependencyUI.this.nbvi != null);
                }
            }
        });
        this.queryRequest = null;
        this.resultsRootNode = new ResultsRootNode();
        this.explorerManager.setRootContext((Node)this.resultsRootNode);
        this.createSearchTask();
        this.load();
        this.txtClassName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchDependencyUI.this.load();
            }
        });
    }

    public NBVersionInfo getSelectedVersion() {
        return this.nbvi;
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    private void createSearchTask() {
        if (task != null) {
            task.cancel();
        }
        final SearchDependencyUI observer = this;
        task = RP.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                final String[] search = new String[1];
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SearchDependencyUI.this.lblSelected.setText(null);
                            search[0] = SearchDependencyUI.this.getClassSearchName();
                        }
                    });
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getSearchingNode());
                    }
                });
                if (search[0].length() > 0) {
                    SearchDependencyUI.this.queryRequest = new QueryRequest(search[0], RepositoryPreferences.getInstance().getRepositoryInfos(), observer);
                    try {
                        RepositoryQueries.findVersionsByClass((QueryRequest)SearchDependencyUI.this.queryRequest);
                    }
                    catch (BooleanQuery.TooManyClauses exc) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getTooGeneralNode());
                            }
                        });
                    }
                    catch (OutOfMemoryError oome) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getTooGeneralNode());
                            }
                        });
                    }
                    SearchDependencyUI searchDependencyUI = SearchDependencyUI.this;
                    synchronized (searchDependencyUI) {
                        if (SearchDependencyUI.this.retrigger) {
                            SearchDependencyUI.this.retrigger = false;
                            task.schedule(20);
                            return;
                        }
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SearchDependencyUI.this.resultsRootNode.setOneChild(SearchDependencyUI.getNoResultsNode());
                    }
                });
            }
        }, true);
    }

    public synchronized void load() {
        if (!task.isFinished() && task.getDelay() == 0) {
            this.retrigger = true;
            if (null != this.queryRequest) {
                this.queryRequest.deleteObserver((Observer)this);
            }
        } else {
            task.schedule(500);
        }
    }

    public String getClassSearchName() {
        return this.txtClassName.getText().trim();
    }

    private void initComponents() {
        this.lblClassName = new JLabel();
        this.txtClassName = new JTextField();
        this.treeView = new BeanTreeView();
        this.lblMatchingArtifacts = new JLabel();
        this.lblSelected = new JLabel();
        this.lblClassName.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Class_Name"));
        this.treeView.setBorder(BorderFactory.createEtchedBorder(null, UIManager.getDefaults().getColor("ComboBox.selectionBackground")));
        this.lblMatchingArtifacts.setText(NbBundle.getMessage(SearchDependencyUI.class, (String)"LBL_Matching_artifacts"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblSelected, GroupLayout.Alignment.LEADING, -2, 430, -2).addComponent(this.treeView, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE).addComponent(this.txtClassName, -1, 430, Short.MAX_VALUE).addComponent(this.lblMatchingArtifacts, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE).addComponent(this.lblClassName, GroupLayout.Alignment.LEADING, -1, 430, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblClassName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtClassName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMatchingArtifacts).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treeView, -1, 214, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSelected, -2, 14, -2)));
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private static Node getSearchingNode() {
        if (searchingNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/hints/wait.gif");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Searching");
            nd.setDisplayName(NbBundle.getMessage(SearchDependencyUI.class, (String)"Node_Loading"));
            searchingNode = nd;
        }
        return new FilterNode(searchingNode, Children.LEAF);
    }

    public static Node getNoResultsNode() {
        if (noResultsNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/hints/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Empty");
            nd.setDisplayName(NbBundle.getMessage(SearchDependencyUI.class, (String)"Node_Empty"));
            noResultsNode = nd;
        }
        return new FilterNode(noResultsNode, Children.LEAF);
    }

    private static Node getTooGeneralNode() {
        if (tooGeneralNode == null) {
            AbstractNode nd = new AbstractNode(Children.LEAF){

                public Image getIcon(int arg0) {
                    return ImageUtilities.loadImage((String)"org/netbeans/modules/maven/hints/empty.png");
                }

                public Image getOpenedIcon(int arg0) {
                    return this.getIcon(arg0);
                }
            };
            nd.setName("Too General");
            nd.setDisplayName(NbBundle.getMessage(SearchDependencyUI.class, (String)"Node_TooGeneral"));
            tooGeneralNode = nd;
        }
        return new FilterNode(tooGeneralNode, Children.LEAF);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (null == o || !(o instanceof QueryRequest)) {
            return;
        }
        List infos = ((QueryRequest)o).getResults();
        final HashMap<String, ArrayList<NBVersionInfo>> map = new HashMap<String, ArrayList<NBVersionInfo>>();
        for (NBVersionInfo nbvi : infos) {
            String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
            ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
            if (get == null) {
                get = new ArrayList<NBVersionInfo>();
                map.put(key, get);
            }
            get.add(nbvi);
        }
        final ArrayList keyList = new ArrayList(map.keySet());
        Collections.sort(keyList, new HeuristicsComparator());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchDependencyUI.this.updateResultNodes(keyList, map);
            }
        });
    }

    private void updateResultNodes(List<String> keyList, Map<String, List<NBVersionInfo>> map) {
        if (keyList.size() > 0) {
            HashMap<String, Node> currentNodes = new HashMap<String, Node>();
            for (Object nd : this.resultsRootNode.getChildren().getNodes()) {
                currentNodes.put(nd.getName(), (Node)nd);
            }
            ArrayList<Node> newNodes = new ArrayList<Node>(keyList.size());
            if (null != this.queryRequest && !this.queryRequest.isFinished()) {
                newNodes.add(SearchDependencyUI.getSearchingNode());
            }
            for (String key : keyList) {
                Object nd;
                nd = (Node)currentNodes.get(key);
                if (null != nd) {
                    ((ArtifactNode)((Object)nd)).setVersionInfos(map.get(key));
                } else {
                    nd = new ArtifactNode(key, map.get(key));
                }
                newNodes.add((Node)nd);
            }
            this.resultsRootNode.setNewChildren(newNodes);
        } else if (null != this.queryRequest && !this.queryRequest.isFinished()) {
            this.resultsRootNode.setOneChild(SearchDependencyUI.getSearchingNode());
        } else {
            this.resultsRootNode.setOneChild(SearchDependencyUI.getNoResultsNode());
        }
    }

    private class HeuristicsComparator
    implements Comparator<String> {
        private Set<String> privilegedGroupIds = new HashSet<String>();

        private HeuristicsComparator() {
            String packaging = ((NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class)).getPackagingType();
            if ("nbm".equalsIgnoreCase(packaging)) {
                this.privilegedGroupIds.add("org.netbeans.api");
            }
            if ("war".equalsIgnoreCase(packaging) || "ear".equalsIgnoreCase(packaging) || "ejb".equalsIgnoreCase(packaging)) {
                this.privilegedGroupIds.add("javax.activation");
                this.privilegedGroupIds.add("javax.ejb");
                this.privilegedGroupIds.add("javax.faces");
                this.privilegedGroupIds.add("javax.j2ee");
                this.privilegedGroupIds.add("javax.jdo");
                this.privilegedGroupIds.add("javax.jms");
                this.privilegedGroupIds.add("javax.mail");
                this.privilegedGroupIds.add("javax.management");
                this.privilegedGroupIds.add("javax.naming");
                this.privilegedGroupIds.add("javax.persistence");
                this.privilegedGroupIds.add("javax.portlet");
                this.privilegedGroupIds.add("javax.resource");
                this.privilegedGroupIds.add("javax.security");
                this.privilegedGroupIds.add("javax.servlet");
                this.privilegedGroupIds.add("javax.sql");
                this.privilegedGroupIds.add("javax.transaction");
                this.privilegedGroupIds.add("javax.xml");
            }
            NbMavenProject mavenproject = (NbMavenProject)SearchDependencyUI.this.project.getLookup().lookup(NbMavenProject.class);
            List deps = mavenproject.getMavenProject().getDependencies();
            for (Dependency d : deps) {
                this.privilegedGroupIds.add(d.getGroupId());
            }
        }

        @Override
        public int compare(String s1, String s2) {
            String[] split1 = s1.split(":");
            String[] split2 = s2.split(":");
            boolean b1 = this.privilegedGroupIds.contains(split1[0].trim());
            boolean b2 = this.privilegedGroupIds.contains(split2[0].trim());
            if (b1 && !b2) {
                return -1;
            }
            if (!b1 && b2) {
                return 1;
            }
            return s1.compareTo(s2);
        }
    }

    private class ResultsRootChildren
    extends Children.Keys<Node> {
        List<Node> myNodes = Collections.EMPTY_LIST;

        private void setNewChildren(List<Node> ch) {
            this.myNodes = ch;
            this.refreshList();
        }

        protected void addNotify() {
            this.refreshList();
        }

        private void refreshList() {
            ArrayList<Node> keys = new ArrayList<Node>();
            for (Node node : this.myNodes) {
                keys.add(node);
            }
            this.setKeys(keys);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }

    private class ResultsRootNode
    extends AbstractNode {
        private ResultsRootChildren resultsChildren;

        public ResultsRootNode() {
            this(new InstanceContent());
        }

        private ResultsRootNode(InstanceContent content) {
            super((Children)new ResultsRootChildren(), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
            content.add((Object)this);
            this.resultsChildren = (ResultsRootChildren)this.getChildren();
        }

        public void setOneChild(Node n) {
            ArrayList<Node> ch = new ArrayList<Node>(1);
            ch.add(n);
            this.setNewChildren(ch);
        }

        public void setNewChildren(List<Node> ch) {
            this.resultsChildren.setNewChildren(ch);
        }
    }
}

