/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTextField;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationUiSupport;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class SendJMSMessageUiSupport
extends MessageDestinationUiSupport {
    public static List<MdbHolder> getMdbs() {
        Project[] openProjects;
        ArrayList<MdbHolder> mdbs = new ArrayList<MdbHolder>();
        for (Project p : openProjects = OpenProjects.getDefault().getOpenProjects()) {
            if (EjbJar.getEjbJars((Project)p).length <= 0) continue;
            try {
                Map<String, String> drivens = SendJMSMessageUiSupport.getMdbs(p);
                SendJMSMessageUiSupport.populateMdbs(mdbs, drivens, p);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return mdbs;
    }

    public static void populateMessageDrivenBeans(List<MdbHolder> mdbs, JComboBox comboBox, final JTextField textField) {
        assert (mdbs != null);
        assert (comboBox != null);
        assert (textField != null);
        comboBox.setRenderer(new MdbHolderListCellRenderer());
        ArrayList<MdbHolder> sortedMdbs = new ArrayList<MdbHolder>(mdbs);
        Collections.sort(sortedMdbs, new MdbHolderComparator());
        comboBox.removeAllItems();
        textField.setText("");
        for (MdbHolder mdbHolder : sortedMdbs) {
            comboBox.addItem(mdbHolder);
        }
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendJMSMessageUiSupport.populateMdbTextField((JComboBox)actionEvent.getSource(), textField);
            }
        });
        SendJMSMessageUiSupport.populateMdbTextField(comboBox, textField);
    }

    private static void populateMdbTextField(JComboBox comboBox, JTextField textField) {
        MdbHolder selectedItem = (MdbHolder)comboBox.getSelectedItem();
        if (selectedItem != null) {
            MessageDestination md = selectedItem.getMessageDestination();
            textField.setText(md != null ? md.getName() : "");
        }
    }

    private static void populateMdbs(List<MdbHolder> mdbs, Map<String, String> drivens, Project project) {
        for (Map.Entry<String, String> mdbEntry : drivens.entrySet()) {
            J2eeModuleProvider j2eeModuleProvider = SendJMSMessageUiSupport.getJ2eeModuleProvider(project);
            try {
                MessageDestination messageDestination = null;
                String mdbName = mdbEntry.getKey();
                String mappedName = mdbEntry.getValue();
                String destName = j2eeModuleProvider.getConfigSupport().findMessageDestinationName(mdbName);
                if (destName == null && mappedName != null) {
                    destName = mappedName;
                }
                if (destName == null) continue;
                messageDestination = j2eeModuleProvider.getConfigSupport().findMessageDestination(destName);
                mdbs.add(new MdbHolder(mdbName, messageDestination, project));
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
    }

    private static J2eeModuleProvider getJ2eeModuleProvider(Project project) {
        return (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
    }

    private static Map<String, String> getMdbs(Project project) throws IOException {
        HashMap<String, String> mdbs = new HashMap<String, String>();
        for (EjbJar ejbModule : EjbJar.getEjbJars((Project)project)) {
            MetadataModel metadataModel = ejbModule.getMetadataModel();
            Map mdbsInModule = (Map)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

                public Map<String, String> run(EjbJarMetadata metadata) throws Exception {
                    MessageDriven[] messageDrivens;
                    HashMap<String, String> result = new HashMap<String, String>();
                    EnterpriseBeans eb = metadata.getRoot().getEnterpriseBeans();
                    if (eb == null) {
                        return Collections.emptyMap();
                    }
                    for (MessageDriven mdb : messageDrivens = eb.getMessageDriven()) {
                        result.put(mdb.getEjbName(), SendJMSMessageUiSupport.findMsgDest(mdb));
                    }
                    return result;
                }
            });
            mdbs.putAll(mdbsInModule);
        }
        return mdbs;
    }

    private static String findMsgDest(MessageDriven mdb) {
        try {
            return mdb.getMappedName();
        }
        catch (VersionNotSupportedException e) {
            try {
                return mdb.getMessageDestinationLink();
            }
            catch (VersionNotSupportedException e2) {
                return null;
            }
        }
    }

    private static class MdbHolderListCellRenderer
    extends DefaultListCellRenderer {
        private MdbHolderListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value instanceof MdbHolder) {
                MdbHolder mdbHolder = (MdbHolder)value;
                this.setText(mdbHolder.getMdbEjbName());
                MessageDestination messageDestination = mdbHolder.getMessageDestination();
                if (messageDestination == null) {
                    this.setToolTipText("");
                } else {
                    String type = MessageDestination.Type.QUEUE.equals((Object)messageDestination.getType()) ? "LBL_Queue" : "LBL_Topic";
                    StringBuilder sb = new StringBuilder(mdbHolder.getProjectName());
                    sb.append(" : ");
                    sb.append(mdbHolder.getMdbEjbName());
                    sb.append(" [");
                    sb.append(NbBundle.getMessage(MessageDestinationUiSupport.class, (String)type));
                    sb.append("]");
                    this.setToolTipText(sb.toString());
                }
            } else {
                this.setText(value != null ? value.toString() : "");
                this.setToolTipText("");
            }
            return this;
        }
    }

    private static class MdbHolderComparator
    implements Comparator<MdbHolder> {
        private MdbHolderComparator() {
        }

        @Override
        public int compare(MdbHolder mdbHolder1, MdbHolder mdbHolder2) {
            if (mdbHolder1 == null) {
                return mdbHolder2 == null ? 0 : -1;
            }
            if (mdbHolder2 == null) {
                return 1;
            }
            String name1 = mdbHolder1.getMdbEjbName();
            String name2 = mdbHolder2.getMdbEjbName();
            if (name1 == null) {
                return name2 == null ? 0 : -1;
            }
            return name2 == null ? 1 : name1.compareToIgnoreCase(name2);
        }
    }

    public static class MdbHolder {
        private final String mdbEjbName;
        private final MessageDestination messageDestination;
        private final Project project;

        public MdbHolder(String mdbEjbName, MessageDestination messageDestination, Project project) {
            assert (mdbEjbName != null);
            assert (project != null);
            this.mdbEjbName = mdbEjbName;
            this.messageDestination = messageDestination;
            this.project = project;
        }

        public MessageDestination getMessageDestination() {
            return this.messageDestination;
        }

        public Project getProject() {
            return this.project;
        }

        public String getMdbEjbName() {
            return this.mdbEjbName;
        }

        public String getProjectName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getName());
            sb.append(" [");
            sb.append(this.getMdbEjbName());
            sb.append(" (");
            sb.append(this.messageDestination != null ? this.messageDestination.getType().toString() : "");
            sb.append("), ");
            sb.append(this.getProjectName());
            sb.append("]");
            return sb.toString();
        }
    }
}

