/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EntityAndSession;
import org.netbeans.modules.j2ee.ejbcore._RetoucheUtil;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AbstractAddMethodStrategy;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public abstract class AbstractMethodGenerator {
    protected final String ejbClass;
    protected final FileObject ejbClassFileObject;
    protected final EjbJar ejbModule;

    protected AbstractMethodGenerator(String ejbClass, FileObject ejbClassFileObject) {
        Parameters.notNull((CharSequence)"ejbClass", (Object)ejbClass);
        Parameters.notNull((CharSequence)"ejbClassFileObject", (Object)ejbClassFileObject);
        this.ejbClass = ejbClass;
        this.ejbClassFileObject = ejbClassFileObject;
        this.ejbModule = EjbJar.getEjbJar((FileObject)ejbClassFileObject);
    }

    protected void addMethodToInterface(final MethodModel methodModel, String className) throws IOException {
        String ci = AbstractMethodGenerator.findCommonInterface(this.ejbClass, className);
        final String commonInterface = ci != null ? ci : className;
        final FileObject fileObject = _RetoucheUtil.resolveFileObjectForClass(this.ejbClassFileObject, commonInterface);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractMethodGenerator.addMethod(methodModel, fileObject, commonInterface);
                }
                catch (IOException ioe) {
                    Logger.getLogger(AbstractAddMethodStrategy.class.getName()).log(Level.WARNING, null, ioe);
                }
            }
        });
    }

    protected static void addMethod(final MethodModel methodModel, FileObject fileObject, final String className) throws IOException {
        if (fileObject != null && methodModel != null) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws IOException {
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                    boolean generateDefaultBody = typeElement.getKind() != ElementKind.INTERFACE && !methodModel.getModifiers().contains((Object)Modifier.ABSTRACT);
                    MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel, (boolean)generateDefaultBody);
                    ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                    ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                    workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
                }
            }).commit();
        }
    }

    protected synchronized void saveXml() throws IOException {
        FileObject ddFileObject = this.ejbModule.getDeploymentDescriptor();
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = DDProvider.getDefault().getDDRoot(ddFileObject);
        if (ejbJar != null) {
            ejbJar.write(ddFileObject);
        }
    }

    protected Map<String, String> getInterfaces() throws IOException {
        Future futureResult = this.ejbModule.getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Map<String, String>>(){

            public Map<String, String> run(EjbJarMetadata metadata) throws Exception {
                EntityAndSession ejb = (EntityAndSession)metadata.findByEjbClass(AbstractMethodGenerator.this.ejbClass);
                HashMap<String, String> result = new HashMap<String, String>();
                if (ejb != null) {
                    result.put("Local", ejb.getLocal());
                    result.put("LocalHome", ejb.getLocalHome());
                    result.put("Remote", ejb.getRemote());
                    result.put("Home", ejb.getHome());
                }
                return result;
            }
        });
        try {
            return (Map)futureResult.get();
        }
        catch (Exception ex) {
            Logger.getLogger(AbstractMethodGenerator.class.getName()).log(Level.WARNING, null, ex);
            return Collections.emptyMap();
        }
    }

    private static String findCommonInterface(String className1, String className2) throws IOException {
        return null;
    }
}

