/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.addproperty;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.beans.addproperty.AddPropertyConfig;
import org.netbeans.modules.beans.addproperty.AddPropertyGenerator;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddPropertyPanel
extends JPanel {
    private boolean propNameModified = false;
    private boolean generatePCSModified = false;
    private boolean generateVCSModified = false;
    private DocumentListener propNameTextFieldDocumentListener;
    private FileObject file;
    private String className;
    private List<String> existingFields;
    private String[] pcsName;
    private String[] vcsName;
    private JButton okButton;
    private boolean generatePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
    private boolean generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
    private ButtonGroup accessGroup;
    private JCheckBox boundCheckBox;
    private JButton browseTypeButton;
    private JLabel equalsLabel;
    private JLabel errorLabel;
    private JCheckBox finalCheckBox;
    private JRadioButton generateGetterAndSetterRadioButton;
    private JRadioButton generateGetterRadioButton;
    private JCheckBox generateJavadocCheckBox;
    private JCheckBox generatePropertyChangeSupportCheckBox;
    private JRadioButton generateSetterRadioButton;
    private JCheckBox generateVetoablePropertyChangeSupportCheckBox;
    private ButtonGroup getterSetterGroup;
    private JCheckBox indexedCheckBox;
    private JTextField initializerTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JRadioButton packageRadioButton;
    private JEditorPane previewEditorPane;
    private JLabel previewLabel;
    private JScrollPane previewScrollPane;
    private JRadioButton privateRadioButton;
    private JTextField propNameTextField;
    private JRadioButton protectedRadioButton;
    private JRadioButton publicRadioButton;
    private JLabel semicolonLabel;
    private JCheckBox staticCheckBox;
    private JComboBox typeComboBox;
    private JLabel typeLabel;
    private JCheckBox vetoableCheckBox;

    public AddPropertyPanel(FileObject file, String className, List<String> existingFields, String[] pcsName, String[] vcsName, JButton okButton) {
        this.file = file;
        this.className = className;
        this.existingFields = existingFields;
        this.pcsName = pcsName;
        this.vcsName = vcsName;
        this.okButton = okButton;
        this.initComponents();
        this.previewScrollPane.putClientProperty("HighlightsLayerExcludes", "^org\\.netbeans\\.modules\\.editor\\.lib2\\.highlighting\\.CaretRowHighlighting$");
        DocumentListener documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddPropertyPanel.this.showPreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddPropertyPanel.this.showPreview();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.nameTextField.getDocument().addDocumentListener(documentListener);
        ((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(documentListener);
        this.initializerTextField.getDocument().addDocumentListener(documentListener);
        this.propNameTextFieldDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AddPropertyPanel.this.propNameModified = true;
                AddPropertyPanel.this.showPreview();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AddPropertyPanel.this.propNameModified = true;
                AddPropertyPanel.this.showPreview();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.propNameTextField.getDocument().addDocumentListener(this.propNameTextFieldDocumentListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.previewEditorPane.setText("");
        this.generatePropertyChangeSupportCheckBox.setSelected(false);
        this.generateVetoablePropertyChangeSupportCheckBox.setSelected(false);
        this.showPreview();
    }

    private void showPreview() {
        if (!this.propNameModified) {
            this.propNameTextField.getDocument().removeDocumentListener(this.propNameTextFieldDocumentListener);
            this.propNameTextField.setText("PROP_" + this.nameTextField.getText().toUpperCase());
            this.propNameTextField.getDocument().addDocumentListener(this.propNameTextFieldDocumentListener);
        }
        int i = this.staticCheckBox.isSelected() ? 1 : 0;
        this.generatePropertyChangeSupportCheckBox.setEnabled(this.pcsName[i] == null);
        this.generateVetoablePropertyChangeSupportCheckBox.setEnabled(this.vcsName[i] == null);
        if (this.staticCheckBox.isSelected()) {
            this.generatePropertyChangeSupportCheckBox.setSelected(false);
            this.generateVetoablePropertyChangeSupportCheckBox.setSelected(false);
            this.generatePropertyChangeSupportCheckBox.setEnabled(false);
            this.generateVetoablePropertyChangeSupportCheckBox.setEnabled(false);
        } else {
            if (!this.generatePCSModified && this.pcsName == null) {
                this.generatePropertyChangeSupportCheckBox.setEnabled(true);
                this.generatePropertyChangeSupportCheckBox.setSelected(this.boundCheckBox.isSelected());
            }
            if (!this.generateVCSModified && this.vcsName == null) {
                this.generateVetoablePropertyChangeSupportCheckBox.setEnabled(true);
                this.generateVetoablePropertyChangeSupportCheckBox.setSelected(this.vetoableCheckBox.isSelected());
            }
        }
        String previewTemplate = new AddPropertyGenerator().generate(this.getAddPropertyConfig());
        this.previewEditorPane.setText(previewTemplate);
        String error = this.resolveError();
        if (error != null) {
            this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/beans/resources/error-glyph.gif")));
            this.errorLabel.setText(error);
        }
        this.okButton.setEnabled(error == null);
        String warning = this.resolveWarning();
        if (warning != null) {
            this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/beans/resources/warning.gif")));
            this.errorLabel.setText(warning);
        }
        this.errorLabel.setVisible(error != null || warning != null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddPropertyPanel.this.previewEditorPane.setCaretPosition(0);
                AddPropertyPanel.this.previewEditorPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            }
        });
    }

    private String resolveError() {
        if (this.nameTextField.getText().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_FieldIsEmpty");
        }
        if (((JTextField)this.typeComboBox.getEditor().getEditorComponent()).getText().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_TypeIsEmpty");
        }
        if (this.boundCheckBox.isSelected() && this.propNameTextField.getText().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_BoundIsEmpty");
        }
        if (this.existingFields.contains(this.nameTextField.getText())) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_FieldAlreadyExists", (Object[])new Object[]{String.valueOf(this.nameTextField.getText())});
        }
        if (this.boundCheckBox.isSelected() && this.existingFields.contains(this.propNameTextField.getText())) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"ERR_FieldAlreadyExists", (Object[])new Object[]{String.valueOf(this.propNameTextField.getText())});
        }
        return null;
    }

    private String resolveWarning() {
        if (this.finalCheckBox.isSelected() && this.initializerTextField.getText().trim().length() == 0) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"WARN_FinalPropertyRequiresInitilizer");
        }
        if (this.staticCheckBox.isSelected() && this.boundCheckBox.isSelected() && this.pcsName[1] == null) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"WARN_CannotPCS");
        }
        if (this.staticCheckBox.isSelected() && this.boundCheckBox.isSelected() && this.vetoableCheckBox.isSelected() && this.vcsName[1] == null) {
            return NbBundle.getMessage(AddPropertyPanel.class, (String)"WARN_CannotVCS");
        }
        return null;
    }

    public AddPropertyConfig getAddPropertyConfig() {
        String type = this.typeComboBox.getSelectedItem().toString().trim();
        String name = this.nameTextField.getText().trim();
        String initializer = this.initializerTextField.getText().trim();
        AddPropertyConfig.ACCESS access = AddPropertyConfig.ACCESS.PACKAGE;
        if (this.privateRadioButton.isSelected()) {
            access = AddPropertyConfig.ACCESS.PRIVATE;
        } else if (this.protectedRadioButton.isSelected()) {
            access = AddPropertyConfig.ACCESS.PROTECTED;
        } else if (this.publicRadioButton.isSelected()) {
            access = AddPropertyConfig.ACCESS.PUBLIC;
        }
        AddPropertyConfig.GENERATE generate = AddPropertyConfig.GENERATE.GETTER_AND_SETTER;
        if (this.generateGetterAndSetterRadioButton.isSelected()) {
            generate = AddPropertyConfig.GENERATE.GETTER_AND_SETTER;
        } else if (this.generateGetterRadioButton.isSelected()) {
            generate = AddPropertyConfig.GENERATE.GETTER;
        } else if (this.generateSetterRadioButton.isSelected()) {
            generate = AddPropertyConfig.GENERATE.SETTER;
        }
        int i = this.staticCheckBox.isSelected() ? 1 : 0;
        AddPropertyConfig addPropertyConfig = new AddPropertyConfig(name, initializer, type, this.className, access, this.staticCheckBox.isSelected(), this.finalCheckBox.isSelected(), generate, this.generateJavadocCheckBox.isSelected(), this.boundCheckBox.isSelected(), this.propNameTextField.getText().trim(), this.vetoableCheckBox.isSelected(), this.indexedCheckBox.isSelected(), this.pcsName[i], this.vcsName[i], this.generatePropertyChangeSupportCheckBox.isSelected(), this.generateVetoablePropertyChangeSupportCheckBox.isSelected());
        return addPropertyConfig;
    }

    private void initComponents() {
        this.accessGroup = new ButtonGroup();
        this.getterSetterGroup = new ButtonGroup();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.equalsLabel = new JLabel();
        this.initializerTextField = new JTextField();
        this.semicolonLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.typeComboBox = new JComboBox();
        this.browseTypeButton = new JButton();
        this.privateRadioButton = new JRadioButton();
        this.packageRadioButton = new JRadioButton();
        this.protectedRadioButton = new JRadioButton();
        this.publicRadioButton = new JRadioButton();
        this.staticCheckBox = new JCheckBox();
        this.finalCheckBox = new JCheckBox();
        this.generateGetterAndSetterRadioButton = new JRadioButton();
        this.generateGetterRadioButton = new JRadioButton();
        this.generateSetterRadioButton = new JRadioButton();
        this.generateJavadocCheckBox = new JCheckBox();
        this.boundCheckBox = new JCheckBox();
        this.propNameTextField = new JTextField();
        this.vetoableCheckBox = new JCheckBox();
        this.indexedCheckBox = new JCheckBox();
        this.generatePropertyChangeSupportCheckBox = new JCheckBox();
        this.generateVetoablePropertyChangeSupportCheckBox = new JCheckBox();
        this.previewLabel = new JLabel();
        this.previewScrollPane = new JScrollPane();
        this.previewEditorPane = new JEditorPane();
        this.errorLabel = new JLabel();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.nameTextField.text"));
        this.equalsLabel.setLabelFor(this.initializerTextField);
        Mnemonics.setLocalizedText((JLabel)this.equalsLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.equalsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.semicolonLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.semicolonLabel.text"));
        this.typeLabel.setLabelFor(this.typeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.typeLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.typeLabel.text"));
        this.typeComboBox.setEditable(true);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"String", "int", "boolean", "long", "double", "byte", "char", "short", "float"}));
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.typeComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browseTypeButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.browseTypeButton.text"));
        this.browseTypeButton.setToolTipText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.browseTypeButton.toolTipText"));
        this.browseTypeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.browseTypeButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.privateRadioButton);
        this.privateRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.privateRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.privateRadioButton.text"));
        this.privateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.privateRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.packageRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.packageRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.packageRadioButton.text"));
        this.packageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.packageRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.protectedRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.protectedRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.protectedRadioButton.text"));
        this.protectedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.protectedRadioButtonActionPerformed(evt);
            }
        });
        this.accessGroup.add(this.publicRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.publicRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.publicRadioButton.text"));
        this.publicRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.publicRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.staticCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.staticCheckBox.text"));
        this.staticCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.staticCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.finalCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.finalCheckBox.text"));
        this.finalCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.finalCheckBoxActionPerformed(evt);
            }
        });
        this.getterSetterGroup.add(this.generateGetterAndSetterRadioButton);
        this.generateGetterAndSetterRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateGetterAndSetterRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateGetterAndSetterRadioButton.text"));
        this.generateGetterAndSetterRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateGetterAndSetterRadioButtonActionPerformed(evt);
            }
        });
        this.getterSetterGroup.add(this.generateGetterRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.generateGetterRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateGetterRadioButton.text"));
        this.generateGetterRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateGetterRadioButtonActionPerformed(evt);
            }
        });
        this.getterSetterGroup.add(this.generateSetterRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.generateSetterRadioButton, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateSetterRadioButton.text"));
        this.generateSetterRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateSetterRadioButtonActionPerformed(evt);
            }
        });
        this.generateJavadocCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.generateJavadocCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateJavadocCheckBox.text"));
        this.generateJavadocCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateJavadocCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.boundCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.boundCheckBox.text"));
        this.boundCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.boundCheckBoxActionPerformed(evt);
            }
        });
        this.propNameTextField.setText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.propNameTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.vetoableCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.vetoableCheckBox.text"));
        this.vetoableCheckBox.setEnabled(false);
        this.vetoableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.vetoableCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.indexedCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.indexedCheckBox.text"));
        this.indexedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.indexedCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.generatePropertyChangeSupportCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generatePropertyChangeSupportCheckBox.text"));
        this.generatePropertyChangeSupportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generatePropertyChangeSupportCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.generateVetoablePropertyChangeSupportCheckBox, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.generateVetoablePropertyChangeSupportCheckBox.text"));
        this.generateVetoablePropertyChangeSupportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddPropertyPanel.this.generateVetoablePropertyChangeSupportCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.previewLabel.text"));
        this.previewEditorPane.setContentType(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.previewEditorPane.contentType"));
        this.previewEditorPane.setEditable(false);
        this.previewEditorPane.setText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.previewEditorPane.text"));
        this.previewEditorPane.setToolTipText(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.previewEditorPane.toolTipText"));
        this.previewScrollPane.setViewportView(this.previewEditorPane);
        this.errorLabel.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/beans/resources/error-glyph.gif")));
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)NbBundle.getBundle(AddPropertyPanel.class).getString("AddPropertyPanel.errorLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameLabel).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.staticCheckBox).addComponent(this.privateRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.finalCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.packageRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.protectedRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.publicRadioButton)))).addGroup(layout.createSequentialGroup().addComponent(this.boundCheckBox).addGap(35, 35, 35).addComponent(this.propNameTextField, -1, 554, Short.MAX_VALUE).addGap(27, 27, 27)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.vetoableCheckBox)).addGroup(layout.createSequentialGroup().addComponent(this.generateGetterAndSetterRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateGetterRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateSetterRadioButton)).addComponent(this.generateJavadocCheckBox).addComponent(this.indexedCheckBox).addGroup(layout.createSequentialGroup().addComponent(this.generatePropertyChangeSupportCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generateVetoablePropertyChangeSupportCheckBox)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.typeComboBox, 0, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseTypeButton, -2, 86, -2)).addGroup(layout.createSequentialGroup().addComponent(this.nameTextField, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.equalsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initializerTextField, -1, 408, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.semicolonLabel)))).addGroup(layout.createSequentialGroup().addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.previewScrollPane, -1, 686, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.finalCheckBox, this.packageRadioButton, this.privateRadioButton, this.protectedRadioButton, this.publicRadioButton, this.staticCheckBox);
        layout.linkSize(0, this.nameLabel, this.previewLabel, this.typeLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.semicolonLabel).addComponent(this.nameTextField, -2, -1, -2).addComponent(this.equalsLabel).addComponent(this.initializerTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.typeLabel).addComponent(this.browseTypeButton).addComponent(this.typeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageRadioButton).addComponent(this.protectedRadioButton).addComponent(this.publicRadioButton).addComponent(this.privateRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.staticCheckBox)).addComponent(this.finalCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generateGetterAndSetterRadioButton).addComponent(this.generateSetterRadioButton).addComponent(this.generateGetterRadioButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateJavadocCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.boundCheckBox).addComponent(this.propNameTextField, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.vetoableCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.indexedCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.generatePropertyChangeSupportCheckBox).addComponent(this.generateVetoablePropertyChangeSupportCheckBox)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewLabel).addComponent(this.previewScrollPane, -1, 333, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.errorLabel).addGap(17, 17, 17)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddPropertyPanel.class, (String)"AddPropertyPanel.AccessibleContext.accessibleDescription"));
    }

    private void finalCheckBoxActionPerformed(ActionEvent evt) {
        this.generateGetterAndSetterRadioButton.setEnabled(!this.finalCheckBox.isSelected());
        this.generateSetterRadioButton.setEnabled(!this.finalCheckBox.isSelected());
        if (this.finalCheckBox.isSelected()) {
            this.generateGetterRadioButton.setSelected(true);
        }
        this.showPreview();
    }

    private void privateRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void packageRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void protectedRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void publicRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void staticCheckBoxActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void indexedCheckBoxActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void generateJavadocCheckBoxActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void boundCheckBoxActionPerformed(ActionEvent evt) {
        this.vetoableCheckBox.setEnabled(this.boundCheckBox.isSelected());
        if (this.generatePropertyChangeSupportCheckBox.isEnabled()) {
            if (this.boundCheckBox.isSelected()) {
                if (!this.generatePropertyChangeSupportCheckBox.isSelected()) {
                    this.generatePropertyChangeSupportCheckBox.setSelected(true);
                    this.generatePropertyChangeSupportCheckBoxWasSelectedAutomatically = true;
                }
                if (!this.generateVetoablePropertyChangeSupportCheckBox.isSelected() && this.vetoableCheckBox.isSelected()) {
                    this.generateVetoablePropertyChangeSupportCheckBox.setSelected(true);
                    this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = true;
                }
            } else {
                if (this.generatePropertyChangeSupportCheckBoxWasSelectedAutomatically) {
                    this.generatePropertyChangeSupportCheckBox.setSelected(false);
                    this.generatePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
                }
                if (this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically) {
                    this.generateVetoablePropertyChangeSupportCheckBox.setSelected(false);
                    this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
                }
            }
        }
        this.showPreview();
    }

    private void vetoableCheckBoxActionPerformed(ActionEvent evt) {
        if (this.generateVetoablePropertyChangeSupportCheckBox.isEnabled()) {
            if (this.boundCheckBox.isSelected() && !this.generateVetoablePropertyChangeSupportCheckBox.isSelected()) {
                this.generateVetoablePropertyChangeSupportCheckBox.setSelected(true);
                this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = true;
            } else if (this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically) {
                this.generateVetoablePropertyChangeSupportCheckBox.setSelected(false);
                this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
            }
        }
        this.showPreview();
    }

    private void generateGetterAndSetterRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void generateSetterRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void generateGetterRadioButtonActionPerformed(ActionEvent evt) {
        this.showPreview();
    }

    private void generateVetoablePropertyChangeSupportCheckBoxActionPerformed(ActionEvent evt) {
        this.generateVCSModified = true;
        this.generateVetoablePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
        this.showPreview();
    }

    private void generatePropertyChangeSupportCheckBoxActionPerformed(ActionEvent evt) {
        this.generatePCSModified = true;
        this.generatePropertyChangeSupportCheckBoxWasSelectedAutomatically = false;
        this.showPreview();
    }

    private void browseTypeButtonActionPerformed(ActionEvent evt) {
        ElementHandle type = TypeElementFinder.find((ClasspathInfo)ClasspathInfo.create((FileObject)this.file), null);
        if (type != null) {
            String fqn = type.getQualifiedName().toString();
            this.typeComboBox.setSelectedItem(fqn);
        }
    }
}

