/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;

class LayoutFeeder
implements LayoutConstants {
    boolean imposeSize;
    boolean optimizeStructure;
    private LayoutModel layoutModel;
    private LayoutOperations operations;
    private LayoutDragger dragger;
    private OriginalPosition[] originalPositions = new OriginalPosition[2];
    private List[] undoMarks = new List[2];
    private LayoutRegion originalSpace;
    private LayoutDragger.PositionDef[] newPositions = new LayoutDragger.PositionDef[2];
    private LayoutInterval[][] selectedComponentIntervals = new LayoutInterval[2][];
    private Boolean[] becomeResizing = new Boolean[2];
    private Collection<LayoutInterval>[] unresizedOnRemove;
    private int dimension;
    private LayoutInterval addingInterval;
    private LayoutRegion addingSpace;
    private boolean solveOverlap;
    private LayoutRegion closedSpace;
    private OriginalPosition originalPosition;
    private Object undoCheckMark;
    private int aEdge;
    private LayoutInterval aSnappedParallel;
    private LayoutInterval aSnappedNextTo;
    private LayoutConstants.PaddingType aPaddingType;

    LayoutFeeder(LayoutComponent[] selectedComponents, LayoutComponent targetContainer, LayoutOperations operations, LayoutDragger dragger) {
        this.layoutModel = operations.getModel();
        this.operations = operations;
        this.dragger = dragger;
        boolean stayInContainer = true;
        for (LayoutComponent c : selectedComponents) {
            if (c.getParent() != null && c.getParent() == targetContainer) continue;
            stayInContainer = false;
            break;
        }
        for (int dim = 0; dim < 2; ++dim) {
            LayoutInterval parent;
            OriginalPosition originalPos;
            LayoutInterval[] compIntervals = new LayoutInterval[selectedComponents.length];
            for (int i = 0; i < selectedComponents.length; ++i) {
                compIntervals[i] = selectedComponents[i].getLayoutInterval(dim);
            }
            this.selectedComponentIntervals[dim] = compIntervals;
            List<LayoutInterval> selCompList = Arrays.asList(compIntervals);
            List<LayoutInterval> inCommonParent = LayoutFeeder.getIntervalsInCommonParent(compIntervals);
            if (inCommonParent != null && !inCommonParent.isEmpty()) {
                originalPos = new OriginalPosition();
                LayoutInterval first = inCommonParent.get(0);
                parent = LayoutInterval.getFirstParent(first, 103);
                if (parent != null && (parent.getGroupAlignment() == 2 || parent.getGroupAlignment() == 3 || LayoutInterval.isAlignedAtBorder(first, parent, 0) && LayoutFeeder.isSignificantGroupEdge(parent, 0, false) || LayoutInterval.isAlignedAtBorder(first, parent, 1) && LayoutFeeder.isSignificantGroupEdge(parent, 1, false))) {
                    originalPos.closedSpace = new LayoutRegion();
                    originalPos.closedSpace.set(dim, parent.getCurrentSpace());
                }
            } else {
                originalPos = null;
            }
            if (dragger.isResizing(dim)) {
                LayoutInterval resizingComp = compIntervals[0];
                parent = resizingComp.getParent();
                int resizingEdge = dragger.getResizingEdge(dim);
                int origAlignment = resizingComp.getRawAlignment();
                IncludeDesc pos = LayoutFeeder.findOutCurrentPosition(selCompList, inCommonParent, originalPos != null && originalPos.closedSpace != null, dim, resizingEdge ^ 1);
                LayoutDragger.PositionDef newPos = dragger.getPositions()[dim];
                if (newPos == null || !newPos.snapped) {
                    int effAlign;
                    if (!pos.snapped() && (effAlign = LayoutInterval.getEffectiveAlignment(resizingComp)) != pos.alignment) {
                        pos.alignment = effAlign;
                        LayoutFeeder.findAlignedInterval(selCompList, inCommonParent, this.dimension, effAlign, pos);
                    }
                } else if (!(pos.alignment != 2 && pos.alignment != 3 || newPos.alignment != 0 && newPos.alignment != 1 || newPos.interval == parent || newPos.interval.getParent() == parent)) {
                    pos.alignment = newPos.alignment ^ 1;
                    if (resizingComp.getParent().getSubIntervalCount() > 2) {
                        pos.snappedParallel = resizingComp.getParent();
                    }
                    resizingComp.setAlignment(pos.alignment);
                }
                originalPos.desc1 = pos;
                this.newPositions[dim] = newPos;
                this.becomeResizing[dim] = LayoutFeeder.checkResizing(resizingComp, resizingEdge, newPos, dim);
                resizingComp.setAlignment(origAlignment);
                if (this.layoutModel.isChangeRecording()) {
                    this.undoMarks[dim] = new ArrayList();
                }
            } else {
                if (!dragger.isResizing()) {
                    this.newPositions[dim] = dragger.getPositions()[dim];
                }
                if (stayInContainer && originalPos != null) {
                    IncludeDesc pos2;
                    IncludeDesc pos1;
                    int alignment = -1;
                    originalPos.desc1 = pos1 = LayoutFeeder.findOutCurrentPosition(selCompList, inCommonParent, originalPos.closedSpace != null, dim, alignment);
                    alignment = pos1.alignment;
                    if (!(alignment != 0 && alignment != 1 || !(pos2 = LayoutFeeder.findOutCurrentPosition(selCompList, inCommonParent, originalPos.closedSpace != null, dim, alignment ^ 1)).snapped() && pos1.snapped())) {
                        originalPos.desc2 = pos2;
                    }
                    if (this.layoutModel.isChangeRecording()) {
                        this.undoMarks[dim] = new ArrayList();
                    }
                }
            }
            if (originalPos != null) {
                if (dragger.isResizing() && inCommonParent.size() == 1) {
                    originalPos.lPosFixed = LayoutFeeder.isFixedRelativePosition(inCommonParent.get(0), 0);
                    originalPos.tPosFixed = LayoutFeeder.isFixedRelativePosition(inCommonParent.get(0), 1);
                }
                LayoutFeeder.saveResizingState(inCommonParent, originalPos);
            }
            this.originalPositions[dim] = originalPos;
        }
    }

    void setUndo(Object start, Object end, int dim) {
        if (this.undoMarks[dim] != null && start != null && !start.equals(end)) {
            this.undoMarks[dim].add(start);
            this.undoMarks[dim].add(end);
        }
    }

    void setUp(LayoutRegion origSpace, Collection<LayoutInterval>[] unresizedOnRemove) {
        this.originalSpace = origSpace;
        this.unresizedOnRemove = unresizedOnRemove;
    }

    void add(LayoutInterval[] addingInts) {
        int overlapDim;
        this.addingSpace = this.dragger.getMovingSpace();
        int dim = overlapDim = this.getDimensionSolvingOverlap(this.newPositions);
        for (int dc = 0; dc < 2; ++dc) {
            IncludeDesc originalPos2;
            IncludeDesc originalPos1;
            this.dimension = dim;
            this.addingInterval = addingInts[dim];
            this.solveOverlap = overlapDim == dim;
            LayoutInterval root = this.dragger.getTargetRoots()[dim];
            this.originalPosition = this.originalPositions[dim];
            if (this.originalPosition != null) {
                this.originalPosition.desc1 = originalPos1 = LayoutFeeder.correctOriginalInclusion(this.originalPosition.desc1, root);
                this.originalPosition.desc2 = originalPos2 = LayoutFeeder.correctOriginalInclusion(this.originalPosition.desc2, root);
            } else {
                originalPos1 = null;
                originalPos2 = null;
            }
            this.undoCheckMark = this.layoutModel.getChangeMark();
            this.closedSpace = null;
            boolean onBaseline = originalPos1 != null && (originalPos1.alignment == 3 || originalPos1.alignment == 2);
            LayoutDragger.PositionDef newPos = this.newPositions[dim];
            if (this.dragger.isResizing() && this.dragger.isResizing(dim)) {
                boolean res = Boolean.TRUE.equals(this.becomeResizing[dim]);
                int min = res ? -1 : -2;
                int max = res ? Short.MAX_VALUE : -2;
                int pref = onBaseline && newPos != null && newPos.snapped && !newPos.nextTo && (newPos.alignment == 0 || newPos.alignment == 1) && originalPos1.snappedParallel != null ? originalPos1.snappedParallel.getCurrentSpace().size(dim) : this.addingSpace.size(dim);
                this.layoutModel.setIntervalSize(this.addingInterval, min, pref, max);
                this.layoutModel.changeIntervalAttribute(this.addingInterval, 1024, true);
            }
            if (!(this.dragger.isResizing(dim) || newPos == null || newPos.alignment != 2 && newPos.alignment != 3)) {
                if (originalPos1 == null || originalPos1.alignment != newPos.alignment || !LayoutFeeder.equalSnap(originalPos1.snappedParallel, newPos.interval, newPos.alignment) || !this.restoreDimension()) {
                    this.aEdge = newPos.alignment;
                    this.aSnappedParallel = newPos.interval;
                    this.addSimplyAligned();
                }
            } else if (this.dragger.isResizing() && onBaseline) {
                if (!this.restoreDimension()) {
                    this.aEdge = originalPos1.alignment;
                    this.aSnappedParallel = originalPos1.snappedParallel;
                    this.addSimplyAligned();
                }
            } else {
                int m;
                boolean preserveOriginal;
                boolean originalSignificant;
                IncludeDesc inclusion1 = null;
                IncludeDesc inclusion2 = null;
                LinkedList<IncludeDesc> inclusions = new LinkedList<IncludeDesc>();
                boolean bl = originalSignificant = this.dragger.isResizing(this.dimension) && originalPos1 != null && (originalPos1.snapped() || newPos == null || newPos.nextTo || newPos.interval == null || originalPos1.neighbor != null || originalPos1.parent.isSequential() && (!originalPos1.newSubGroup || !originalPos1.parent.isParentOf(newPos.interval)));
                if (this.dragger.isResizing(dim ^ 1) && (originalSignificant || newPos == null && originalPos1 != null)) {
                    this.aEdge = originalPos1.alignment;
                    this.aSnappedParallel = originalPos1.snappedParallel;
                    this.aSnappedNextTo = originalPos1.snappedNextTo;
                    this.aPaddingType = originalPos1.paddingType;
                    preserveOriginal = false;
                } else if (newPos != null) {
                    this.aEdge = newPos.alignment;
                    this.aSnappedParallel = newPos.snapped && !newPos.nextTo ? newPos.interval : null;
                    this.aSnappedNextTo = newPos.snapped && newPos.nextTo ? newPos.interval : null;
                    this.aPaddingType = newPos.paddingType;
                    preserveOriginal = originalSignificant;
                } else if (this.dragger.isResizing(dim) && originalPos1 != null) {
                    this.aEdge = originalPos1.alignment;
                    if (originalPos1.alignment == (this.dragger.getResizingEdge(dim) ^ 1)) {
                        this.aSnappedParallel = originalPos1.snappedParallel;
                        this.aSnappedNextTo = originalPos1.snappedNextTo;
                    }
                    this.aPaddingType = originalPos1.paddingType;
                    preserveOriginal = !LayoutFeeder.resizingOutOfOriginalAlignment(originalPos1, this.dragger.getResizingEdge(dim), this.addingSpace, dim);
                } else {
                    this.aEdge = -1;
                    this.aSnappedNextTo = null;
                    this.aSnappedParallel = null;
                    this.aPaddingType = null;
                    preserveOriginal = false;
                }
                this.analyzeParallel(root, inclusions);
                if (inclusions.isEmpty()) {
                    assert (this.aSnappedParallel != null);
                    if (this.dragger.isResizing() && originalPos1 != null && originalPos1.alignment == this.aEdge) {
                        inclusions.add(originalPos1);
                    } else {
                        this.addAligningInclusion(inclusions);
                    }
                } else {
                    IncludeDesc preferred = this.addAligningInclusion(inclusions);
                    if (inclusions.size() > 1) {
                        if ((preferred == null || preserveOriginal && originalPos1.alignment == this.aEdge) && this.dragger.isResizing()) {
                            preferred = originalPos1;
                        }
                        this.mergeParallelInclusions(inclusions, preferred, preserveOriginal);
                        assert (inclusions.size() == 1);
                    }
                }
                IncludeDesc found = (IncludeDesc)inclusions.get(0);
                inclusions.clear();
                if (preserveOriginal) {
                    inclusion1 = originalPos1;
                    if (found != originalPos1) {
                        LayoutInterval origP;
                        LayoutInterval foundP;
                        if (newPos != null) {
                            inclusion2 = found;
                        }
                        if ((foundP = found.parent) == (origP = originalPos1.parent) && found.newSubGroup || origP.isSequential() && foundP.isParallel() && foundP.isParentOf(origP) && LayoutUtils.contentOverlap(this.addingInterval, origP, dim)) {
                            inclusion1.newSubGroup = true;
                        }
                    }
                } else {
                    boolean secondRound;
                    inclusion1 = found;
                    if (newPos != null) {
                        if (this.dragger.isResizing(dim ^ 1) && originalSignificant) {
                            assert (this.dragger.isResizing(dim));
                            this.aEdge = newPos.alignment;
                            this.aSnappedParallel = !newPos.nextTo ? newPos.interval : null;
                            this.aSnappedNextTo = newPos.snapped && newPos.nextTo ? newPos.interval : null;
                            this.aPaddingType = newPos.paddingType;
                            secondRound = true;
                        } else if (inclusion1.parent.isSequential()) {
                            this.aEdge = newPos.alignment ^ 1;
                            this.aSnappedParallel = null;
                            this.aSnappedNextTo = null;
                            this.aPaddingType = null;
                            secondRound = true;
                        } else {
                            secondRound = false;
                        }
                    } else if (this.dragger.isResizing(dim ^ 1) && originalPos2 != null) {
                        assert (!this.dragger.isResizing(dim));
                        secondRound = true;
                        this.aEdge = originalPos2.alignment;
                        this.aSnappedParallel = originalPos2.snappedParallel;
                        this.aSnappedNextTo = originalPos2.snappedNextTo;
                        this.aPaddingType = originalPos2.paddingType;
                    } else {
                        secondRound = false;
                    }
                    if (secondRound) {
                        this.analyzeParallel(root, inclusions);
                        if (inclusions.isEmpty()) {
                            assert (this.aSnappedParallel != null);
                            if (originalPos2 != null && originalPos2.alignment == this.aEdge) {
                                inclusions.add(originalPos2);
                            } else {
                                this.addAligningInclusion(inclusions);
                            }
                        } else {
                            IncludeDesc preferred = this.addAligningInclusion(inclusions);
                            if (inclusions.size() > 1) {
                                if (preferred == null) {
                                    preferred = originalPos2 != null ? originalPos2 : originalPos1;
                                }
                                this.mergeParallelInclusions(inclusions, preferred, false);
                                assert (inclusions.size() == 1);
                            }
                        }
                        inclusion2 = (IncludeDesc)inclusions.get(0);
                        inclusions.clear();
                        if (!this.dragger.isResizing() && newPos != null) {
                            if (inclusion1.parent.getParent() == null && inclusion1.parent.getSubIntervalCount() == 0) {
                                inclusion1.parent = inclusion2.parent;
                                inclusion1.newSubGroup = inclusion2.newSubGroup;
                                inclusion1.neighbor = inclusion2.neighbor;
                                inclusion1.index = inclusion2.index;
                                inclusion2 = null;
                            } else if (!inclusion1.parent.isParentOf(inclusion2.parent)) {
                                inclusion2 = null;
                            }
                        }
                    }
                }
                if (!this.preferClosedPosition(inclusion1)) {
                    this.cancelResizingOfMovingComponent();
                }
                if ((m = this.mergeSequentialInclusions(inclusion1, inclusion2)) == 1 || m == 2) {
                    if (m == 2) {
                        inclusion1 = inclusion2;
                    }
                    inclusion2 = null;
                }
                if (this.dragger.isResizing(dim)) {
                    this.checkResizing2(inclusion1, inclusion2);
                }
                if (!this.unchangeDimension(inclusion1, inclusion2)) {
                    this.addInterval(inclusion1, inclusion2, !this.dragger.isResizing() && !LayoutUtils.getComponentIterator(root).hasNext());
                }
            }
            dim ^= 1;
        }
    }

    private static IncludeDesc findOutCurrentPosition(List<LayoutInterval> components, List<LayoutInterval> inParent, boolean inClosedSpace, int dimension, int alignment) {
        LayoutInterval prev;
        LayoutInterval gap;
        LayoutInterval firstParent;
        LayoutInterval parent = firstParent = inParent.get(0).getParent();
        int remainingCount = LayoutUtils.getRemainingCount(parent, components, true);
        IncludeDesc iDesc = new IncludeDesc();
        if (parent.isSequential() && remainingCount > 0) {
            if (alignment < 0) {
                alignment = 0;
            }
            if (remainingCount == 1) {
                iDesc.parent = parent.getParent();
                int index = 0;
                for (int i = parent.getSubIntervalCount() - 1; i >= 0; --i) {
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li.isEmptySpace()) continue;
                    if (inParent.contains(li)) {
                        index = i;
                        continue;
                    }
                    iDesc.neighbor = li;
                    iDesc.index = index;
                    break;
                }
            } else {
                iDesc.parent = parent;
                iDesc.index = parent.indexOf(inParent.get(0));
                for (LayoutInterval li : components) {
                    if (li.getParent() == parent) continue;
                    iDesc.newSubGroup = true;
                    break;
                }
            }
        } else {
            int currentAlign;
            if (parent.isSequential()) {
                currentAlign = parent.getAlignment();
                parent = parent.getParent();
                remainingCount = LayoutInterval.getCount(parent, Integer.MAX_VALUE, true) - 1;
            } else {
                currentAlign = inParent.get(0).getAlignment();
            }
            if (alignment < 0 || currentAlign != 0 && currentAlign != 1) {
                alignment = currentAlign;
            }
            if (remainingCount <= 1 && parent.getParent() != null) {
                LayoutInterval subGroup = parent;
                if ((parent = parent.getParent()).isSequential()) {
                    boolean inSequence = inClosedSpace;
                    if (!inSequence) {
                        LayoutRegion selSpace = new LayoutRegion();
                        for (LayoutInterval li : components) {
                            selSpace.expand(li.getCurrentSpace());
                        }
                        Iterator<LayoutInterval> it = parent.getSubIntervals();
                        while (it.hasNext()) {
                            LayoutInterval li;
                            li = it.next();
                            if (li.isEmptySpace() || li == subGroup || !LayoutRegion.overlap(selSpace, li.getCurrentSpace(), dimension ^ 1, 0)) continue;
                            inSequence = true;
                            break;
                        }
                    }
                    if (inSequence) {
                        iDesc.newSubGroup = true;
                        iDesc.index = parent.indexOf(subGroup);
                    } else {
                        parent = parent.getParent();
                    }
                }
            }
            iDesc.parent = parent;
        }
        alignment = LayoutFeeder.findAlignedInterval(components, inParent, dimension, alignment, iDesc);
        LayoutInterval borderInterval = null;
        if (alignment == 0 || alignment == 1) {
            if (firstParent.isSequential()) {
                borderInterval = inParent.get(alignment == 0 ? 0 : inParent.size() - 1);
            } else {
                for (LayoutInterval li : inParent) {
                    if (LayoutInterval.isAlignedAtBorder(li, alignment)) {
                        borderInterval = li;
                        break;
                    }
                    if (borderInterval != null || !LayoutInterval.isPlacedAtBorder(li, firstParent, dimension, alignment)) continue;
                    borderInterval = li;
                }
                if (borderInterval == null) {
                    borderInterval = inParent.get(0);
                }
            }
            iDesc.fixedPosition = LayoutFeeder.isFixedRelativePosition(borderInterval, alignment);
        }
        if (iDesc.snappedParallel == null && (alignment == 0 || alignment == 1) && (gap = LayoutInterval.getNeighbor(borderInterval, alignment, false, true, false)) != null && LayoutInterval.isFixedDefaultPadding(gap) && ((prev = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true)) == borderInterval || LayoutInterval.isPlacedAtBorder(borderInterval, prev, dimension, alignment))) {
            LayoutInterval next = LayoutInterval.getNeighbor(gap, alignment, true, true, false);
            if (next != null) {
                if (next.getParent() == gap.getParent() || next.getCurrentSpace().positions[dimension][alignment ^ 1] == gap.getParent().getCurrentSpace().positions[dimension][alignment]) {
                    iDesc.snappedNextTo = next;
                    iDesc.paddingType = gap.getPaddingType();
                }
            } else {
                next = LayoutInterval.getRoot(firstParent);
                if (LayoutInterval.isPlacedAtBorder(gap.getParent(), next, dimension, alignment)) {
                    iDesc.snappedNextTo = next;
                }
            }
        }
        iDesc.alignment = alignment;
        return iDesc;
    }

    private static List<LayoutInterval> getIntervalsInCommonParent(LayoutInterval[] compIntervals) {
        List<LayoutInterval> inParent = null;
        LayoutInterval commonParent = LayoutInterval.getCommonParent(compIntervals);
        if (commonParent != null) {
            if (compIntervals.length == 1) {
                inParent = Collections.singletonList(compIntervals[0]);
            } else {
                HashSet comps = new HashSet();
                Collections.addAll(comps, compIntervals);
                if (commonParent != null) {
                    boolean found = false;
                    boolean previous = false;
                    boolean all = true;
                    for (int i = 0; i < commonParent.getSubIntervalCount(); ++i) {
                        LayoutInterval li = commonParent.getSubInterval(i);
                        if (li.isEmptySpace()) continue;
                        int sel = LayoutFeeder.isInSelectedComponents(li, compIntervals, true);
                        if (sel > 0) {
                            if (!found) {
                                found = true;
                                inParent = new ArrayList<LayoutInterval>();
                            } else if (!previous && commonParent.isSequential()) {
                                inParent.clear();
                                break;
                            }
                            previous = true;
                            inParent.add(li);
                            continue;
                        }
                        if (sel < 0) {
                            previous = false;
                            all = false;
                            continue;
                        }
                        if (inParent == null) break;
                        inParent.clear();
                        break;
                    }
                    if (commonParent.isParallel() && commonParent.getParent() != null && found && all) {
                        inParent.clear();
                        inParent.add(commonParent);
                        commonParent = commonParent.getParent();
                    }
                }
            }
        }
        if (inParent == null) {
            inParent = Collections.emptyList();
        }
        return inParent;
    }

    private static int isInSelectedComponents(LayoutInterval interval, LayoutInterval[] selectedComps, boolean firstLevel) {
        if (interval.isComponent()) {
            for (LayoutInterval li : selectedComps) {
                if (li != interval) continue;
                return 1;
            }
        } else if (interval.isGroup()) {
            boolean oneEnough = firstLevel && interval.isParallel();
            boolean inSelected = false;
            boolean notInSelected = false;
            for (int i = 0; i < interval.getSubIntervalCount(); ++i) {
                LayoutInterval li = interval.getSubInterval(i);
                if (li.isEmptySpace()) continue;
                int sel = LayoutFeeder.isInSelectedComponents(li, selectedComps, false);
                if (sel > 0) {
                    if (oneEnough) {
                        return 1;
                    }
                    inSelected = true;
                    continue;
                }
                if (sel < 0) {
                    notInSelected = true;
                    continue;
                }
                return 0;
            }
            if (inSelected && !notInSelected) {
                return 1;
            }
            if (!inSelected) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private static boolean isFixedRelativePosition(LayoutInterval interval, int edge) {
        assert (edge == 0 || edge == 1);
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isSequential()) {
            LayoutInterval li = LayoutInterval.getDirectNeighbor(interval, edge, false);
            if (li != null) {
                return !LayoutInterval.wantResize(li);
            }
            interval = parent;
            parent = interval.getParent();
        }
        if (!LayoutInterval.isAlignedAtBorder(interval, parent, edge) && LayoutInterval.contentWantResize(parent)) {
            return false;
        }
        return LayoutFeeder.isFixedRelativePosition(parent, edge);
    }

    private static int findAlignedInterval(List<LayoutInterval> components, List<LayoutInterval> inParent, int dimension, int alignment, IncludeDesc iDesc) {
        LayoutInterval neighbor;
        LayoutInterval interval = inParent.get(0);
        LayoutInterval parent = interval.getParent();
        if (parent.isSequential() && alignment == 1) {
            interval = inParent.get(inParent.size() - 1);
        }
        boolean indent = false;
        if ((alignment == 0 || alignment == 1) && parent.isSequential() && LayoutInterval.getCount(parent, -1, true) == 1 && (neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false)) != null && neighbor.isEmptySpace() && !LayoutInterval.canResize(neighbor) && LayoutInterval.getCount(parent.getParent(), Integer.MAX_VALUE, true) == 2 && !LayoutInterval.isAlignedAtBorder(neighbor, LayoutInterval.getRoot(parent), alignment)) {
            indent = true;
        }
        LayoutInterval closedAlignRep = null;
        if (!(components.size() <= 1 || indent || alignment != 0 && alignment != 1)) {
            for (LayoutInterval comp : components) {
                if (comp.getAlignment() != 2 && comp.getAlignment() != 3) continue;
                Iterator<LayoutInterval> it = comp.getParent().getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = it.next();
                    if (sub == comp || components.contains(sub)) continue;
                    closedAlignRep = comp;
                    break;
                }
                if (closedAlignRep == null) continue;
                break;
            }
        }
        int overallAlignment = alignment;
        if (closedAlignRep != null) {
            alignment = closedAlignRep.getAlignment();
            interval = closedAlignRep;
            parent = closedAlignRep.getParent();
        }
        LayoutInterval alignedInterval = null;
        LayoutInterval directParent = parent;
        do {
            parent = LayoutInterval.getFirstParent(interval, 103);
            if (!indent) {
                boolean aligned;
                if (alignment == 0 || alignment == 1) {
                    if (parent != directParent) {
                        aligned = LayoutInterval.isAlignedAtBorder(interval, parent, alignment);
                    } else {
                        aligned = false;
                        for (LayoutInterval li : inParent) {
                            if (!LayoutInterval.isAlignedAtBorder(li = LayoutUtils.getOutermostComponent(li, dimension, alignment), alignment)) continue;
                            aligned = true;
                            break;
                        }
                    }
                } else {
                    boolean bl = aligned = interval.getParent() == parent && interval.getAlignment() == alignment;
                }
                if (!aligned) break;
                if (parent.getParent() == null) {
                    alignedInterval = parent;
                    break;
                }
            }
            Iterator<LayoutInterval> it = parent.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval sub = it.next();
                if (sub.isEmptySpace() || components.contains(sub) || (parent == directParent || sub == interval || sub.isParentOf(interval)) && (parent != directParent || inParent.contains(sub))) continue;
                if (alignment == 0 || alignment == 1) {
                    LayoutInterval li;
                    li = LayoutUtils.getOutermostComponent(sub, dimension, alignment);
                    if (!LayoutInterval.isAlignedAtBorder(li, parent, alignment) && !LayoutInterval.isPlacedAtBorder(li, parent, dimension, alignment)) continue;
                    alignedInterval = li;
                    break;
                }
                alignedInterval = sub;
                break;
            }
            interval = parent;
        } while (!indent && alignedInterval == null);
        if (alignedInterval != null) {
            int remainingCount;
            overallAlignment = alignment;
            if (alignedInterval.getParent() == parent && (remainingCount = LayoutUtils.getRemainingCount(parent, components, true)) >= 2) {
                alignedInterval = parent;
            }
            iDesc.snappedParallel = alignedInterval;
        }
        return overallAlignment;
    }

    private static void saveResizingState(List<LayoutInterval> inParent, OriginalPosition pos) {
        LayoutInterval parent = inParent.get(0).getParent();
        boolean wholeResizing = inParent.size() == 1 || parent.isParallel();
        boolean suppResChecked = false;
        boolean suppressedResizing = false;
        for (LayoutInterval li : inParent) {
            if (LayoutInterval.wantResize(li)) {
                if (suppResChecked) continue;
                suppressedResizing = !LayoutInterval.canResizeInLayout(li);
                suppResChecked = true;
                continue;
            }
            wholeResizing = false;
        }
        pos.wholeResizing = wholeResizing;
        pos.suppressedResizing = suppressedResizing;
    }

    private static Boolean checkResizing(LayoutInterval interval, int resizingEdge, LayoutDragger.PositionDef newPos, int dim) {
        int fixedEdge = resizingEdge ^ 1;
        Boolean resizing = null;
        if (newPos != null && newPos.snapped && newPos.interval != null) {
            int align2;
            int align1;
            LayoutInterval parent;
            if (newPos.interval.isParentOf(interval)) {
                parent = newPos.interval;
                align1 = LayoutInterval.getEffectiveAlignmentInParent(interval, newPos.interval, fixedEdge);
                align2 = resizingEdge;
            } else {
                parent = LayoutInterval.getCommonParent(interval, newPos.interval);
                align1 = LayoutFeeder.determineFixedEdgeAlignemnt(interval, parent, fixedEdge, dim);
                int n = align1 == resizingEdge ? resizingEdge : (align2 = LayoutInterval.getEffectiveAlignmentInParent(newPos.interval, parent, newPos.nextTo ? fixedEdge : resizingEdge));
            }
            if (align1 == resizingEdge && LayoutInterval.wantResize(interval.getParent())) {
                resizing = Boolean.FALSE;
            } else if (!(align1 == align2 || align1 != 0 && align1 != 1 || align2 != 0 && align2 != 1 || parent.getParent() != null && !LayoutInterval.wantResize(parent))) {
                resizing = Boolean.TRUE;
            }
        }
        return resizing;
    }

    private static int determineFixedEdgeAlignemnt(LayoutInterval resizingInterval, LayoutInterval parent, int fixedEdge, int dimension) {
        LayoutInterval parParent;
        if (parent.isSequential() && LayoutInterval.wantResize(resizingInterval) && parent.isParentOf(parParent = LayoutInterval.getFirstParent(resizingInterval, 103)) && LayoutInterval.isPlacedAtBorder(resizingInterval, parParent, dimension, fixedEdge) && LayoutUtils.anythingAtGroupEdge(parParent, resizingInterval, dimension, fixedEdge)) {
            return fixedEdge;
        }
        return LayoutInterval.getEffectiveAlignmentInParent(resizingInterval, parent, fixedEdge);
    }

    private static boolean resizingOutOfOriginalAlignment(IncludeDesc originalPos, int resizingEdge, LayoutRegion space, int dimension) {
        int align;
        if (originalPos.snappedParallel != null && ((align = originalPos.alignment) == 0 || align == 1) && resizingEdge == align) {
            int d;
            int n = d = align == 0 ? 1 : -1;
            if (space.positions[dimension][align] * d < originalPos.snappedParallel.getCurrentSpace().positions[dimension][align] * d) {
                return true;
            }
        }
        return false;
    }

    private static IncludeDesc correctOriginalInclusion(IncludeDesc iDesc, LayoutInterval targetRoot) {
        if (iDesc != null) {
            if (iDesc.parent.getParent() == null && iDesc.parent.getSubIntervalCount() == 0 && iDesc.parent != targetRoot) {
                LayoutInterval interval;
                if (iDesc.snappedParallel != null) {
                    interval = iDesc.snappedParallel;
                } else if (iDesc.snappedNextTo != null) {
                    interval = iDesc.snappedNextTo;
                } else if (iDesc.neighbor != null) {
                    interval = iDesc.neighbor;
                } else {
                    return null;
                }
                if (interval != null) {
                    LayoutInterval layoutInterval = iDesc.parent = interval.getParent() != null ? LayoutInterval.getFirstParent(interval, 103) : interval;
                }
            }
            if (iDesc.neighbor != null) {
                if (iDesc.neighbor.isParallel() && iDesc.neighbor.getParent() == null) {
                    iDesc.neighbor = null;
                } else if (iDesc.neighbor.getParent().isSequential()) {
                    iDesc.parent = iDesc.neighbor.getParent();
                    iDesc.neighbor = null;
                    if (iDesc.index > iDesc.parent.getSubIntervalCount()) {
                        iDesc.index = iDesc.parent.getSubIntervalCount();
                    }
                }
            }
        }
        return iDesc;
    }

    private boolean unchangeDimension(IncludeDesc ndesc1, IncludeDesc ndesc2) {
        IncludeDesc odesc2;
        IncludeDesc odesc1;
        if (this.undoMarks[this.dimension] == null || !this.layoutModel.getChangeMark().equals(this.undoCheckMark)) {
            return false;
        }
        if (this.dragger.isResizing(this.dimension)) {
            return false;
        }
        IncludeDesc includeDesc = odesc1 = this.originalPosition != null ? this.originalPosition.desc1 : null;
        if (odesc1 == null || ndesc1 == null || odesc1.parent.getSubIntervalCount() == 0) {
            return false;
        }
        IncludeDesc includeDesc2 = odesc2 = this.originalPosition != null ? this.originalPosition.desc2 : null;
        if (ndesc2 != null && odesc2 == null) {
            return false;
        }
        if ((ndesc1.alignment == 0 || ndesc1.alignment == 1) && ndesc1.alignment != odesc1.alignment && odesc2 != null && ndesc1.alignment == odesc2.alignment) {
            IncludeDesc tmp = odesc1;
            odesc1 = odesc2;
            odesc2 = tmp;
        }
        int align = odesc1.alignment;
        if (ndesc1.alignment != -1 && ndesc1.alignment != odesc1.alignment) {
            align = ndesc1.alignment;
        }
        boolean multi = this.selectedComponentIntervals[this.dimension].length > 1;
        boolean originalClosedAlignment = multi && (odesc1.alignment == 2 || odesc1.alignment == 3);
        int dst = LayoutRegion.distance(this.originalSpace, this.addingSpace, this.dimension, 2, 2);
        if (dst >= -5 && dst <= 5 && originalClosedAlignment) {
            dst = 0;
        }
        if (dst != 0 && !LayoutFeeder.equalNextTo(ndesc1, odesc1, align)) {
            return false;
        }
        if (!originalClosedAlignment && align != odesc1.alignment) {
            return this.plainAlignmentChange(ndesc1, odesc1);
        }
        boolean equalToOriginal = false;
        LayoutInterval np = ndesc1.parent;
        LayoutInterval op = odesc1.parent;
        if (np != op) {
            if (np.isParentOf(op)) {
                if (np.isParallel()) {
                    if (ndesc1.neighbor == null) {
                        if (op.isParallel()) {
                            if (LayoutInterval.isClosedGroup(op, align ^ 1)) {
                                equalToOriginal = true;
                            } else {
                                LayoutInterval neighbor = LayoutInterval.getNeighbor(op, align ^ 1, true, true, false);
                                if (neighbor == null || !np.isParentOf(neighbor)) {
                                    equalToOriginal = true;
                                }
                            }
                        } else if (multi && odesc1.newSubGroup) {
                            equalToOriginal = true;
                        }
                    }
                } else if (op.isParallel() && (LayoutFeeder.equalNextTo(ndesc1, odesc1, align) || LayoutFeeder.equalSnap(ndesc1.snappedParallel, odesc1.snappedParallel, align))) {
                    equalToOriginal = true;
                }
            }
        } else if (np.isParallel() && ndesc1.neighbor == odesc1.neighbor || np.isSequential() && ndesc1.newSubGroup == odesc1.newSubGroup) {
            equalToOriginal = true;
        }
        if (equalToOriginal) {
            return this.restoreDimension();
        }
        return false;
    }

    private boolean restoreDimension() {
        boolean undone = false;
        List undoList = this.undoMarks[this.dimension];
        if (undoList != null) {
            for (int n = undoList.size() - 1; n > 0; n -= 2) {
                Object startMark = undoList.get(n - 1);
                Object endMark = undoList.get(n);
                undone |= this.layoutModel.revert(startMark, endMark);
            }
            undoList.clear();
        }
        return undone;
    }

    private static boolean equalNextTo(IncludeDesc iDesc1, IncludeDesc iDesc2, int alignment) {
        if (iDesc1.parent.isSequential() && iDesc1.snappedNextTo != null) {
            LayoutInterval neighbor;
            if (iDesc1.parent == iDesc2.parent && iDesc1.snappedNextTo == iDesc2.snappedNextTo) {
                return iDesc1.paddingType == iDesc2.paddingType;
            }
            if (iDesc2.snappedParallel != null && (iDesc1.parent == iDesc2.parent || iDesc1.parent.isParentOf(iDesc2.parent) && iDesc1.newSubGroup && (iDesc2.parent.isParallel() || iDesc2.newSubGroup)) && (neighbor = LayoutInterval.getNeighbor(iDesc2.snappedParallel, alignment, false, true, true)) != null && neighbor.isEmptySpace() && neighbor.getPreferredSize() == -1) {
                if ((neighbor = LayoutInterval.getDirectNeighbor(neighbor, alignment, false)) == null) {
                    neighbor = LayoutInterval.getRoot(iDesc2.snappedParallel);
                }
                if (LayoutFeeder.equalSnap(neighbor, iDesc1.snappedNextTo, alignment)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean equalSnap(LayoutInterval interval1, LayoutInterval interval2, int alignment) {
        if (interval1 != null && interval2 != null) {
            if (interval1 == interval2) {
                return true;
            }
            if (alignment == 0 || alignment == 1) {
                if (interval1.isParentOf(interval2)) {
                    return LayoutInterval.isAlignedAtBorder(interval2, interval1, alignment);
                }
                if (interval2.isParentOf(interval1)) {
                    return LayoutInterval.isAlignedAtBorder(interval1, interval2, alignment);
                }
                return LayoutUtils.alignedIntervals(interval1, interval2, alignment);
            }
            if (alignment == 2 || alignment == 3) {
                return interval1 == interval2.getParent() && interval1.getGroupAlignment() == alignment && interval2.getAlignment() == alignment || interval2 == interval1.getParent() && interval2.getGroupAlignment() == alignment && interval1.getAlignment() == alignment || interval1.getParent() == interval2.getParent() && interval1.getAlignment() == alignment && interval2.getAlignment() == alignment;
            }
        }
        return false;
    }

    private boolean plainAlignmentChange(IncludeDesc ndesc, IncludeDesc odesc) {
        if (this.closedSpace != null && odesc.snappedParallel != null) {
            LayoutInterval ogroup;
            LayoutInterval layoutInterval = ogroup = odesc.snappedParallel == odesc.parent ? odesc.parent : null;
            if (this.restoreDimension()) {
                if (ogroup == null) {
                    ogroup = odesc.snappedParallel.getParent();
                }
                LayoutInterval moved = this.dragger.getMovingComponents()[0].getLayoutInterval(this.dimension);
                Iterator<LayoutInterval> it = ogroup.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = it.next();
                    if (li != moved && !li.isParentOf(moved)) continue;
                    this.layoutModel.setIntervalAlignment(li, ndesc.alignment);
                    return true;
                }
            }
        }
        return false;
    }

    private int getDimensionSolvingOverlap(LayoutDragger.PositionDef[] positions) {
        boolean[] overlapDim;
        if (this.dragger.isResizing(0) && !this.dragger.isResizing(1)) {
            return 0;
        }
        if (this.dragger.isResizing(1) && !this.dragger.isResizing(0) || positions[0] != null && positions[0].snapped && (positions[1] == null || !positions[1].snapped) || positions[1] != null && !positions[1].nextTo && positions[1].snapped && positions[1].interval.getParent() == null && !LayoutFeeder.existsComponentPlacedAtBorder(positions[1].interval, 1, positions[1].alignment)) {
            return 1;
        }
        if (positions[1] != null && positions[1].nextTo && positions[1].snapped && positions[1].interval.getParent() == null) {
            int alignment = positions[1].alignment;
            int[][] overlapSides = LayoutFeeder.overlappingGapSides(this.dragger.getTargetRoots()[0], this.dragger.getMovingSpace());
            if ((alignment == 0 || alignment == 1) && overlapSides[1][1 - alignment] != 0 && overlapSides[1][alignment] == 0) {
                return 1;
            }
        }
        if (!(positions[0] != null && positions[0].snapped || positions[1] != null && positions[1].snapped || !(overlapDim = LayoutFeeder.overlappingGapDimensions(this.dragger.getTargetRoots()[0], this.dragger.getMovingSpace()))[1] || overlapDim[0])) {
            return 1;
        }
        return 0;
    }

    private static boolean existsComponentPlacedAtBorder(LayoutInterval interval, int dimension, int alignment) {
        Iterator<LayoutInterval> iter = interval.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = iter.next();
            if (!LayoutInterval.isPlacedAtBorder(interval, dimension, alignment)) continue;
            if (subInterval.isComponent()) {
                return true;
            }
            if (!subInterval.isGroup() || !LayoutFeeder.existsComponentPlacedAtBorder(subInterval, dimension, alignment)) continue;
            return true;
        }
        return false;
    }

    private static void fillOverlappingComponents(List<LayoutComponent> overlaps, LayoutInterval group, LayoutRegion region) {
        Iterator<LayoutInterval> iter = group.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval subInterval = iter.next();
            if (subInterval.isGroup()) {
                LayoutFeeder.fillOverlappingComponents(overlaps, subInterval, region);
                continue;
            }
            if (!subInterval.isComponent()) continue;
            LayoutComponent component = subInterval.getComponent();
            LayoutRegion compRegion = subInterval.getCurrentSpace();
            if (!LayoutRegion.overlap(compRegion, region, 0, 0) || !LayoutRegion.overlap(compRegion, region, 1, 0)) continue;
            overlaps.add(component);
        }
    }

    private static boolean[] overlappingGapDimensions(LayoutInterval layoutRoot, LayoutRegion region) {
        boolean[] result = new boolean[2];
        int[][] overlapSides = LayoutFeeder.overlappingGapSides(layoutRoot, region);
        for (int i = 0; i < 2; ++i) {
            result[i] = overlapSides[i][0] == 1 && overlapSides[i][1] == 1;
        }
        return result;
    }

    private static int[][] overlappingGapSides(LayoutInterval layoutRoot, LayoutRegion region) {
        int[][] overlapSides = new int[][]{{0, 0}, {0, 0}};
        LinkedList<LayoutComponent> overlaps = new LinkedList<LayoutComponent>();
        LayoutFeeder.fillOverlappingComponents(overlaps, layoutRoot, region);
        for (LayoutComponent component : overlaps) {
            LayoutRegion compRegion = component.getLayoutInterval(0).getCurrentSpace();
            for (int i = 0; i < 2; ++i) {
                int[] edges = LayoutFeeder.overlappingSides(compRegion, region, i);
                for (int j = 0; j < 2; ++j) {
                    if (edges[j] == 1) {
                        overlapSides[i][j] = 1;
                        continue;
                    }
                    if (edges[j] != -1) continue;
                    if (overlapSides[i][j] == -1) {
                        overlapSides[i][j] = 1;
                        continue;
                    }
                    if (overlapSides[i][j] != 0) continue;
                    overlapSides[i][j] = -1;
                }
            }
        }
        return overlapSides;
    }

    private static int[] overlappingSides(LayoutRegion compRegion, LayoutRegion region, int dimension) {
        int[] sides = new int[2];
        int compLeading = compRegion.positions[dimension][0];
        int compTrailing = compRegion.positions[dimension][1];
        int regLeading = region.positions[dimension][0];
        int regTrailing = region.positions[dimension][1];
        if (regLeading < compTrailing && compTrailing < regTrailing) {
            sides[0] = 1;
        }
        if (regLeading < compLeading && compLeading < regTrailing) {
            sides[1] = 1;
        }
        if (sides[0] == 1 && sides[1] == 1) {
            sides[1] = -1;
            sides[0] = -1;
        }
        return sides;
    }

    private void cancelResizingOfMovingComponent() {
        if (!this.dragger.isResizing() && this.originalPosition != null && this.originalPosition.suppressedResizing) {
            Object start = this.layoutModel.getChangeMark();
            if (this.addingInterval.isComponent()) {
                assert (LayoutInterval.wantResize(this.addingInterval));
                this.operations.eliminateResizing(this.addingInterval, this.dimension, null);
            } else if (this.addingInterval.isParallel()) {
                this.addingInterval.setMaximumSize(-2);
            }
            Object end = this.layoutModel.getChangeMark();
            this.setUndo(start, end, this.dimension);
            if (start.equals(this.undoCheckMark)) {
                this.undoCheckMark = end;
            }
        }
    }

    private void checkResizing2(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        if (!LayoutInterval.wantResize(this.addingInterval) && this.becomeResizing[this.dimension] == null && (iDesc1.snapped() || iDesc1.fixedPosition) && iDesc2 != null && iDesc2.snapped()) {
            LayoutInterval snap1;
            assert (this.dragger.getResizingEdge(this.dimension) == iDesc2.alignment);
            if (iDesc1.snapped()) {
                snap1 = iDesc1.snappedParallel != null ? iDesc1.snappedParallel : iDesc1.snappedNextTo;
            } else if (iDesc1.neighbor != null) {
                snap1 = iDesc1.neighbor;
            } else if (iDesc1.parent.isParallel()) {
                snap1 = iDesc1.parent;
            } else {
                snap1 = null;
                LayoutInterval p = iDesc1.parent;
                int i = iDesc1.index;
                if (iDesc1.alignment == 0 && i >= p.getSubIntervalCount()) {
                    i = p.getSubIntervalCount() - 1;
                }
                while (i >= 0 && i < p.getSubIntervalCount()) {
                    LayoutInterval li = p.getSubInterval(i);
                    if (!li.isEmptySpace()) {
                        snap1 = li;
                        break;
                    }
                    i += iDesc1.alignment == 1 ? 1 : -1;
                }
                if (snap1 == null) {
                    snap1 = iDesc1.parent.getParent();
                }
            }
            LayoutInterval snap2 = iDesc2.snappedParallel != null ? iDesc2.snappedParallel : iDesc2.snappedNextTo;
            if (this.snapEqualToParallelSnap(snap2, snap2 == iDesc2.snappedParallel, iDesc2.alignment, snap1) && (this.snapEqualToParallelSnap(snap1, snap1 == iDesc1.snappedParallel, iDesc1.alignment, snap2) || this.tiedToParallelSnap(snap1, iDesc1.alignment, snap2))) {
                this.operations.setIntervalResizing(this.addingInterval, true);
            }
        }
    }

    private boolean snapEqualToParallelSnap(LayoutInterval snapped, boolean parallel, int alignment, LayoutInterval otherSnapped) {
        if (snapped.getParent() == null) {
            LayoutInterval group;
            LayoutInterval layoutInterval = group = otherSnapped.isGroup() ? otherSnapped : otherSnapped.getParent();
            while (group != snapped && !LayoutInterval.isPlacedAtBorder(group, snapped, this.dimension, alignment)) {
                group = group.getParent();
            }
            return LayoutUtils.anythingAtGroupEdge(group, null, this.dimension, alignment);
        }
        if (parallel) {
            return true;
        }
        LayoutInterval neighborGap = LayoutInterval.getDirectNeighbor(snapped, alignment ^ 1, false);
        return neighborGap != null && neighborGap.isEmptySpace() && neighborGap.getPreferredSize() == -1 && neighborGap.getDiffToDefaultSize() == 0;
    }

    private boolean tiedToParallelSnap(LayoutInterval snapped, int alignment, LayoutInterval otherSnapped) {
        LayoutInterval tieParent;
        if (otherSnapped == null || otherSnapped.getParent() == null) {
            tieParent = LayoutInterval.getFirstParent(snapped, 103);
        } else if (otherSnapped.isParallel() && otherSnapped.isParentOf(snapped)) {
            tieParent = otherSnapped;
        } else {
            tieParent = LayoutInterval.getCommonParent(snapped, otherSnapped);
            if (tieParent != null && tieParent.isSequential()) {
                LayoutInterval p = snapped;
                if (p != tieParent) {
                    while (p.getParent() != tieParent) {
                        p = p.getParent();
                    }
                }
                LayoutInterval layoutInterval = tieParent = p.isParallel() ? p : null;
            }
        }
        if (tieParent != null) {
            if (tieParent.isParentOf(snapped)) {
                snapped = LayoutFeeder.tiedToParent(snapped, tieParent, false, this.dimension, alignment);
            }
            if (snapped != null && LayoutUtils.anythingAtGroupEdge(tieParent, snapped, this.dimension, alignment)) {
                return true;
            }
        }
        return false;
    }

    private static LayoutInterval tiedToParent(LayoutInterval interval, LayoutInterval tieParent, boolean defGap, int dimension, int alignment) {
        if (LayoutInterval.wantResize(interval)) {
            return null;
        }
        LayoutInterval parParent = interval;
        while (parParent != tieParent) {
            interval = parParent;
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            while (neighbor != null) {
                if (LayoutInterval.canResize(neighbor) || neighbor.isEmptySpace() && defGap && neighbor.getPreferredSize() != -1) {
                    return null;
                }
                interval = neighbor;
                neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            }
            if (interval.isEmptySpace()) {
                interval = interval.getParent();
                assert (interval.isSequential());
            }
            if (LayoutInterval.isPlacedAtBorder(interval, parParent = LayoutInterval.getFirstParent(interval, 103), dimension, alignment)) continue;
            return null;
        }
        while (interval != tieParent && interval != null && interval.getParent() != tieParent) {
            interval = interval.getParent();
        }
        return interval;
    }

    private void addSimplyAligned() {
        LayoutRegion currentSpace;
        LayoutInterval group;
        int alignment = this.aEdge;
        assert (alignment == 2 || alignment == 3);
        this.layoutModel.setIntervalAlignment(this.addingInterval, alignment);
        if (this.aSnappedParallel.isParallel() && this.aSnappedParallel.getGroupAlignment() == alignment) {
            group = this.aSnappedParallel;
            currentSpace = this.aSnappedParallel.getCurrentSpace();
        } else {
            group = this.aSnappedParallel.getParent();
            if (group.isParallel() && group.getGroupAlignment() == alignment) {
                currentSpace = group.getCurrentSpace();
            } else {
                int alignIndex = this.layoutModel.removeInterval(this.aSnappedParallel);
                LayoutInterval subGroup = new LayoutInterval(103);
                subGroup.setGroupAlignment(alignment);
                if (group.isParallel()) {
                    subGroup.setAlignment(this.aSnappedParallel.getAlignment());
                }
                this.layoutModel.setIntervalAlignment(this.aSnappedParallel, alignment);
                this.layoutModel.addInterval(this.aSnappedParallel, subGroup, -1);
                this.layoutModel.addInterval(subGroup, group, alignIndex);
                group = subGroup;
                currentSpace = this.aSnappedParallel.getCurrentSpace();
            }
        }
        this.layoutModel.addInterval(this.addingInterval, group, -1);
        for (int e = 0; e <= 1; ++e) {
            int growth;
            LayoutInterval gap = LayoutInterval.getNeighbor(group, e, false, true, false);
            if (gap == null || !gap.isEmptySpace() || LayoutInterval.isDefaultPadding(gap)) continue;
            if (gap.getParent() == group.getParent()) {
                growth = LayoutRegion.distance(this.addingSpace, currentSpace, this.dimension, e, e);
            } else {
                LayoutInterval superGroup = LayoutInterval.getDirectNeighbor(gap, e ^ 1, true);
                growth = LayoutRegion.distance(this.addingSpace, superGroup.getCurrentSpace(), this.dimension, e, e);
            }
            if (e == 1) {
                growth *= -1;
            }
            if (growth <= 0) continue;
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, e, true);
            int npos = neighbor != null ? neighbor.getCurrentSpace().positions[this.dimension][e ^ 1] : LayoutInterval.getFirstParent((LayoutInterval)gap, (int)103).getCurrentSpace().positions[this.dimension][e];
            int dist = this.addingSpace.positions[this.dimension][e] - npos;
            if (e == 1) {
                dist *= -1;
            }
            if (dist >= LayoutInterval.getCurrentSize(gap, this.dimension) || dist <= 0) continue;
            this.operations.resizeInterval(gap, dist);
        }
    }

    private void addInterval(IncludeDesc iDesc1, IncludeDesc iDesc2, boolean newRoot) {
        int nonEmptyCount;
        this.addToGroup(iDesc1, iDesc2, true);
        List<LayoutInterval> added = this.getAddedIntervals();
        if (iDesc1.snappedParallel != null || iDesc2 != null && iDesc2.snappedParallel != null) {
            if (iDesc2 != null && iDesc2.snappedParallel != null) {
                this.alignInParallel(this.getAlignRep(added, iDesc2.alignment), iDesc2.snappedParallel, iDesc2.alignment);
            }
            if (iDesc1.snappedParallel != null) {
                this.alignInParallel(this.getAlignRep(added, iDesc1.alignment), iDesc1.snappedParallel, iDesc1.alignment);
            }
        }
        this.checkParallelResizing(added, iDesc1, iDesc2);
        if (!newRoot) {
            this.accommodateOutPosition(added);
        }
        LayoutInterval interval = this.getAddedIntervals().get(0);
        if (this.dragger.isResizing(this.dimension) && LayoutInterval.wantResize(interval)) {
            this.operations.suppressResizingOfSurroundingGaps(interval);
        }
        this.operations.mergeParallelGroups(LayoutInterval.getRoot(this.selectedComponentIntervals[this.dimension][0]));
        LayoutInterval parent = null;
        do {
            LayoutInterval p;
            if ((p = LayoutInterval.getFirstParent(interval = this.getAddedIntervals().get(0), 103)) != parent) {
                parent = p;
                this.operations.optimizeGaps(parent, this.dimension);
                continue;
            }
            parent = LayoutInterval.getFirstParent(parent, 103);
            while (parent != null) {
                this.operations.optimizeGaps(parent, this.dimension);
                parent = LayoutInterval.getFirstParent(parent, 103);
            }
        } while (parent != null);
        interval = this.getAddedIntervals().get(0);
        parent = interval.getParent();
        if (!parent.isSequential() || (nonEmptyCount = LayoutInterval.getCount(parent, Integer.MAX_VALUE, true)) <= 1 || this.dimension == 0) {
            // empty if block
        }
    }

    private List<LayoutInterval> getAddedIntervals() {
        return LayoutFeeder.getIntervalsInCommonParent(this.selectedComponentIntervals[this.dimension]);
    }

    private LayoutInterval getAlignRep(List<LayoutInterval> added, int alignment) {
        LayoutInterval first = added.get(0);
        if (added.size() == 1) {
            return first;
        }
        LayoutInterval parent = first.getParent();
        if (parent.isSequential()) {
            return alignment != 1 ? first : added.get(added.size() - 1);
        }
        return parent;
    }

    private void addToGroup(IncludeDesc iDesc1, IncludeDesc iDesc2, boolean definite) {
        IncludeDesc iiDesc;
        assert (iDesc2 == null || iDesc1.parent == iDesc2.parent && iDesc1.newSubGroup == iDesc2.newSubGroup && iDesc1.neighbor == iDesc2.neighbor);
        LayoutInterval parent = iDesc1.parent;
        LayoutInterval seq = null;
        boolean subseq = false;
        int index = 0;
        if (parent.isSequential()) {
            if (iDesc1.newSubGroup) {
                int closeAlign2;
                int closeAlign1;
                LayoutRegion space;
                LayoutRegion layoutRegion = space = this.closedSpace == null ? this.addingSpace : this.closedSpace;
                if (this.closedSpace != null) {
                    closeAlign1 = 0;
                    closeAlign2 = 1;
                } else {
                    closeAlign1 = this.getExtractCloseAlign(iDesc1);
                    closeAlign2 = this.getExtractCloseAlign(iDesc2);
                }
                LayoutInterval subgroup = this.extractParallelSequence(parent, space, closeAlign1, closeAlign2, iDesc1.alignment, null);
                if (subgroup != null) {
                    seq = new LayoutInterval(102);
                    parent = subgroup;
                    subseq = true;
                }
            }
            if (seq == null) {
                seq = parent;
                parent = seq.getParent();
                index = iDesc1.index;
            }
            if (iDesc2 != null && iDesc2.alignment == this.dragger.getResizingEdge(this.dimension)) {
                this.alignWithResizingInSubgroup(seq, parent, iDesc2);
            }
        } else {
            LayoutInterval neighbor = iDesc1.neighbor;
            if (neighbor != null) {
                assert (neighbor.getParent() == parent);
                seq = new LayoutInterval(102);
                this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(neighbor));
                seq.setAlignment(neighbor.getAlignment());
                this.layoutModel.setIntervalAlignment(neighbor, -1);
                this.layoutModel.addInterval(neighbor, seq, 0);
                index = iDesc1.index;
            } else {
                seq = new LayoutInterval(102);
                if (iDesc1.snapped()) {
                    seq.setAlignment(iDesc1.alignment);
                }
            }
        }
        assert (iDesc1.alignment >= 0 || iDesc2 == null);
        assert (iDesc2 == null || iDesc2.alignment == (iDesc1.alignment ^ 1));
        assert (parent.isParallel());
        LayoutInterval[] outBounds = new LayoutInterval[2];
        boolean[] span = new boolean[2];
        boolean[] outOfGroup = new boolean[2];
        boolean[] expanded = new boolean[2];
        LayoutInterval[] neighbors = new LayoutInterval[2];
        LayoutInterval[] gaps = new LayoutInterval[2];
        LayoutInterval originalGap = null;
        int[] centerDst = new int[2];
        int count = seq.getSubIntervalCount();
        if (index > count) {
            index = count;
        }
        for (int i = 0; i <= 1; ++i) {
            int idx2;
            int idx1 = i == 0 ? index - 1 : index;
            int n = idx2 = i == 0 ? index - 2 : index + 1;
            if (idx1 >= 0 && idx1 < count) {
                LayoutInterval li = seq.getSubInterval(idx1);
                if (li.isEmptySpace()) {
                    originalGap = li;
                    if (idx2 >= 0 && idx2 < count) {
                        neighbors[i] = seq.getSubInterval(idx2);
                    }
                } else {
                    neighbors[i] = li;
                }
            }
            IncludeDesc includeDesc = iiDesc = iDesc1.alignment < 0 || iDesc1.alignment == i ? iDesc1 : iDesc2;
            if (iiDesc != null && iiDesc.snappedParallel != null) {
                span[i] = true;
            } else if (iiDesc != null && iiDesc.snappedNextTo != null && !parent.isParentOf(iiDesc.snappedNextTo)) {
                LayoutInterval li = parent;
                LayoutInterval gap = null;
                do {
                    if ((li = LayoutInterval.getNeighbor(li, i, false, true, false)) == null || !li.isEmptySpace()) continue;
                    gap = li;
                } while (li != null && li != iiDesc.snappedNextTo && !li.isParentOf(iiDesc.snappedNextTo));
                if (gap != null && (li != null || iiDesc.snappedNextTo.getParent() == null) && LayoutInterval.isDefaultPadding(gap)) {
                    span[i] = true;
                }
            }
            outOfGroup[i] = this.stickingOutOfGroup(parent, i);
            outBounds[i] = neighbors[i] != null ? neighbors[i] : LayoutFeeder.getPerceivedParentNeighbor(parent, this.addingSpace, outOfGroup[i], this.dimension, i);
            if (definite && neighbors[i] == null) {
                if (!subseq && seq.getParent() != null && parent.getParent() != null && outOfGroup[i] && LayoutFeeder.shouldExpandOverGroupEdge(parent, outBounds[i], i)) {
                    parent = this.separateSequence(seq, i);
                    expanded[i] = true;
                } else if (subseq && iDesc1.parent.getParent().getParent() != null && this.stickingOutOfGroup(iDesc1.parent.getParent(), i) && LayoutFeeder.shouldExpandOverGroupEdge(iDesc1.parent.getParent(), outBounds[i], i)) {
                    LayoutInterval p = this.separateSequence(iDesc1.parent, i);
                    if (parent.getSubIntervalCount() == 0 && parent.getParent() == null) {
                        parent = p;
                    } else {
                        LayoutFeeder.setCurrentPositionToParent(parent, p, this.dimension, i);
                    }
                }
            }
            if (iDesc1.alignment >= 0) continue;
            centerDst[i] = this.addingSpace.positions[this.dimension][2] - (outBounds[i] == parent || outBounds[i].isParentOf(parent) ? outBounds[i].getCurrentSpace().positions[this.dimension][i] : LayoutFeeder.getPerceivedNeighborPosition(outBounds[i], this.addingSpace, this.dimension, i));
            if (i != 1) continue;
            int n2 = i;
            centerDst[n2] = centerDst[n2] * -1;
        }
        boolean minorOriginalGap = originalGap != null && !LayoutInterval.canResize(originalGap) && (neighbors[0] == null && LayoutInterval.getEffectiveAlignment(neighbors[1], 0, true) == 1 || neighbors[1] == null && LayoutInterval.getEffectiveAlignment(neighbors[0], 1, true) == 0);
        int i = 0;
        for (int edges = 2; edges > 0; --edges) {
            block106: {
                LayoutInterval gap;
                boolean fixedGap;
                boolean noMinPadding;
                IncludeDesc otherDesc;
                block107: {
                    block108: {
                        int distance;
                        LayoutInterval otherPar;
                        LayoutInterval outerNeighbor;
                        gaps[i] = null;
                        LayoutInterval layoutInterval = outerNeighbor = neighbors[i] == null ? LayoutInterval.getNeighbor(parent, i, false, true, false) : null;
                        if (iDesc1.alignment < 0 || iDesc1.alignment == i) {
                            iiDesc = iDesc1;
                            otherDesc = iDesc2;
                        } else {
                            iiDesc = iDesc2;
                            otherDesc = iDesc1;
                        }
                        if (neighbors[i] == null && iiDesc != null && (iiDesc.snappedNextTo != null && outerNeighbor != null && LayoutInterval.isDefaultPadding(outerNeighbor) || iiDesc.snappedParallel != null && (!seq.isParentOf(iiDesc.snappedParallel) ? this.canAlignWith(iiDesc.snappedParallel, parent, i) : originalGap == null))) break block106;
                        boolean aligned = iDesc1.alignment < 0 ? centerDst[i] < centerDst[i ^ 1] || centerDst[i] == centerDst[i ^ 1] && i == 0 : (iDesc2 != null ? (this.dragger.isResizing(this.dimension) && LayoutInterval.wantResize(this.addingInterval) ? true : iiDesc.fixedPosition || i == 0 && this.originalPosition != null && this.originalPosition.lPosFixed || i == 1 && this.originalPosition != null && this.originalPosition.tPosFixed) : (iDesc1.snappedParallel == null || !seq.isParentOf(iDesc1.snappedParallel) ? i == iDesc1.alignment : i == (iDesc1.alignment ^ 1)));
                        boolean minorGap = false;
                        noMinPadding = false;
                        LayoutInterval layoutInterval2 = otherPar = otherDesc != null ? otherDesc.snappedParallel : null;
                        if (!aligned && neighbors[i] == null) {
                            if (originalGap == null) {
                                if (outerNeighbor != null && outerNeighbor.isEmptySpace()) {
                                    minorGap = true;
                                    noMinPadding = true;
                                } else if (otherPar != null && otherPar.getParent() != null) {
                                    minorGap = parent.isParentOf(otherPar) || LayoutInterval.getCount(parent, i ^ 1, true) > 0 || neighbors[i ^ 1] == null && LayoutUtils.alignedIntervals(parent, otherPar, i ^ 1);
                                } else if (!(outOfGroup[i ^ 1] || expanded[i] || LayoutInterval.getCount(parent, i ^ 1, true) <= 0 && (LayoutInterval.getCount(parent, Integer.MAX_VALUE, true) <= 0 || LayoutInterval.contentWantResize(parent)))) {
                                    minorGap = true;
                                }
                                if (outerNeighbor == null) {
                                    if (otherPar != null && (!otherPar.isParallel() || parent.isParentOf(otherPar))) {
                                        noMinPadding = !this.endsWithNonZeroGap(otherPar, i, parent);
                                    } else {
                                        boolean wantMinPadding = otherPar == null && (seq.getSubIntervalCount() == 0 || this.endsWithNonZeroGap(seq, i ^ 1, null));
                                        noMinPadding = this.followEndingPaddingFromNeighbors(otherPar != null ? otherPar : parent, seq, i, wantMinPadding) ^ wantMinPadding;
                                    }
                                }
                            } else if (minorOriginalGap) {
                                minorGap = true;
                            }
                        }
                        fixedGap = aligned;
                        if (!aligned) {
                            if (minorGap && !LayoutInterval.wantResize(parent) || LayoutInterval.wantResize(this.addingInterval)) {
                                fixedGap = true;
                            } else if (originalGap != null && LayoutInterval.canResize(originalGap)) {
                                if (originalGap.getMinimumSize() == 0 && neighbors[i] == null) {
                                    noMinPadding = true;
                                }
                            } else if (originalGap != null && !minorOriginalGap) {
                                if (!span[i ^ 1] || neighbors[i] == null && !LayoutInterval.canResize(originalGap) || neighbors[i] != null && (LayoutInterval.getEffectiveAlignment(neighbors[i], i ^ 1, true) == (i ^ 1) || !this.tiedToParallelSnap(neighbors[i], i, otherPar))) {
                                    fixedGap = true;
                                }
                            } else if (LayoutInterval.wantResize(seq)) {
                                fixedGap = true;
                            } else if (neighbors[i] != null) {
                                if (LayoutInterval.getEffectiveAlignment(neighbors[i], i ^ 1, true) == (i ^ 1)) {
                                    fixedGap = true;
                                }
                            } else if (otherPar != null) {
                                if (parent.isParentOf(otherPar)) {
                                    if (LayoutInterval.getEffectiveAlignmentInParent(otherPar, parent, i ^ 1) == i) {
                                        fixedGap = true;
                                    }
                                } else {
                                    LayoutInterval p = LayoutInterval.getCommonParent(otherPar, parent);
                                    if (p == parent) {
                                        p = p.getParent();
                                    }
                                    if (p != null && LayoutInterval.getEffectiveAlignmentInParent(parent, p, i) == (i ^ 1)) {
                                        fixedGap = true;
                                    }
                                }
                            } else if (!span[i ^ 1]) {
                                LayoutInterval alignParent = LayoutInterval.getCommonParent(outBounds[0], outBounds[1]);
                                int[] effa = new int[2];
                                for (int e = 0; e <= 1; ++e) {
                                    LayoutInterval b = outBounds[e];
                                    if (b == alignParent) {
                                        effa[e] = e;
                                        continue;
                                    }
                                    int edge = b == parent || b.isParentOf(parent) ? e : e ^ 1;
                                    effa[e] = LayoutInterval.getEffectiveAlignmentInParent(b, alignParent, edge);
                                }
                                if (effa[0] == effa[1]) {
                                    fixedGap = true;
                                }
                            }
                        }
                        if (!(aligned || fixedGap && !minorGap || neighbors[i] != null || originalGap != null || seq.getSubIntervalCount() != 0 || seq.getRawAlignment() != -1 || otherPar != null && parent.isParentOf(otherPar))) {
                            this.layoutModel.setIntervalAlignment(seq, i ^ 1);
                        }
                        if (fixedGap && noMinPadding) break block106;
                        gap = new LayoutInterval(101);
                        if (minorGap && fixedGap) break block107;
                        if (iiDesc != null && iiDesc.snappedNextTo != null) break block108;
                        LayoutRegion space = iiDesc != null && iiDesc.snappedParallel != null ? iiDesc.snappedParallel.getCurrentSpace() : this.addingSpace;
                        int n = distance = neighbors[i] != null ? LayoutRegion.distance(neighbors[i].getCurrentSpace(), space, this.dimension, i ^ 1, i) : LayoutRegion.distance(parent.getCurrentSpace(), space, this.dimension, i, i);
                        if (i == 1) {
                            distance *= -1;
                        }
                        if (distance > 0) {
                            int pad;
                            int n3 = pad = neighbors[i] != null || outerNeighbor == null ? this.dragger.findPaddings(neighbors[i], this.addingInterval, LayoutConstants.PaddingType.RELATED, this.dimension, i)[0] : Short.MIN_VALUE;
                            if (distance > pad || fixedGap && distance != pad) {
                                gap.setPreferredSize(distance);
                                if (fixedGap) {
                                    gap.setMinimumSize(-2);
                                    gap.setMaximumSize(-2);
                                }
                            }
                        } else if (noMinPadding) {
                            gap.setPreferredSize(0);
                        }
                        if (!fixedGap || gap.getPreferredSize() != -1 || neighbors[i] == null || LayoutUtils.isDefaultGapValidForNeighbor(neighbors[i], i ^ 1)) break block107;
                        break block106;
                    }
                    gap.setPaddingType(iiDesc.paddingType);
                }
                if (!fixedGap) {
                    if (noMinPadding) {
                        gap.setMinimumSize(0);
                    }
                    gap.setMaximumSize(Short.MAX_VALUE);
                }
                gap.setAttribute(1024);
                gaps[i] = gap;
                if (definite && (otherDesc == null || otherDesc.alignment < 0)) {
                    if (!subseq && parent.getParent() != null) {
                        if (!fixedGap && neighbors[i] != null && outBounds[i ^ 1] != parent && !parent.isParentOf(outBounds[i ^ 1])) {
                            parent = this.separateSequence(seq, i ^ 1);
                            if (i == 1) {
                                ++edges;
                            }
                        }
                    } else if (subseq && iDesc1.parent.getParent().getParent() != null && !fixedGap && LayoutInterval.getDirectNeighbor(parent, i, true) != null && outBounds[i ^ 1] != iDesc1.parent.getParent() && !iDesc1.parent.getParent().isParentOf(outBounds[i ^ 1])) {
                        LayoutInterval p = this.separateSequence(iDesc1.parent, i ^ 1);
                        if (parent.getSubIntervalCount() == 0 && parent.getParent() == null) {
                            parent = p;
                        } else {
                            LayoutFeeder.setCurrentPositionToParent(parent, p, this.dimension, i ^ 1);
                        }
                        if (i == 1) {
                            ++edges;
                        }
                    }
                }
            }
            i ^= 1;
        }
        for (i = 0; i <= 1; ++i) {
            if (neighbors[i] != null || seq.getCurrentSpace().isSet(this.dimension, i)) continue;
            int pos = Integer.MIN_VALUE;
            IncludeDesc includeDesc = iiDesc = iDesc1.alignment < 0 || iDesc1.alignment == i ? iDesc1 : iDesc2;
            if (iiDesc != null && iiDesc.snappedParallel != null) {
                pos = iiDesc.snappedParallel.getCurrentSpace().positions[this.dimension][i];
            } else if (iiDesc != null && iiDesc.snappedNextTo != null) {
                pos = parent.getCurrentSpace().positions[this.dimension][i];
            } else if (gaps[i] == null || gaps[i].getPreferredSize() == 0) {
                pos = this.addingInterval.getCurrentSpace().positions[this.dimension][i];
            }
            if (pos == Integer.MIN_VALUE) continue;
            seq.getCurrentSpace().setPos(this.dimension, i, pos);
        }
        if (seq.getParent() == null) {
            assert (seq.getSubIntervalCount() == 0);
            if (gaps[0] == null && gaps[1] == null) {
                this.layoutModel.setIntervalAlignment(this.addingInterval, seq.getAlignment());
                this.layoutModel.addInterval(this.addingInterval, parent, -1);
                return;
            }
            this.layoutModel.addInterval(seq, parent, -1);
        }
        if (iDesc1.snappedParallel != null && seq.isParentOf(iDesc1.snappedParallel)) {
            iDesc1.snappedParallel = null;
        }
        index = originalGap != null ? this.layoutModel.removeInterval(originalGap) : (neighbors[1] != null ? seq.indexOf(neighbors[1]) : (neighbors[0] != null ? seq.getSubIntervalCount() : 0));
        if (gaps[0] != null) {
            this.layoutModel.addInterval(gaps[0], seq, index++);
        }
        this.layoutModel.setIntervalAlignment(this.addingInterval, -1);
        if (definite) {
            index += this.operations.addContent(this.addingInterval, seq, index);
        } else {
            assert (!this.addingInterval.isSequential());
            this.layoutModel.addInterval(this.addingInterval, seq, index++);
        }
        if (gaps[1] != null) {
            this.layoutModel.addInterval(gaps[1], seq, index);
        }
    }

    private int getExtractCloseAlign(IncludeDesc iDesc) {
        return iDesc != null && iDesc.snappedParallel != null && iDesc.parent.isParentOf(iDesc.snappedParallel) && LayoutRegion.distance(this.addingSpace, iDesc.snappedParallel.getCurrentSpace(), this.dimension, iDesc.alignment, iDesc.alignment) == 0 ? iDesc.alignment : -1;
    }

    private LayoutInterval extractParallelSequence(LayoutInterval seq, LayoutRegion space, int closeAlign1, int closeAlign2, int refPoint, int[] visualBoundary) {
        LayoutInterval li;
        LayoutInterval li2;
        boolean closeEnd;
        int count = seq.getSubIntervalCount();
        int startIndex = 0;
        int endIndex = count - 1;
        int startPos = seq.getCurrentSpace().positions[this.dimension][0];
        int endPos = seq.getCurrentSpace().positions[this.dimension][1];
        int startPosBoundary = visualBoundary != null ? visualBoundary[0] : Integer.MIN_VALUE;
        int endPosBoundary = visualBoundary != null ? visualBoundary[1] : Integer.MIN_VALUE;
        boolean closeStart = closeAlign1 == 0 || closeAlign2 == 0;
        boolean bl = closeEnd = closeAlign1 == 1 || closeAlign2 == 1;
        if (refPoint < 0) {
            refPoint = 2;
        }
        for (int i = 0; i < count; ++i) {
            boolean forcedParallel;
            li2 = seq.getSubInterval(i);
            if (li2.isEmptySpace()) continue;
            LayoutRegion subSpace = li2.getCurrentSpace();
            boolean bl2 = forcedParallel = !this.solveOverlap && LayoutUtils.contentOverlap(space, li2, this.dimension);
            if (!forcedParallel && LayoutUtils.contentOverlap(space, li2, this.dimension ^ 1)) {
                if (LayoutFeeder.getAddDirection(space, subSpace, this.dimension, refPoint) == 0) {
                    endIndex = i - 1;
                    endPos = subSpace.positions[this.dimension][0];
                    break;
                }
                startIndex = i + 1;
                startPos = subSpace.positions[this.dimension][1];
                continue;
            }
            if (startPosBoundary != Integer.MIN_VALUE && subSpace.positions[this.dimension][0] < startPosBoundary) {
                startIndex = i + 1;
                startPos = subSpace.positions[this.dimension][1];
                continue;
            }
            if (endPosBoundary != Integer.MIN_VALUE && subSpace.positions[this.dimension][1] > endPosBoundary) {
                endIndex = i - 1;
                endPos = subSpace.positions[this.dimension][0];
                break;
            }
            if (!closeStart && !closeEnd) continue;
            int[] detPos = space.positions[this.dimension];
            int[] subPos = subSpace.positions[this.dimension];
            if (closeStart) {
                if (detPos[0] >= subPos[1]) {
                    startIndex = i + 1;
                    startPos = subPos[1];
                } else if (detPos[0] >= subPos[0]) {
                    startIndex = i;
                    startPos = subPos[0];
                }
            }
            if (!closeEnd || detPos[1] > subPos[1]) continue;
            if (detPos[1] > subPos[0]) {
                endIndex = i;
                endPos = subPos[1];
                break;
            }
            endIndex = i - 1;
            endPos = subPos[0];
            break;
        }
        if (startIndex > endIndex || startIndex == endIndex && seq.getSubInterval(startIndex).isEmptySpace()) {
            return null;
        }
        if (startIndex == 0 && endIndex == count - 1) {
            return seq.getParent();
        }
        if (startIndex == endIndex && (li = seq.getSubInterval(startIndex)).isParallel()) {
            return li;
        }
        if (seq.getParent() != null) {
            if (!LayoutRegion.isValidCoordinate(startPos) && startIndex == 0) {
                startPos = seq.getParent().getCurrentSpace().positions[this.dimension][0];
            }
            if (!LayoutRegion.isValidCoordinate(endPos) && endIndex == count - 1) {
                endPos = seq.getParent().getCurrentSpace().positions[this.dimension][1];
            }
        }
        LayoutInterval group = new LayoutInterval(103);
        if (startIndex == 0 && LayoutInterval.getEffectiveAlignmentInParent(seq.getSubInterval(0), seq.getParent(), 0) == 1) {
            group.setGroupAlignment(1);
        }
        if (startIndex == endIndex) {
            li2 = this.layoutModel.removeInterval(seq, startIndex);
            this.layoutModel.addInterval(li2, group, 0);
        } else {
            LayoutInterval interSeq = new LayoutInterval(102);
            group.add(interSeq, 0);
            int i = startIndex;
            while (i <= endIndex) {
                LayoutInterval li3 = this.layoutModel.removeInterval(seq, i);
                --endIndex;
                this.layoutModel.addInterval(li3, interSeq, -1);
            }
        }
        this.layoutModel.addInterval(group, seq, startIndex);
        group.getCurrentSpace().set(this.dimension, startPos, endPos);
        return group;
    }

    private void alignWithResizingInSubgroup(LayoutInterval seqWithResizing, LayoutInterval group, IncludeDesc iDesc) {
        int alignment;
        if (LayoutInterval.wantResize(this.addingInterval) || !iDesc.snapped() || !group.isParallel() || group.getSubIntervalCount() > 2) {
            return;
        }
        LayoutInterval toAlign = group.getSubInterval(0);
        if (seqWithResizing.getParent() == null) {
            if (group.getSubIntervalCount() != 1) {
                return;
            }
        } else {
            if (group.getSubIntervalCount() != 2) {
                return;
            }
            if (toAlign == seqWithResizing) {
                toAlign = group.getSubInterval(1);
            }
        }
        if (LayoutUtils.anythingAtGroupEdge(toAlign, null, this.dimension, alignment = iDesc.alignment) && !LayoutUtils.anythingAtGroupEdge(toAlign, null, this.dimension, alignment ^ 1)) {
            this.layoutModel.setGroupAlignment(group, alignment);
            if (toAlign.getAlignment() != alignment) {
                this.layoutModel.setIntervalAlignment(toAlign, -1);
            }
            if (seqWithResizing.getParent() == group && seqWithResizing.getAlignment() != alignment) {
                this.layoutModel.setIntervalAlignment(seqWithResizing, -1);
            }
        }
    }

    private static void setCurrentPositionToParent(LayoutInterval interval, LayoutInterval parent, int dimension, int alignment) {
        if (!parent.isParentOf(interval)) {
            return;
        }
        int parentPos = parent.getCurrentSpace().positions[dimension][alignment];
        if (!LayoutRegion.isValidCoordinate(parentPos)) {
            return;
        }
        for (LayoutInterval li = interval; li != parent; li = li.getParent()) {
            li.getCurrentSpace().setPos(dimension, alignment, parentPos);
        }
    }

    private static LayoutInterval getPerceivedParentNeighbor(LayoutInterval parent, LayoutRegion space, boolean outOfGroup, int dimension, int alignment) {
        assert (parent.isParallel());
        LayoutInterval interval = null;
        LayoutInterval neighbor = null;
        boolean done = false;
        do {
            neighbor = null;
            while (neighbor == null && parent.getParent() != null && !LayoutFeeder.isSignificantGroupEdge(parent, alignment, outOfGroup)) {
                neighbor = LayoutInterval.getDirectNeighbor(parent, alignment, true);
                if (neighbor != null || !(parent = (interval = parent).getParent()).isSequential()) continue;
                interval = parent;
                parent = interval.getParent();
            }
            if (neighbor == null) {
                done = true;
                continue;
            }
            do {
                if (LayoutUtils.contentOverlap(space, neighbor, dimension ^ 1)) {
                    done = true;
                    continue;
                }
                neighbor = LayoutInterval.getDirectNeighbor(neighbor, alignment, true);
            } while (!done && neighbor != null);
            if (neighbor != null || !(parent = (interval = parent).getParent()).isSequential()) continue;
            interval = parent;
            parent = interval.getParent();
        } while (!done);
        return neighbor != null ? neighbor : parent;
    }

    private static boolean shouldExpandOverGroupEdge(LayoutInterval group, LayoutInterval outBound, int alignment) {
        if (group != outBound && !group.isParentOf(outBound) && !LayoutFeeder.isSignificantGroupEdge(group, alignment, true)) {
            boolean open = !LayoutInterval.isClosedGroup(group, alignment);
            LayoutInterval li = group;
            boolean gapNotWorthExpanding = false;
            while ((li = LayoutInterval.getNeighbor(li, alignment, false, true, false)) != null) {
                if (li == outBound || li.isParentOf(outBound) || LayoutInterval.getDirectNeighbor(li, alignment ^ 1, false) == outBound) {
                    return false;
                }
                if (gapNotWorthExpanding) {
                    return true;
                }
                if (li.isEmptySpace() && (LayoutInterval.isDefaultPadding(li) || open && LayoutInterval.canResize(li))) {
                    gapNotWorthExpanding = true;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isSignificantGroupEdge(LayoutInterval group, int alignment, boolean placedOver) {
        assert (group.isParallel());
        return LayoutInterval.isExplicitlyClosedGroup(group) || !placedOver && LayoutUtils.edgeSubComponents(group, alignment, true).size() > 1;
    }

    private static int getPerceivedNeighborPosition(LayoutInterval firstNeighbor, LayoutRegion space, int dimension, int alignment) {
        LayoutInterval neighbor = firstNeighbor;
        do {
            int pos;
            if ((pos = LayoutFeeder.getPerceivedNeighborPosition0(neighbor, space, dimension, alignment)) == Integer.MIN_VALUE) continue;
            return pos;
        } while ((neighbor = LayoutInterval.getDirectNeighbor(neighbor, alignment, true)) != null);
        return firstNeighbor.getCurrentSpace().positions[dimension][alignment ^ 1];
    }

    private static int getPerceivedNeighborPosition0(LayoutInterval neighbor, LayoutRegion space, int dimension, int alignment) {
        assert (!neighbor.isEmptySpace());
        int neighborPos = Integer.MIN_VALUE;
        if (neighbor.isComponent()) {
            if (LayoutRegion.overlap(space, neighbor.getCurrentSpace(), dimension ^ 1, 0)) {
                neighborPos = neighbor.getCurrentSpace().positions[dimension][alignment ^ 1];
            }
        } else {
            int i;
            int d;
            int n = neighbor.getSubIntervalCount();
            if (neighbor.isParallel() || alignment == 1) {
                d = 1;
                i = 0;
            } else {
                d = -1;
                i = n - 1;
            }
            while (i >= 0 && i < n) {
                int pos;
                LayoutInterval sub = neighbor.getSubInterval(i);
                i += d;
                if (sub.isEmptySpace() || (pos = LayoutFeeder.getPerceivedNeighborPosition0(sub, space, dimension, alignment)) == Integer.MIN_VALUE) continue;
                if (neighbor.isSequential()) {
                    neighborPos = pos;
                    break;
                }
                if (neighborPos != Integer.MIN_VALUE && pos * d >= neighborPos * d) continue;
                neighborPos = pos;
            }
        }
        return neighborPos;
    }

    private boolean endsWithNonZeroGap(LayoutInterval interval, int edge, LayoutInterval inParent) {
        assert (edge == 0 || edge == 1);
        if (interval.isParallel() && inParent == null) {
            Iterator<LayoutInterval> it = interval.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = it.next();
                if (!this.endsWithNonZeroGap(li, edge, null)) continue;
                return true;
            }
            return false;
        }
        if (inParent != null) {
            LayoutInterval parent;
            LayoutInterval firstSeq = interval;
            for (parent = interval.getParent(); parent != null && parent != inParent; parent = parent.getParent()) {
                if (!parent.isSequential()) continue;
                if (!firstSeq.isSequential()) {
                    firstSeq = parent;
                }
                interval = parent;
            }
            if (parent == null) {
                interval = firstSeq;
            }
        }
        if (interval.isSequential() && interval.getSubIntervalCount() > 0) {
            int idx = edge == 0 ? 0 : interval.getSubIntervalCount() - 1;
            LayoutInterval li = interval.getSubInterval(idx);
            return li.isEmptySpace() && li.getMinimumSize() != 0;
        }
        return false;
    }

    private boolean followEndingPaddingFromNeighbors(LayoutInterval parent, LayoutInterval interval, int edge, boolean wantMinPadding) {
        boolean someAligned = false;
        Iterator<LayoutInterval> it = parent.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (li == interval || li.isParentOf(interval) || wantMinPadding != this.endsWithNonZeroGap(li, edge ^ 1, null)) continue;
            someAligned = true;
            if (wantMinPadding != this.endsWithNonZeroGap(li, edge, null)) continue;
            return true;
        }
        return !someAligned;
    }

    private LayoutInterval separateSequence(LayoutInterval seq, int alignment) {
        LayoutInterval sub;
        int end;
        LayoutInterval parentPar = seq.getParent();
        assert (parentPar.isParallel());
        while (!parentPar.getParent().isSequential()) {
            parentPar = parentPar.getParent();
        }
        LayoutInterval parentSeq = parentPar.getParent();
        int d = alignment == 0 ? -1 : 1;
        int n = parentSeq.getSubIntervalCount();
        for (end = parentSeq.indexOf(parentPar) + d; end >= 0 && end < n && ((sub = parentSeq.getSubInterval(end)).isEmptySpace() || !LayoutUtils.contentOverlap(this.addingSpace, sub, this.dimension ^ 1)); end += d) {
        }
        int endPos = end >= 0 && end < n ? parentSeq.getSubInterval((int)end).getCurrentSpace().positions[this.dimension][alignment ^ 1] : parentSeq.getParent().getCurrentSpace().positions[this.dimension][alignment];
        this.operations.parallelizeWithParentSequence(seq, end -= d, this.dimension);
        parentPar = seq.getParent();
        parentPar.getCurrentSpace().positions[this.dimension][alignment] = endPos;
        return parentPar;
    }

    private void accommodateOutPosition(List<LayoutInterval> added) {
        int align;
        LayoutInterval interval = added.get(0);
        LayoutInterval parent = interval.getParent();
        int alignment = -1;
        if (parent.isSequential()) {
            align = parent.getAlignment();
            if (align == 0 || align == 1) {
                for (int i = 0; i < 2; ++i) {
                    LayoutInterval li;
                    LayoutInterval layoutInterval = li = (align ^= 1) == 0 ? interval : added.get(added.size() - 1);
                    if (LayoutInterval.getDirectNeighbor(li, align, true) != null) continue;
                    alignment = align;
                    interval = li;
                    break;
                }
            }
        } else {
            align = interval.getAlignment();
            if (align == 0 || align == 1) {
                alignment = align ^ 1;
                int maxPos = Integer.MIN_VALUE;
                for (LayoutInterval li : added) {
                    int pos = li.getCurrentSpace().positions[this.dimension][alignment];
                    if (maxPos != Integer.MIN_VALUE && (alignment != 0 || pos >= maxPos) && (alignment != 1 || pos <= maxPos)) continue;
                    maxPos = pos;
                    interval = li;
                }
            }
        }
        if (alignment == -1) {
            return;
        }
        int pos = interval.getCurrentSpace().positions[this.dimension][alignment];
        assert (pos != Integer.MIN_VALUE);
        int sizeIncrement = Integer.MIN_VALUE;
        int d = alignment == 0 ? -1 : 1;
        int[] groupPos = null;
        LayoutInterval prev = null;
        do {
            if (parent.isSequential()) {
                LayoutInterval neighbor;
                if (sizeIncrement > 0) {
                    int accommodated = this.accommodateSizeInSequence(interval, prev, sizeIncrement, alignment);
                    sizeIncrement -= accommodated;
                }
                if ((neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false)) != null && !neighbor.isEmptySpace()) {
                    return;
                }
                if (prev == null) {
                    prev = interval;
                } else if (parent.isParentOf(prev)) {
                    while (prev.getParent() != parent) {
                        prev = prev.getParent();
                    }
                } else {
                    parent = parent.getParent();
                }
            } else {
                groupPos = parent.getCurrentSpace().positions[this.dimension];
                if (groupPos[alignment] != Integer.MIN_VALUE) {
                    if (interval.isParallel() && prev != null && interval.getCurrentSpace().positions[this.dimension][alignment] != groupPos[alignment] && this.groupGrowingVisibly(interval, prev, alignment)) {
                        int align2 = prev.getAlignment();
                        this.layoutModel.removeInterval(prev);
                        this.layoutModel.addInterval(prev, parent, -1);
                        if (prev.getAlignment() != align2) {
                            this.layoutModel.setIntervalAlignment(prev, align2);
                        }
                    }
                    if ((sizeIncrement = (pos - groupPos[alignment]) * d) > 0) {
                        int[] subPos = interval.getCurrentSpace().positions[this.dimension];
                        if (!interval.getCurrentSpace().isSet(this.dimension) || subPos[alignment] * d < pos * d) {
                            subPos[alignment] = pos;
                        }
                    }
                } else {
                    groupPos = null;
                }
                if (!interval.isSequential() || prev == null) {
                    prev = interval;
                }
            }
            interval = parent;
            parent = interval.getParent();
        } while ((sizeIncrement > 0 || sizeIncrement == Integer.MIN_VALUE) && parent != null && (!parent.isParallel() || interval.getAlignment() != alignment));
    }

    private int accommodateSizeInSequence(LayoutInterval interval, LayoutInterval lower, int sizeIncrement, int alignment) {
        LayoutInterval parent = interval.getParent();
        assert (parent.isSequential());
        LayoutRegion space = lower.getCurrentSpace();
        int increment = sizeIncrement;
        int pos = interval.getCurrentSpace().positions[this.dimension][alignment];
        int outPos = parent.getParent().getCurrentSpace().positions[this.dimension][alignment];
        boolean groupGrowingVisibly = this.groupGrowingVisibly(interval, lower, alignment);
        boolean parallel = false;
        boolean snapGap = false;
        int d = alignment == 0 ? -1 : 1;
        int start = parent.indexOf(interval);
        int end = lower.isComponent() && !LayoutInterval.wantResize(lower) ? start : -1;
        int endPos = Integer.MIN_VALUE;
        boolean expanded = false;
        for (int i = start + d; i >= 0 && i < parent.getSubIntervalCount(); i += d) {
            LayoutInterval li = parent.getSubInterval(i);
            if (end != -1) {
                boolean last = i > start && i + d == parent.getSubIntervalCount() || i < start && i == 0;
                endPos = Integer.MIN_VALUE;
                if (!li.isEmptySpace()) {
                    if (LayoutUtils.contentOverlap(space, li, this.dimension ^ 1)) {
                        if (end != start) {
                            end = i - d;
                            endPos = li.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                        } else if (groupGrowingVisibly) {
                            endPos = space.positions[this.dimension][alignment];
                            if (!snapGap && LayoutInterval.wantResize(interval)) {
                                end = i - d;
                            }
                        } else {
                            end = -1;
                        }
                    } else {
                        end = i;
                        if (!parallel && LayoutUtils.contentOverlap(space, li, this.dimension)) {
                            parallel = true;
                        }
                    }
                } else {
                    boolean bl = snapGap = i == start + d && LayoutInterval.isFixedDefaultPadding(li);
                }
                if (last && endPos == Integer.MIN_VALUE && end != -1) {
                    if (end != start && (parallel || this.dimension == 0)) {
                        end = i;
                        endPos = outPos;
                    } else if (groupGrowingVisibly) {
                        endPos = outPos;
                        if (!snapGap && LayoutInterval.wantResize(interval)) {
                            end = i;
                        }
                    } else {
                        end = -1;
                    }
                }
                if (endPos != Integer.MIN_VALUE) {
                    LayoutInterval toPar;
                    LayoutInterval layoutInterval = toPar = lower.getParent().isSequential() ? lower.getParent() : lower;
                    if (end != start) {
                        LayoutInterval endGap = LayoutInterval.getDirectNeighbor(lower, alignment, false);
                        if (endGap == null && !LayoutInterval.isAlignedAtBorder(toPar, alignment)) {
                            endGap = new LayoutInterval(101);
                            if (!toPar.isSequential()) {
                                toPar = new LayoutInterval(102);
                                this.layoutModel.addInterval(toPar, lower.getParent(), this.layoutModel.removeInterval(lower));
                                this.layoutModel.setIntervalAlignment(toPar, lower.getRawAlignment());
                                this.layoutModel.setIntervalAlignment(lower, -1);
                                this.layoutModel.addInterval(lower, toPar, 0);
                            }
                            this.layoutModel.addInterval(endGap, toPar, alignment == 0 ? 0 : -1);
                        } else if (toPar.isSequential() && pos != outPos && endGap != null && endGap.getPreferredSize() == 0) {
                            this.layoutModel.setIntervalSize(endGap, -1, -1, endGap.getMaximumSize());
                        }
                        expanded = true;
                    } else if (snapGap && last && LayoutInterval.getNeighbor(parent.getParent(), alignment, false, true, false) != null) {
                        end += d;
                    }
                    this.operations.parallelizeWithParentSequence(toPar, end, this.dimension);
                    if (expanded && (increment -= Math.abs(endPos - pos)) <= 0) {
                        increment = 0;
                        break;
                    }
                    if (!parent.isParentOf(lower)) break;
                    i = start;
                    end = -1;
                    continue;
                }
                if (end != -1) continue;
                i = start;
                continue;
            }
            if (li.isEmptySpace()) {
                if (li.getPreferredSize() != -1 || li.getMaximumSize() == Short.MAX_VALUE) {
                    int pad = this.determinePadding(interval, li.getPaddingType(), this.dimension, alignment);
                    int currentSize = LayoutInterval.getCurrentSize(li, this.dimension);
                    int size = currentSize - increment;
                    if (size <= pad) {
                        size = -1;
                        increment -= currentSize - pad;
                    } else {
                        increment = 0;
                    }
                    this.operations.resizeInterval(li, size);
                    if (LayoutInterval.wantResize(li) && LayoutInterval.wantResize(interval)) {
                        this.layoutModel.setIntervalSize(li, li.getMinimumSize(), li.getPreferredSize(), -2);
                    }
                }
            } else if (li.isParallel()) {
                LayoutInterval comp = LayoutUtils.getOutermostComponent(li, this.dimension, alignment ^ 1);
                int extPos = space.positions[this.dimension][alignment];
                int pos2 = comp.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                int pos1 = li.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                if (pos2 != pos1 && (alignment == 1 && extPos > pos1 || alignment == 0 && extPos < pos1)) {
                    if (alignment == 1 && pos2 > extPos || alignment == 0 && pos2 < extPos) {
                        pos2 = extPos;
                    }
                    for (LayoutInterval gap : LayoutUtils.getSideGaps(li, alignment ^ 1, false)) {
                        int gapSize = gap.getPreferredSize();
                        if (gapSize <= 0) continue;
                        int gapPos2 = LayoutUtils.getVisualPosition(gap, this.dimension, alignment);
                        int adjustedSize = alignment == 1 ? gapPos2 - pos2 : pos2 - gapPos2;
                        if (adjustedSize < 0 || adjustedSize >= gapSize) continue;
                        this.operations.resizeInterval(gap, adjustedSize);
                    }
                    increment -= Math.abs(pos2 - pos1);
                    li.getCurrentSpace().setPos(this.dimension, alignment ^ 1, pos2);
                }
            }
            if (increment == sizeIncrement || !groupGrowingVisibly || expanded || endPos == Integer.MIN_VALUE) break;
            LayoutInterval toPar = lower.getParent().isSequential() ? lower.getParent() : lower;
            LayoutInterval par = toPar.getParent();
            for (int ii = 0; ii < par.getSubIntervalCount(); ++ii) {
                LayoutInterval sibling = par.getSubInterval(ii);
                if (sibling != interval) continue;
                LayoutInterval strut = new LayoutInterval(101);
                strut.setSizes(-2, sizeIncrement, -2);
                this.operations.insertGap(strut, sibling, endPos, this.dimension, alignment);
            }
            break;
        }
        return sizeIncrement - increment;
    }

    private boolean groupGrowingVisibly(LayoutInterval group, LayoutInterval interval, int edge) {
        List<LayoutInterval> l = LayoutUtils.getSideComponents(interval, edge, true, false);
        if (l.size() == 1) {
            LayoutInterval comp = l.get(0);
            l = LayoutUtils.getSideComponents(group, edge, false, true);
            if (l.size() > 1 || l.size() == 1 && l.get(0) != comp) {
                return true;
            }
        }
        return false;
    }

    private LayoutInterval alignInParallel(LayoutInterval interval, LayoutInterval toAlignWith, int alignment) {
        LayoutInterval aligning1;
        LayoutInterval commonSeq;
        LayoutInterval group;
        LayoutInterval indentNeighbor;
        boolean onPlace;
        LayoutInterval alignParent;
        assert (alignment == 0 || alignment == 1);
        if (toAlignWith.isParentOf(interval) || interval.isParentOf(toAlignWith)) {
            return null;
        }
        LayoutInterval commonParent = LayoutInterval.getCommonParent(interval, toAlignWith);
        if (commonParent == null || commonParent.isSequential()) {
            return null;
        }
        boolean resizing = LayoutInterval.wantResize(interval);
        LayoutInterval aligning = interval;
        LayoutInterval parParent = LayoutInterval.getFirstParent(interval, 103);
        while (!parParent.isParentOf(toAlignWith)) {
            if (LayoutInterval.isAlignedAtBorder(aligning, parParent, alignment)) {
                if (resizing && !LayoutInterval.canResize(parParent)) {
                    this.operations.enableGroupResizing(parParent);
                }
                aligning = parParent;
                parParent = LayoutInterval.getFirstParent(aligning, 103);
            } else {
                parParent = null;
            }
            if (parParent != null) continue;
            return null;
        }
        LayoutInterval tempRemoved = aligning;
        while (tempRemoved.getParent() != parParent) {
            tempRemoved = tempRemoved.getParent();
        }
        int removedIndex = parParent.remove(tempRemoved);
        boolean alignWithParent = false;
        do {
            if ((alignParent = LayoutInterval.getFirstParent(toAlignWith, 103)) == null) {
                parParent.add(tempRemoved, removedIndex);
                return null;
            }
            if (!LayoutFeeder.canSubstAlignWithParent(toAlignWith, this.dimension, alignment, this.dragger.isResizing())) continue;
            if (alignParent == parParent) {
                if (LayoutInterval.getNeighbor(aligning, alignment, false, true, false) != null) continue;
                alignWithParent = true;
                continue;
            }
            toAlignWith = alignParent;
        } while (toAlignWith == alignParent);
        parParent.add(tempRemoved, removedIndex);
        if (alignParent != parParent) {
            return null;
        }
        if (aligning != interval) {
            int dst;
            if (!LayoutInterval.isAlignedAtBorder(toAlignWith, alignment) && (dst = LayoutRegion.distance(aligning.getCurrentSpace(), toAlignWith.getCurrentSpace(), this.dimension, alignment, alignment) * (alignment == 1 ? -1 : 1)) > 0) {
                tempRemoved = interval;
                while (tempRemoved.getParent() != aligning) {
                    tempRemoved = tempRemoved.getParent();
                }
                removedIndex = aligning.remove(tempRemoved);
                this.operations.cutStartingGap(aligning, dst, this.dimension, alignment);
                aligning.add(tempRemoved, removedIndex);
            }
            this.optimizeStructure = true;
        }
        int effAlign1 = LayoutInterval.getEffectiveAlignment(toAlignWith, alignment, true);
        int indent = LayoutRegion.distance(toAlignWith.getCurrentSpace(), interval.getCurrentSpace(), this.dimension, alignment, alignment);
        boolean bl = onPlace = aligning != interval && LayoutRegion.distance(aligning.getCurrentSpace(), interval.getCurrentSpace(), this.dimension, alignment, alignment) == 0;
        if (indent != 0 && onPlace && (indentNeighbor = LayoutInterval.getDirectNeighbor(aligning, alignment, false)) != null && indentNeighbor.isEmptySpace() && indentNeighbor.getPreferredSize() > 0) {
            int size = indentNeighbor.getPreferredSize() - Math.abs(indent);
            if (size < 0) {
                size = -1;
            }
            this.operations.resizeInterval(indentNeighbor, size);
        }
        ArrayList<LayoutInterval> alignedList = new ArrayList<LayoutInterval>(2);
        ArrayList<List> remainder = new ArrayList<List>(2);
        int originalCount = parParent.getSubIntervalCount();
        int extAlign1 = this.extract(toAlignWith, alignedList, remainder, alignment);
        this.extract(aligning, alignedList, remainder, alignment);
        assert (!alignWithParent || remainder.isEmpty());
        if (indent != 0) {
            LayoutInterval indentGap = new LayoutInterval(101);
            indentGap.setSize(Math.abs(indent));
            LayoutInterval indented = onPlace ? aligning : interval;
            LayoutInterval parent = indented.getParent();
            if (parent == null || !parent.isSequential()) {
                LayoutInterval seq = new LayoutInterval(102);
                if (parent != null) {
                    this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(indented));
                }
                this.layoutModel.setIntervalAlignment(indented, -1);
                this.layoutModel.addInterval(indented, seq, 0);
                parent = seq;
            }
            this.layoutModel.addInterval(indentGap, parent, alignment == 0 ? 0 : -1);
            if (interval == aligning) {
                alignedList.set(alignedList.size() - 1, parent);
            }
        }
        if (alignWithParent || originalCount == 2 && parParent.getParent() != null) {
            group = parParent;
            if (!remainder.isEmpty()) {
                LayoutInterval groupParent = group.getParent();
                if (groupParent.isSequential()) {
                    commonSeq = groupParent;
                } else {
                    int index = this.layoutModel.removeInterval(group);
                    commonSeq = new LayoutInterval(102);
                    commonSeq.setAlignment(group.getAlignment());
                    this.layoutModel.addInterval(commonSeq, groupParent, index);
                    this.layoutModel.setIntervalAlignment(group, -1);
                    this.layoutModel.addInterval(group, commonSeq, -1);
                }
            } else {
                commonSeq = null;
            }
        } else {
            group = new LayoutInterval(103);
            group.setGroupAlignment(alignment);
            if (!remainder.isEmpty()) {
                commonSeq = new LayoutInterval(102);
                commonSeq.add(group, 0);
                if (effAlign1 == 0 || effAlign1 == 1) {
                    commonSeq.setAlignment(effAlign1);
                }
                this.layoutModel.addInterval(commonSeq, parParent, -1);
            } else {
                commonSeq = null;
                if (effAlign1 == 0 || effAlign1 == 1) {
                    group.setAlignment(effAlign1);
                }
                this.layoutModel.addInterval(group, parParent, -1);
            }
            if (alignment == 0 || alignment == 1) {
                int alignPos = toAlignWith.getCurrentSpace().positions[this.dimension][alignment];
                int outerPos = parParent.getCurrentSpace().positions[this.dimension][alignment ^ 1];
                group.getCurrentSpace().set(this.dimension, alignment == 0 ? alignPos : outerPos, alignment == 0 ? outerPos : alignPos);
            }
        }
        LayoutInterval aligning2 = (LayoutInterval)alignedList.get(1);
        if (aligning2.getParent() != group) {
            if (aligning2.getParent() != null) {
                this.layoutModel.removeInterval(aligning2);
            }
            this.layoutModel.addInterval(aligning2, group, -1);
        }
        if (!LayoutInterval.isAlignedAtBorder(aligning2, alignment)) {
            this.layoutModel.setIntervalAlignment(aligning2, alignment);
        }
        if ((aligning1 = (LayoutInterval)alignedList.get(0)).getParent() != group) {
            if (aligning1.getParent() != null) {
                this.layoutModel.removeInterval(aligning1);
            }
            this.layoutModel.addInterval(aligning1, group, -1);
            if (group == parParent && effAlign1 == alignment && !LayoutInterval.isAlignedAtBorder(aligning1, group, effAlign1)) {
                this.layoutModel.setIntervalAlignment(aligning1, effAlign1);
            }
        }
        if (!(this.dragger.isResizing(this.dimension) && this.dragger.getResizingEdge(this.dimension) == alignment || group.getSubIntervalCount() != 2)) {
            if (!LayoutInterval.isAlignedAtBorder(aligning1, alignment) && !LayoutInterval.isAlignedAtBorder(aligning2, alignment ^ 1)) {
                this.layoutModel.setIntervalAlignment(aligning1, alignment);
            }
            if (LayoutInterval.isAlignedAtBorder(aligning1, group.getGroupAlignment()) && LayoutInterval.isAlignedAtBorder(aligning2, group.getGroupAlignment())) {
                this.layoutModel.setIntervalAlignment(aligning1, -1);
                this.layoutModel.setIntervalAlignment(aligning2, -1);
            } else if (LayoutInterval.isAlignedAtBorder(aligning1, alignment) && LayoutInterval.isAlignedAtBorder(aligning2, alignment)) {
                this.layoutModel.setGroupAlignment(group, alignment);
                this.layoutModel.setIntervalAlignment(aligning1, -1);
                this.layoutModel.setIntervalAlignment(aligning2, -1);
            }
        }
        if (!remainder.isEmpty()) {
            LayoutInterval sideGroup;
            int index = commonSeq.indexOf(group);
            if (alignment == 1) {
                ++index;
            }
            if ((sideGroup = this.operations.addGroupContent(remainder, commonSeq, index, this.dimension, alignment)) != null) {
                int pos1 = parParent.getCurrentSpace().positions[this.dimension][alignment];
                int pos2 = toAlignWith.getCurrentSpace().positions[this.dimension][alignment];
                sideGroup.getCurrentSpace().set(this.dimension, alignment == 0 ? pos1 : pos2, alignment == 0 ? pos2 : pos1);
                this.operations.optimizeGaps(sideGroup, this.dimension);
                this.operations.mergeParallelGroups(sideGroup);
            }
        }
        if (toAlignWith.isParallel()) {
            this.operations.dissolveRedundantGroup(toAlignWith);
        }
        return group;
    }

    private int extract(LayoutInterval interval, List<LayoutInterval> toAlign, List<List> toRemain, int alignment) {
        int effAlign = LayoutInterval.getEffectiveAlignment(interval, alignment, false);
        LayoutInterval parent = interval.getParent();
        if (parent.isSequential()) {
            int extractCount = this.operations.extract(interval, alignment, false, alignment == 0 ? toRemain : null, alignment == 0 ? null : toRemain);
            if (extractCount == 1) {
                this.layoutModel.removeInterval(parent);
                toAlign.add(interval);
            } else {
                toAlign.add(parent);
            }
        } else {
            toAlign.add(interval);
        }
        return effAlign;
    }

    private void checkParallelResizing(List<LayoutInterval> added, IncludeDesc iDesc1, IncludeDesc iDesc2) {
        LayoutInterval parallelInt;
        boolean one = added.size() == 1;
        LayoutInterval interval = added.get(0);
        LayoutInterval group = interval.getParent();
        if (group.isSequential()) {
            parallelInt = group;
            group = group.getParent();
        } else {
            parallelInt = interval;
        }
        LayoutInterval neighborGap = null;
        if (interval != parallelInt) {
            assert (parallelInt.isSequential());
            LayoutInterval gap = LayoutInterval.getDirectNeighbor(interval, 0, false);
            if (gap != null && gap.isEmptySpace() && LayoutInterval.canResize(gap)) {
                neighborGap = gap;
            } else {
                gap = LayoutInterval.getDirectNeighbor(added.get(added.size() - 1), 1, false);
                if (gap != null && gap.isEmptySpace() && LayoutInterval.canResize(gap)) {
                    neighborGap = gap;
                }
            }
        }
        if (one && LayoutInterval.wantResize(interval) ? !this.dragger.isResizing(this.dimension) : neighborGap == null) {
            return;
        }
        int rootAlign = -1;
        if (group.getParent() == null) {
            rootAlign = Integer.MAX_VALUE;
        } else {
            if (iDesc1.snappedNextTo != null && iDesc1.snappedNextTo.getParent() == null) {
                rootAlign = iDesc1.alignment;
            }
            if (iDesc2 != null && iDesc2.snappedNextTo != null && iDesc2.snappedNextTo.getParent() == null) {
                int n = rootAlign = rootAlign == -1 ? iDesc2.alignment : Integer.MAX_VALUE;
            }
            if (rootAlign == 0 || rootAlign == 1) {
                int remIdx = group.remove(parallelInt);
                LayoutInterval neighbor = LayoutInterval.getNeighbor(group, rootAlign ^ 1, false, true, true);
                if (neighbor != null && neighbor.getPreferredSize() == -1 && LayoutInterval.getEffectiveAlignmentInParent(group, LayoutInterval.getRoot(group), rootAlign ^ 1) == (rootAlign ^ 1) || neighbor == null && LayoutInterval.isAlignedAtBorder(group, LayoutInterval.getRoot(group), rootAlign ^ 1)) {
                    rootAlign = Integer.MAX_VALUE;
                }
                group.add(parallelInt, remIdx);
            }
        }
        if (rootAlign != Integer.MAX_VALUE) {
            if (!LayoutInterval.canResize(group) && (iDesc1.snappedNextTo != null && !group.isParentOf(iDesc1.snappedNextTo) || iDesc2 != null && iDesc2.snappedNextTo != null && !group.isParentOf(iDesc2.snappedNextTo))) {
                this.operations.enableGroupResizing(group);
            }
            while (LayoutInterval.canResize(group) && group.getParent() != null) {
                boolean otherResizing = false;
                boolean samePosition = false;
                boolean onEdge = true;
                for (int i = 0; i < group.getSubIntervalCount(); ++i) {
                    LayoutInterval li = group.getSubInterval(i);
                    if (li != parallelInt) {
                        int align;
                        if (LayoutInterval.wantResize(li)) {
                            otherResizing = true;
                            break;
                        }
                        if (!group.isParallel() || samePosition || (align = li.getAlignment()) != 0 && align != 1) continue;
                        samePosition = this.getExpectedBorderPosition(parallelInt, this.dimension, align ^ 1) == this.getExpectedBorderPosition(li, this.dimension, align ^ 1);
                        continue;
                    }
                    if (!group.isSequential() || i == 0 || i + 1 == group.getSubIntervalCount()) continue;
                    onEdge = false;
                    break;
                }
                if (otherResizing || !onEdge) break;
                if (samePosition) {
                    this.operations.suppressGroupResizing(group);
                    break;
                }
                parallelInt = group;
                group = group.getParent();
            }
            if (!LayoutInterval.canResize(group)) {
                if (neighborGap != null) {
                    this.layoutModel.setIntervalSize(neighborGap, -1, -1, Short.MAX_VALUE);
                }
                if (this.unresizedOnRemove != null && this.unresizedOnRemove[this.dimension] != null) {
                    for (LayoutInterval li : this.unresizedOnRemove[this.dimension]) {
                        if (LayoutInterval.canResize(li) || !group.isParentOf(li)) continue;
                        boolean l = LayoutInterval.isPlacedAtBorder(li, group, this.dimension, 0);
                        boolean t = LayoutInterval.isPlacedAtBorder(li, group, this.dimension, 1);
                        if ((li.getParent() != group || !l || !t) && (li.getParent() == group || !l && !t)) continue;
                        if (li.isParallel()) {
                            this.operations.enableGroupResizing(li);
                            continue;
                        }
                        if (!li.isSingle()) continue;
                        this.operations.setIntervalResizing(li, true);
                    }
                }
            }
            if (interval.isComponent() && neighborGap == null && (parallelInt == interval || parallelInt == interval.getParent() && LayoutInterval.getCount(parallelInt, Integer.MAX_VALUE, true) == 1)) {
                this.operations.setParallelSameSize(group, parallelInt, this.dimension);
            }
        }
        this.operations.completeGroupResizing(group, this.dimension);
    }

    private void eliminateParallelResizingGaps(LayoutInterval interval) {
        if (interval.getParent().isSequential()) {
            interval = interval.getParent();
        }
        LayoutInterval parent = interval.getParent();
        assert (parent.isParallel() && LayoutInterval.wantResize(interval));
        Iterator<LayoutInterval> it = parent.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sibling = it.next();
            if (sibling == interval || sibling.isParentOf(interval) || !sibling.isSequential()) continue;
            LayoutInterval resGap = null;
            int gapIndex = -1;
            int count = sibling.getSubIntervalCount();
            for (int i = 0; i < count; ++i) {
                LayoutInterval li = sibling.getSubInterval(i);
                if (!LayoutInterval.wantResize(li)) continue;
                if (li.isEmptySpace() && resGap == null) {
                    resGap = li;
                    gapIndex = i;
                    continue;
                }
                resGap = null;
                break;
            }
            if (resGap == null) continue;
            if (gapIndex == 0 || gapIndex == count - 1) {
                int align;
                if (resGap.getMinimumSize() != 0) {
                    this.layoutModel.setIntervalSize(resGap, -1, -1, -2);
                } else {
                    this.layoutModel.removeInterval(resGap);
                }
                int n = align = gapIndex == 0 ? 1 : 0;
                if (sibling.getAlignment() == align) continue;
                this.layoutModel.setIntervalAlignment(sibling, align);
                continue;
            }
            if (resGap.getMinimumSize() == -2) continue;
            this.layoutModel.setIntervalSize(resGap, resGap.getMinimumSize(), resGap.getMinimumSize(), resGap.getMaximumSize());
        }
    }

    private int getExpectedBorderPosition(LayoutInterval interval, int dimension, int alignment) {
        LayoutInterval comp = LayoutUtils.getOutermostComponent(interval, dimension, alignment);
        int pos = comp.getCurrentSpace().positions[dimension][alignment];
        LayoutInterval neighbor = LayoutInterval.getNeighbor(comp, alignment, false, true, false);
        if (neighbor != null && neighbor.isEmptySpace() && interval.isParentOf(neighbor)) {
            int diff = neighbor.getPreferredSize();
            if (diff == -1) {
                diff = LayoutUtils.getSizeOfDefaultGap(neighbor, this.operations.getMapper());
            }
            if (alignment == 0) {
                diff *= -1;
            }
            pos += diff;
        }
        return pos;
    }

    private int determinePadding(LayoutInterval interval, LayoutConstants.PaddingType paddingType, int dimension, int alignment) {
        LayoutInterval neighbor = LayoutInterval.getNeighbor(interval, alignment, true, true, false);
        if (paddingType == null) {
            paddingType = LayoutConstants.PaddingType.RELATED;
        }
        return this.dragger.findPaddings(neighbor, interval, paddingType, dimension, alignment)[0];
    }

    private void analyzeParallel(LayoutInterval group, List<IncludeDesc> inclusions) {
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            IncludeDesc iDesc;
            LayoutInterval neighbor;
            LayoutInterval sub = it.next();
            if (sub.isEmptySpace()) continue;
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isParallel() && this.shouldEnterGroup(sub)) {
                this.analyzeParallel(sub, inclusions);
                continue;
            }
            if (sub.isSequential()) {
                this.analyzeSequential(sub, inclusions);
                continue;
            }
            boolean ortOverlap = this.orthogonalOverlap(sub);
            int margin = this.dimension == 1 && !ortOverlap ? 4 : 0;
            boolean dimOverlap = LayoutRegion.overlap(this.addingSpace, subSpace, this.dimension, margin);
            if (!ortOverlap && (this.dimension != 1 || dimOverlap)) continue;
            int ortDistance = 0;
            if (dimOverlap) {
                if (!this.solveOverlap && LayoutUtils.contentOverlap(this.addingSpace, sub)) continue;
                this.imposeSize = true;
            } else if (!ortOverlap) {
                int dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension ^ 1, 1, 0);
                int dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension ^ 1, 1, 0);
                ortDistance = dstL >= 0 ? dstL : dstT;
            }
            int distance = Integer.MIN_VALUE;
            if (this.aSnappedNextTo != null && (sub == this.aSnappedNextTo || sub.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null || (neighbor = LayoutInterval.getNeighbor(sub, this.aEdge, true, true, false)) == this.aSnappedNextTo || neighbor != null && neighbor.isParentOf(this.aSnappedNextTo))) {
                distance = -1;
            }
            if (distance != -1) {
                if (!dimOverlap) {
                    int dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension, 1, 0);
                    int dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension, 1, 0);
                    distance = dstL >= 0 ? dstL : dstT;
                } else {
                    distance = 0;
                }
            }
            if ((iDesc = this.addInclusion(group, false, distance, ortDistance, inclusions)) == null) continue;
            iDesc.neighbor = sub;
            iDesc.index = LayoutFeeder.getAddDirection(this.addingSpace, subSpace, this.dimension, this.getAddingPoint()) == 0 ? 0 : 1;
        }
        if (inclusions.isEmpty() && group.getParent() == null && (this.aSnappedParallel == null || this.canAlignWith(this.aSnappedParallel, group, this.aEdge))) {
            int distance = this.aSnappedNextTo == group ? -1 : Integer.MAX_VALUE;
            this.addInclusion(group, false, distance, Integer.MAX_VALUE, inclusions);
        }
    }

    private void analyzeSequential(LayoutInterval group, List<IncludeDesc> inclusions) {
        boolean inSequence = false;
        boolean parallelWithSequence = false;
        int startIndex = -1;
        int endIndex = -1;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;
        int n = group.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (sub.isEmptySpace()) {
                if (startIndex != i) continue;
                ++startIndex;
                continue;
            }
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isParallel() && this.shouldEnterGroup(sub)) {
                IncludeDesc[] before = inclusions.isEmpty() ? null : inclusions.toArray(new IncludeDesc[inclusions.size()]);
                this.analyzeParallel(sub, inclusions);
                if (before == null && !inclusions.isEmpty() || before != null && (before.length < inclusions.size() || !Arrays.asList(before).containsAll(inclusions))) {
                    return;
                }
            }
            boolean ortOverlap = this.orthogonalOverlap(sub);
            int margin = this.dimension == 1 && !ortOverlap ? 4 : 0;
            boolean dimOverlap = LayoutRegion.overlap(this.addingSpace, subSpace, this.dimension, margin);
            if (ortOverlap || this.dimension == 1 && !dimOverlap && !parallelWithSequence) {
                if (dimOverlap) {
                    if (!this.solveOverlap && LayoutUtils.contentOverlap(this.addingSpace, sub)) {
                        parallelWithSequence = true;
                        continue;
                    }
                    if (ortOverlap) {
                        this.imposeSize = true;
                    }
                    inSequence = true;
                    ortDistance = 0;
                    distance = 0;
                } else {
                    int dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension, 1, 0);
                    int dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension, 1, 0);
                    if (dstL >= 0 && dstL < distance) {
                        distance = dstL;
                    }
                    if (dstT >= 0 && dstT < distance) {
                        distance = dstT;
                    }
                    if (ortOverlap) {
                        ortDistance = 0;
                        inSequence = true;
                    } else {
                        dstL = LayoutRegion.distance(subSpace, this.addingSpace, this.dimension ^ 1, 1, 0);
                        dstT = LayoutRegion.distance(this.addingSpace, subSpace, this.dimension ^ 1, 1, 0);
                        if (dstL > 0 && dstL < ortDistance) {
                            ortDistance = dstL;
                        }
                        if (dstT > 0 && dstT < ortDistance) {
                            ortDistance = dstT;
                        }
                    }
                }
                if (LayoutFeeder.getAddDirection(this.addingSpace, subSpace, this.dimension, this.getAddingPoint()) == 0) {
                    endIndex = i;
                    break;
                }
                parallelWithSequence = false;
                startIndex = i + 1;
                continue;
            }
            parallelWithSequence = true;
        }
        if (inSequence || this.dimension == 1 && !parallelWithSequence) {
            IncludeDesc iDesc;
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (endIndex < 0) {
                endIndex = group.getSubIntervalCount();
            }
            if (this.forwardIntoSubParallel(group, startIndex, endIndex, inclusions)) {
                return;
            }
            if (this.aSnappedNextTo != null) {
                if (group.isParentOf(this.aSnappedNextTo) || this.aSnappedNextTo.getParent() == null) {
                    distance = -1;
                } else {
                    LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(group.getParent(), this.aEdge, true);
                    if (neighbor != null && (neighbor == this.aSnappedNextTo || LayoutInterval.isAlignedAtBorder(this.aSnappedNextTo, neighbor, this.aEdge ^ 1))) {
                        distance = -1;
                    }
                }
            }
            if ((iDesc = this.addInclusion(group, parallelWithSequence, distance, ortDistance, inclusions)) != null) {
                int n2 = iDesc.index = this.aEdge == 0 ? startIndex : endIndex;
                if (iDesc.snappedParallel != null && group.isParentOf(iDesc.snappedParallel) && !parallelWithSequence && this.dragger.isResizing(this.dimension ^ 1)) {
                    iDesc.snappedParallel = null;
                }
            }
        }
    }

    private int getAddingPoint() {
        if (this.aEdge < 0) {
            return 2;
        }
        if ((this.aEdge == 0 || this.aEdge == 1) && this.aSnappedNextTo == null && this.aSnappedParallel == null) {
            LayoutDragger.PositionDef primaryPos = this.newPositions[this.dimension];
            return primaryPos != null && primaryPos.snapped && primaryPos.alignment == (this.aEdge ^ 1) ? primaryPos.alignment : 2;
        }
        return this.aEdge;
    }

    private boolean orthogonalOverlap(LayoutInterval interval) {
        boolean ortOverlap;
        if (this.solveOverlap || !LayoutUtils.isOverlapPreventedInOtherDimension(this.addingInterval, interval, this.dimension)) {
            ortOverlap = LayoutUtils.contentOverlap(this.addingSpace, interval, this.dimension ^ 1);
            if (ortOverlap) {
                if (this.dragger.isResizing()) {
                    IncludeDesc original;
                    IncludeDesc includeDesc = original = this.originalPosition != null ? this.originalPosition.desc1 : null;
                    if (original != null && (!this.dragger.isResizing(this.dimension ^ 1) || LayoutUtils.contentOverlap(this.originalSpace, interval, this.dimension ^ 1))) {
                        LayoutInterval parent = original.parent;
                        if (parent.isParentOf(interval)) {
                            if (parent.isParallel() && (original.neighbor == null || original.neighbor != interval && !original.neighbor.isParentOf(interval))) {
                                ortOverlap = false;
                            }
                        } else if (parent == interval) {
                            if (parent.isParallel() && original.neighbor == null) {
                                ortOverlap = false;
                            }
                        } else if (!interval.isParentOf(parent) && (parent = LayoutInterval.getCommonParent(parent, interval)) != null && parent.isParallel()) {
                            ortOverlap = false;
                        }
                    }
                } else {
                    LayoutDragger.PositionDef otherDimPos = this.newPositions[this.dimension ^ 1];
                    if (otherDimPos != null && otherDimPos.snapped && (otherDimPos.alignment == 2 || otherDimPos.alignment == 3)) {
                        LayoutInterval ortInterval;
                        LayoutInterval li;
                        LayoutInterval ortAligned = otherDimPos.interval;
                        if (!ortAligned.isParallel() && (li = LayoutInterval.getFirstParent(ortAligned, 103)).getGroupAlignment() == otherDimPos.alignment) {
                            ortAligned = li;
                        }
                        boolean intervalAligned = false;
                        Iterator<LayoutInterval> it = LayoutUtils.getComponentIterator(ortAligned);
                        while (it.hasNext()) {
                            LayoutInterval li2 = it.next().getComponent().getLayoutInterval(this.dimension);
                            if (interval != li2 && !interval.isParentOf(li2)) continue;
                            intervalAligned = true;
                            break;
                        }
                        if (!intervalAligned && LayoutInterval.getCommonParent(ortAligned, ortInterval = LayoutUtils.getComponentIterator(interval).next().getComponent().getLayoutInterval(this.dimension ^ 1)).isSequential()) {
                            ortOverlap = false;
                        }
                    }
                }
            }
        } else {
            ortOverlap = false;
        }
        return ortOverlap;
    }

    private IncludeDesc addInclusion(LayoutInterval parent, boolean subgroup, int distance, int ortDistance, List<IncludeDesc> inclusions) {
        if (!inclusions.isEmpty()) {
            boolean ortOverlap2;
            int index = inclusions.size() - 1;
            IncludeDesc last = inclusions.get(index);
            boolean useLast = false;
            boolean useNew = false;
            boolean ortOverlap1 = last.ortDistance == 0;
            boolean bl = ortOverlap2 = ortDistance == 0;
            if (ortOverlap1 != ortOverlap2) {
                useLast = ortOverlap1;
                useNew = ortOverlap2;
            } else if (ortOverlap1) {
                useNew = true;
                useLast = true;
            } else if (last.ortDistance != ortDistance) {
                useLast = last.ortDistance < ortDistance;
                useNew = ortDistance < last.ortDistance;
            } else if (last.distance != distance) {
                useLast = last.distance < distance;
                boolean bl2 = useNew = distance < last.distance;
            }
            if (!useLast && !useNew) {
                LayoutInterval parParent = last.parent.isParallel() ? last.parent : last.parent.getParent();
                useNew = parParent.isParentOf(parent);
                boolean bl3 = useLast = !useNew;
            }
            if (!useLast) {
                inclusions.remove(index);
            }
            if (!useNew) {
                return null;
            }
        }
        IncludeDesc iDesc = new IncludeDesc();
        iDesc.parent = parent;
        iDesc.newSubGroup = subgroup;
        iDesc.alignment = this.aEdge;
        iDesc.snappedParallel = this.aSnappedParallel;
        if (distance == -1) {
            iDesc.snappedNextTo = this.aSnappedNextTo;
            iDesc.paddingType = this.aPaddingType;
            iDesc.fixedPosition = true;
        }
        iDesc.distance = distance;
        iDesc.ortDistance = ortDistance;
        inclusions.add(iDesc);
        return iDesc;
    }

    private IncludeDesc addAligningInclusion(List<IncludeDesc> inclusions) {
        LayoutInterval parent;
        if (this.aSnappedParallel == null) {
            return null;
        }
        for (IncludeDesc inc : inclusions) {
            if (!this.canAlignWith(this.aSnappedParallel, inc.parent, this.aEdge)) continue;
            return null;
        }
        IncludeDesc iDesc = new IncludeDesc();
        if (!this.aSnappedParallel.isParallel() && (parent = LayoutInterval.getFirstParent(this.aSnappedParallel, 103)) != null && parent.getParent() != null && LayoutInterval.isPlacedAtBorder(this.aSnappedParallel, parent, this.dimension, this.aEdge) && (LayoutInterval.contentWantResize(parent) && !LayoutInterval.wantResize(this.addingInterval) || !LayoutInterval.isAlignedAtBorder(this.aSnappedParallel, parent, this.aEdge))) {
            iDesc.snappedParallel = parent;
            iDesc.parent = LayoutInterval.getFirstParent(parent, 103);
            boolean same = false;
            for (IncludeDesc inc : inclusions) {
                if (inc.snappedParallel != this.aSnappedParallel) continue;
                inc.snappedParallel = iDesc.snappedParallel;
                if (inc.parent != iDesc.parent) continue;
                same = true;
            }
            if (same) {
                return null;
            }
        }
        if (iDesc.snappedParallel == null) {
            iDesc.snappedParallel = this.aSnappedParallel;
            iDesc.parent = LayoutInterval.getFirstParent(this.aSnappedParallel, 103);
        }
        if (iDesc.parent == null) {
            iDesc.parent = this.aSnappedParallel;
        }
        iDesc.alignment = this.aEdge;
        inclusions.add(0, iDesc);
        return iDesc;
    }

    private boolean forwardIntoSubParallel(LayoutInterval seq, int startIndex, int endIndex, List<IncludeDesc> inclusions) {
        int d2;
        int d1;
        if (this.dragger.isResizing(this.dimension) || this.aSnappedParallel != null) {
            return false;
        }
        LayoutInterval[] neighbors = new LayoutInterval[2];
        boolean[] aimsToGroup = new boolean[2];
        for (int e = 0; e <= 1; ++e) {
            if (this.aSnappedNextTo != null && e == (this.aEdge ^ 1)) continue;
            LayoutInterval neighbor = null;
            if (e == 0) {
                if (startIndex - 1 >= 0 && (neighbor = seq.getSubInterval(startIndex - 1)).isEmptySpace() && startIndex - 2 >= 0) {
                    neighbor = seq.getSubInterval(startIndex - 2);
                }
            } else if (endIndex < seq.getSubIntervalCount()) {
                neighbor = seq.getSubInterval(endIndex);
            }
            if (neighbor == null || !neighbor.isParallel()) continue;
            neighbors[e] = neighbor;
            aimsToGroup[e] = this.addingOverGroupEdge(neighbor, e ^ 1);
        }
        if (this.dimension == 1 && !aimsToGroup[0] && !aimsToGroup[1]) {
            return false;
        }
        int tryFirst = neighbors[0] != null && neighbors[1] != null && aimsToGroup[0] == aimsToGroup[1] ? ((d1 = LayoutRegion.distance(neighbors[0].getCurrentSpace(), this.addingSpace, this.dimension, 1, 0)) <= (d2 = LayoutRegion.distance(this.addingSpace, neighbors[1].getCurrentSpace(), this.dimension, 1, 0)) ? 0 : 1) : (aimsToGroup[0] ? (!aimsToGroup[1] || this.aEdge != 1 ? 0 : 1) : (!aimsToGroup[1] ? 0 : 1));
        int e = tryFirst;
        int edgeCount = 2;
        while (edgeCount > 0) {
            LayoutInterval neighbor = neighbors[e];
            if (neighbor != null && this.groupOpenToEnter(neighbor, e ^ 1)) {
                int count = inclusions.size();
                this.analyzeParallel(neighbor, inclusions);
                if (inclusions.size() > count) {
                    return true;
                }
            }
            --edgeCount;
            e ^= 1;
        }
        return false;
    }

    private boolean addingOverGroupEdge(LayoutInterval group, int alignment) {
        int[] apos = this.addingSpace.positions[this.dimension];
        int[] gpos = group.getCurrentSpace().positions[this.dimension];
        return apos[0] < gpos[alignment] && apos[1] > gpos[alignment];
    }

    private boolean stickingOutOfGroup(LayoutInterval group, int alignment) {
        int[] apos = this.addingSpace.positions[this.dimension];
        int[] gpos = group.getCurrentSpace().positions[this.dimension];
        return alignment == 0 ? apos[0] < gpos[0] : apos[1] > gpos[1];
    }

    private boolean hasOpenRoomForAdding(LayoutInterval group, int alignment) {
        assert (group.isParallel());
        LayoutRegion groupSpace = group.getCurrentSpace();
        for (LayoutInterval comp : LayoutUtils.edgeSubComponents(group, alignment, false)) {
            LayoutRegion compSpace = comp.getCurrentSpace();
            if (!LayoutRegion.overlap(this.addingSpace, compSpace, this.dimension ^ 1, 0) || compSpace.positions[this.dimension][alignment] != groupSpace.positions[this.dimension][alignment]) continue;
            return false;
        }
        return true;
    }

    private boolean preferClosedPosition(IncludeDesc newDesc) {
        if (this.originalPosition == null) {
            return false;
        }
        IncludeDesc origDesc = this.originalPosition.desc1;
        if (origDesc != null && origDesc != newDesc && this.originalPosition.closedSpace != null && this.layoutModel.getChangeMark().equals(this.undoCheckMark)) {
            LayoutInterval origParent = origDesc.parent;
            if (origParent.isSequential() && !origDesc.newSubGroup) {
                origParent = origParent.getParent();
            }
            LayoutRegion origClosedSpace = this.originalPosition.closedSpace;
            if ((newDesc.parent == origParent || newDesc.parent.isParentOf(origParent)) && LayoutRegion.pointInside(this.addingSpace, 0, origClosedSpace, this.dimension) && LayoutRegion.pointInside(this.addingSpace, 1, origClosedSpace, this.dimension) && newDesc.snappedNextTo == null && (newDesc.snappedParallel == null || newDesc.snappedParallel == origParent || origParent.isParentOf(newDesc.snappedParallel))) {
                boolean sameNeighbors;
                if (origParent.isParallel()) {
                    sameNeighbors = newDesc.neighbor == origDesc.neighbor;
                } else {
                    sameNeighbors = true;
                    Iterator<LayoutInterval> it = origParent.getSubIntervals();
                    while (it.hasNext()) {
                        LayoutInterval sub = it.next();
                        if (sub.isEmptySpace()) continue;
                        LayoutRegion subSpace = sub.getCurrentSpace();
                        if (!LayoutUtils.contentOverlap(this.addingSpace, sub, this.dimension ^ 1) || LayoutRegion.overlap(this.addingSpace, subSpace, this.dimension, 0) == LayoutRegion.overlap(origClosedSpace, subSpace, this.dimension, 0)) continue;
                        sameNeighbors = false;
                        break;
                    }
                }
                if (sameNeighbors) {
                    newDesc.parent = origParent;
                    newDesc.index = origDesc.parent == origParent ? origDesc.index : -1;
                    newDesc.newSubGroup = origDesc.newSubGroup;
                    this.closedSpace = new LayoutRegion(origClosedSpace);
                    this.closedSpace.set(this.dimension ^ 1, this.addingSpace);
                    return true;
                }
            }
        }
        if (!this.dragger.isResizing() && this.originalPosition.wholeResizing && newDesc.snappedParallel != null && newDesc.neighbor == null) {
            LayoutInterval snapParent;
            if (newDesc.snappedParallel.isParallel()) {
                snapParent = newDesc.snappedParallel;
            } else {
                snapParent = LayoutInterval.getFirstParent(newDesc.snappedParallel, 103);
                if (!LayoutInterval.isAlignedAtBorder(newDesc.snappedParallel, snapParent, this.aEdge)) {
                    snapParent = null;
                }
            }
            if (snapParent != null && newDesc.parent.isParentOf(snapParent) && (!LayoutInterval.canResize(snapParent) || !this.originalPosition.suppressedResizing && LayoutInterval.wantResize(snapParent))) {
                newDesc.parent = snapParent;
                newDesc.index = -1;
                newDesc.neighbor = null;
                newDesc.newSubGroup = false;
                this.closedSpace = new LayoutRegion(snapParent.getCurrentSpace());
                this.closedSpace.set(this.dimension ^ 1, this.addingSpace);
                if (this.originalPosition.suppressedResizing && this.originalPosition.wholeResizing) {
                    int overSize;
                    int defSizeDef = LayoutInterval.getDefaultSizeDef(this.addingInterval);
                    if (this.addingInterval.getPreferredSize() != defSizeDef) {
                        this.operations.resizeInterval(this.addingInterval, defSizeDef);
                    }
                    if ((overSize = this.addingInterval.getDiffToDefaultSize()) > 0) {
                        if (newDesc.alignment == 1) {
                            this.addingInterval.getCurrentSpace().reshape(this.dimension, 0, overSize);
                        } else {
                            this.addingInterval.getCurrentSpace().reshape(this.dimension, 1, -overSize);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void mergeParallelInclusions(List<IncludeDesc> inclusions, IncludeDesc original, boolean preserveOriginal) {
        IncludeDesc alignedDesc;
        LayoutInterval separatingGap;
        int checkCount;
        LayoutInterval commonSeq;
        int index;
        LayoutInterval addingMultiWrapper;
        IncludeDesc best = null;
        boolean bestOriginal = false;
        for (IncludeDesc iDesc : inclusions) {
            if (original != null && preserveOriginal && !this.canCombine(iDesc, original)) continue;
            if (best != null) {
                LayoutInterval group2;
                boolean originalCompatible;
                boolean bl = originalCompatible = original != null && !preserveOriginal && iDesc.parent == original.parent;
                if (!bestOriginal && originalCompatible) {
                    best = iDesc;
                    bestOriginal = true;
                    continue;
                }
                if (bestOriginal != originalCompatible) continue;
                LayoutInterval group1 = best.parent.isSequential() ? best.parent.getParent() : best.parent;
                LayoutInterval layoutInterval = group2 = iDesc.parent.isSequential() ? iDesc.parent.getParent() : iDesc.parent;
                if (group1.isParentOf(group2)) {
                    best = iDesc;
                    continue;
                }
                if (group2.isParentOf(group1) || iDesc.distance >= best.distance) continue;
                best = iDesc;
                continue;
            }
            best = iDesc;
            bestOriginal = original != null && !preserveOriginal && iDesc.parent == original.parent;
        }
        if (best == null) {
            assert (preserveOriginal);
            inclusions.clear();
            inclusions.add(original);
            return;
        }
        LayoutInterval commonGroup = best.parent.isSequential() ? best.parent.getParent() : best.parent;
        Iterator<IncludeDesc> it = inclusions.iterator();
        while (it.hasNext()) {
            IncludeDesc iDesc = it.next();
            if (iDesc == best) continue;
            if (!LayoutFeeder.compatibleInclusions(iDesc, best, this.dimension)) {
                it.remove();
                continue;
            }
            if (iDesc.parent == best.parent && iDesc.neighbor == best.neighbor && (iDesc.neighbor != null || iDesc.index == iDesc.index)) {
                it.remove();
                continue;
            }
            LayoutInterval group = iDesc.parent.isSequential() ? iDesc.parent.getParent() : iDesc.parent;
            if (!group.isParentOf(commonGroup)) continue;
            LayoutInterval neighbor = iDesc.parent.isSequential() ? iDesc.parent : iDesc.neighbor;
            this.layoutModel.removeInterval(neighbor);
            this.layoutModel.addInterval(neighbor, commonGroup, -1);
            for (int e = 0; e <= 1; ++e) {
                int d = e == 0 ? 1 : -1;
                int posDiff = LayoutRegion.distance(group.getCurrentSpace(), commonGroup.getCurrentSpace(), this.dimension, e, e);
                if (posDiff != Integer.MIN_VALUE) {
                    posDiff *= d;
                }
                if (posDiff <= 0) continue;
                for (LayoutInterval gap : LayoutUtils.getSideGaps(neighbor, e, true)) {
                    int currentSize = LayoutInterval.canResize(gap) ? -1 : gap.getPreferredSize();
                    if (currentSize <= posDiff) continue;
                    this.operations.resizeInterval(gap, currentSize - posDiff);
                }
            }
            if (iDesc.parent == group) {
                iDesc.parent = commonGroup;
            }
            if (group.getSubIntervalCount() != 1 || group.getParent() == null) continue;
            LayoutInterval parent = group.getParent();
            LayoutInterval last = this.layoutModel.removeInterval(group, 0);
            int index2 = this.layoutModel.removeInterval(group);
            this.operations.addContent(last, parent, index2, this.dimension);
            this.updateInclusionsForEliminatedGroup(inclusions, group, parent, index2);
            if (last.getParent() != null) continue;
            this.updateInclusionsForEliminatedGroup(inclusions, last, parent, index2);
            if (commonGroup != last) continue;
            commonGroup = parent;
        }
        if (original != null && original.parent.isParallel() && original.snappedParallel != null && original.ortDistance != 0 && inclusions.size() > 1) {
            inclusions.remove(original);
        }
        if (inclusions.size() == 1) {
            return;
        }
        LayoutInterval subGroup = null;
        int subEffAlign = -1;
        LayoutInterval nextTo = null;
        LinkedList<List> separatedLeading = new LinkedList<List>();
        LinkedList<List> separatedTrailing = new LinkedList<List>();
        Iterator<IncludeDesc> it2 = inclusions.iterator();
        while (it2.hasNext()) {
            IncludeDesc iDesc = it2.next();
            if (!iDesc.parent.isSequential() || !iDesc.newSubGroup) continue;
            LayoutInterval parSeq = this.extractParallelSequence(iDesc.parent, this.addingSpace, -1, -1, iDesc.alignment, LayoutFeeder.collectNeighborPositions(inclusions, iDesc, this.addingSpace, this.dimension));
            if (parSeq != null) {
                assert (parSeq.isParallel());
                if (subGroup == null) {
                    subGroup = parSeq;
                    subEffAlign = LayoutInterval.getEffectiveAlignment(parSeq);
                } else {
                    do {
                        LayoutInterval sub = this.layoutModel.removeInterval(parSeq, 0);
                        this.layoutModel.addInterval(sub, subGroup, -1);
                    } while (parSeq.getSubIntervalCount() > 0);
                    if (subEffAlign == 0 || subEffAlign == 1) {
                        int d;
                        LayoutRegion commSpace = subGroup.getCurrentSpace();
                        LayoutRegion space = parSeq.getCurrentSpace();
                        int e1 = subEffAlign;
                        int e2 = subEffAlign ^ 1;
                        int n = d = e1 == 0 ? 1 : -1;
                        if (LayoutRegion.distance(commSpace, space, this.dimension, e1, e1) * d > 0) {
                            commSpace.setPos(this.dimension, 0, space.positions[this.dimension][0]);
                        }
                        if (LayoutRegion.distance(commSpace, space, this.dimension, e2, e2) * d > 0) {
                            commSpace.setPos(this.dimension, e2, space.positions[this.dimension][e2]);
                        }
                    }
                }
                this.operations.extract(parSeq, -1, true, separatedLeading, separatedTrailing);
                this.layoutModel.removeInterval(parSeq);
                this.layoutModel.removeInterval(iDesc.parent);
                continue;
            }
            it2.remove();
            if (inclusions.size() != 1) continue;
            if (!separatedLeading.isEmpty() || !separatedTrailing.isEmpty()) break;
            return;
        }
        int extractAlign = -1;
        if (subGroup != null) {
            if (separatedLeading.isEmpty()) {
                extractAlign = 1;
            }
            if (separatedTrailing.isEmpty()) {
                extractAlign = 0;
            }
        }
        boolean[] anyResizingNeighbor = new boolean[2];
        int[] fixedSideGaps = new int[2];
        ArrayList<LayoutInterval[]> unifyGaps = null;
        if (this.addingInterval.isSequential()) {
            addingMultiWrapper = new LayoutInterval(103);
            addingMultiWrapper.add(this.addingInterval, 0);
            addingMultiWrapper.getCurrentSpace().set(this.addingSpace);
            this.addingInterval = addingMultiWrapper;
        } else {
            addingMultiWrapper = null;
        }
        LayoutInterval subsubGroup = null;
        Iterator<IncludeDesc> it3 = inclusions.iterator();
        while (it3.hasNext()) {
            IncludeDesc iDesc = it3.next();
            if (iDesc.parent.isParallel() || !iDesc.newSubGroup) {
                LayoutInterval snp = null;
                if (iDesc.snappedParallel != null && !iDesc.parent.isParentOf(iDesc.snappedParallel)) {
                    snp = iDesc.snappedParallel;
                    iDesc.snappedParallel = null;
                }
                this.addToGroup(iDesc, null, false);
                if (snp != null) {
                    iDesc.snappedParallel = snp;
                }
                if (subGroup == null && !LayoutInterval.wantResize(this.addingInterval)) {
                    LayoutInterval lGap = LayoutInterval.getDirectNeighbor(this.addingInterval, 0, false);
                    LayoutInterval tGap = LayoutInterval.getDirectNeighbor(this.addingInterval, 1, false);
                    if (lGap != null && lGap.isEmptySpace() && tGap != null && tGap.isEmptySpace()) {
                        LayoutInterval[] gaps = new LayoutInterval[]{lGap, tGap};
                        for (int i = 0; i <= 1; ++i) {
                            if (LayoutInterval.canResize(gaps[i])) continue;
                            if (LayoutInterval.hasAnyResizingNeighbor(gaps[i], i)) {
                                anyResizingNeighbor[i] = true;
                                gaps[i] = null;
                            }
                            int n = i;
                            fixedSideGaps[n] = fixedSideGaps[n] + 1;
                        }
                        if (gaps[0] != null && gaps[1] != null) {
                            if (unifyGaps == null) {
                                unifyGaps = new ArrayList<LayoutInterval[]>();
                            }
                            unifyGaps.add(gaps);
                        }
                    }
                }
                this.operations.extract(this.addingInterval, extractAlign, extractAlign == -1, separatedLeading, separatedTrailing);
                LayoutInterval parent = this.addingInterval.getParent();
                this.layoutModel.removeInterval(this.addingInterval);
                this.layoutModel.removeInterval(parent);
                if (extractAlign != -1 && LayoutInterval.getCount(parent, Integer.MAX_VALUE, true) >= 1) {
                    if (subsubGroup == null) {
                        subsubGroup = new LayoutInterval(103);
                        subsubGroup.setGroupAlignment(extractAlign);
                    }
                    this.operations.addContent(parent, subsubGroup, -1, this.dimension);
                }
            }
            if (iDesc.snappedNextTo != null) {
                nextTo = iDesc.snappedNextTo;
            }
            if (iDesc == best) continue;
            it3.remove();
        }
        if (!inclusions.contains(best)) {
            inclusions.add(best);
        }
        if (addingMultiWrapper != null) {
            this.addingInterval = addingMultiWrapper.remove(0);
        }
        if (unifyGaps != null) {
            block8: for (LayoutInterval[] gaps : unifyGaps) {
                int preferredFixedSide = fixedSideGaps[0] >= fixedSideGaps[1] ? 0 : 1;
                for (int i = 0; i <= 1; ++i) {
                    if (!LayoutInterval.canResize(gaps[i]) || anyResizingNeighbor[i] || !anyResizingNeighbor[i ^ 1] && preferredFixedSide != i) continue;
                    this.operations.setIntervalResizing(gaps[i], false);
                    if (LayoutInterval.canResize(gaps[i ^ 1])) continue block8;
                    this.operations.setIntervalResizing(gaps[i ^ i], true);
                    continue block8;
                }
            }
        } else if (subGroup != null && (subEffAlign == 0 || subEffAlign == 1)) {
            int d = subEffAlign == 0 ? 1 : -1;
            int groupPos = subGroup.getCurrentSpace().positions[this.dimension][subEffAlign];
            for (LayoutInterval gap : LayoutUtils.getSideGaps(subGroup, subEffAlign, true)) {
                int pos;
                int expectedSize;
                int currentSize = LayoutInterval.canResize(gap) ? -1 : gap.getPreferredSize();
                if (currentSize <= 0 || (expectedSize = ((pos = LayoutUtils.getVisualPosition(gap, this.dimension, subEffAlign ^ 1)) - groupPos) * d) <= 0 || expectedSize >= currentSize) continue;
                this.operations.resizeInterval(gap, expectedSize);
            }
        }
        int[] borderPos = commonGroup.getCurrentSpace().positions[this.dimension];
        int[] neighborPos = (subGroup != null ? subGroup : this.addingInterval).getCurrentSpace().positions[this.dimension];
        if (commonGroup.getSubIntervalCount() == 0 && commonGroup.getParent() != null) {
            LayoutInterval parent = commonGroup.getParent();
            index = this.layoutModel.removeInterval(commonGroup);
            if (parent.isSequential()) {
                commonSeq = parent;
                commonGroup = parent.getParent();
            } else {
                commonSeq = new LayoutInterval(102);
                commonSeq.setAlignment(commonGroup.getAlignment());
                this.layoutModel.addInterval(commonSeq, parent, index);
                commonGroup = parent;
                index = 0;
            }
        } else {
            commonSeq = new LayoutInterval(102);
            this.layoutModel.addInterval(commonSeq, commonGroup, -1);
            index = 0;
        }
        if (commonSeq.getSubIntervalCount() == 0) {
            commonSeq.getCurrentSpace().set(this.dimension, commonGroup.getCurrentSpace());
        }
        this.updateReplacedOriginalGroup(commonGroup, commonSeq);
        LayoutInterval sideGroupLeading = null;
        LayoutInterval sideGroupTrailing = null;
        if (!separatedLeading.isEmpty()) {
            checkCount = commonSeq.getSubIntervalCount();
            sideGroupLeading = this.operations.addGroupContent(separatedLeading, commonSeq, index, this.dimension, 0);
            index += commonSeq.getSubIntervalCount() - checkCount;
        }
        if (!separatedTrailing.isEmpty()) {
            sideGroupTrailing = this.operations.addGroupContent(separatedTrailing, commonSeq, index, this.dimension, 1);
        }
        if (sideGroupLeading != null) {
            checkCount = commonSeq.getSubIntervalCount();
            sideGroupLeading.getCurrentSpace().set(this.dimension, borderPos[0], neighborPos[0]);
            this.operations.optimizeGaps(sideGroupLeading, this.dimension);
            index += commonSeq.getSubIntervalCount() - checkCount;
        }
        if (sideGroupTrailing != null) {
            sideGroupTrailing.getCurrentSpace().set(this.dimension, neighborPos[1], borderPos[1]);
            this.operations.optimizeGaps(sideGroupTrailing, this.dimension);
        }
        best.parent = commonSeq;
        best.newSubGroup = false;
        best.neighbor = null;
        int gapIdx = index;
        if (gapIdx == commonSeq.getSubIntervalCount()) {
            separatingGap = commonSeq.getSubInterval(--gapIdx);
        } else {
            separatingGap = commonSeq.getSubInterval(gapIdx);
            if (!separatingGap.isEmptySpace() && --gapIdx > 0) {
                separatingGap = commonSeq.getSubInterval(gapIdx);
            }
        }
        if (!separatingGap.isEmptySpace()) {
            separatingGap = null;
        } else if (subGroup == null) {
            index = gapIdx;
            if (index == 0 && !LayoutInterval.isAlignedAtBorder(commonSeq, 0)) {
                this.layoutModel.removeInterval(separatingGap);
                separatingGap = null;
            } else if (index == commonSeq.getSubIntervalCount() - 1 && !LayoutInterval.isAlignedAtBorder(commonSeq, 1)) {
                this.layoutModel.removeInterval(separatingGap);
                separatingGap = null;
            }
        }
        best.snappedNextTo = nextTo;
        if (nextTo != null) {
            best.fixedPosition = true;
        }
        if (subGroup != null) {
            if (separatingGap != null && (extractAlign == -1 || extractAlign == 0 && index > gapIdx || extractAlign == 1 && index <= gapIdx)) {
                this.layoutModel.removeInterval(separatingGap);
                if (index >= gapIdx && index > 0) {
                    --index;
                }
            }
            int subIdx = index;
            if (subsubGroup != null && subsubGroup.getSubIntervalCount() > 0) {
                LayoutInterval seq = new LayoutInterval(102);
                seq.setAlignment(best.alignment);
                this.operations.addContent(subsubGroup, seq, 0, this.dimension);
                this.layoutModel.addInterval(seq, subGroup, -1);
                best.parent = seq;
                index = extractAlign == 0 ? 0 : seq.getSubIntervalCount();
            } else {
                best.newSubGroup = true;
            }
            this.operations.addContent(subGroup, commonSeq, subIdx, this.dimension);
            this.updateMovedOriginalNeighbor();
        }
        this.operations.mergeConsecutiveGaps(commonSeq, index - 1, this.dimension);
        best.index = index;
        if (subGroup != null && best.newSubGroup && best.snappedParallel != null && (alignedDesc = this.addAligningInclusion(inclusions)) != null) {
            inclusions.remove(best.parent.isParentOf(alignedDesc.parent) ? best : alignedDesc);
        }
        this.optimizeStructure = true;
    }

    private static boolean compatibleInclusions(IncludeDesc iDesc1, IncludeDesc iDesc2, int dimension) {
        LayoutRegion spaceAvailable;
        LayoutInterval neighbor;
        LayoutInterval group2;
        LayoutInterval group1 = iDesc1.parent.isSequential() ? iDesc1.parent.getParent() : iDesc1.parent;
        LayoutInterval layoutInterval = group2 = iDesc2.parent.isSequential() ? iDesc2.parent.getParent() : iDesc2.parent;
        if (group1 == group2) {
            return true;
        }
        if (group1.isParentOf(group2)) {
            LayoutInterval temp = group1;
            group1 = group2;
            group2 = temp;
            IncludeDesc itemp = iDesc1;
            iDesc1 = iDesc2;
            iDesc2 = itemp;
        } else if (!group2.isParentOf(group1)) {
            return false;
        }
        if (iDesc2.parent.isSequential()) {
            if (iDesc2.parent.isParentOf(iDesc1.parent)) {
                return false;
            }
            neighbor = iDesc2.parent;
        } else {
            neighbor = iDesc2.neighbor;
        }
        if (neighbor == null) {
            return false;
        }
        LayoutRegion spaceToHold = new LayoutRegion(neighbor.getCurrentSpace());
        LayoutInterval lComp = LayoutUtils.getOutermostComponent(neighbor, dimension, 0);
        LayoutInterval tComp = LayoutUtils.getOutermostComponent(neighbor, dimension, 1);
        if (lComp != null && tComp != null) {
            spaceToHold.set(dimension, lComp.getCurrentSpace().positions[dimension][0], tComp.getCurrentSpace().positions[dimension][1]);
        }
        return LayoutRegion.pointInside(spaceToHold, 0, spaceAvailable = group1.getCurrentSpace(), dimension) && LayoutRegion.pointInside(spaceToHold, 1, spaceAvailable, dimension);
    }

    private void updateInclusionsForEliminatedGroup(List<IncludeDesc> inclusions, LayoutInterval replacedGroup, LayoutInterval newGroup, int index) {
        for (IncludeDesc iDesc : inclusions) {
            LayoutFeeder.updateReplacedGroup(iDesc, replacedGroup, newGroup, index);
        }
        if (this.originalPosition != null) {
            if (this.originalPosition.desc1 != null) {
                LayoutFeeder.updateReplacedGroup(this.originalPosition.desc1, replacedGroup, newGroup, index);
            }
            if (this.originalPosition.desc2 != null) {
                LayoutFeeder.updateReplacedGroup(this.originalPosition.desc2, replacedGroup, newGroup, index);
            }
        }
    }

    private static void updateReplacedGroup(IncludeDesc iDesc, LayoutInterval replacedGroup, LayoutInterval newGroup, int index) {
        if (iDesc.parent == replacedGroup) {
            if (newGroup.isSequential()) {
                if (replacedGroup.isParallel()) {
                    iDesc.newSubGroup = true;
                } else if (iDesc.index >= 0 && index >= 0) {
                    iDesc.index += index;
                }
            }
            iDesc.parent = newGroup;
        }
    }

    private void updateReplacedOriginalGroup(LayoutInterval newGroup, LayoutInterval newSeq) {
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPosition != null ? this.originalPosition.desc1 : null, newGroup, newSeq);
        LayoutFeeder.updateReplacedOriginalGroup(this.originalPosition != null ? this.originalPosition.desc2 : null, newGroup, newSeq);
    }

    private static void updateReplacedOriginalGroup(IncludeDesc iDesc, LayoutInterval newGroup, LayoutInterval newSeq) {
        if (iDesc != null && LayoutInterval.getRoot(newGroup) != LayoutInterval.getRoot(iDesc.parent)) {
            if (iDesc.parent.isParallel()) {
                iDesc.parent = newGroup;
            } else if (newSeq != null) {
                iDesc.parent = newSeq;
            }
        }
    }

    private void updateMovedOriginalNeighbor() {
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPosition != null ? this.originalPosition.desc1 : null);
        LayoutFeeder.updateMovedOriginalNeighbor(this.originalPosition != null ? this.originalPosition.desc2 : null);
    }

    private static void updateMovedOriginalNeighbor(IncludeDesc iDesc) {
        if (iDesc != null && iDesc.neighbor != null) {
            if (iDesc.neighbor.getParent() != null) {
                iDesc.parent = LayoutInterval.getFirstParent(iDesc.neighbor, 103);
            }
            LayoutFeeder.correctOriginalInclusion(iDesc, LayoutInterval.getRoot(iDesc.neighbor));
        }
    }

    private static int[] collectNeighborPositions(List<IncludeDesc> inclusions, IncludeDesc exclude, LayoutRegion space, int dimension) {
        int minPos = Integer.MIN_VALUE;
        int maxPos = Integer.MAX_VALUE;
        LayoutInterval[] neighbors = new LayoutInterval[2];
        for (IncludeDesc iDesc : inclusions) {
            int pos;
            block10: {
                LayoutInterval parent;
                block11: {
                    LayoutInterval neighbor;
                    block9: {
                        LayoutRegion nSpace;
                        parent = iDesc.parent;
                        if (iDesc == exclude) continue;
                        neighbors[0] = null;
                        neighbors[1] = null;
                        if (!parent.isParallel()) break block9;
                        if (iDesc.neighbor == null || !(nSpace = iDesc.neighbor.getCurrentSpace()).isSet(dimension)) break block10;
                        int dir = LayoutFeeder.getAddDirection(space, nSpace, dimension, 2);
                        neighbors[dir ^ 1] = iDesc.neighbor;
                        break block10;
                    }
                    if (iDesc.newSubGroup) break block11;
                    int i = iDesc.index;
                    if (i < 0) {
                        i = parent.getSubIntervalCount() - 1;
                    }
                    if (i >= 0 && i < parent.getSubIntervalCount() && !(neighbor = parent.getSubInterval(i)).isEmptySpace()) {
                        neighbors[1] = neighbor;
                        --i;
                    }
                    if (i > 0 && !(neighbor = parent.getSubInterval(i - 1)).isEmptySpace()) {
                        neighbors[0] = neighbor;
                    }
                    if (neighbors[1] != null || i + 1 >= parent.getSubIntervalCount() || (neighbor = parent.getSubInterval(i + 1)).isEmptySpace()) break block10;
                    neighbors[1] = neighbor;
                    break block10;
                }
                for (int i = 0; i < parent.getSubIntervalCount(); ++i) {
                    LayoutRegion subSpace;
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li.isEmptySpace() || !LayoutRegion.overlap(space, subSpace = li.getCurrentSpace(), dimension ^ 1, 0)) continue;
                    if (subSpace.positions[dimension][1] <= space.positions[dimension][0]) {
                        neighbors[0] = li;
                        continue;
                    }
                    if (subSpace.positions[dimension][0] < space.positions[dimension][1]) continue;
                    neighbors[1] = li;
                    break;
                }
            }
            if (neighbors[0] != null && (pos = neighbors[0].getCurrentSpace().positions[dimension][1]) != Integer.MIN_VALUE && pos > minPos) {
                minPos = pos;
            }
            if (neighbors[1] == null || (pos = neighbors[1].getCurrentSpace().positions[dimension][0]) == Integer.MIN_VALUE || pos >= maxPos) continue;
            maxPos = pos;
        }
        if (maxPos == Integer.MAX_VALUE) {
            maxPos = Integer.MIN_VALUE;
        }
        if (minPos == Integer.MIN_VALUE) {
            minPos = Integer.MIN_VALUE;
        }
        return new int[]{minPos, maxPos};
    }

    private int mergeSequentialInclusions(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        boolean nextTo;
        LayoutInterval commonGroup;
        boolean orig1;
        if (iDesc2 == null || !this.canCombine(iDesc1, iDesc2)) {
            return 1;
        }
        assert (!(iDesc1.alignment != 0 && iDesc1.alignment != 1 || iDesc2.alignment != 0 && iDesc2.alignment != 1 || iDesc1.alignment != (iDesc2.alignment ^ 1)));
        boolean bl = orig1 = this.originalPosition != null && iDesc1 == this.originalPosition.desc1;
        if (iDesc1.parent == iDesc2.parent) {
            if (orig1) {
                iDesc1.newSubGroup = iDesc2.newSubGroup;
                iDesc1.neighbor = iDesc2.neighbor;
            }
            return 3;
        }
        if (iDesc1.parent.isParentOf(iDesc2.parent)) {
            commonGroup = iDesc1.parent;
            nextTo = iDesc1.neighbor != null || iDesc2.snappedNextTo != null || iDesc2.parent.isSequential();
        } else if (iDesc2.parent.isParentOf(iDesc1.parent)) {
            if (this.dragger.isResizing(this.dimension) && this.releaseFromSubGroup(iDesc2, iDesc1)) {
                return 2;
            }
            commonGroup = iDesc2.parent;
            boolean bl2 = nextTo = iDesc2.neighbor != null || iDesc1.snappedNextTo != null || iDesc1.parent.isSequential();
            if (orig1 && iDesc1.neighbor != null && !LayoutUtils.contentOverlap(this.addingSpace, iDesc1.neighbor, this.dimension ^ 1)) {
                iDesc1.neighbor = null;
            }
        } else {
            commonGroup = LayoutInterval.getFirstParent(iDesc1.parent, 102);
            nextTo = false;
        }
        if (commonGroup.isSequential() || nextTo) {
            if (iDesc1.alignment == 1) {
                IncludeDesc temp = iDesc1;
                iDesc1 = iDesc2;
                iDesc2 = temp;
            }
            this.mergeInclusionsInCommonSequence(iDesc1, iDesc2, commonGroup);
        } else {
            assert (iDesc1.parent.isParallel() && iDesc2.parent.isParallel() && (commonGroup == iDesc1.parent || commonGroup == iDesc2.parent) && iDesc1.neighbor == null && iDesc2.neighbor == null);
            if (iDesc1.snappedParallel != null && iDesc2.snappedParallel != null && commonGroup.isParentOf(iDesc1.snappedParallel) && commonGroup.isParentOf(iDesc2.snappedParallel)) {
                LayoutInterval parParent = iDesc1.snappedParallel;
                if (!(parParent.isParentOf(iDesc2.snappedParallel) || (parParent = LayoutInterval.getFirstParent(iDesc1.snappedParallel, 103)).isParentOf(iDesc2.snappedParallel) || (parParent = iDesc2.snappedParallel).isParentOf(iDesc1.snappedParallel) || (parParent = LayoutInterval.getFirstParent(iDesc2.snappedParallel, 103)).isParentOf(iDesc1.snappedParallel))) {
                    parParent = null;
                }
                if (parParent != null && commonGroup.isParentOf(parParent) && this.canAlignWith(iDesc1.snappedParallel, parParent, iDesc1.alignment) && this.canAlignWith(iDesc2.snappedParallel, parParent, iDesc2.alignment)) {
                    iDesc1.parent = parParent;
                    iDesc2.parent = parParent;
                    return 3;
                }
            }
            if (iDesc2.snappedNextTo == null && iDesc2.snappedParallel == null || iDesc2.snappedParallel != null && this.canAlignWith(iDesc2.snappedParallel, iDesc1.parent, iDesc2.alignment)) {
                iDesc2.parent = iDesc1.parent;
                return 3;
            }
            if (iDesc2.parent == commonGroup) {
                IncludeDesc temp = iDesc1;
                iDesc1 = iDesc2;
                iDesc2 = temp;
            }
            assert (iDesc2.snappedNextTo == null);
            if (iDesc2.snappedParallel == iDesc2.parent) {
                iDesc2.parent = LayoutInterval.getFirstParent(iDesc2.parent, 103);
                if (iDesc2.parent == iDesc1.parent) {
                    return 3;
                }
            }
            if (iDesc2.snappedParallel == null || this.canAlignWith(iDesc2.snappedParallel, iDesc1.parent, iDesc2.alignment)) {
                iDesc2.parent = iDesc1.parent;
                return 3;
            }
            if (LayoutInterval.isAlignedAtBorder(iDesc2.parent, iDesc1.parent, iDesc1.alignment)) {
                iDesc1.parent = iDesc2.parent;
                return 3;
            }
            LayoutInterval seq = iDesc2.parent.getParent();
            if (seq.isSequential() && seq.getParent() == iDesc1.parent) {
                LayoutInterval gap;
                int index = seq.indexOf(iDesc2.parent) + (iDesc1.alignment == 0 ? -1 : 1);
                LayoutInterval layoutInterval = gap = index == 0 || index == seq.getSubIntervalCount() - 1 ? seq.getSubInterval(index) : null;
                if (gap != null && LayoutInterval.isFixedDefaultPadding(gap) && iDesc1.snappedNextTo == iDesc1.parent && LayoutInterval.wantResize(seq)) {
                    iDesc1.parent = iDesc2.parent;
                    iDesc1.snappedNextTo = null;
                    iDesc1.snappedParallel = iDesc2.parent;
                    return 3;
                }
                if (gap != null && gap.isEmptySpace() && iDesc1.snappedParallel == iDesc1.parent) {
                    int gapSize = LayoutInterval.getCurrentSize(gap, this.dimension);
                    this.copyGapInsideGroup(gap, gapSize, iDesc2.parent, iDesc1.alignment);
                    this.layoutModel.removeInterval(gap);
                    iDesc1.parent = iDesc2.parent;
                    return 3;
                }
            }
            iDesc2.parent = iDesc1.parent;
        }
        return 3;
    }

    private boolean releaseFromSubGroup(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        if (iDesc2.parent.isParentOf(iDesc1.parent)) {
            IncludeDesc temp = iDesc1;
            iDesc1 = iDesc2;
            iDesc2 = temp;
        } else if (!iDesc1.parent.isParentOf(iDesc2.parent)) {
            return false;
        }
        LayoutInterval outP = iDesc1.parent;
        LayoutInterval subP = iDesc2.parent;
        LayoutInterval outSnap = iDesc1.snappedParallel;
        LayoutInterval subSnap = iDesc2.snappedParallel;
        if (!(outSnap != null && (subP == outSnap || subP.isParentOf(outSnap)) || subSnap != null && this.canAlignWith(subSnap, outP, iDesc2.alignment))) {
            boolean tiedInSubParent;
            if (outP.isSequential()) {
                LayoutInterval parentAsNeighbor = outP.getSubInterval(LayoutInterval.getIndexInParent(subP, outP));
                tiedInSubParent = LayoutUtils.contentOverlap(this.addingSpace, parentAsNeighbor, this.dimension ^ 1);
            } else {
                tiedInSubParent = false;
            }
            if (!tiedInSubParent) {
                boolean significantSubEdge = false;
                LayoutInterval p = subP;
                do {
                    if (!p.isParallel() || !LayoutUtils.anythingAtGroupEdge(p, null, this.dimension, iDesc1.alignment)) continue;
                    significantSubEdge = true;
                    break;
                } while ((p = p.getParent()) != outP);
                if (significantSubEdge) {
                    return true;
                }
            }
        }
        return false;
    }

    private void mergeInclusionsInCommonSequence(IncludeDesc iDesc1, IncludeDesc iDesc2, LayoutInterval commonGroup) {
        boolean more;
        do {
            boolean validSection;
            more = false;
            int startIndex = 0;
            LayoutInterval ext1 = null;
            int depth1 = 0;
            boolean startGap = false;
            int endIndex = 0;
            LayoutInterval ext2 = null;
            int depth2 = 0;
            boolean endGap = false;
            boolean goingParallel = false;
            if (commonGroup.isSequential()) {
                if (commonGroup.isParentOf(iDesc1.parent)) {
                    int d;
                    startIndex = LayoutInterval.getIndexInParent(iDesc1.parent, commonGroup);
                    depth1 = 1;
                    ext1 = LayoutFeeder.intervalToExtractIntoCommonSequence(iDesc1, commonGroup);
                    if (ext1 != null && (d = LayoutInterval.getDepthInParent(iDesc1.parent, ext1)) > 0) {
                        depth1 += d;
                    }
                    if (this.dragger.isResizing(this.dimension)) {
                        LayoutInterval inSequence;
                        LayoutInterval layoutInterval = inSequence = iDesc1.parent.isSequential() && !iDesc1.newSubGroup ? iDesc1.parent : iDesc1.neighbor;
                        if (inSequence != null && LayoutUtils.contentOverlap(this.addingSpace, inSequence, this.dimension)) {
                            goingParallel = true;
                        }
                    }
                } else {
                    startIndex = iDesc1.index;
                    if (iDesc1.snappedParallel != null && commonGroup.isParentOf(iDesc1.snappedParallel) && iDesc1.newSubGroup && this.dragger.isResizing(this.dimension)) {
                        startIndex = LayoutInterval.getIndexInParent(iDesc1.snappedParallel, commonGroup);
                    } else {
                        if (startIndex == commonGroup.getSubIntervalCount()) {
                            --startIndex;
                        }
                        startGap = commonGroup.getSubInterval(startIndex).isEmptySpace();
                    }
                }
                if (commonGroup.isParentOf(iDesc2.parent)) {
                    int d;
                    endIndex = LayoutInterval.getIndexInParent(iDesc2.parent, commonGroup);
                    depth2 = 1;
                    ext2 = LayoutFeeder.intervalToExtractIntoCommonSequence(iDesc2, commonGroup);
                    if (ext2 != null && (d = LayoutInterval.getDepthInParent(iDesc2.parent, ext2)) > 0) {
                        depth2 += d;
                    }
                    if (this.dragger.isResizing(this.dimension)) {
                        LayoutInterval inSequence;
                        LayoutInterval layoutInterval = inSequence = iDesc2.parent.isSequential() && !iDesc2.newSubGroup ? iDesc2.parent : iDesc2.neighbor;
                        if (inSequence != null && LayoutUtils.contentOverlap(this.addingSpace, inSequence, this.dimension)) {
                            goingParallel = true;
                        }
                    }
                } else {
                    endIndex = iDesc2.index;
                    if (iDesc2.snappedParallel != null && commonGroup.isParentOf(iDesc2.snappedParallel)) {
                        if (iDesc2.newSubGroup && this.dragger.isResizing(this.dimension)) {
                            endIndex = LayoutInterval.getIndexInParent(iDesc2.snappedParallel, commonGroup);
                        }
                        if (endIndex == commonGroup.getSubIntervalCount()) {
                            --endIndex;
                        }
                    } else {
                        endGap = commonGroup.getSubInterval(--endIndex).isEmptySpace();
                    }
                }
            }
            boolean bl = validSection = endIndex > startIndex + 1 || endIndex == startIndex + 1 && (!startGap || iDesc1.snappedParallel != null) && (!endGap || iDesc2.snappedParallel != null);
            if (validSection && (ext1 != null || ext2 != null)) {
                LayoutInterval parent;
                LayoutInterval parGroup;
                LayoutInterval li;
                int idx2;
                LayoutInterval parent2;
                int idx1;
                LayoutInterval parent1;
                LayoutInterval extSeq = new LayoutInterval(102);
                LayoutInterval startInt = commonGroup.getSubInterval(startIndex);
                LayoutInterval endInt = commonGroup.getSubInterval(endIndex);
                int posL = LayoutUtils.getVisualPosition(startInt, this.dimension, 0);
                int posT = LayoutUtils.getVisualPosition(endInt, this.dimension, 1);
                LayoutInterval parConnectingGap = null;
                LayoutInterval extConnectingGap = null;
                if (ext1 != null) {
                    parent1 = ext1.getParent();
                    idx1 = parent1.remove(ext1);
                } else {
                    parent1 = null;
                    idx1 = -1;
                }
                if (ext2 != null) {
                    parent2 = ext2.getParent();
                    idx2 = parent2.remove(ext2);
                } else {
                    parent2 = null;
                    idx2 = -1;
                }
                if (ext1 != null && !LayoutInterval.isClosedGroup(startInt, 1) && LayoutUtils.contentOverlap(ext1, commonGroup, startIndex + 1, endIndex, this.dimension ^ 1) && !LayoutUtils.contentOverlap(startInt, commonGroup, startIndex + 1, endIndex, this.dimension ^ 1)) {
                    while (startIndex < endIndex) {
                        this.layoutModel.addInterval(this.layoutModel.removeInterval(commonGroup, startIndex + 1), extSeq, -1);
                        --endIndex;
                    }
                    if (extSeq.getSubIntervalCount() > 0) {
                        li = extSeq.getSubInterval(extSeq.getSubIntervalCount() - 1);
                        if (li.isEmptySpace()) {
                            parConnectingGap = LayoutInterval.cloneInterval(li, null);
                        }
                        if ((li = extSeq.getSubInterval(0)).isEmptySpace()) {
                            extConnectingGap = li;
                        }
                    }
                    if (ext2 != null) {
                        parent2.add(ext2, idx2);
                        ext2 = null;
                        if (depth2 == 1) {
                            depth2 = 2;
                        }
                    }
                } else if (ext2 != null && !LayoutInterval.isClosedGroup(endInt, 0) && LayoutUtils.contentOverlap(ext2, commonGroup, startIndex, endIndex - 1, this.dimension ^ 1) && !LayoutUtils.contentOverlap(endInt, commonGroup, startIndex, endIndex - 1, this.dimension ^ 1)) {
                    while (startIndex < endIndex) {
                        this.layoutModel.addInterval(this.layoutModel.removeInterval(commonGroup, startIndex), extSeq, -1);
                        --endIndex;
                    }
                    if (extSeq.getSubIntervalCount() > 0) {
                        li = extSeq.getSubInterval(0);
                        if (li.isEmptySpace()) {
                            parConnectingGap = LayoutInterval.cloneInterval(li, null);
                        }
                        if ((li = extSeq.getSubInterval(extSeq.getSubIntervalCount() - 1)).isEmptySpace()) {
                            extConnectingGap = li;
                        }
                    }
                    if (ext1 != null) {
                        parent1.add(ext1, idx1);
                        ext1 = null;
                        if (depth1 == 1) {
                            depth1 = 2;
                        }
                    }
                }
                if (ext1 != null) {
                    parent1.add(ext1, idx1);
                }
                if (ext2 != null) {
                    parent2.add(ext2, idx2);
                }
                if (startIndex == 0 && endIndex == commonGroup.getSubIntervalCount() - 1) {
                    parGroup = commonGroup.getParent();
                } else {
                    parGroup = new LayoutInterval(103);
                    LayoutInterval parSeq = new LayoutInterval(102);
                    parGroup.add(parSeq, 0);
                    parGroup.getCurrentSpace().set(this.dimension, posL, posT);
                    while (startIndex <= endIndex) {
                        this.layoutModel.addInterval(this.layoutModel.removeInterval(commonGroup, startIndex), parSeq, -1);
                        --endIndex;
                    }
                    this.layoutModel.addInterval(parGroup, commonGroup, startIndex);
                }
                this.layoutModel.addInterval(extSeq, parGroup, -1);
                if (ext1 != null) {
                    parent = ext1.getParent();
                    this.layoutModel.removeInterval(ext1);
                    if (LayoutInterval.hasAnyResizingNeighbor(parent, 1) && LayoutInterval.getCount(parent, 1, true) > 0 && !LayoutInterval.wantResize(parent)) {
                        this.operations.maintainSize(parent, LayoutInterval.wantResize(ext2), this.dimension, false);
                    }
                    if (parent.getSubIntervalCount() == 1) {
                        LayoutInterval last = this.layoutModel.removeInterval(parent, 0);
                        this.operations.addContent(last, parent.getParent(), this.layoutModel.removeInterval(parent), this.dimension);
                        if (parent == startInt) {
                            startInt = last;
                        }
                    }
                    int beforeCount = extSeq.getSubIntervalCount();
                    this.operations.addContent(ext1, extSeq, 0, this.dimension);
                    if (depth1 == 1 && !iDesc1.parent.isSequential()) {
                        iDesc1.index = extSeq.getSubIntervalCount() - beforeCount;
                    }
                    if (depth2 <= 1) {
                        iDesc2.index = ext2 == null || !iDesc2.parent.isSequential() ? extSeq.getSubIntervalCount() : (iDesc2.index += extSeq.getSubIntervalCount());
                    }
                    if (ext2 != null) {
                        LayoutInterval gap = new LayoutInterval(101);
                        int size = LayoutRegion.distance(ext1.getCurrentSpace(), ext2.getCurrentSpace(), this.dimension, 0, 1);
                        gap.setSize(size);
                        this.layoutModel.addInterval(gap, extSeq, -1);
                    } else {
                        if (parConnectingGap != null) {
                            parent = startInt.getParent();
                            if (!parent.isSequential()) {
                                LayoutInterval seq = new LayoutInterval(102);
                                this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(startInt));
                                this.layoutModel.addInterval(startInt, seq, 0);
                                parent = seq;
                            }
                            assert (parent.indexOf(startInt) == 0);
                            this.layoutModel.addInterval(parConnectingGap, parent, 1);
                        }
                        if (extConnectingGap != null) {
                            this.operations.accommodateGap(extConnectingGap, this.dimension);
                            if (LayoutInterval.wantResize(startInt) && !LayoutInterval.wantResize(extSeq)) {
                                this.operations.setIntervalResizing(extConnectingGap, true);
                            }
                        }
                    }
                } else {
                    iDesc1.index = 0;
                    if (depth2 <= 1 && !iDesc2.parent.isSequential()) {
                        iDesc2.index = extSeq.getSubIntervalCount();
                    }
                }
                if (ext2 != null) {
                    parent = ext2.getParent();
                    if (ext2.getAlignment() == 1) {
                        extSeq.setAlignment(1);
                    }
                    this.layoutModel.removeInterval(ext2);
                    if (LayoutInterval.hasAnyResizingNeighbor(parent, 0) && LayoutInterval.getCount(parent, 0, true) > 0 && !LayoutInterval.wantResize(parent)) {
                        this.operations.maintainSize(parent, LayoutInterval.wantResize(ext2), this.dimension, false);
                    }
                    if (parent.getSubIntervalCount() == 1) {
                        LayoutInterval last = this.layoutModel.removeInterval(parent, 0);
                        this.operations.addContent(last, parent.getParent(), this.layoutModel.removeInterval(parent), this.dimension);
                        if (parent == endInt) {
                            endInt = last;
                        }
                    }
                    this.operations.addContent(ext2, extSeq, -1, this.dimension);
                    if (ext1 == null) {
                        if (parConnectingGap != null) {
                            parent = endInt.getParent();
                            if (!parent.isSequential()) {
                                LayoutInterval seq = new LayoutInterval(102);
                                this.layoutModel.addInterval(seq, parent, this.layoutModel.removeInterval(endInt));
                                this.layoutModel.addInterval(endInt, seq, 0);
                                parent = seq;
                            }
                            assert (parent.indexOf(endInt) == 0);
                            this.layoutModel.addInterval(parConnectingGap, parent, 0);
                        }
                        if (extConnectingGap != null) {
                            this.operations.accommodateGap(extConnectingGap, this.dimension);
                            if (LayoutInterval.wantResize(endInt) && !LayoutInterval.wantResize(extSeq)) {
                                this.operations.setIntervalResizing(extConnectingGap, true);
                            }
                        }
                    }
                }
                if (depth1 <= 1) {
                    boolean newSubGroupBeforeMerge = iDesc1.parent == commonGroup && iDesc1.newSubGroup;
                    iDesc1.parent = extSeq;
                    if (iDesc2.newSubGroup) {
                        iDesc1.newSubGroup = true;
                    } else if (newSubGroupBeforeMerge) {
                        iDesc1.newSubGroup = false;
                    }
                    iDesc1.neighbor = null;
                }
                if (depth2 <= 1) {
                    iDesc2.parent = extSeq;
                    if (iDesc1.newSubGroup) {
                        iDesc2.newSubGroup = true;
                    }
                    iDesc2.neighbor = null;
                }
                commonGroup = extSeq;
                more = depth1 > 1 || depth2 > 1;
                this.optimizeStructure = true;
                continue;
            }
            if (ext1 == null && ext2 == null && validSection) {
                if (commonGroup.isParentOf(iDesc1.parent)) {
                    iDesc1.index = startIndex;
                }
                if (commonGroup.isParentOf(iDesc2.parent)) {
                    iDesc2.index = endIndex;
                }
                iDesc1.parent = iDesc2.parent = commonGroup;
                iDesc2.newSubGroup = true;
                iDesc1.newSubGroup = true;
                continue;
            }
            boolean p1 = iDesc1.parent.isParentOf(iDesc2.parent);
            boolean p2 = iDesc2.parent.isParentOf(iDesc1.parent);
            if (p2 && !goingParallel || p1 && goingParallel) {
                iDesc2.parent = iDesc1.parent;
                iDesc2.index = iDesc1.index;
                iDesc2.newSubGroup = iDesc1.newSubGroup;
                iDesc2.neighbor = iDesc1.neighbor;
                if (!endGap) continue;
                iDesc2.fixedPosition = false;
                continue;
            }
            if ((!p1 || goingParallel) && (!p2 || !goingParallel)) continue;
            iDesc1.parent = iDesc2.parent;
            iDesc1.index = iDesc2.index;
            iDesc1.newSubGroup = iDesc2.newSubGroup;
            iDesc1.neighbor = iDesc2.neighbor;
            if (!startGap) continue;
            iDesc1.fixedPosition = false;
        } while (more);
        if (iDesc1.snappedParallel != null && iDesc1.snappedParallel.isParallel() && iDesc1.snappedParallel.getSubIntervalCount() == 0) {
            iDesc1.snappedParallel = null;
        }
        if (iDesc2.snappedParallel != null && iDesc2.snappedParallel.isParallel() && iDesc2.snappedParallel.getSubIntervalCount() == 0) {
            iDesc2.snappedParallel = null;
        }
    }

    private static LayoutInterval intervalToExtractIntoCommonSequence(IncludeDesc iDesc, LayoutInterval commonSeq) {
        boolean aligned;
        assert (commonSeq.isSequential() && commonSeq.isParentOf(iDesc.parent));
        LayoutInterval ext = null;
        LayoutInterval interval = iDesc.parent.isParallel() && iDesc.neighbor != null ? iDesc.neighbor : iDesc.parent;
        boolean bl = aligned = iDesc.parent.isParallel() && iDesc.neighbor == null;
        while (interval.getParent() != commonSeq) {
            if (aligned && !LayoutInterval.isAlignedAtBorder(interval, iDesc.alignment)) {
                aligned = false;
            }
            ext = interval;
            interval = interval.getParent();
        }
        if (aligned) {
            ext = null;
        }
        return ext;
    }

    private void copyGapInsideGroup(LayoutInterval gap, int gapSize, LayoutInterval group, int alignment) {
        assert (gap.isEmptySpace() && (alignment == 0 || alignment == 1));
        if (alignment == 0) {
            gapSize = -gapSize;
        }
        int[] nArray = group.getCurrentSpace().positions[this.dimension];
        int n = alignment;
        nArray[n] = nArray[n] + gapSize;
        ArrayList<LayoutInterval> originalGroup = new ArrayList<LayoutInterval>(group.getSubIntervalCount());
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            originalGroup.add(it.next());
        }
        for (LayoutInterval sub : originalGroup) {
            LayoutInterval gapClone = LayoutInterval.cloneInterval(gap, null);
            if (sub.isSequential()) {
                int[] nArray2 = sub.getCurrentSpace().positions[this.dimension];
                int n2 = alignment;
                nArray2[n2] = nArray2[n2] + gapSize;
                int index = alignment == 0 ? 0 : sub.getSubIntervalCount();
                this.operations.insertGapIntoSequence(gapClone, sub, index, this.dimension);
                continue;
            }
            LayoutInterval seq = new LayoutInterval(102);
            seq.getCurrentSpace().set(this.dimension, sub.getCurrentSpace());
            int[] nArray3 = seq.getCurrentSpace().positions[this.dimension];
            int n3 = alignment;
            nArray3[n3] = nArray3[n3] + gapSize;
            seq.setAlignment(sub.getRawAlignment());
            this.layoutModel.addInterval(seq, group, this.layoutModel.removeInterval(sub));
            this.layoutModel.setIntervalAlignment(sub, -1);
            this.layoutModel.addInterval(sub, seq, 0);
            this.layoutModel.addInterval(gapClone, seq, alignment == 0 ? 0 : 1);
        }
    }

    private boolean shouldEnterGroup(LayoutInterval group) {
        assert (group.isParallel());
        if (this.positionToEnterGroup(group)) {
            if (this.aSnappedParallel != null || this.aSnappedNextTo != null || this.aEdge == -1) {
                return true;
            }
            if (!this.stickingOutOfGroup(group, this.aEdge ^ 1) || this.groupOpenToEnter(group, this.aEdge ^ 1)) {
                return true;
            }
        }
        return false;
    }

    private boolean positionToEnterGroup(LayoutInterval group) {
        LayoutRegion groupSpace;
        if (group.getGroupAlignment() == 3 && this.aSnappedParallel == null) {
            return false;
        }
        int alignment = this.aEdge != -1 ? this.aEdge : 2;
        if (LayoutRegion.pointInside(this.addingSpace, alignment, groupSpace = group.getCurrentSpace(), this.dimension)) {
            if (this.aEdge == -1) {
                if (!LayoutRegion.pointInside(this.addingSpace, 0, groupSpace, this.dimension) || !LayoutRegion.pointInside(this.addingSpace, 1, groupSpace, this.dimension)) {
                    int[] apos = this.addingSpace.positions[this.dimension];
                    int[] gpos = groupSpace.positions[this.dimension];
                    if (LayoutFeeder.getAddDirection(this.addingSpace, groupSpace, this.dimension, 2) == 0) {
                        if (LayoutInterval.isClosedGroup(group, 0)) {
                            int dCL = apos[2] - gpos[0];
                            int dCC = gpos[2] - apos[2];
                            if (dCL < 10 && dCL < dCC) {
                                return false;
                            }
                        }
                    } else if (LayoutInterval.isClosedGroup(group, 1)) {
                        int dCT = gpos[1] - apos[2];
                        int dCC = apos[2] - gpos[2];
                        if (dCT < 10 && dCT < dCC) {
                            return false;
                        }
                    }
                }
                return true;
            }
            if (this.aSnappedParallel == null || group == this.aSnappedParallel || group.isParentOf(this.aSnappedParallel) || LayoutUtils.contentOverlap(this.addingSpace, group, this.dimension ^ 1)) {
                return true;
            }
            if (alignment == 0 || alignment == 1) {
                LayoutInterval interval = this.aSnappedParallel;
                LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
                while (parent != null && LayoutInterval.isAlignedAtBorder(interval, parent, alignment)) {
                    if (parent.isParentOf(group) && LayoutInterval.isAlignedAtBorder(group, parent, alignment)) {
                        return true;
                    }
                    interval = parent;
                    parent = LayoutInterval.getFirstParent(interval, 103);
                }
            }
        }
        return false;
    }

    private boolean groupOpenToEnter(LayoutInterval group, int alignment) {
        if (group.getGroupAlignment() == 3) {
            return false;
        }
        boolean placedOver = this.addingOverGroupEdge(group, alignment);
        if (!LayoutInterval.isClosedGroup(group, alignment) || placedOver && this.hasOpenRoomForAdding(group, alignment) && !LayoutFeeder.isSignificantGroupEdge(group, alignment, true)) {
            boolean nextToEverything = true;
            Iterator<LayoutInterval> it = group.getSubIntervals();
            while (it.hasNext()) {
                if (this.orthogonalOverlap(it.next())) continue;
                nextToEverything = false;
                break;
            }
            if (!nextToEverything) {
                LayoutInterval significantNeighbor;
                if (placedOver) {
                    return true;
                }
                LayoutDragger.PositionDef primaryPos = this.newPositions[this.dimension];
                if (!(primaryPos != null && primaryPos.snapped && primaryPos.alignment != this.aEdge && alignment == (primaryPos.alignment ^ 1) || (significantNeighbor = LayoutInterval.getDirectNeighbor(group, alignment, true)) != null && LayoutRegion.overlap(this.addingSpace, significantNeighbor.getCurrentSpace(), this.dimension, 0))) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canAlignWith(LayoutInterval interval, LayoutInterval group, int alignment) {
        LayoutInterval neighbor;
        if (group.isSequential()) {
            group = group.getParent();
        }
        if (interval == group) {
            return true;
        }
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            parent = interval;
        } else if (parent.isSequential()) {
            parent = parent.getParent();
        }
        while (parent != null && parent != group && !parent.isParentOf(group)) {
            if (LayoutFeeder.canSubstAlignWithParent(interval, this.dimension, alignment, this.dragger.isResizing(this.dimension))) {
                interval = parent;
                parent = LayoutInterval.getFirstParent(interval, 103);
                continue;
            }
            parent = null;
        }
        if (parent == null) {
            return false;
        }
        if (parent == group) {
            return true;
        }
        if (LayoutInterval.isAlignedAtBorder(group, parent, alignment)) {
            return true;
        }
        return LayoutInterval.isAlignedAtBorder(interval, parent, alignment) && ((neighbor = LayoutInterval.getNeighbor(group, alignment, false, true, false)) == null || !parent.isParentOf(neighbor));
    }

    private static boolean canSubstAlignWithParent(LayoutInterval interval, int dimension, int alignment, boolean placedAtBorderEnough) {
        LayoutInterval parent = LayoutInterval.getFirstParent(interval, 103);
        boolean aligned = LayoutInterval.isAlignedAtBorder(interval, parent, alignment);
        if (!aligned && LayoutInterval.getDirectNeighbor(interval, alignment, false) == null && LayoutInterval.isPlacedAtBorder(interval, parent, dimension, alignment)) {
            boolean bl = aligned = placedAtBorderEnough || LayoutInterval.getDirectNeighbor(parent, alignment, true) != null || LayoutInterval.isClosedGroup(parent, alignment);
            if (!aligned) {
                boolean allTouching = true;
                Iterator<LayoutInterval> it = parent.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = it.next();
                    if (li.getAlignment() == alignment || LayoutInterval.wantResize(li)) {
                        aligned = true;
                        break;
                    }
                    if (!allTouching || LayoutInterval.isPlacedAtBorder(li, dimension, alignment)) continue;
                    allTouching = false;
                }
                if (allTouching) {
                    aligned = true;
                }
            }
        }
        return aligned;
    }

    private boolean canCombine(IncludeDesc iDesc1, IncludeDesc iDesc2) {
        if (iDesc1.parent == iDesc2.parent) {
            return true;
        }
        if (iDesc1.parent.isParentOf(iDesc2.parent)) {
            return this.isBorderInclusion(iDesc2);
        }
        if (iDesc2.parent.isParentOf(iDesc1.parent)) {
            return this.isBorderInclusion(iDesc1);
        }
        LayoutInterval parParent1 = iDesc1.parent.isParallel() ? iDesc1.parent : iDesc1.parent.getParent();
        LayoutInterval parParent2 = iDesc2.parent.isParallel() ? iDesc2.parent : iDesc2.parent.getParent();
        return parParent1.getParent() == parParent2.getParent() && this.isBorderInclusion(iDesc1) && this.isBorderInclusion(iDesc2) && LayoutInterval.getDirectNeighbor(parParent1, iDesc1.alignment ^ 1, true) == parParent2;
    }

    private boolean isBorderInclusion(IncludeDesc iDesc) {
        if (iDesc.alignment != 0 && iDesc.alignment != 1) {
            return false;
        }
        if (iDesc.parent.isSequential()) {
            int endIndex;
            int startIndex;
            int n = startIndex = iDesc.alignment == 0 ? iDesc.index : 0;
            if (iDesc.alignment == 0) {
                endIndex = iDesc.parent.getSubIntervalCount() - 1;
            } else {
                endIndex = iDesc.index - 1;
                if (endIndex >= iDesc.parent.getSubIntervalCount()) {
                    endIndex = iDesc.parent.getSubIntervalCount() - 1;
                }
            }
            return startIndex > endIndex || !LayoutUtils.contentOverlap(this.addingSpace, iDesc.parent, startIndex, endIndex, this.dimension ^ 1);
        }
        if (iDesc.snappedParallel != null) {
            return iDesc.snappedParallel == iDesc.parent || !iDesc.parent.isParentOf(iDesc.snappedParallel) || LayoutInterval.isPlacedAtBorder(iDesc.snappedParallel, iDesc.parent, this.dimension, iDesc.alignment);
        }
        return iDesc.neighbor == null || iDesc.alignment == 0 && iDesc.index >= 1 || iDesc.alignment == 1 && iDesc.index == 0;
    }

    private static int getAddDirection(LayoutRegion adding, LayoutRegion existing, int dimension, int alignment) {
        return LayoutRegion.distance(adding, existing, dimension, alignment, 2) > 0 ? 0 : 1;
    }

    private static class OriginalPosition {
        IncludeDesc desc1;
        IncludeDesc desc2;
        LayoutRegion closedSpace;
        boolean lPosFixed;
        boolean tPosFixed;
        boolean suppressedResizing;
        boolean wholeResizing;

        private OriginalPosition() {
        }
    }

    private static class IncludeDesc {
        LayoutInterval parent;
        int index = -1;
        boolean newSubGroup;
        LayoutInterval neighbor;
        LayoutInterval snappedParallel;
        LayoutInterval snappedNextTo;
        LayoutConstants.PaddingType paddingType;
        int alignment;
        boolean fixedPosition;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;

        private IncludeDesc() {
        }

        boolean snapped() {
            return this.snappedNextTo != null || this.snappedParallel != null;
        }
    }
}

