/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Color;
import java.util.prefs.Preferences;
import org.netbeans.modules.form.FormUtils;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class FormLoaderSettings
implements HelpCtx.Provider {
    private static final FormLoaderSettings INSTANCE = new FormLoaderSettings();
    public static final String PROP_USE_INDENT_ENGINE = "useIndentEngine";
    public static final String PROP_LISTENER_GENERATION_STYLE = "listenerGenerationStyle";
    public static final String PROP_SELECTION_BORDER_SIZE = "selectionBorderSize";
    public static final String PROP_SELECTION_BORDER_COLOR = "selectionBorderColor";
    public static final String PROP_CONNECTION_BORDER_COLOR = "connectionBorderColor";
    public static final String PROP_DRAG_BORDER_COLOR = "dragBorderColor";
    public static final String PROP_GUIDING_LINE_COLOR = "guidingLineColor";
    public static final String PROP_FORMDESIGNER_BACKGROUND_COLOR = "formDesignerBackgroundColor";
    public static final String PROP_FORMDESIGNER_BORDER_COLOR = "formDesignerBorderColor";
    public static final String PROP_GRID_X = "gridX";
    public static final String PROP_GRID_Y = "gridY";
    public static final String PROP_APPLY_GRID_TO_POSITION = "applyGridToPosition";
    public static final String PROP_APPLY_GRID_TO_SIZE = "applyGridToSize";
    public static final String PROP_VARIABLES_MODIFIER = "variablesModifier";
    public static final String PROP_VARIABLES_LOCAL = "variablesLocal";
    public static final String PROP_AUTO_SET_COMPONENT_NAME = "autoSetComponentName";
    static final int AUTO_NAMING_DEFAULT = 0;
    static final int AUTO_NAMING_ON = 1;
    static final int AUTO_NAMING_OFF = 2;
    public static final String PROP_GENERATE_MNEMONICS = "generateMnemonicsCode";
    public static final String PROP_SHOW_MNEMONICS_DIALOG = "showMnemonicsDialog";
    public static final String PROP_DISPLAY_WRITABLE_ONLY = "displayWritableOnly";
    public static final String PROP_EDITOR_SEARCH_PATH = "editorSearchPath";
    public static final String PROP_PALETTE_IN_TOOLBAR = "toolBarPalette";
    public static final String PROP_FOLD_GENERATED_CODE = "foldGeneratedCode";
    public static final String PROP_ASSISTANT_SHOWN = "assistantShown";
    public static final String PROP_DESIGNER_LAF = "designerLAF";
    public static final String PROP_LAYOUT_CODE_TARGET = "layoutCodeTarget";
    public static final String PROP_GENERATE_FQN = "generateFQN";
    public static final String PROP_PAD_EMPTY_CELLS = "padEmptyCells";
    public static final String PROP_GAP_WIDTH = "gapWidth";
    public static final String PROP_GAP_HEIGHT = "gapHeight";
    public static final String PROP_AUTO_RESOURCING = "i18nAutoMode";
    static final int AUTO_RESOURCE_DEFAULT = 0;
    static final int AUTO_RESOURCE_ON = 1;
    static final int AUTO_RESOURCE_OFF = 2;
    private static String[] editorSearchPath = null;
    private static final int MIN_SELECTION_BORDER_SIZE = 1;
    private static final int MAX_SELECTION_BORDER_SIZE = 15;
    private static final int MIN_GRID_X = 2;
    private static final int MIN_GRID_Y = 2;
    private static final boolean USE_STORED_SEARCH_PATH = Boolean.getBoolean("nb.form.useStoredSearchPath");
    private static final String DEFAULT_EDITOR_SEARCH_PATH = "";

    public static Preferences getPreferences() {
        return NbPreferences.forModule(FormLoaderSettings.class);
    }

    public static FormLoaderSettings getInstance() {
        return INSTANCE;
    }

    public boolean getUseIndentEngine() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_USE_INDENT_ENGINE, false);
    }

    public void setUseIndentEngine(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_USE_INDENT_ENGINE, value);
    }

    public int getListenerGenerationStyle() {
        return FormLoaderSettings.getPreferences().getInt(PROP_LISTENER_GENERATION_STYLE, 0);
    }

    public void setListenerGenerationStyle(int style) {
        FormLoaderSettings.getPreferences().putInt(PROP_LISTENER_GENERATION_STYLE, style);
    }

    public int getSelectionBorderSize() {
        return FormLoaderSettings.getPreferences().getInt(PROP_SELECTION_BORDER_SIZE, 1);
    }

    public void setSelectionBorderSize(int value) {
        if (value < 1) {
            value = 1;
        } else if (value > 15) {
            value = 15;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_SELECTION_BORDER_SIZE, value);
    }

    public Color getSelectionBorderColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_SELECTION_BORDER_COLOR, new Color(255, 164, 0).getRGB());
        return new Color(rgb);
    }

    public void setSelectionBorderColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_SELECTION_BORDER_COLOR, value.getRGB());
    }

    public Color getConnectionBorderColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_CONNECTION_BORDER_COLOR, Color.red.getRGB());
        return new Color(rgb);
    }

    public void setConnectionBorderColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_CONNECTION_BORDER_COLOR, value.getRGB());
    }

    public Color getDragBorderColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_DRAG_BORDER_COLOR, Color.gray.getRGB());
        return new Color(rgb);
    }

    public void setDragBorderColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_DRAG_BORDER_COLOR, value.getRGB());
    }

    public Color getGuidingLineColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_GUIDING_LINE_COLOR, new Color(143, 171, 196).getRGB());
        return new Color(rgb);
    }

    public void setGuidingLineColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_GUIDING_LINE_COLOR, value.getRGB());
    }

    public int getGridX() {
        return FormLoaderSettings.getPreferences().getInt(PROP_GRID_X, 10);
    }

    public void setGridX(int value) {
        if (value < 2) {
            value = 2;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_GRID_X, value);
    }

    public int getGridY() {
        return FormLoaderSettings.getPreferences().getInt(PROP_GRID_Y, 10);
    }

    public void setGridY(int value) {
        if (value < 2) {
            value = 2;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_GRID_Y, value);
    }

    public boolean getApplyGridToPosition() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_APPLY_GRID_TO_POSITION, true);
    }

    public void setApplyGridToPosition(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_APPLY_GRID_TO_POSITION, value);
    }

    public boolean getApplyGridToSize() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_APPLY_GRID_TO_SIZE, true);
    }

    public void setApplyGridToSize(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_APPLY_GRID_TO_SIZE, value);
    }

    public boolean getVariablesLocal() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_VARIABLES_LOCAL, false);
    }

    public void setVariablesLocal(boolean value) {
        int varType;
        FormLoaderSettings.getPreferences().putBoolean(PROP_VARIABLES_LOCAL, value);
        int variablesModifier = this.getVariablesModifier();
        int n = varType = value ? 0x1000 | variablesModifier & 0x10 | 0x4000 : 0x2000 | variablesModifier;
        if (value) {
            this.setVariablesModifier(variablesModifier &= 0x10);
        }
    }

    public int getVariablesModifier() {
        return FormLoaderSettings.getPreferences().getInt(PROP_VARIABLES_MODIFIER, 2);
    }

    public void setVariablesModifier(int value) {
        FormLoaderSettings.getPreferences().putInt(PROP_VARIABLES_MODIFIER, value);
        if (this.getVariablesLocal()) {
            int varType = 0x1000 | value;
            if ((value & 0x10) == 0) {
                varType |= 0x4000;
            }
        } else {
            int varType = 0x2000 | value;
        }
    }

    public int getAutoSetComponentName() {
        return FormLoaderSettings.getPreferences().getInt(PROP_AUTO_SET_COMPONENT_NAME, 0);
    }

    public void setAutoSetComponentName(int value) {
        FormLoaderSettings.getPreferences().putInt(PROP_AUTO_SET_COMPONENT_NAME, value);
    }

    public boolean getGenerateMnemonicsCode() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_GENERATE_MNEMONICS, false);
    }

    public void setGenerateMnemonicsCode(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_GENERATE_MNEMONICS, value);
    }

    public boolean getDisplayWritableOnly() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_DISPLAY_WRITABLE_ONLY, true);
    }

    public void setDisplayWritableOnly(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_DISPLAY_WRITABLE_ONLY, value);
    }

    public String[] getEditorSearchPath() {
        if (editorSearchPath == null) {
            editorSearchPath = USE_STORED_SEARCH_PATH ? FormLoaderSettings.translatedEditorSearchPath(FormLoaderSettings.toArray(FormLoaderSettings.getPreferences().get(PROP_EDITOR_SEARCH_PATH, DEFAULT_EDITOR_SEARCH_PATH))) : FormLoaderSettings.toArray(DEFAULT_EDITOR_SEARCH_PATH);
        }
        return editorSearchPath;
    }

    public void setEditorSearchPath(String[] value) {
        editorSearchPath = value;
        if (USE_STORED_SEARCH_PATH) {
            FormLoaderSettings.getPreferences().put(PROP_EDITOR_SEARCH_PATH, FormLoaderSettings.fromArray(editorSearchPath));
        }
    }

    public boolean isPaletteInToolBar() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_PALETTE_IN_TOOLBAR, false);
    }

    public void setPaletteInToolBar(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_PALETTE_IN_TOOLBAR, value);
    }

    public Color getFormDesignerBackgroundColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_FORMDESIGNER_BACKGROUND_COLOR, Color.white.getRGB());
        return new Color(rgb);
    }

    public void setFormDesignerBackgroundColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_FORMDESIGNER_BACKGROUND_COLOR, value.getRGB());
    }

    public Color getFormDesignerBorderColor() {
        int rgb = FormLoaderSettings.getPreferences().getInt(PROP_FORMDESIGNER_BORDER_COLOR, new Color(224, 224, 255).getRGB());
        return new Color(rgb);
    }

    public void setFormDesignerBorderColor(Color value) {
        if (value == null) {
            return;
        }
        FormLoaderSettings.getPreferences().putInt(PROP_FORMDESIGNER_BORDER_COLOR, value.getRGB());
    }

    public boolean getFoldGeneratedCode() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_FOLD_GENERATED_CODE, true);
    }

    public void setFoldGeneratedCode(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_FOLD_GENERATED_CODE, value);
    }

    public boolean getAssistantShown() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_ASSISTANT_SHOWN, true);
    }

    public void setAssistantShown(boolean value) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_ASSISTANT_SHOWN, value);
    }

    public int getLayoutCodeTarget() {
        return FormLoaderSettings.getPreferences().getInt(PROP_LAYOUT_CODE_TARGET, 0);
    }

    public void setLayoutCodeTarget(int target) {
        FormLoaderSettings.getPreferences().putInt(PROP_LAYOUT_CODE_TARGET, target);
    }

    public int getI18nAutoMode() {
        return FormLoaderSettings.getPreferences().getInt(PROP_AUTO_RESOURCING, 0);
    }

    public void setI18nAutoMode(int mode) {
        FormLoaderSettings.getPreferences().putInt(PROP_AUTO_RESOURCING, mode);
    }

    public boolean getGenerateFQN() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_GENERATE_FQN, true);
    }

    public void setGenerateFQN(boolean generateFQN) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_GENERATE_FQN, generateFQN);
    }

    public boolean getPadEmptyCells() {
        return FormLoaderSettings.getPreferences().getBoolean(PROP_PAD_EMPTY_CELLS, true);
    }

    public void setPadEmptyCells(boolean padEmptyCells) {
        FormLoaderSettings.getPreferences().putBoolean(PROP_PAD_EMPTY_CELLS, padEmptyCells);
    }

    public int getGapWidth() {
        return FormLoaderSettings.getPreferences().getInt(PROP_GAP_WIDTH, -1);
    }

    public void setGapWidth(int gapWidth) {
        FormLoaderSettings.getPreferences().putInt(PROP_GAP_WIDTH, gapWidth);
    }

    public int getGapHeight() {
        return FormLoaderSettings.getPreferences().getInt(PROP_GAP_HEIGHT, -1);
    }

    public void setGapHeight(int gapHeight) {
        FormLoaderSettings.getPreferences().putInt(PROP_GAP_HEIGHT, gapHeight);
    }

    private static String[] toArray(String esp) {
        return esp.split(" , ");
    }

    private static String fromArray(String[] items) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < items.length; ++i) {
            sb.append(items[i]);
            if (i >= items.length - 1) continue;
            sb.append(" , ");
        }
        return sb.toString();
    }

    private static String[] translatedEditorSearchPath(String[] eSearchPath) {
        String[] retval = new String[eSearchPath.length];
        for (int i = 0; i < eSearchPath.length; ++i) {
            String path = eSearchPath[i];
            path = Utilities.translate((String)(path + ".BogusClass"));
            retval[i] = path = path.substring(0, path.length() - ".BogusClass".length());
        }
        return retval;
    }

    public String displayName() {
        return FormUtils.getBundleString("CTL_FormSettings");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("gui.configuring");
    }
}

