/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.eventhandler;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.ListCellRenderer;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.handlers.SwitchDisplayableEventHandlerCD;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorElementFactory;
import org.netbeans.modules.vmd.midp.propertyeditors.element.PropertyEditorEventHandlerElement;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SwitchToDisplayableElement
extends JPanel
implements PropertyEditorEventHandlerElement,
CleanUp {
    private DefaultComboBoxModel displayablesModel;
    private DefaultComboBoxModel displayablesWithoutAlertModel;
    private JRadioButton radioButton = new JRadioButton();
    private ListCellRenderer cellRenderer;
    private JComboBox displayablesComboBox;
    private JComboBox displayablesWithoutAlertsComboBox;
    private JCheckBox thenGoToCheckBox;

    private SwitchToDisplayableElement() {
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"LBL_SWITCH_TO_DISPL"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSN_SWITCH_TO_DISPL"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSD_SWITCH_TO_DISPL"));
        this.displayablesModel = new DefaultComboBoxModel();
        this.displayablesWithoutAlertModel = new DefaultComboBoxModel();
        this.cellRenderer = new ListCellRenderer();
        this.initComponents();
    }

    @Override
    public void clean(DesignComponent component) {
        this.displayablesComboBox = null;
        this.displayablesWithoutAlertsComboBox = null;
        this.thenGoToCheckBox = null;
        this.displayablesModel = null;
        this.displayablesWithoutAlertModel = null;
        this.radioButton = null;
        this.cellRenderer = null;
        this.removeAll();
    }

    @Override
    public void setTextForPropertyValue(String text) {
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return false;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public void createEventHandler(DesignComponent eventSource) {
        if (!this.radioButton.isSelected()) {
            return;
        }
        DesignComponent displayable = (DesignComponent)this.displayablesModel.getSelectedItem();
        DesignComponent displayable2 = (DesignComponent)this.displayablesWithoutAlertsComboBox.getSelectedItem();
        if (this.thenGoToCheckBox.isSelected()) {
            DesignComponent eventHandler = MidpDocumentSupport.updateEventHandlerFromTarget(eventSource, displayable2);
            MidpDocumentSupport.updateEventHandlerWithAlert(eventHandler, displayable);
        } else {
            DesignComponent eventHandler = MidpDocumentSupport.updateEventHandlerFromTarget(eventSource, displayable);
            MidpDocumentSupport.updateSwitchDisplayableEventHandler(eventHandler, null, displayable);
        }
    }

    @Override
    public void updateModel(List<DesignComponent> components, int modelType) {
        if (modelType == 0) {
            this.displayablesModel.removeAllElements();
            for (DesignComponent component : components) {
                this.displayablesModel.addElement(component);
            }
        }
        if (modelType == 1) {
            this.displayablesWithoutAlertModel.removeAllElements();
            for (DesignComponent component : components) {
                this.displayablesWithoutAlertModel.addElement(component);
            }
        }
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        if (value != null) {
            DesignComponent eventHandler = value.getComponent();
            if (SwitchDisplayableEventHandlerCD.TYPEID.equals((Object)eventHandler.getType())) {
                this.radioButton.setSelected(true);
                DesignComponent displayable = eventHandler.readProperty("displayable").getComponent();
                DesignComponent displayable2 = eventHandler.readProperty("alert").getComponent();
                if (displayable2 != null) {
                    this.thenGoToCheckBox.setEnabled(true);
                    this.displayablesWithoutAlertsComboBox.setEnabled(true);
                    this.thenGoToCheckBox.setSelected(true);
                    this.displayablesComboBox.setSelectedItem(displayable2);
                    this.displayablesWithoutAlertsComboBox.setSelectedItem(displayable);
                } else {
                    this.displayablesComboBox.setSelectedItem(displayable);
                    this.clearAlertCheckBox();
                }
            } else {
                this.clearAlertCheckBox();
            }
        } else {
            this.clearAlertCheckBox();
        }
    }

    private void clearAlertCheckBox() {
        this.thenGoToCheckBox.setSelected(false);
        this.thenGoToCheckBox.setEnabled(false);
        this.displayablesWithoutAlertsComboBox.setEnabled(false);
    }

    @Override
    public void setElementEnabled(boolean enabled) {
    }

    @Override
    public Collection<TypeID> getTypes() {
        return Collections.singleton(SwitchDisplayableEventHandlerCD.TYPEID);
    }

    private void initComponents() {
        this.displayablesComboBox = new JComboBox();
        this.thenGoToCheckBox = new JCheckBox();
        this.displayablesWithoutAlertsComboBox = new JComboBox();
        this.displayablesComboBox.setModel(this.displayablesModel);
        this.displayablesComboBox.setRenderer(this.cellRenderer);
        this.displayablesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwitchToDisplayableElement.this.displayablesComboBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.thenGoToCheckBox, (String)NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"LBL_THROUGH_ALERT"));
        this.thenGoToCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.thenGoToCheckBox.setEnabled(false);
        this.thenGoToCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.thenGoToCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SwitchToDisplayableElement.this.thenGoToCheckBoxActionPerformed(evt);
            }
        });
        this.displayablesWithoutAlertsComboBox.setModel(this.displayablesWithoutAlertModel);
        this.displayablesWithoutAlertsComboBox.setEnabled(false);
        this.displayablesWithoutAlertsComboBox.setRenderer(this.cellRenderer);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.thenGoToCheckBox).addContainerGap()).addComponent(this.displayablesWithoutAlertsComboBox, 0, 300, Short.MAX_VALUE).addComponent(this.displayablesComboBox, 0, 300, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.displayablesComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.thenGoToCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayablesWithoutAlertsComboBox, -2, -1, -2)));
        this.displayablesComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSN_FirstDisplayable"));
        this.displayablesComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSD_FirstDisplayable"));
        this.thenGoToCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSN_ForwardTo"));
        this.thenGoToCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSD_ForwardTo"));
        this.displayablesWithoutAlertsComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSN_SecondDisplayable"));
        this.displayablesWithoutAlertsComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SwitchToDisplayableElement.class, (String)"ACSD_SecondDisplayable"));
    }

    private void displayablesComboBoxActionPerformed(ActionEvent evt) {
        DesignComponent component = (DesignComponent)this.displayablesComboBox.getSelectedItem();
        if (component == null) {
            return;
        }
        this.radioButton.setSelected(true);
        this.displayablesWithoutAlertsComboBox.setEnabled(AlertCD.TYPEID.equals((Object)component.getType()));
        this.thenGoToCheckBox.setEnabled(AlertCD.TYPEID.equals((Object)component.getType()));
    }

    private void thenGoToCheckBoxActionPerformed(ActionEvent evt) {
        this.displayablesWithoutAlertsComboBox.setEnabled(this.thenGoToCheckBox.isSelected());
    }

    public static class SwitchToDisplayableElementFactory
    implements PropertyEditorElementFactory {
        @Override
        public PropertyEditorEventHandlerElement createElement() {
            return new SwitchToDisplayableElement();
        }
    }
}

