/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.inspector.controllers;

import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorPositionController;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.TypeID;

public class ChildrenByTypePC
implements InspectorPositionController {
    private TypeID[] typeIDs;

    public ChildrenByTypePC(TypeID ... typeIDs) {
        if (typeIDs.length == 0) {
            throw Debug.error((Object[])new Object[]{"Argument typIDs cant be empty"});
        }
        this.typeIDs = typeIDs;
    }

    public boolean isInside(InspectorFolderPath path, InspectorFolder folder, DesignComponent component) {
        int parentIndex = path.getPath().size() - 1;
        Long parentComponentID = ((InspectorFolder)path.getPath().get(parentIndex)).getComponentID();
        if (parentComponentID != null) {
            DesignComponent parentComponent = component.getDocument().getComponentByUID(parentComponentID.longValue());
            if (!parentComponent.getComponents().contains(component)) {
                return false;
            }
            for (TypeID typeID : this.typeIDs) {
                if (!component.getDocument().getDescriptorRegistry().isInHierarchy(typeID, parentComponent.getType())) continue;
                return true;
            }
        }
        return false;
    }
}

