/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.EditorViewFactory;
import org.netbeans.modules.editor.lib2.view.OffsetRegion;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyChange;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;
import org.netbeans.modules.editor.lib2.view.ViewReplace;
import org.netbeans.modules.editor.lib2.view.ViewStats;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class ViewBuilder {
    private static final int MAX_CHARS_FOR_CREATE_LOCAL_VIEWS = 2000;
    private static final Logger LOG = Logger.getLogger(ViewBuilder.class.getName());
    private final ViewReplace<DocumentView, ParagraphView> docReplace;
    private FactoryState[] factoryStates;
    private boolean createLocalViews;
    private int creationOffset;
    private int matchOffset;
    private int modLength;
    private int docViewStartOffset;
    private final int docViewEndBoundOffset;
    private Element lineRoot;
    private int lineIndex;
    private int lineEndOffset;
    private Element lineForParagraphView;
    private ViewReplace<ParagraphView, EditorView> firstReplace;
    private ViewReplace<ParagraphView, EditorView> localReplace;
    private List<ViewReplace<ParagraphView, EditorView>> allReplaces;
    private volatile boolean staleCreation;
    private int startCreationOffset;
    private RebuildCause rebuildCause;

    ViewBuilder(DocumentView docView, EditorViewFactory[] viewFactories) {
        this.docReplace = new ViewReplace(docView);
        this.factoryStates = new FactoryState[viewFactories.length];
        for (int i = 0; i < viewFactories.length; ++i) {
            this.factoryStates[i] = new FactoryState(viewFactories[i]);
        }
        this.docViewStartOffset = docView.getStartOffset();
        this.docViewEndBoundOffset = docView.getEndBoundOffset();
        this.createLocalViews = docView.op.isAccurateSpan();
    }

    void initFullRebuild() {
        this.docReplace.removeTillEnd();
        this.creationOffset = this.docViewStartOffset;
        this.matchOffset = this.docViewEndBoundOffset;
        this.rebuildCause = RebuildCause.FULL_REBUILD;
    }

    void initParagraphs(int startRebuildIndex, int endRebuildIndex, int startOffset, int endOffset) {
        this.createLocalViews = true;
        this.docReplace.index = startRebuildIndex;
        this.docReplace.removeCount = endRebuildIndex - startRebuildIndex;
        this.creationOffset = startOffset;
        this.matchOffset = endOffset;
        this.rebuildCause = RebuildCause.INIT_PARAGRAPHS;
    }

    boolean initChangedRegionRebuild(OffsetRegion rRegion) {
        DocumentView docView = (DocumentView)this.docReplace.view;
        int startAffectedOffset = rRegion.startOffset();
        int endAffectedOffset = rRegion.endOffset();
        int startRebuildIndex = -1;
        if (!(docView.hasExtraStartBound() && endAffectedOffset < this.docViewStartOffset || docView.hasExtraEndBound() && startAffectedOffset >= this.docViewEndBoundOffset)) {
            startRebuildIndex = docView.getViewIndex(startAffectedOffset);
        }
        if (startRebuildIndex == -1) {
            this.factoryStates = null;
            return false;
        }
        this.updateRebuildIndexes(startRebuildIndex, endAffectedOffset);
        this.checkCreateLocalViews(startAffectedOffset, endAffectedOffset);
        this.checkLocalRebuild(startAffectedOffset, endAffectedOffset, 0);
        this.rebuildCause = RebuildCause.CHANGED_REGION;
        return true;
    }

    boolean initModUpdate(int modOffset, int modLength, OffsetRegion rRegion) {
        this.modLength = modLength;
        DocumentView docView = (DocumentView)this.docReplace.view;
        int startAffectedOffset = modOffset;
        int endAffectedOffset = modOffset + Math.max(modLength, 1);
        if (rRegion != null) {
            startAffectedOffset = Math.min(startAffectedOffset, rRegion.startOffset());
            endAffectedOffset = Math.max(endAffectedOffset, rRegion.endOffset());
        }
        int startRebuildIndex = -1;
        boolean allowLocalRebuild = true;
        if (!(docView.hasExtraStartBound() && endAffectedOffset < this.docViewStartOffset || docView.hasExtraEndBound() && startAffectedOffset > this.docViewEndBoundOffset)) {
            if (docView.hasExtraStartBound() && modLength > 0 && modOffset + modLength == this.docViewStartOffset) {
                try {
                    docView.setStartPosition(docView.getDocument().createPosition(modOffset));
                    this.docViewStartOffset = modOffset;
                }
                catch (BadLocationException ex) {
                    throw new IllegalStateException("Unexpected BadLocationException", ex);
                }
                startRebuildIndex = 0;
                allowLocalRebuild = false;
            } else {
                startRebuildIndex = docView.getViewIndex(startAffectedOffset);
                if (modLength > 0) {
                    if (endAffectedOffset == modOffset + modLength && startRebuildIndex + 1 < docView.getViewCount() && docView.getParagraphView(startRebuildIndex + 1).getStartOffset() == modOffset + modLength) {
                        ++endAffectedOffset;
                        allowLocalRebuild = false;
                    }
                } else if (startAffectedOffset == modOffset && startRebuildIndex < docView.getViewCount() && docView.getParagraphView(startRebuildIndex).getStartOffset() == modOffset) {
                    if (startRebuildIndex > 0) {
                        --startRebuildIndex;
                    } else {
                        allowLocalRebuild = false;
                    }
                }
            }
        }
        if (startRebuildIndex == -1) {
            this.factoryStates = null;
            return false;
        }
        this.updateRebuildIndexes(startRebuildIndex, endAffectedOffset);
        this.checkCreateLocalViews(startAffectedOffset, endAffectedOffset);
        if (allowLocalRebuild) {
            this.checkLocalRebuild(startAffectedOffset, endAffectedOffset, modLength);
        }
        this.rebuildCause = RebuildCause.MOD_UPDATE;
        return true;
    }

    boolean createReplaceRepaintViews(boolean force) {
        if (!this.createViews(force)) {
            return false;
        }
        this.replaceRepaintViews();
        return true;
    }

    private void updateRebuildIndexes(int startRebuildIndex, int endAffectedOffset) {
        DocumentView docView = (DocumentView)this.docReplace.view;
        this.docReplace.index = startRebuildIndex;
        this.creationOffset = startRebuildIndex != 0 ? docView.getParagraphView(startRebuildIndex).getStartOffset() : this.docViewStartOffset;
        int pViewCount = docView.getViewCount();
        int endRebuildIndex = this.docReplace.index;
        this.matchOffset = this.docViewEndBoundOffset;
        if (endRebuildIndex < pViewCount && ++endRebuildIndex < pViewCount) {
            int nextParagraphViewOffset = docView.getView(endRebuildIndex).getStartOffset();
            if (endAffectedOffset > nextParagraphViewOffset) {
                endRebuildIndex = docView.getViewIndex(endAffectedOffset) + 1;
                if (endRebuildIndex < pViewCount) {
                    this.matchOffset = docView.getView(endRebuildIndex).getStartOffset();
                }
            } else {
                this.matchOffset = nextParagraphViewOffset;
            }
        }
        this.docReplace.removeCount = endRebuildIndex - this.docReplace.index;
    }

    private void checkCreateLocalViews(int startAffectedOffset, int endAffectedOffset) {
        if (!this.createLocalViews) {
            this.createLocalViews = endAffectedOffset - startAffectedOffset < 2000;
        }
    }

    private void checkLocalRebuild(int startAffectedOffset, int endAffectedOffset, int modLength) {
        ParagraphView pView;
        if (this.docReplace.removeCount == 1 && (pView = ((DocumentView)this.docReplace.view).getParagraphView(this.docReplace.index)).getViewCount() > 0) {
            int startLocalIndex = pView.getViewIndex(startAffectedOffset - 1);
            EditorView startLocalView = pView.getEditorView(startLocalIndex);
            int localViewCount = pView.getViewCount();
            int origEndAffectedOffset = endAffectedOffset - modLength;
            int pViewStartOffset = pView.getStartOffset();
            if (startAffectedOffset > pViewStartOffset && origEndAffectedOffset <= pView.getEndOffset()) {
                EditorView localView = pView.getEditorView(startLocalIndex);
                int endLocalIndex = origEndAffectedOffset <= localView.getEndOffset() ? startLocalIndex + 1 : Math.min(pView.getViewIndex(origEndAffectedOffset) + 1, localViewCount);
                if (startLocalIndex > 0 || endLocalIndex < localViewCount) {
                    this.firstReplace = new ViewReplace(pView);
                    this.firstReplace.index = startLocalIndex;
                    this.firstReplace.removeCount = endLocalIndex - startLocalIndex;
                    this.creationOffset = startLocalView.getStartOffset();
                    if (endLocalIndex < localViewCount) {
                        this.matchOffset = pView.getView(endLocalIndex).getStartOffset() + modLength;
                    }
                    this.localReplace = this.firstReplace;
                    ++this.docReplace.index;
                    --this.docReplace.removeCount;
                }
            }
        }
    }

    boolean createViews(boolean force) {
        this.startCreationOffset = this.creationOffset;
        if (this.creationOffset > this.matchOffset) {
            throw new IllegalStateException("creationOffset=" + this.creationOffset + " > matchOffset=" + this.matchOffset);
        }
        Document doc = ((DocumentView)this.docReplace.view).getDocument();
        this.lineRoot = doc.getDefaultRootElement();
        this.lineIndex = this.lineRoot.getElementIndex(this.creationOffset);
        Element line = this.lineRoot.getElement(this.lineIndex);
        this.lineEndOffset = line.getEndOffset();
        this.lineForParagraphView = line;
        for (int i = 0; i < this.factoryStates.length; ++i) {
            FactoryState state = this.factoryStates[i];
            state.init(this, this.creationOffset, this.matchOffset);
        }
        this.allReplaces = new ArrayList<ViewReplace<ParagraphView, EditorView>>(2);
        if (this.creationOffset < this.matchOffset) {
            while (this.createNextView()) {
                if (!this.staleCreation || force) continue;
                ViewStats.incrementStaleViewCreations();
                if (ViewHierarchyImpl.BUILD_LOG.isLoggable(Level.FINE)) {
                    ViewHierarchyImpl.BUILD_LOG.fine("STALE-CREATION notified => View Rebuild Terminated\n");
                }
                return false;
            }
        }
        if (this.localReplace != null && this.localReplace != this.firstReplace) {
            assert (((DocumentView)this.docReplace.view).hasExtraEndBound()) : "No ending newline view for document view without explicit start bound.";
            int length = this.creationOffset - ((ParagraphView)this.localReplace.view).getStartOffset();
            ((ParagraphView)this.localReplace.view).setLength(length);
            this.localReplace = null;
        }
        if (this.firstReplace != null && this.firstReplace.isMakingViewEmpty()) {
            --this.docReplace.index;
            ++this.docReplace.removeCount;
            this.firstReplace = null;
        }
        if (ViewHierarchyImpl.BUILD_LOG.isLoggable(Level.FINE)) {
            if (ViewHierarchyImpl.BUILD_LOG.isLoggable(Level.FINEST)) {
                ViewHierarchyImpl.BUILD_LOG.finer("ViewBuilder: DocView-Original-Content:\n" + ((DocumentView)this.docReplace.view).toStringDetailUnlocked() + '\n');
            }
            StringBuilder sb = new StringBuilder(200);
            sb.append("ViewBuilder.createViews(): in <").append(this.startCreationOffset);
            sb.append(",").append(this.creationOffset).append("> cause:").append((Object)this.rebuildCause).append("\n");
            sb.append("Document:").append(doc).append('\n');
            if (this.firstReplace != null) {
                sb.append("FirstReplace:\n").append(this.firstReplace);
            } else {
                sb.append("No-FirstReplace\n");
            }
            sb.append("DocReplace:\n").append(this.docReplace);
            sb.append("pReplaceList:\n");
            int digitCount = ArrayUtilities.digitCount((int)this.allReplaces.size());
            for (int i = 0; i < this.allReplaces.size(); ++i) {
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
                sb.append(this.allReplaces.get(i));
            }
            sb.append("-------------END-OF-VIEW-REBUILD-------------\n");
            ViewUtils.log(ViewHierarchyImpl.BUILD_LOG, sb.toString());
        }
        return true;
    }

    boolean createNextView() {
        int limitOffset = this.matchOffset;
        for (int i = this.factoryStates.length - 1; i >= 0; --i) {
            FactoryState state = this.factoryStates[i];
            int cmp = state.nextViewStartOffset - this.creationOffset;
            if (cmp < 0) {
                state.updateNextViewStartOffset(this.creationOffset);
                cmp = state.nextViewStartOffset - this.creationOffset;
            }
            if (cmp == 0) {
                int index;
                boolean inFirstReplace;
                int createdViewEndOffset;
                EditorView view = null;
                if (this.createLocalViews) {
                    view = state.factory.createView(this.creationOffset, limitOffset);
                    if (view == null) continue;
                    int viewLength = view.getLength();
                    createdViewEndOffset = this.creationOffset + viewLength;
                    assert (viewLength > 0) : "viewLength=" + viewLength + " < 0";
                } else {
                    createdViewEndOffset = state.factory.viewEndOffset(this.creationOffset, limitOffset);
                    if (createdViewEndOffset == -1) continue;
                }
                this.updateLine(createdViewEndOffset);
                boolean eolView = createdViewEndOffset == this.lineEndOffset;
                boolean bl = inFirstReplace = this.localReplace == this.firstReplace && this.firstReplace != null;
                if (eolView && inFirstReplace) {
                    this.firstReplace.removeCount = ((ParagraphView)this.firstReplace.view).getViewCount() - this.firstReplace.index;
                    index = this.docReplace.removeEndIndex();
                    this.matchOffset = index < ((DocumentView)this.docReplace.view).getViewCount() ? ((DocumentView)this.docReplace.view).getParagraphView(index).getStartOffset() : this.docViewEndBoundOffset;
                }
                if (createdViewEndOffset > this.matchOffset) {
                    if (inFirstReplace) {
                        int localViewCount = ((ParagraphView)this.firstReplace.view).getViewCount();
                        while ((index = this.firstReplace.removeEndIndex()) < localViewCount) {
                            this.matchOffset += ((ParagraphView)this.localReplace.view).getEditorView(index).getLength();
                            ++this.localReplace.removeCount;
                            if (createdViewEndOffset > this.matchOffset) continue;
                            break;
                        }
                    } else {
                        int pViewCount = ((DocumentView)this.docReplace.view).getViewCount();
                        if (this.docReplace.removeEndIndex() < pViewCount) {
                            do {
                                int index2;
                                if ((index2 = this.docReplace.removeNext()) >= pViewCount) {
                                    this.matchOffset = this.docViewEndBoundOffset;
                                    break;
                                }
                                this.matchOffset = ((DocumentView)this.docReplace.view).getParagraphView(index2).getStartOffset();
                            } while (createdViewEndOffset > this.matchOffset);
                        }
                    }
                }
                if (this.localReplace == null) {
                    Position startPos;
                    if (this.creationOffset == this.docViewStartOffset && this.docViewStartOffset != 0) {
                        startPos = ((DocumentView)this.docReplace.view).getStartPosition();
                    } else if (this.lineForParagraphView instanceof Position && this.creationOffset == this.lineForParagraphView.getStartOffset()) {
                        startPos = (Position)((Object)this.lineForParagraphView);
                    } else {
                        try {
                            startPos = ((DocumentView)this.docReplace.view).getDocument().createPosition(this.creationOffset);
                        }
                        catch (BadLocationException e) {
                            throw new IllegalStateException("Cannot create position at offset=" + this.creationOffset, e);
                        }
                    }
                    ParagraphView paragraphView = new ParagraphView(startPos);
                    this.docReplace.add(paragraphView);
                    this.localReplace = new ViewReplace(paragraphView);
                    if (this.createLocalViews) {
                        this.allReplaces.add(this.localReplace);
                    }
                }
                if (this.createLocalViews) {
                    this.localReplace.add(view);
                }
                if (eolView) {
                    if (this.localReplace != this.firstReplace) {
                        int length = createdViewEndOffset - ((ParagraphView)this.localReplace.view).getStartOffset();
                        ((ParagraphView)this.localReplace.view).setLength(length);
                    }
                    this.localReplace = null;
                    this.lineForParagraphView = this.lineIndex + 1 < this.lineRoot.getElementCount() ? this.lineRoot.getElement(this.lineIndex + 1) : null;
                }
                this.creationOffset = createdViewEndOffset;
                return this.creationOffset < this.matchOffset;
            }
            if (state.nextViewStartOffset >= limitOffset) continue;
            limitOffset = state.nextViewStartOffset;
        }
        throw new IllegalStateException("No factory returned view for offset=" + this.creationOffset);
    }

    private void transcribe(ParagraphView origPView, ParagraphView newPView) {
        float origWidth = origPView.getWidth();
        newPView.setWidth(origWidth);
        float origHeight = origPView.getHeight();
        newPView.setHeight(origHeight);
    }

    private void replaceRepaintViews() {
        double deltaY;
        double endY;
        double startY;
        boolean firstReplaceValid;
        DocumentView docView = (DocumentView)this.docReplace.view;
        JTextComponent textComponent = docView.getTextComponent();
        assert (textComponent != null) : "Null textComponent";
        boolean bl = firstReplaceValid = this.firstReplace != null && this.firstReplace.isChanged();
        if (firstReplaceValid) {
            ((ParagraphView)this.firstReplace.view).replace(this.firstReplace.index, this.firstReplace.removeCount, this.firstReplace.addedViews(), this.modLength);
        }
        TextLayoutCache textLayoutCache = docView.op.getTextLayoutCache();
        for (int i = 0; i < this.docReplace.removeCount; ++i) {
            ParagraphView pView = docView.getParagraphView(this.docReplace.index + i);
            if (pView.children == null) continue;
            textLayoutCache.remove(pView, false);
        }
        List addedPViews = this.docReplace.added;
        int addedCount = this.docReplace.addedSize();
        int removeCount = this.docReplace.removeCount;
        int index = this.docReplace.index;
        int i0 = 0;
        int i1 = addedCount;
        int i1Orig = removeCount;
        int commonCount = Math.min(addedCount, removeCount);
        if (commonCount > 0) {
            int endCount;
            ParagraphView origPView = docView.getParagraphView(index);
            ParagraphView newPView = (ParagraphView)addedPViews.get(0);
            if (origPView.getStartOffset() == newPView.getStartOffset()) {
                while (origPView.getLength() == newPView.getLength()) {
                    this.transcribe(origPView, newPView);
                    if (++i0 >= commonCount) break;
                    origPView = docView.getParagraphView(index + i0);
                    newPView = (ParagraphView)addedPViews.get(i0);
                }
            }
            if ((endCount = commonCount - i0) > 0) {
                int i = 1;
                origPView = docView.getParagraphView(index + removeCount - i);
                newPView = (ParagraphView)addedPViews.get(addedCount - i);
                if (origPView.getEndOffset() == newPView.getEndOffset()) {
                    while (true) {
                        if (origPView.getLength() != newPView.getLength()) {
                            --i;
                            break;
                        }
                        this.transcribe(origPView, newPView);
                        if (i >= commonCount - i0) break;
                        origPView = docView.getParagraphView(index + removeCount - ++i);
                        newPView = (ParagraphView)addedPViews.get(addedCount - i);
                    }
                    i1 = addedCount - i;
                    i1Orig = removeCount - i;
                }
            }
        }
        if (i0 != i1) {
            float defaultRowHeight = docView.op.getDefaultRowHeight();
            for (int i = i0; i < i1; ++i) {
                ParagraphView addedPView = (ParagraphView)addedPViews.get(i);
                addedPView.setHeight(defaultRowHeight);
            }
        }
        if (ViewHierarchyImpl.BUILD_LOG.isLoggable(Level.FINE)) {
            ViewHierarchyImpl.BUILD_LOG.fine("Non-Retained Views: " + (i0 != i1 ? "<" + i0 + "," + i1 + ">" : "NONE") + " of " + addedCount + " new pViews\n");
        }
        ViewHierarchyChange change = docView.validChange();
        int changeEndOffset = firstReplaceValid && !this.docReplace.isChanged() ? ((ParagraphView)this.firstReplace.view).getEndOffset() : this.matchOffset;
        change.addChange(this.startCreationOffset, changeEndOffset);
        if (this.docReplace.isChanged()) {
            boolean changeY = false;
            double y0 = 0.0;
            double y1 = 0.0;
            if (removeCount != addedCount || i0 != i1) {
                changeY = true;
                y0 = docView.children != null ? docView.getY(index + i0) : 0.0;
                y1 = i0 != i1Orig ? docView.getY(index + i1Orig) : y0;
            }
            double[] startEndDeltaY = docView.replaceViews(this.docReplace.index, this.docReplace.removeCount, this.docReplace.addedViews());
            startY = startEndDeltaY[0];
            endY = startEndDeltaY[1];
            deltaY = startEndDeltaY[2];
            for (int i = 0; i < this.allReplaces.size(); ++i) {
                ViewReplace<ParagraphView, EditorView> replace = this.allReplaces.get(i);
                if (!replace.isChanged()) continue;
                ((ParagraphView)replace.view).replace(replace.index, replace.removeCount, replace.addedViews());
            }
            if (changeY) {
                boolean realChange = true;
                if (deltaY == 0.0 && i1 - i0 == 1) {
                    realChange = false;
                }
                if (realChange) {
                    change.addChangeY(y0, y1, deltaY);
                }
            }
        } else {
            assert (firstReplaceValid) : "Invalid state - no updates done";
            startY = docView.getY(this.docReplace.index - 1);
            endY = docView.getY(this.docReplace.index);
            deltaY = 0.0;
        }
        Rectangle2D.Double docViewRect = docView.getAllocationMutable();
        if (docView.op.isAccurateSpan()) {
            int pIndex = this.docReplace.index;
            int endIndex = this.docReplace.addEndIndex();
            if (firstReplaceValid) {
                --pIndex;
            }
            while (pIndex < endIndex) {
                ParagraphView pView = docView.getParagraphView(pIndex);
                Shape childAlloc = docView.getChildAllocation(pIndex, docViewRect);
                if (pView.children != null) {
                    pView.children.ensureIndexMeasured(pView, pView.getViewCount(), ViewUtils.shapeAsRect(childAlloc));
                    docView.children.checkChildrenSpanChange(docView, pIndex);
                }
                ++pIndex;
            }
        }
        docViewRect.y = startY;
        double endRepaintY = deltaY != 0.0 ? docViewRect.getMaxY() + Math.max(0.0, deltaY) : endY;
        docViewRect.height = endRepaintY - docViewRect.y;
        docView.op.notifyRepaint(docView.op.extendToVisibleWidth(docViewRect));
    }

    void finish() {
        if (this.factoryStates != null) {
            for (FactoryState factoryState : this.factoryStates) {
                factoryState.finish();
            }
        }
        ((DocumentView)this.docReplace.view).checkIntegrityIfLoggable();
    }

    void updateLine(int offset) {
        while (offset > this.lineEndOffset) {
            ++this.lineIndex;
            Element line = this.lineRoot.getElement(this.lineIndex);
            this.lineEndOffset = line.getEndOffset();
        }
    }

    void notifyStaleCreation() {
        this.staleCreation = true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("-------- ViewBuilder dump -------\n");
        sb.append("creationOffset=").append(this.creationOffset).append('\n');
        sb.append("docViewEndBoundOffset=").append(this.docViewEndBoundOffset).append('\n');
        sb.append("lineIndex=").append(this.lineIndex).append('\n');
        sb.append("lineEndOffset=").append(this.lineEndOffset).append('\n');
        sb.append("matchOffset=").append(this.matchOffset).append('\n');
        sb.append("modLength=").append(this.modLength).append('\n');
        sb.append("firstReplace=").append(this.firstReplace).append('\n');
        sb.append("docReplace=").append(this.docReplace).append('\n');
        sb.append("pReplace=").append(this.localReplace).append('\n');
        sb.append("pReplaceList=").append(this.allReplaces).append('\n');
        sb.append("-------- End of ViewBuilder dump -------\n");
        return sb.toString();
    }

    private static final class FactoryState {
        final EditorViewFactory factory;
        int nextViewStartOffset;

        FactoryState(EditorViewFactory factory) {
            this.factory = factory;
        }

        void init(ViewBuilder viewBuilder, int startOffset, int matchOffset) {
            this.factory.setViewBuilder(viewBuilder);
            this.factory.restart(startOffset, matchOffset);
            this.updateNextViewStartOffset(startOffset);
        }

        void updateNextViewStartOffset(int offset) {
            this.nextViewStartOffset = this.factory.nextViewStartOffset(offset);
            if (this.nextViewStartOffset < offset) {
                throw new IllegalStateException("Editor view factory " + this.factory + " returned nextViewStartOffset=" + this.nextViewStartOffset + " < offset=" + offset);
            }
        }

        void finish() {
            this.factory.finishCreation();
            this.factory.setViewBuilder(null);
        }
    }

    private static enum RebuildCause {
        FULL_REBUILD,
        CHANGED_REGION,
        MOD_UPDATE,
        INIT_PARAGRAPHS;

    }
}

