/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DebugRepaintManager;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorTabExpander;
import org.netbeans.modules.editor.lib2.view.LineWrapType;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyImpl;
import org.netbeans.modules.editor.lib2.view.ViewStats;
import org.netbeans.modules.editor.lib2.view.ViewUpdates;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public final class DocumentViewOp
implements PropertyChangeListener,
ChangeListener,
MouseWheelListener {
    private static final Logger LOG = Logger.getLogger(DocumentViewOp.class.getName());
    static final char PRINTING_SPACE = '\u00b7';
    static final char PRINTING_TAB = '\u00bb';
    static final char PRINTING_NEWLINE = '\u00b6';
    static final char LINE_CONTINUATION = '\u21a9';
    static final char LINE_CONTINUATION_ALTERNATE = '\u2190';
    private static final int CHILD_WIDTH_CHANGE = 1;
    private static final int CHILD_HEIGHT_CHANGE = 2;
    private static final int WIDTH_CHANGE = 4;
    private static final int HEIGHT_CHANGE = 8;
    private static final int CHILDREN_VALID = 16;
    private static final int INCOMING_MODIFICATION = 32;
    private static final int FIRING_CHANGE = 64;
    private static final int ACCURATE_SPAN = 128;
    private static final int AVAILABLE_WIDTH_VALID = 256;
    private static final int CUSTOM_FONT = 1024;
    private static final int CUSTOM_FOREGROUND = 2048;
    private static final int CUSTOM_BACKGROUND = 4096;
    private static final int NON_PRINTABLE_CHARACTERS_VISIBLE = 8192;
    private static final int EXPECTED_FONT_NOTIFY = 16384;
    private static final int EXPECTED_FOREGROUND_NOTIFY = 32768;
    private static final int EXPECTED_BACKGROUND_NOTIFY = 65536;
    private final DocumentView docView;
    private int statusBits;
    private ViewUpdates viewUpdates;
    private TextLayoutCache textLayoutCache;
    private Rectangle visibleRect = new Rectangle();
    private float availableWidth;
    private float renderWrapWidth;
    private double repaintX0;
    private double repaintY0;
    private double repaintX1;
    private double repaintY1;
    private FontRenderContext fontRenderContext;
    private AttributeSet defaultColoring;
    private Font defaultFont;
    private float defaultLineHeight;
    private float defaultAscent;
    private float defaultDescent;
    private float defaultLeading;
    private float defaultCharWidth;
    private Color defaultForeground;
    private Color defaultBackground;
    private Color textLimitLineColor;
    private int textLimitLineX;
    private LineWrapType lineWrapType;
    private TextLayout newlineTextLayout;
    private TextLayout tabTextLayout;
    private TextLayout singleCharTabTextLayout;
    private TextLayout lineContinuationTextLayout;
    private LookupListener lookupListener;
    private JViewport listeningOnViewport;
    private Preferences prefs;
    private PreferenceChangeListener prefsListener;
    Map<?, ?> renderingHints;
    private int lengthyAtomicEdit;
    ViewHierarchyImpl viewHierarchyImpl;
    private Map<Font, FontInfo> fontInfos = new HashMap<Font, FontInfo>(4);
    private Font fallbackFont;
    private float lineHeightCorrection;
    private MouseWheelListener origMouseWheelListener;

    public DocumentViewOp(DocumentView docView) {
        this.docView = docView;
    }

    public ViewHierarchyImpl viewHierarchyImpl() {
        return this.viewHierarchyImpl;
    }

    public boolean isChildrenValid() {
        return this.isAnyStatusBit(16);
    }

    public void syncViewsRebuild() {
        this.docView.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                if (DocumentViewOp.this.viewUpdates != null) {
                    DocumentViewOp.this.viewUpdates.syncedViewsRebuild();
                }
            }
        });
    }

    public void notifyChildWidthChange() {
        this.setStatusBits(1);
        if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINEST)) {
            ViewUtils.log(ViewHierarchyImpl.SPAN_LOG, "CHILD-WIDTH changed\n");
        }
    }

    boolean isChildWidthChange() {
        return this.isAnyStatusBit(1);
    }

    void resetChildWidthChange() {
        this.clearStatusBits(1);
    }

    public void notifyChildHeightChange() {
        this.setStatusBits(2);
        if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINEST)) {
            ViewUtils.log(ViewHierarchyImpl.SPAN_LOG, "CHILD-HEIGHT changed\n");
        }
    }

    boolean isChildHeightChange() {
        return this.isAnyStatusBit(2);
    }

    void resetChildHeightChange() {
        this.clearStatusBits(2);
    }

    void notifyWidthChange() {
        this.setStatusBits(4);
        if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.SPAN_LOG, "DV-WIDTH changed\n");
        }
    }

    boolean isWidthChange() {
        return this.isAnyStatusBit(4);
    }

    private void resetWidthChange() {
        this.clearStatusBits(4);
    }

    private boolean checkRealWidthChange() {
        if (this.isWidthChange()) {
            this.resetWidthChange();
            return this.docView.assignChildrenWidth();
        }
        return false;
    }

    void notifyHeightChange() {
        this.setStatusBits(8);
        if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(ViewHierarchyImpl.SPAN_LOG, "DV-HEIGHT changed\n");
        }
    }

    boolean isHeightChange() {
        return this.isAnyStatusBit(8);
    }

    private void resetHeightChange() {
        this.clearStatusBits(8);
    }

    private boolean checkRealHeightChange() {
        if (this.isHeightChange()) {
            this.resetHeightChange();
            return this.docView.assignChildrenHeight();
        }
        return false;
    }

    boolean isChildWidthHeightChange() {
        return this.isAnyStatusBit(3);
    }

    boolean isAnyWidthHeightChange() {
        return this.isAnyStatusBit(15);
    }

    private void setStatusBits(int bits) {
        this.statusBits |= bits;
    }

    private void clearStatusBits(int bits) {
        this.statusBits &= ~bits;
    }

    private void updateStatusBits(int bits, boolean value) {
        if (value) {
            this.setStatusBits(bits);
        } else {
            this.clearStatusBits(bits);
        }
    }

    private boolean isAnyStatusBit(int bits) {
        return (this.statusBits & bits) != 0;
    }

    void unlockCheck() {
        this.checkRealSpanChange();
        this.checkRepaint();
        if (this.isAnyWidthHeightChange()) {
            LOG.log(Level.INFO, "DocumentView invalid state upon unlock: " + this.docView.toStringUnlocked(), new Exception());
        }
    }

    void checkRealSpanChange() {
        boolean widthChange = this.checkRealWidthChange();
        boolean heightChange = this.checkRealHeightChange();
        if (widthChange || heightChange) {
            if (ViewHierarchyImpl.SPAN_LOG.isLoggable(Level.FINE)) {
                String msg = "TC-preferenceChanged(" + (widthChange ? "W" : "-") + "x" + (heightChange ? "H" : "-") + ")\n";
                ViewUtils.log(ViewHierarchyImpl.SPAN_LOG, msg);
            }
            this.docView.superPreferenceChanged(widthChange, heightChange);
        }
    }

    public void notifyRepaint(double x0, double y0, double x1, double y1) {
        if (this.repaintX1 == 0.0) {
            this.repaintX0 = x0;
            this.repaintY0 = y0;
            this.repaintX1 = x1;
            this.repaintY1 = y1;
        } else {
            this.repaintX0 = Math.min(this.repaintX0, x0);
            this.repaintX1 = Math.max(this.repaintX1, x1);
            this.repaintY0 = Math.min(this.repaintY0, y0);
            this.repaintY1 = Math.max(this.repaintY1, y1);
        }
        if (ViewHierarchyImpl.REPAINT_LOG.isLoggable(Level.FINE)) {
            String msg = "NOTIFY-REPAINT [x0,y0][x1,y1]: [" + x0 + "," + y0 + "][" + x1 + "," + y1 + "] => [" + this.repaintX0 + "," + this.repaintY0 + "][" + this.repaintX1 + "," + this.repaintY1 + "]\n";
            ViewUtils.log(ViewHierarchyImpl.REPAINT_LOG, msg);
        }
    }

    void notifyRepaint(Rectangle2D repaintRect) {
        this.notifyRepaint(repaintRect.getX(), repaintRect.getY(), repaintRect.getMaxX(), repaintRect.getMaxY());
    }

    final void checkRepaint() {
        if (this.repaintX1 != 0.0) {
            final int x0 = (int)this.repaintX0;
            final int x1 = (int)Math.ceil(this.repaintX1);
            final int y0 = (int)this.repaintY0;
            final int y1 = (int)Math.ceil(this.repaintY1);
            this.resetRepaintRegion();
            ViewUtils.runInEDT(new Runnable(){

                @Override
                public void run() {
                    JTextComponent textComponent = DocumentViewOp.this.docView.getTextComponent();
                    if (textComponent != null) {
                        if (ViewHierarchyImpl.REPAINT_LOG.isLoggable(Level.FINER)) {
                            ViewHierarchyImpl.REPAINT_LOG.finer("REPAINT [x0,y0][x1,y1]: [" + x0 + "," + y0 + "][" + x1 + "," + y1 + "]\n");
                        }
                        textComponent.repaint(x0, y0, x1 - x0, y1 - y0);
                    }
                }
            });
        }
    }

    private void resetRepaintRegion() {
        this.repaintX1 = 0.0;
    }

    Rectangle2D.Double extendToVisibleWidth(Rectangle2D.Double r) {
        r.width = this.getVisibleRect().getMaxX();
        return r;
    }

    void parentViewSet() {
        JTextComponent textComponent = this.docView.getTextComponent();
        this.textLayoutCache = new TextLayoutCache();
        this.updateStatusBits(128, Boolean.TRUE.equals(textComponent.getClientProperty("document-view-accurate-span")));
        this.viewUpdates = new ViewUpdates(this.docView);
        textComponent.addPropertyChangeListener(this);
        this.viewHierarchyImpl = ViewHierarchyImpl.get(textComponent);
        this.viewHierarchyImpl.setDocumentView(this.docView);
        if (ViewHierarchyImpl.REPAINT_LOG.isLoggable(Level.FINE)) {
            DebugRepaintManager.register(textComponent);
        }
    }

    void parentCleared() {
        JTextComponent textComponent = this.docView.getTextComponent();
        this.viewHierarchyImpl.setDocumentView(null);
        this.uninstallFromViewport();
        textComponent.removePropertyChangeListener(this);
        this.textLayoutCache = null;
        this.viewUpdates = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkViewsInited() {
        if (!this.isAnyStatusBit(16) && this.docView.getTextComponent() != null) {
            this.updateVisibleDimension();
            this.checkSettingsInfo();
            if (this.checkFontRenderContext()) {
                this.updateCharMetrics();
            }
            ((EditorTabExpander)this.docView.getTabExpander()).updateTabSize();
            if (this.isBuildable()) {
                LOG.fine("viewUpdates.reinitViews()\n");
                this.setStatusBits(16);
                try {
                    this.viewUpdates.reinitAllViews();
                }
                finally {
                    if (this.docView.children == null) {
                        this.clearStatusBits(16);
                    }
                }
            }
        }
    }

    boolean ensureChildrenValid(int startIndex, int endIndex, int extraStart, int extraEnd) {
        return this.viewUpdates.ensureChildrenValid(startIndex, endIndex, extraStart, extraEnd);
    }

    private boolean checkFontRenderContext() {
        Graphics graphics;
        if (this.fontRenderContext == null && (graphics = this.docView.getTextComponent().getGraphics()) != null) {
            assert (graphics instanceof Graphics2D) : "Not Graphics2D";
            if (this.renderingHints != null) {
                ((Graphics2D)graphics).addRenderingHints(this.renderingHints);
            }
            this.fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            if (this.fontRenderContext != null) {
                return true;
            }
        }
        return false;
    }

    protected void releaseChildrenUnlocked() {
        this.clearStatusBits(16);
    }

    public void releaseChildren(final boolean updateFonts) {
        this.docView.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                if (updateFonts) {
                    DocumentViewOp.this.updateDefaultFontAndColors();
                } else {
                    DocumentViewOp.this.releaseChildrenUnlocked();
                }
            }
        });
    }

    boolean isAccurateSpan() {
        return this.isAnyStatusBit(128);
    }

    void updateVisibleDimension() {
        Rectangle newRect;
        JTextComponent textComponent = this.docView.getTextComponent();
        Container parent = textComponent.getParent();
        if (parent instanceof JViewport) {
            JViewport viewport = (JViewport)parent;
            if (this.listeningOnViewport != viewport) {
                this.uninstallFromViewport();
                this.listeningOnViewport = viewport;
                if (this.listeningOnViewport != null) {
                    this.listeningOnViewport.addChangeListener(this);
                    Container scrollPane = this.listeningOnViewport.getParent();
                    MouseWheelListener[] mwls = (MouseWheelListener[])scrollPane.getListeners(MouseWheelListener.class);
                    if (mwls.length == 1) {
                        this.origMouseWheelListener = mwls[0];
                        scrollPane.removeMouseWheelListener(this.origMouseWheelListener);
                    }
                    this.listeningOnViewport.getParent().addMouseWheelListener(this);
                }
            }
            newRect = viewport.getViewRect();
        } else {
            this.uninstallFromViewport();
            Dimension size = textComponent.getSize();
            newRect = new Rectangle(0, 0, size.width, size.height);
        }
        this.docView.updateExtraVirtualHeight(this.listeningOnViewport);
        boolean widthDiffers = newRect.width != this.visibleRect.width;
        this.visibleRect = newRect;
        if (widthDiffers) {
            this.clearStatusBits(256);
            this.docView.recomputeChildrenWidths();
        }
    }

    private void uninstallFromViewport() {
        if (this.listeningOnViewport != null) {
            this.listeningOnViewport.getParent().removeMouseWheelListener(this);
            if (this.origMouseWheelListener != null) {
                this.listeningOnViewport.getParent().addMouseWheelListener(this.origMouseWheelListener);
            }
            this.listeningOnViewport.removeChangeListener(this);
            this.listeningOnViewport = null;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.docView.runReadLockTransaction(new Runnable(){

            @Override
            public void run() {
                JTextComponent textComponent = DocumentViewOp.this.docView.getTextComponent();
                if (textComponent != null) {
                    DocumentViewOp.this.updateVisibleDimension();
                }
            }
        });
    }

    private void checkSettingsInfo() {
        String mimeType;
        JTextComponent textComponent = this.docView.getTextComponent();
        if (textComponent == null) {
            return;
        }
        if (this.prefs == null) {
            mimeType = DocumentUtilities.getMimeType((JTextComponent)textComponent);
            this.prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
            this.prefsListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent evt) {
                    DocumentViewOp.this.updatePreferencesSettings(true);
                }
            };
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
            this.updatePreferencesSettings(false);
        }
        if (this.lookupListener == null) {
            this.lookupListener = new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    final Lookup.Result result = (Lookup.Result)ev.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DocumentViewOp.this.docView.runReadLockTransaction(new Runnable(){

                                @Override
                                public void run() {
                                    JTextComponent textComponent = DocumentViewOp.this.docView.getTextComponent();
                                    if (textComponent != null) {
                                        textComponent.putClientProperty("text-zoom", null);
                                        DocumentViewOp.this.updateFontColorSettings((Lookup.Result<FontColorSettings>)result, true);
                                    }
                                }
                            });
                        }
                    });
                }
            };
            mimeType = DocumentUtilities.getMimeType((JTextComponent)textComponent);
            Lookup lookup = MimeLookup.getLookup((String)mimeType);
            Lookup.Result result = lookup.lookupResult(FontColorSettings.class);
            this.updateFontColorSettings((Lookup.Result<FontColorSettings>)result, false);
            this.updateDefaultFontAndColors();
            result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.lookupListener, (Object)result));
        }
        if (this.lineWrapType == null) {
            this.updateLineWrapType();
            Document doc = this.docView.getDocument();
            this.updateTextLimitLine(doc);
            this.clearStatusBits(256);
            DocumentUtilities.addPropertyChangeListener((Document)doc, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)doc));
        }
    }

    void updatePreferencesSettings(boolean nonInitialUpdate) {
        boolean releaseChildren;
        boolean nonPrintableCharactersVisibleOrig = this.isAnyStatusBit(8192);
        boolean nonPrintableCharactersVisible = Boolean.TRUE.equals(this.prefs.getBoolean("non-printable-characters-visible", false));
        this.updateStatusBits(8192, nonPrintableCharactersVisible);
        float lineHeightCorrectionOrig = this.lineHeightCorrection;
        this.lineHeightCorrection = this.prefs.getFloat("line-height-correction", 1.0f);
        boolean updateMetrics = nonInitialUpdate && this.lineHeightCorrection != lineHeightCorrectionOrig;
        boolean bl = releaseChildren = nonInitialUpdate && (nonPrintableCharactersVisible != nonPrintableCharactersVisibleOrig || this.lineHeightCorrection != lineHeightCorrectionOrig);
        if (updateMetrics) {
            this.updateCharMetrics();
        }
        if (releaseChildren) {
            this.releaseChildren(false);
        }
    }

    void updateFontColorSettings(Lookup.Result<FontColorSettings> result, boolean nonInitialUpdate) {
        boolean releaseChildren;
        AttributeSet defaultColoringOrig = this.defaultColoring;
        FontColorSettings fcs = (FontColorSettings)result.allInstances().iterator().next();
        AttributeSet newDefaultColoring = fcs.getFontColors("default");
        if (newDefaultColoring != null) {
            this.defaultColoring = newDefaultColoring;
        }
        Color textLimitLineColorOrig = this.textLimitLineColor;
        AttributeSet textLimitLineColoring = fcs.getFontColors("text-limit-line-color");
        Color color = this.textLimitLineColor = textLimitLineColoring != null ? (Color)textLimitLineColoring.getAttribute(StyleConstants.Foreground) : null;
        if (this.textLimitLineColor == null) {
            this.textLimitLineColor = Color.PINK;
        }
        boolean bl = releaseChildren = nonInitialUpdate && !this.defaultColoring.equals(defaultColoringOrig);
        if (releaseChildren) {
            this.releaseChildren(true);
        } else {
            boolean repaint;
            boolean bl2 = repaint = nonInitialUpdate && (this.textLimitLineColor == null || !this.textLimitLineColor.equals(textLimitLineColorOrig));
            if (repaint) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextComponent textComponent = DocumentViewOp.this.docView.getTextComponent();
                        if (textComponent != null) {
                            textComponent.repaint();
                        }
                    }
                });
            }
        }
    }

    private void updateTextLimitLine(Document doc) {
        Integer dllw = (Integer)doc.getProperty("text-limit-width");
        int textLimitLineColumn = dllw != null ? dllw : 80;
        boolean drawTextLimitLine = this.prefs.getBoolean("text-limit-line-visible", true);
        this.textLimitLineX = drawTextLimitLine ? (int)((float)textLimitLineColumn * this.defaultCharWidth) : -1;
    }

    private void updateLineWrapType() {
        String lwt = null;
        JTextComponent textComponent = this.docView.getTextComponent();
        if (textComponent != null) {
            lwt = (String)textComponent.getClientProperty("text-line-wrap");
        }
        if (lwt == null) {
            Document doc = this.docView.getDocument();
            lwt = (String)doc.getProperty("text-line-wrap");
        }
        if (lwt != null) {
            this.lineWrapType = LineWrapType.fromSettingValue(lwt);
            if (this.lineWrapType == null) {
                this.lineWrapType = LineWrapType.NONE;
            }
        }
        this.clearStatusBits(256);
    }

    void updateDefaultFontAndColors() {
        final JTextComponent textComponent = this.docView.getTextComponent();
        if (textComponent == null) {
            return;
        }
        Font font = textComponent.getFont();
        Color foreColor = textComponent.getForeground();
        Color backColor = textComponent.getBackground();
        if (this.defaultColoring != null) {
            Color c;
            Font validFont = font != null ? font : this.fallbackFont();
            font = ViewUtils.getFont(this.defaultColoring, validFont);
            Integer textZoom = (Integer)textComponent.getClientProperty("text-zoom");
            if (textZoom != null && textZoom != 0) {
                int newSize = Math.max(font.getSize() + textZoom, 2);
                font = new Font(font.getFamily(), font.getStyle(), newSize);
            }
            if ((c = (Color)this.defaultColoring.getAttribute(StyleConstants.Foreground)) != null) {
                foreColor = c;
            }
            if ((c = (Color)this.defaultColoring.getAttribute(StyleConstants.Background)) != null) {
                backColor = c;
            }
            this.renderingHints = (Map)this.defaultColoring.getAttribute(EditorStyleConstants.RenderingHints);
        }
        if (!(this.isAnyStatusBit(1024) || font != null && font.equals(this.defaultFont))) {
            this.defaultFont = font;
            this.updateCharMetrics();
            ViewUtils.runInEDT(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DocumentViewOp.this.setStatusBits(16384);
                    try {
                        textComponent.setFont(DocumentViewOp.this.defaultFont);
                    }
                    finally {
                        DocumentViewOp.this.clearStatusBits(16384);
                    }
                }
            });
        }
        if (!this.isAnyStatusBit(2048)) {
            this.defaultForeground = foreColor;
            ViewUtils.runInEDT(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DocumentViewOp.this.setStatusBits(32768);
                    try {
                        textComponent.setForeground(DocumentViewOp.this.defaultForeground);
                    }
                    finally {
                        DocumentViewOp.this.clearStatusBits(32768);
                    }
                }
            });
        }
        if (!this.isAnyStatusBit(4096)) {
            this.defaultBackground = backColor;
            ViewUtils.runInEDT(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DocumentViewOp.this.setStatusBits(65536);
                    try {
                        textComponent.setBackground(DocumentViewOp.this.defaultBackground);
                    }
                    finally {
                        DocumentViewOp.this.clearStatusBits(65536);
                    }
                }
            });
        }
        this.releaseChildrenUnlocked();
        if (ViewHierarchyImpl.SETTINGS_LOG.isLoggable(Level.FINE)) {
            ViewHierarchyImpl.SETTINGS_LOG.fine(this.docView.getDumpId() + ": Updated DEFAULTS: font=" + this.defaultFont + ", fg=" + ViewUtils.toString(this.defaultForeground) + ", bg=" + ViewUtils.toString(this.defaultBackground) + '\n');
        }
    }

    private void updateCharMetrics() {
        this.checkFontRenderContext();
        FontRenderContext frc = this.getFontRenderContext();
        assert (this.defaultFont != null) : "Null defaultFont";
        if (frc != null) {
            this.fontInfos.clear();
            FontInfo defaultFontInfo = new FontInfo(this.defaultFont, this.docView.getTextComponent(), frc, this.lineHeightCorrection);
            this.fontInfos.put(this.defaultFont, defaultFontInfo);
            this.defaultAscent = defaultFontInfo.ascent;
            this.defaultDescent = defaultFontInfo.descent;
            this.defaultLeading = defaultFontInfo.leading;
            this.updateLineHeight();
            this.defaultCharWidth = defaultFontInfo.charWidth;
            this.tabTextLayout = null;
            this.singleCharTabTextLayout = null;
            this.lineContinuationTextLayout = null;
            this.updateTextLimitLine(this.docView.getDocument());
            this.clearStatusBits(256);
            ViewHierarchyImpl.SETTINGS_LOG.fine("updateCharMetrics(): FontRenderContext: AA=" + frc.isAntiAliased() + ", AATransformed=" + frc.isTransformed() + ", AAFractMetrics=" + frc.usesFractionalMetrics() + ", AAHint=" + frc.getAntiAliasingHint() + "\n");
        }
    }

    private void updateLineHeight() {
        this.defaultLineHeight = (float)Math.ceil(this.defaultAscent + this.defaultDescent + this.defaultLeading);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("updateLineHeight(): LH=" + this.defaultLineHeight + ", ascent=" + this.defaultAscent + ", descent=" + this.defaultDescent + ", leading=" + this.defaultLeading + '\n');
        }
    }

    void notifyFontUse(Font font) {
        if (font == this.defaultFont || this.fontInfos.containsKey(font)) {
            return;
        }
        FontInfo fontInfo = new FontInfo(font, this.docView.getTextComponent(), this.getFontRenderContext(), this.lineHeightCorrection);
        this.fontInfos.put(font, fontInfo);
        boolean change = false;
        if (fontInfo.ascent > this.defaultAscent) {
            this.defaultAscent = fontInfo.ascent;
            change = true;
        }
        if (fontInfo.descent > this.defaultDescent) {
            this.defaultDescent = fontInfo.descent;
            change = true;
        }
        if (fontInfo.leading > this.defaultLeading) {
            this.defaultLeading = fontInfo.leading;
            change = true;
        }
        if (change) {
            this.updateLineHeight();
            this.releaseChildrenUnlocked();
        }
    }

    void markIncomingModification() {
        this.setStatusBits(32);
    }

    void clearIncomingModification() {
        this.clearStatusBits(32);
    }

    boolean isActive() {
        if (this.isAnyStatusBit(64)) {
            throw new IllegalStateException("View hierarchy must not be queried during change firing");
        }
        if (this.isAnyStatusBit(32)) {
            if (ViewHierarchyImpl.OP_LOG.isLoggable(Level.FINER)) {
                ViewHierarchyImpl.OP_LOG.log(Level.INFO, "View Hierarchy Query during Incoming Modification\n", new Exception());
            }
            return false;
        }
        return this.isUpdatable();
    }

    boolean isUpdatable() {
        JTextComponent textComponent = this.docView.getTextComponent();
        return textComponent != null && this.isAnyStatusBit(16) && this.lengthyAtomicEdit <= 0;
    }

    boolean isBuildable() {
        JTextComponent textComponent = this.docView.getTextComponent();
        return textComponent != null && this.fontRenderContext != null && this.lengthyAtomicEdit <= 0 && !this.isAnyStatusBit(32);
    }

    public void updateLengthyAtomicEdit(int delta) {
        this.lengthyAtomicEdit += delta;
        if (LOG.isLoggable(Level.FINE)) {
            ViewUtils.log(LOG, "updateLengthyAtomicEdit: delta=" + delta + " lengthyAtomicEdit=" + this.lengthyAtomicEdit + "\n");
        }
        if (this.lengthyAtomicEdit == 0) {
            this.releaseChildren(false);
        }
    }

    Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    float getAvailableWidth() {
        if (!this.isAnyStatusBit(256)) {
            this.setStatusBits(256);
            this.renderWrapWidth = this.availableWidth = 2.1474836E9f;
            TextLayout lineContTextLayout = this.getLineContinuationCharTextLayout();
            if (lineContTextLayout != null && this.getLineWrapType() != LineWrapType.NONE) {
                this.availableWidth = Math.max((float)this.getVisibleRect().width, 4.0f * this.getDefaultCharWidth() + lineContTextLayout.getAdvance());
                this.renderWrapWidth = this.availableWidth - lineContTextLayout.getAdvance();
            }
        }
        return this.availableWidth;
    }

    float getRenderWrapWidth() {
        return this.renderWrapWidth;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.textLayoutCache;
    }

    FontRenderContext getFontRenderContext() {
        return this.fontRenderContext;
    }

    public float getDefaultRowHeight() {
        this.checkSettingsInfo();
        return this.defaultLineHeight;
    }

    public float getDefaultAscent() {
        this.checkSettingsInfo();
        return this.defaultAscent;
    }

    public float[] getUnderlineAndStrike(Font font) {
        this.checkSettingsInfo();
        FontInfo fontInfo = this.fontInfos.get(font);
        if (fontInfo == null) {
            fontInfo = this.fontInfos.get(this.defaultFont);
        }
        return fontInfo.underlineAndStrike;
    }

    public float getDefaultCharWidth() {
        this.checkSettingsInfo();
        return this.defaultCharWidth;
    }

    public boolean isNonPrintableCharactersVisible() {
        this.checkSettingsInfo();
        return this.isAnyStatusBit(8192);
    }

    LineWrapType getLineWrapType() {
        this.checkSettingsInfo();
        return this.lineWrapType;
    }

    Color getTextLimitLineColor() {
        this.checkSettingsInfo();
        return this.textLimitLineColor;
    }

    int getTextLimitLineX() {
        return this.textLimitLineX;
    }

    TextLayout getNewlineCharTextLayout() {
        if (this.newlineTextLayout == null && this.defaultFont != null) {
            this.newlineTextLayout = this.createTextLayout(String.valueOf('\u00b6'), this.defaultFont);
        }
        return this.newlineTextLayout;
    }

    TextLayout getTabCharTextLayout(double availableWidth) {
        if (this.tabTextLayout == null && this.defaultFont != null) {
            this.tabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), this.defaultFont);
        }
        TextLayout ret = this.tabTextLayout;
        if (this.tabTextLayout != null && availableWidth > 0.0 && (double)this.tabTextLayout.getAdvance() > availableWidth) {
            if (this.singleCharTabTextLayout == null) {
                for (int i = this.defaultFont.getSize() - 1; i >= 0; --i) {
                    Font font = new Font(this.defaultFont.getName(), this.defaultFont.getStyle(), i);
                    this.singleCharTabTextLayout = this.createTextLayout(String.valueOf('\u00bb'), font);
                    if (this.singleCharTabTextLayout == null) break;
                    if (!(this.singleCharTabTextLayout.getAdvance() <= this.getDefaultCharWidth())) continue;
                    LOG.log(Level.FINE, "singleChar font size={0}\n", i);
                    break;
                }
            }
            ret = this.singleCharTabTextLayout;
        }
        return ret;
    }

    TextLayout getLineContinuationCharTextLayout() {
        if (this.lineContinuationTextLayout == null && this.defaultFont != null) {
            char lineContinuationChar = '\u21a9';
            if (!this.defaultFont.canDisplay(lineContinuationChar)) {
                lineContinuationChar = '\u2190';
            }
            this.lineContinuationTextLayout = this.createTextLayout(String.valueOf(lineContinuationChar), this.defaultFont);
        }
        return this.lineContinuationTextLayout;
    }

    private TextLayout createTextLayout(String text, Font font) {
        this.checkSettingsInfo();
        if (this.fontRenderContext != null && font != null) {
            ViewStats.incrementTextLayoutCreated(text.length());
            return new TextLayout(text, font, this.fontRenderContext);
        }
        return null;
    }

    TextLayout createTextLayout(String text, AttributeSet attrs) {
        Font font = this.defaultFont != null ? this.defaultFont : this.fallbackFont();
        font = ViewUtils.getFont(attrs, font);
        return this.createTextLayout(text, font);
    }

    Font fallbackFont() {
        if (this.fallbackFont == null) {
            this.fallbackFont = new Font("Monospaced", 0, 12);
        }
        return this.fallbackFont;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JTextComponent textComponent = this.docView.getTextComponent();
        if (textComponent == null) {
            return;
        }
        boolean releaseChildren = false;
        boolean updateFonts = false;
        if (evt.getSource() instanceof Document) {
            String propName = evt.getPropertyName();
            if (propName == null || "text-line-wrap".equals(propName)) {
                LineWrapType origLineWrapType = this.lineWrapType;
                this.updateLineWrapType();
                if (origLineWrapType != this.lineWrapType) {
                    LOG.log(Level.FINE, "Changing lineWrapType from {0} to {1}", new Object[]{origLineWrapType, this.lineWrapType});
                    releaseChildren = true;
                }
            }
            if (propName == null || "tab-size".equals(propName)) {
                releaseChildren = true;
            }
            if (propName == null || "text-limit-width".equals(propName)) {
                this.updateTextLimitLine(this.docView.getDocument());
                releaseChildren = true;
            }
        } else {
            String propName = evt.getPropertyName();
            if (!"ancestor".equals(propName) && !"document".equals(propName)) {
                if ("font".equals(propName)) {
                    if (!this.isAnyStatusBit(16384)) {
                        this.defaultFont = textComponent.getFont();
                        this.setStatusBits(1024);
                        releaseChildren = true;
                        updateFonts = true;
                    }
                } else if ("foreground".equals(propName)) {
                    if (!this.isAnyStatusBit(32768)) {
                        this.defaultForeground = textComponent.getForeground();
                        this.setStatusBits(2048);
                        releaseChildren = true;
                    }
                } else if ("background".equals(propName)) {
                    if (!this.isAnyStatusBit(65536)) {
                        this.defaultBackground = textComponent.getBackground();
                        this.setStatusBits(4096);
                        releaseChildren = true;
                    }
                } else if ("text-line-wrap".equals(propName)) {
                    this.updateLineWrapType();
                    releaseChildren = true;
                } else if ("document-view-start-position".equals(propName) || "document-view-end-position".equals(propName)) {
                    this.docView.runReadLockTransaction(new Runnable(){

                        @Override
                        public void run() {
                            DocumentViewOp.this.docView.updateStartEndPos();
                            DocumentViewOp.this.releaseChildrenUnlocked();
                        }
                    });
                } else if ("text-zoom".equals(propName)) {
                    releaseChildren = true;
                    updateFonts = true;
                }
            }
        }
        if (releaseChildren) {
            this.releaseChildren(updateFonts);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        if (evt.getScrollType() != 0) {
            this.origMouseWheelListener.mouseWheelMoved(evt);
            return;
        }
        int modifiers = 0;
        if (evt.isControlDown()) {
            modifiers |= 0x80;
        }
        if (evt.isAltDown()) {
            modifiers |= 0x200;
        }
        if (evt.isShiftDown()) {
            modifiers |= 0x40;
        }
        if (evt.isMetaDown()) {
            modifiers |= 0x100;
        }
        Keymap keymap = this.docView.getTextComponent().getKeymap();
        if (evt.getWheelRotation() < 0) {
            Action action = keymap.getAction(KeyStroke.getKeyStroke(656, modifiers));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.docView.getTextComponent(), 0, ""));
                return;
            }
            this.origMouseWheelListener.mouseWheelMoved(evt);
        } else {
            Action action = keymap.getAction(KeyStroke.getKeyStroke(657, modifiers));
            if (action != null) {
                action.actionPerformed(new ActionEvent(this.docView.getTextComponent(), 0, ""));
                return;
            }
            this.origMouseWheelListener.mouseWheelMoved(evt);
        }
    }

    StringBuilder appendInfo(StringBuilder sb) {
        sb.append("incomingMod=").append(this.isAnyStatusBit(32));
        sb.append("; lengthyAE=").append(this.lengthyAtomicEdit);
        sb.append("\nChged:");
        int len = sb.length();
        if (this.isWidthChange()) {
            sb.append(" W");
        }
        if (this.isHeightChange()) {
            sb.append(" H");
        }
        if (this.isChildWidthChange()) {
            sb.append(" ChW");
        }
        if (this.isChildHeightChange()) {
            sb.append(" ChH");
        }
        if (sb.length() == len) {
            sb.append(" NONE");
        }
        sb.append("; visWidth").append(this.getVisibleRect().width);
        return sb;
    }

    public String toString() {
        return this.appendInfo(new StringBuilder(200)).toString();
    }

    private static final class FontInfo {
        final float ascent;
        final float descent;
        final float leading;
        final float charWidth;
        final float[] underlineAndStrike = new float[4];

        FontInfo(Font font, JTextComponent textComponent, FontRenderContext frc, float lineHeightCorrection) {
            char defaultChar = 'A';
            String defaultCharText = String.valueOf(defaultChar);
            TextLayout defaultCharTextLayout = new TextLayout(defaultCharText, font, frc);
            TextLayout lineHeightTextLayout = new TextLayout("A_|B", font, frc);
            this.ascent = lineHeightTextLayout.getAscent() * lineHeightCorrection;
            this.descent = lineHeightTextLayout.getDescent() * lineHeightCorrection;
            this.leading = lineHeightTextLayout.getLeading() * lineHeightCorrection;
            this.charWidth = (float)Math.ceil(defaultCharTextLayout.getAdvance());
            LineMetrics lineMetrics = font.getLineMetrics(defaultCharText, frc);
            this.underlineAndStrike[0] = lineMetrics.getUnderlineOffset() * lineHeightCorrection;
            this.underlineAndStrike[1] = lineMetrics.getUnderlineThickness();
            this.underlineAndStrike[2] = lineMetrics.getStrikethroughOffset() * lineHeightCorrection;
            this.underlineAndStrike[3] = lineMetrics.getStrikethroughThickness();
            if (LOG.isLoggable(Level.FINE)) {
                FontMetrics fm = textComponent.getFontMetrics(font);
                LOG.fine("Font: " + font + "\nSize2D: " + font.getSize2D() + ", lineHeightCorrection(applied to subsequent measures)=" + lineHeightCorrection + "\nascent=" + this.ascent + ", descent=" + this.descent + ", leading=" + this.leading + "\nChar-width=" + this.charWidth + ", underlineO/T=" + this.underlineAndStrike[0] + "/" + this.underlineAndStrike[1] + ", strikethroughO/T=" + this.underlineAndStrike[2] + "/" + this.underlineAndStrike[3] + "\nFontMetrics (for comparison; without-LHC): fm-line-height=" + fm.getHeight() + ", fm-ascent=" + fm.getAscent() + ", fm-descent=" + fm.getDescent() + "\n");
            }
        }
    }
}

