/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.PluginArtifactsCache;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.problems.BatchProblemNotifier;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.SanityBuildAction;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProblemReporterImpl
implements ProblemReporter,
Comparator<ProblemReport> {
    private static final String MISSINGJ2EE = "MISSINGJ2EE";
    private static final Logger LOG = Logger.getLogger(ProblemReporterImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ProblemReporterImpl.class);
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private final Set<ProblemReport> reports;
    private final Set<Artifact> missingArtifacts;
    private final RequestProcessor.Task reloadTask = RP.create(new Runnable(){

        @Override
        public void run() {
            LOG.log(Level.FINE, "actually reloading {0}", ProblemReporterImpl.this.nbproject.getPOMFile());
            ProblemReporterImpl.this.nbproject.fireProjectReload();
        }
    });
    private final FileChangeListener fcl = new FileChangeAdapter(){

        public void fileDataCreated(FileEvent fe) {
            LOG.log(Level.FINE, "due to {0} scheduling reload of {1}", new Object[]{fe.getFile(), ProblemReporterImpl.this.nbproject.getPOMFile()});
            ProblemReporterImpl.this.reloadTask.schedule(1000);
            File f = FileUtil.toFile((FileObject)fe.getFile());
            if (f != null) {
                BatchProblemNotifier.resolved(f);
            } else {
                LOG.log(Level.FINE, "no java.io.File from {0}", fe);
            }
        }
    };
    private final NbMavenProjectImpl nbproject;
    private ModuleInfo j2eeInfo;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ProblemReport rep;
            if ("enabled".equals(evt.getPropertyName()) && (rep = ProblemReporterImpl.this.getReportWithId(ProblemReporterImpl.MISSINGJ2EE)) != null) {
                boolean hasj2ee;
                boolean bl = hasj2ee = ProblemReporterImpl.this.j2eeInfo != null && ProblemReporterImpl.this.j2eeInfo.isEnabled();
                if (hasj2ee) {
                    ProblemReporterImpl.this.removeReport(rep);
                    ProblemReporterImpl.this.j2eeInfo.removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        }
    };

    public ProblemReporterImpl(NbMavenProjectImpl proj) {
        this.reports = new TreeSet<ProblemReport>(this);
        this.missingArtifacts = new HashSet<Artifact>();
        this.nbproject = proj;
    }

    public void addChangeListener(ChangeListener list) {
        this.listeners.add(list);
    }

    public void removeChangeListener(ChangeListener list) {
        this.listeners.remove(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReport(ProblemReport report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.add(report);
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReports(ProblemReport[] report) {
        assert (report != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (int i = 0; i < report.length; ++i) {
                assert (report[i] != null);
                this.reports.add(report[i]);
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReport(ProblemReport report) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            this.reports.remove(report);
        }
        this.fireChange();
    }

    private void fireChange() {
        for (ChangeListener list : this.listeners) {
            list.stateChanged(new ChangeEvent(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBroken() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport report : this.reports) {
                if (report.getSeverityLevel() >= 10) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProblemReport> getReports() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new ArrayList<ProblemReport>(this.reports);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMissingArtifact(Artifact a) {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            if (this.missingArtifacts.add(a)) {
                File f = a.getFile();
                if (f == null) {
                    f = EmbedderFactory.getProjectEmbedder().getLocalRepository().find(a).getFile();
                }
                LOG.log(Level.FINE, "listening to {0} from {1}", new Object[]{f, this.nbproject.getPOMFile()});
                FileUtil.addFileChangeListener((FileChangeListener)this.fcl, (File)FileUtil.normalizeFile((File)f));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Artifact> getMissingArtifacts() {
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            return new TreeSet<Artifact>(this.missingArtifacts);
        }
    }

    public boolean hasReportWithId(String id) {
        return this.getReportWithId(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemReport getReportWithId(String id) {
        assert (id != null);
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            for (ProblemReport rep : this.reports) {
                if (!id.equals(rep.getId())) continue;
                return rep;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReports() {
        boolean hasAny;
        Set<ProblemReport> set = this.reports;
        synchronized (set) {
            hasAny = !this.reports.isEmpty();
            this.reports.clear();
            Iterator<Artifact> as = this.missingArtifacts.iterator();
            while (as.hasNext()) {
                File f = as.next().getFile();
                if (f != null) {
                    LOG.log(Level.FINE, "ceasing to listen to {0} from {1}", new Object[]{f, this.nbproject.getPOMFile()});
                    FileUtil.removeFileChangeListener((FileChangeListener)this.fcl, (File)FileUtil.normalizeFile((File)f));
                    if (f.isFile()) {
                        BatchProblemNotifier.resolved(f);
                    }
                }
                as.remove();
            }
            this.missingArtifacts.clear();
        }
        if (hasAny) {
            this.fireChange();
        }
        ((PluginArtifactsCache)this.nbproject.getEmbedder().lookupComponent(PluginArtifactsCache.class)).flush();
    }

    @Override
    public int compare(ProblemReport o1, ProblemReport o2) {
        int ret = o1.getSeverityLevel() - o2.getSeverityLevel();
        if (ret != 0) {
            return ret;
        }
        return o1.hashCode() - o2.hashCode();
    }

    private ModuleInfo findJ2eeModule() {
        Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
        for (ModuleInfo info : infos) {
            if (!"org.netbeans.modules.maven.j2ee".equals(info.getCodeNameBase())) continue;
            return info;
        }
        return null;
    }

    public void doBaseProblemChecks(@NonNull MavenProject project) {
        String packaging = this.nbproject.getProjectWatcher().getPackagingType();
        if ("war".equals(packaging) || "ear".equals(packaging) || "ejb".equals(packaging)) {
            boolean foundJ2ee;
            if (this.j2eeInfo == null) {
                this.j2eeInfo = this.findJ2eeModule();
            }
            boolean bl = foundJ2ee = this.j2eeInfo != null && this.j2eeInfo.isEnabled();
            if (!foundJ2ee) {
                if (!this.hasReportWithId(MISSINGJ2EE)) {
                    ProblemReport report = new ProblemReport(5, Bundle.ERR_MissingJ2eeModule(), Bundle.MSG_MissingJ2eeModule(), null);
                    report.setId(MISSINGJ2EE);
                    this.addReport(report);
                    if (this.j2eeInfo != null) {
                        this.j2eeInfo.addPropertyChangeListener(this.listener);
                    }
                }
            } else if (this.j2eeInfo != null) {
                this.j2eeInfo.removePropertyChangeListener(this.listener);
            }
        } else if ("nbm".equals(packaging)) {
            Collection infos = Lookup.getDefault().lookupAll(ModuleInfo.class);
            boolean foundApisupport = false;
            for (ModuleInfo info : infos) {
                if (!"org.netbeans.modules.maven.apisupport".equals(info.getCodeNameBase()) || !info.isEnabled()) continue;
                foundApisupport = true;
                break;
            }
            if (!foundApisupport) {
                ProblemReport report = new ProblemReport(5, Bundle.ERR_MissingApisupportModule(), Bundle.MSG_MissingApisupportModule(), null);
                this.addReport(report);
            }
        }
        MavenProject parent = project;
        while (parent != null) {
            parent = this.checkParent(parent);
        }
        this.doArtifactChecks(project);
    }

    private void doArtifactChecks(@NonNull MavenProject project) {
        boolean missingNonSibling = false;
        ArrayList<Artifact> missingJars = new ArrayList<Artifact>();
        for (Artifact art : project.getArtifacts()) {
            File file = art.getFile();
            if (file != null && file.exists()) continue;
            this.addMissingArtifact(art);
            if ("system".equals(art.getScope())) {
                ProblemReport report = new ProblemReport(5, Bundle.ERR_SystemScope(), Bundle.MSG_SystemScope(), new OpenPomAction(this.nbproject));
                this.addReport(report);
                continue;
            }
            if (file == null) {
                missingNonSibling = true;
            } else {
                SourceForBinaryQuery.Result2 result = SourceForBinaryQuery.findSourceRoots2((URL)FileUtil.urlForArchiveOrDir((File)file));
                if (!result.preferSources() || result.getRoots().length == 0) {
                    missingNonSibling = true;
                }
            }
            missingJars.add(art);
        }
        if (!missingJars.isEmpty()) {
            StringBuilder mess = new StringBuilder();
            for (Artifact art : missingJars) {
                mess.append(art.getId()).append('\n');
            }
            ProblemReport report = new ProblemReport(missingNonSibling ? 5 : 10, Bundle.ERR_NonLocal(), Bundle.MSG_NonLocal(mess), new SanityBuildAction(this.nbproject));
            this.addReport(report);
        }
    }

    @CheckForNull
    private MavenProject checkParent(@NonNull MavenProject project) {
        MavenProject parentDecl;
        try {
            parentDecl = project.getParent();
        }
        catch (IllegalStateException x) {
            parentDecl = null;
        }
        if (parentDecl == null) {
            return null;
        }
        Artifact art = project.getParentArtifact();
        if (art != null && "F@LLB@CK".equals(parentDecl.getName())) {
            ProblemReport report = new ProblemReport(0, Bundle.ERR_NoParent(), Bundle.MSG_NoParent(art.getId()), new SanityBuildAction(this.nbproject));
            this.addReport(report);
            this.addMissingArtifact(art);
        }
        return parentDecl;
    }

    static class OpenPomAction
    extends AbstractAction {
        private NbMavenProjectImpl project;
        private String filepath;

        OpenPomAction(NbMavenProjectImpl proj) {
            this.putValue("Name", Bundle.ACT_OpenPom());
            this.project = proj;
        }

        OpenPomAction(NbMavenProjectImpl project, String filePath) {
            this(project);
            this.filepath = filePath;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject fo = null;
            fo = this.filepath != null ? FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.filepath))) : FileUtil.toFileObject((File)this.project.getPOMFile());
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    EditCookie edit = (EditCookie)dobj.getCookie(EditCookie.class);
                    edit.edit();
                }
                catch (DataObjectNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

