/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.io.IOException;
import java.net.URI;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.options.Bundle;
import org.netbeans.modules.maven.options.MavenSettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NetworkSettings;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public class UnsetProxyChecker
implements ExecutionResultChecker {
    private static final String USE_SYSTEM_PROXIES = "-Djava.net.useSystemProxies=true";

    @Override
    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        if (resultCode == 0) {
            return;
        }
        final String proxyHost = NetworkSettings.getProxyHost((URI)URI.create("http://repo1.maven.org/maven2"));
        if (proxyHost == null) {
            return;
        }
        if (!EmbedderFactory.getProjectEmbedder().getSettings().getProxies().isEmpty()) {
            return;
        }
        if (MavenSettings.getDefault().getDefaultOptions().contains(USE_SYSTEM_PROXIES)) {
            return;
        }
        try {
            res.getInputOutput().getOut().println("Check Maven network proxy...", new OutputListener(){

                public void outputLineAction(OutputEvent ev) {
                    UnsetProxyChecker.prompt(proxyHost);
                }

                public void outputLineSelected(OutputEvent ev) {
                }

                public void outputLineCleared(OutputEvent ev) {
                }
            });
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
        }
    }

    private static void prompt(String proxyHost) {
        String opts = MavenSettings.getDefault().getDefaultOptions();
        if (opts.contains(USE_SYSTEM_PROXIES)) {
            return;
        }
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_unset_proxy(proxyHost), Bundle.TITLE_unset_proxy(), 2)) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        MavenSettings.getDefault().setDefaultOptions(opts.isEmpty() ? USE_SYSTEM_PROXIES : opts + ' ' + USE_SYSTEM_PROXIES);
    }
}

