/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.openide.filesystems.FileObject;

public final class ModelUtils {
    private static final String PROBABLE_ROOTS = "maven2|maven[.]repo|content/(?:groups|repositories|shadows)/[^/]+|.+(?=/(?:javax|org|net|com)/)";
    private static Pattern DEFAULT = Pattern.compile("(.+://[^/]+/(?:(?:.+/)?(?:maven2|maven[.]repo|content/(?:groups|repositories|shadows)/[^/]+|.+(?=/(?:javax|org|net|com)/))/)?)(.+)/([^/]+)/([^/]+)/\\3-\\4[.]pom");
    private static Pattern LEGACY = Pattern.compile("(.+/)([^/]+)/poms/([a-zA-Z0-9_]+[a-zA-Z_-]+)-([0-9].+)[.]pom");

    private ModelUtils() {
    }

    public static void addDependency(FileObject pom, final String group, final String artifact, final String version, final String type, final String scope, final String classifier, final boolean acceptNull) {
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
            private static final String BUNDLE_TYPE = "bundle";

            public void performOperation(POMModel model) {
                Dependency dep = ModelUtils.checkModelDependency(model, group, artifact, true);
                dep.setVersion(version);
                if (acceptNull || scope != null) {
                    dep.setScope(scope);
                }
                if (acceptNull || type != null && !BUNDLE_TYPE.equals(type)) {
                    dep.setType(type);
                }
                if (acceptNull || classifier != null) {
                    dep.setClassifier(classifier);
                }
            }
        };
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
    }

    public static Dependency checkModelDependency(POMModel pom, String groupId, String artifactId, boolean add) {
        DependencyManagement mng;
        Project mdl = pom.getProject();
        Dependency ret = mdl.findDependencyById(groupId, artifactId, null);
        Dependency managed = null;
        if ((ret == null || ret.getVersion() == null) && (mng = mdl.getDependencyManagement()) != null) {
            managed = mng.findDependencyById(groupId, artifactId, null);
        }
        if (add && ret == null) {
            ret = mdl.getModel().getFactory().createDependency();
            ret.setGroupId(groupId);
            ret.setArtifactId(artifactId);
            mdl.addDependency(ret);
        }
        return managed == null ? ret : managed;
    }

    public static boolean hasModelDependency(POMModel mdl, String groupid, String artifactid) {
        return ModelUtils.checkModelDependency(mdl, groupid, artifactid, false) != null;
    }

    public static Repository addModelRepository(MavenProject project, POMModel mdl, String url) {
        if (url.contains("http://repo1.maven.org/maven2")) {
            return null;
        }
        List repos = mdl.getProject().getRepositories();
        if (repos != null) {
            for (Repository r : repos) {
                if (!url.equals(r.getUrl())) continue;
                return null;
            }
        }
        List reps = project.getRepositories();
        org.apache.maven.model.Repository prjret = null;
        Repository ret = null;
        if (reps != null) {
            for (org.apache.maven.model.Repository re : reps) {
                if (!url.equals(re.getUrl())) continue;
                prjret = re;
                break;
            }
        }
        if (prjret == null) {
            ret = mdl.getFactory().createRepository();
            ret.setUrl(url);
            ret.setId(url);
            mdl.getProject().addRepository(ret);
        }
        return ret;
    }

    public static void setSourceLevel(POMModel mdl, String sourceLevel) {
        Plugin plugin;
        Plugin old = null;
        Build bld = mdl.getProject().getBuild();
        if (bld != null) {
            old = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        } else {
            mdl.getProject().setBuild(mdl.getFactory().createBuild());
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = mdl.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            mdl.getProject().getBuild().addPlugin(plugin);
        }
        Configuration conf = plugin.getConfiguration();
        if (conf == null) {
            conf = mdl.getFactory().createConfiguration();
            plugin.setConfiguration(conf);
        }
        conf.setSimpleParameter("source", sourceLevel);
        conf.setSimpleParameter("target", sourceLevel);
    }

    public static POMExtensibilityElement getOrCreateChild(POMComponent parent, String localQName, POMModel pomModel) {
        POMExtensibilityElement result = null;
        for (POMExtensibilityElement el : parent.getExtensibilityElements()) {
            if (!localQName.equals(el.getQName().getLocalPart())) continue;
            result = el;
            break;
        }
        if (result == null) {
            result = pomModel.getFactory().createPOMExtensibilityElement(new QName(localQName));
            parent.addExtensibilityElement(result);
        }
        return result;
    }

    @SuppressWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    public static LibraryDescriptor checkLibrary(URL pom) {
        String pomS;
        try {
            pomS = new URL(pom.getProtocol(), pom.getHost(), pom.getPort(), pom.getFile()).toString();
        }
        catch (MalformedURLException x) {
            pomS = pom.toString();
        }
        Matcher m1 = LEGACY.matcher(pomS);
        if (m1.matches()) {
            return new LibraryDescriptor("legacy", m1.group(1), m1.group(2), m1.group(3), m1.group(4), pom.getRef());
        }
        Matcher m2 = DEFAULT.matcher(pomS);
        if (m2.matches()) {
            return new LibraryDescriptor("default", m2.group(1), m2.group(2).replace('/', '.'), m2.group(3), m2.group(4), pom.getRef());
        }
        return null;
    }

    public static class LibraryDescriptor {
        private String repoType;
        private String repoRoot;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;

        LibraryDescriptor(String repoType, String repoRoot, String groupId, String artifactId, String version, String classifier) {
            this.repoType = repoType;
            this.repoRoot = repoRoot;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getRepoRoot() {
            return this.repoRoot;
        }

        public String getRepoType() {
            return this.repoType;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

