/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.NamedLibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class Util {
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static Map<LibraryImplementation, FileObject> sources = new WeakHashMap<LibraryImplementation, FileObject>();

    private Util() {
    }

    @NonNull
    public static String getLocalizedName(LibraryImplementation impl) {
        String proxiedName;
        Object obj;
        if (Util.supportsDisplayName(impl) && ((NamedLibraryImplementation)impl).getDisplayName() != null) {
            return ((NamedLibraryImplementation)impl).getDisplayName();
        }
        FileObject src = sources.get(impl);
        if (src != null && (obj = src.getAttribute("displayName")) instanceof String) {
            return (String)obj;
        }
        if (impl instanceof ProxyLibraryImplementation && (proxiedName = Util.getLocalizedName(((ProxyLibraryImplementation)impl).getOriginal())) != null) {
            return proxiedName;
        }
        return Util.getLocalizedString(impl.getLocalizingBundle(), impl.getName());
    }

    public static boolean supportsDisplayName(@NonNull LibraryImplementation impl) {
        assert (impl != null);
        if (impl instanceof ProxyLibraryImplementation) {
            return Util.supportsDisplayName(((ProxyLibraryImplementation)impl).getOriginal());
        }
        return impl instanceof NamedLibraryImplementation;
    }

    @CheckForNull
    public static String getDisplayName(@NonNull LibraryImplementation impl) {
        return Util.supportsDisplayName(impl) ? ((NamedLibraryImplementation)impl).getDisplayName() : null;
    }

    public static boolean setDisplayName(@NonNull LibraryImplementation impl, @NullAllowed String name) {
        if (Util.supportsDisplayName(impl)) {
            ((NamedLibraryImplementation)impl).setDisplayName(name);
            return true;
        }
        return false;
    }

    public static void registerSource(@NonNull LibraryImplementation impl, @NonNull FileObject descriptorFile) {
        sources.put(impl, descriptorFile);
    }

    private static String getLocalizedString(@NullAllowed String bundleResourceName, @NullAllowed String key) {
        ResourceBundle bundle;
        if (key == null) {
            return null;
        }
        if (bundleResourceName == null) {
            return key;
        }
        try {
            bundle = NbBundle.getBundle((String)bundleResourceName);
        }
        catch (MissingResourceException mre) {
            LOG.log(Level.INFO, "Wrong resource bundle", mre);
            return key;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return key;
        }
    }
}

