/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.project.libraries.LibraryDeclarationConvertorImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationHandlerImpl;
import org.netbeans.modules.project.libraries.LibraryDeclarationParser;
import org.netbeans.modules.project.libraries.LibraryTypeRegistry;
import org.netbeans.modules.project.libraries.Util;
import org.netbeans.modules.project.libraries.WritableLibraryProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LibrariesStorage
extends FileChangeAdapter
implements WritableLibraryProvider<LibraryImplementation>,
ChangeListener {
    private static final String NB_HOME_PROPERTY = "netbeans.home";
    private static final String LIBRARIES_REPOSITORY = "org-netbeans-api-project-libraries/Libraries";
    private static final String TIME_STAMPS_FILE = "libraries-timestamps.properties";
    private static final String XML_EXT = "xml";
    static final Logger LOG = Logger.getLogger(LibrariesStorage.class.getName());
    private static final Object TIMESTAMPS_LOCK = new Object();
    private FileObject storage = null;
    private Libs libs;
    private ResourceBundle bundle;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean initialized;
    private Properties timeStamps;
    private final LibraryTypeRegistry ltRegistry = LibraryTypeRegistry.getDefault();

    public LibrariesStorage() {
        this.ltRegistry.addChangeListener(this);
    }

    LibrariesStorage(FileObject storage) {
        this();
        this.storage = storage;
    }

    private static final FileObject createStorage() {
        try {
            return FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)LIBRARIES_REPOSITORY);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void loadFromStorage(Map<? super String, ? super LibraryImplementation> libraries, Map<? super String, ? super LibraryImplementation> librariesByFileNames) {
        if (this.storage == null) {
            return;
        }
        LibraryDeclarationConvertorImpl convertor = new LibraryDeclarationConvertorImpl();
        for (FileObject descriptorFile : this.storage.getChildren()) {
            if (!XML_EXT.equalsIgnoreCase(descriptorFile.getExt())) continue;
            try {
                LibraryDeclarationHandlerImpl handler = new LibraryDeclarationHandlerImpl();
                LibraryDeclarationParser parser = new LibraryDeclarationParser(handler, convertor);
                LibrariesStorage.readLibrary(descriptorFile, parser);
                LibraryImplementation impl = handler.getLibrary();
                if (impl == null) continue;
                LibraryTypeProvider provider = this.ltRegistry.getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    continue;
                }
                if (libraries.keySet().contains(impl.getName())) {
                    LOG.log(Level.WARNING, "LibrariesStorage: Library \"{0}\" is already defined, skeeping the definition from: {1}", new Object[]{impl.getName(), FileUtil.getFileDisplayName((FileObject)descriptorFile)});
                    continue;
                }
                if (!this.isUpToDate(descriptorFile)) {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(descriptorFile);
                }
                librariesByFileNames.put(descriptorFile.getPath(), impl);
                libraries.put(impl.getName(), impl);
                Util.registerSource(impl, descriptorFile);
            }
            catch (SAXException e) {
                this.logBrokenLibraryDescripor(descriptorFile, e);
            }
            catch (ParserConfigurationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (RuntimeException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        try {
            this.saveTimeStamps();
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Libs initStorage() {
        LibrariesStorage librariesStorage = this;
        synchronized (librariesStorage) {
            if (!this.initialized) {
                if (this.storage == null) {
                    this.storage = LibrariesStorage.createStorage();
                }
                if (this.storage != null) {
                    this.storage.addFileChangeListener((FileChangeListener)this);
                }
                this.initialized = true;
            }
            if (this.libs != null) {
                return this.libs;
            }
        }
        HashMap<String, LibraryImplementation> libraries = new HashMap<String, LibraryImplementation>();
        HashMap<String, LibraryImplementation> librariesByFileNames = new HashMap<String, LibraryImplementation>();
        this.loadFromStorage(libraries, librariesByFileNames);
        LibrariesStorage librariesStorage2 = this;
        synchronized (librariesStorage2) {
            this.libs = new Libs(libraries, librariesByFileNames);
            return this.libs;
        }
    }

    private static LibraryImplementation readLibrary(FileObject descriptorFile) throws SAXException, ParserConfigurationException, IOException {
        return LibrariesStorage.readLibrary(descriptorFile, (LibraryImplementation)null);
    }

    private static LibraryImplementation readLibrary(FileObject descriptorFile, LibraryImplementation impl) throws SAXException, ParserConfigurationException, IOException {
        LibraryDeclarationHandlerImpl handler = new LibraryDeclarationHandlerImpl();
        LibraryDeclarationConvertorImpl convertor = new LibraryDeclarationConvertorImpl();
        LibraryDeclarationParser parser = new LibraryDeclarationParser(handler, convertor);
        handler.setLibrary(impl);
        LibrariesStorage.readLibrary(descriptorFile, parser);
        Util.registerSource(impl, descriptorFile);
        return handler.getLibrary();
    }

    private static void readLibrary(FileObject descriptorFile, LibraryDeclarationParser parser) throws SAXException, ParserConfigurationException, IOException {
        URL baseURL = descriptorFile.getURL();
        InputSource input = new InputSource(baseURL.toExternalForm());
        input.setByteStream(descriptorFile.getInputStream());
        try {
            parser.parse(input);
        }
        catch (SAXException e) {
            throw (SAXException)Exceptions.attachMessage((Throwable)e, (String)("From: " + baseURL));
        }
    }

    private void writeLibrary(final FileObject storage, final LibraryImplementation library) throws IOException {
        storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                String libraryType = library.getType();
                LibraryTypeProvider libraryTypeProvider = LibrariesStorage.this.ltRegistry.getLibraryTypeProvider(libraryType);
                if (libraryTypeProvider == null) {
                    LOG.warning("LibrariesStorage: Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                    return;
                }
                FileObject fo = storage.createData(library.getName(), LibrariesStorage.XML_EXT);
                LibraryDeclarationParser.writeLibraryDefinition(fo, library, libraryTypeProvider);
            }
        });
    }

    private void fireLibrariesChanged() {
        this.support.firePropertyChange("libraries", null, null);
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public final LibraryImplementation[] getLibraries() {
        Libs res = this.initStorage();
        assert (res != null);
        return res.getImpls();
    }

    @Override
    public void addLibrary(LibraryImplementation library) throws IOException {
        this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        this.writeLibrary(this.storage, library);
    }

    @Override
    public void removeLibrary(LibraryImplementation library) throws IOException {
        FileObject fo;
        Libs data = this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        String path = data.findPath(library);
        if (path != null && (fo = this.storage.getFileSystem().findResource(path)) != null) {
            fo.delete();
        }
    }

    @Override
    public void updateLibrary(LibraryImplementation oldLibrary, final LibraryImplementation newLibrary) throws IOException {
        FileObject fo;
        Libs data = this.initStorage();
        assert (this.storage != null) : "Storage is not initialized";
        String path = data.findPath(oldLibrary);
        if (path != null && (fo = this.storage.getFileSystem().findResource(path)) != null) {
            String libraryType = newLibrary.getType();
            final LibraryTypeProvider libraryTypeProvider = this.ltRegistry.getLibraryTypeProvider(libraryType);
            if (libraryTypeProvider == null) {
                LOG.warning("LibrariesStorageL Cannot store library, the library type is not recognized by any of installed LibraryTypeProviders.");
                return;
            }
            this.storage.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                public void run() throws IOException {
                    LibraryDeclarationParser.writeLibraryDefinition(fo, newLibrary, libraryTypeProvider);
                }
            });
        }
    }

    public void fileDataCreated(FileEvent fe) {
        block7: {
            FileObject fo = fe.getFile();
            try {
                Libs data = this.initStorage();
                LibraryImplementation impl = LibrariesStorage.readLibrary(fo);
                if (impl == null) break block7;
                LibraryTypeProvider provider = this.ltRegistry.getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                    break block7;
                }
                data.add(impl.getName(), fo.getPath(), impl);
                try {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(fo);
                    this.saveTimeStamps();
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)message));
                }
                this.fireLibrariesChanged();
            }
            catch (SAXException e) {
                this.logBrokenLibraryDescripor(fo, e);
            }
            catch (ParserConfigurationException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        String fileName = fe.getFile().getPath();
        Libs data = this.initStorage();
        LibraryImplementation impl = data.remove(fileName);
        if (impl != null) {
            LibraryTypeProvider provider = this.ltRegistry.getLibraryTypeProvider(impl.getType());
            if (provider == null) {
                LOG.warning("LibrariesStorage: Cannot invoke LibraryTypeProvider.libraryDeleted(), the library type provider is unknown.");
            } else {
                try {
                    provider.libraryDeleted(impl);
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryDeletedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)message));
                }
            }
            this.fireLibrariesChanged();
        }
    }

    public void fileChanged(FileEvent fe) {
        FileObject definitionFile = fe.getFile();
        String fileName = definitionFile.getPath();
        Libs data = this.initStorage();
        LibraryImplementation impl = data.get(fileName);
        if (impl != null) {
            try {
                LibrariesStorage.readLibrary(definitionFile, impl);
                LibraryTypeProvider provider = this.ltRegistry.getLibraryTypeProvider(impl.getType());
                if (provider == null) {
                    LOG.warning("LibrariesStorage: Can not invoke LibraryTypeProvider.libraryCreated(), the library type provider is unknown.");
                }
                try {
                    provider.libraryCreated(impl);
                    this.updateTimeStamp(definitionFile);
                    this.saveTimeStamps();
                }
                catch (RuntimeException e) {
                    String message = NbBundle.getMessage(LibrariesStorage.class, (String)"MSG_libraryCreatedError");
                    Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)e, (String)message));
                }
            }
            catch (SAXException se) {
                this.logBrokenLibraryDescripor(definitionFile, se);
            }
            catch (ParserConfigurationException pce) {
                Exceptions.printStackTrace((Throwable)pce);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    protected final ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = NbBundle.getBundle(LibrariesStorage.class);
        }
        return this.bundle;
    }

    private boolean isUpToDate(FileObject libraryDefinition) {
        Properties timeStamps = this.getTimeStamps();
        String ts = (String)timeStamps.get(libraryDefinition.getNameExt());
        return ts == null ? false : Long.parseLong(ts) >= libraryDefinition.lastModified().getTime();
    }

    private void updateTimeStamp(FileObject libraryDefinition) {
        Properties timeStamps = this.getTimeStamps();
        timeStamps.put(libraryDefinition.getNameExt(), Long.toString(libraryDefinition.lastModified().getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTimeStamps() throws IOException {
        if (this.storage != null) {
            Object object = TIMESTAMPS_LOCK;
            synchronized (object) {
                FileObject parent;
                FileObject timeStampFile;
                Properties timeStamps = this.getTimeStamps();
                if (timeStamps.get(NB_HOME_PROPERTY) == null) {
                    String currNbLoc = LibrariesStorage.getNBRoots();
                    timeStamps.put(NB_HOME_PROPERTY, currNbLoc);
                }
                if ((timeStampFile = (parent = this.storage.getParent()).getFileObject(TIME_STAMPS_FILE)) == null) {
                    timeStampFile = parent.createData(TIME_STAMPS_FILE);
                }
                FileLock lock = timeStampFile.lock();
                try {
                    OutputStream out = timeStampFile.getOutputStream(lock);
                    try {
                        timeStamps.store(out, null);
                    }
                    finally {
                        out.close();
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Properties getTimeStamps() {
        if (this.timeStamps == null) {
            FileObject timeStampFile;
            this.timeStamps = new Properties();
            if (this.storage != null && (timeStampFile = this.storage.getParent().getFileObject(TIME_STAMPS_FILE)) != null) {
                try {
                    InputStream in = timeStampFile.getInputStream();
                    try {
                        this.timeStamps.load(in);
                    }
                    finally {
                        in.close();
                    }
                    String nbLoc = (String)this.timeStamps.get(NB_HOME_PROPERTY);
                    String currNbLoc = LibrariesStorage.getNBRoots();
                    if (nbLoc == null || !nbLoc.equals(currNbLoc)) {
                        this.timeStamps.clear();
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
        return this.timeStamps;
    }

    private static String getNBRoots() {
        File f;
        TreeSet<String> result = new TreeSet<String>();
        String currentNbLoc = System.getProperty(NB_HOME_PROPERTY);
        if (currentNbLoc != null && (f = FileUtil.normalizeFile((File)new File(currentNbLoc))).isDirectory()) {
            result.add(f.getAbsolutePath());
        }
        if ((currentNbLoc = System.getProperty("netbeans.dirs")) != null) {
            StringTokenizer tok = new StringTokenizer(currentNbLoc, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File f2 = FileUtil.normalizeFile((File)new File(tok.nextToken()));
                result.add(f2.getAbsolutePath());
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append(":");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        LibrariesStorage librariesStorage = this;
        synchronized (librariesStorage) {
            this.libs = null;
        }
        this.fireLibrariesChanged();
    }

    private void logBrokenLibraryDescripor(@NonNull FileObject descriptorFile, @NonNull Exception cause) {
        LOG.log(cause instanceof LibraryDeclarationHandlerImpl.UnknownLibraryTypeException ? Level.INFO : Level.WARNING, "Cannot load library from file {0}, reason: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)descriptorFile), cause.getMessage()});
    }

    private static final class Libs {
        private final Map<String, LibraryImplementation> librariesByName;
        private final Map<String, LibraryImplementation> librariesByPath;

        Libs(Map<String, LibraryImplementation> librariesByName, Map<String, LibraryImplementation> librariesByPath) {
            assert (librariesByName != null);
            assert (librariesByPath != null);
            this.librariesByName = librariesByName;
            this.librariesByPath = librariesByPath;
        }

        synchronized LibraryImplementation[] getImpls() {
            return this.librariesByName.values().toArray(new LibraryImplementation[this.librariesByName.size()]);
        }

        synchronized String findPath(LibraryImplementation library) {
            for (String key : this.librariesByPath.keySet()) {
                LibraryImplementation lib = this.librariesByPath.get(key);
                if (!library.equals(lib)) continue;
                return key;
            }
            return null;
        }

        synchronized void add(String name, String path, LibraryImplementation impl) {
            assert (name != null);
            assert (path != null);
            assert (impl != null);
            this.librariesByName.put(name, impl);
            this.librariesByPath.put(path, impl);
        }

        synchronized LibraryImplementation remove(String path) {
            assert (path != null);
            LibraryImplementation impl = this.librariesByPath.remove(path);
            if (impl != null) {
                this.librariesByName.remove(impl.getName());
            }
            return impl;
        }

        synchronized LibraryImplementation get(String path) {
            assert (path != null);
            return this.librariesByPath.get(path);
        }
    }
}

