/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoring;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.GroovyWhereUsed;
import org.netbeans.modules.groovy.refactoring.RefactoringUtil;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class GroovyRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        boolean folder;
        NonRecursiveFolder pkg = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        FileObject sourceFO = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        TreePathHandle handle = this.resolveTreePathHandle(refactoring);
        GroovyRefactoringElement element = (GroovyRefactoringElement)((Object)refactoring.getRefactoringSource().lookup(GroovyRefactoringElement.class));
        boolean javaPackage = pkg != null && RefactoringUtil.isOnSourceClasspath(pkg.getFolder());
        boolean bl = folder = sourceFO != null && sourceFO.isFolder();
        if (sourceFO == null) {
            if (handle != null) {
                sourceFO = handle.getFileObject();
            } else if (pkg != null) {
                sourceFO = pkg.getFolder();
            } else if (element != null) {
                sourceFO = element.getFileObject();
            }
        }
        if (sourceFO == null) {
            return null;
        }
        boolean supportedFile = sourceFO != null && Utils.isInGroovyProject(sourceFO) && (RefactoringUtil.isJavaFile(sourceFO) || Utils.isGroovyFile(sourceFO));
        String clazz = null;
        if (handle != null) {
            clazz = this.resolveClass(handle);
        } else if (element != null) {
            clazz = element.getDefClass();
        }
        if (supportedFile && clazz == null) {
            return null;
        }
        ArrayList<GroovyRefactoring> refactorings = new ArrayList<GroovyRefactoring>();
        if (refactoring instanceof WhereUsedQuery && supportedFile) {
            WhereUsedQuery whereUsedQuery = (WhereUsedQuery)refactoring;
            refactorings.add(new GroovyWhereUsed(sourceFO, clazz, whereUsedQuery));
        }
        return refactorings.isEmpty() ? null : new GroovyRefactoringPlugin(refactorings);
    }

    private TreePathHandle resolveTreePathHandle(AbstractRefactoring refactoring) {
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph != null) {
            return tph;
        }
        FileObject sourceFO = (FileObject)refactoring.getRefactoringSource().lookup(FileObject.class);
        if (sourceFO == null || !RefactoringUtil.isJavaFile(sourceFO)) {
            return null;
        }
        final TreePathHandle[] result = new TreePathHandle[1];
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)sourceFO);
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController co) throws Exception {
                    co.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cut = co.getCompilationUnit();
                    if (cut.getTypeDecls().isEmpty()) {
                        return;
                    }
                    result[0] = TreePathHandle.create((TreePath)TreePath.getPath(cut, cut.getTypeDecls().get(0)), (CompilationInfo)co);
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }

    private String resolveClass(final TreePathHandle treePathHandle) {
        if (treePathHandle == null) {
            return null;
        }
        final String[] result = new String[1];
        try {
            JavaSource source = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            if (source == null) {
                return null;
            }
            source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController parameter) throws Exception {
                    parameter.toPhase(JavaSource.Phase.RESOLVED);
                    if (treePathHandle != null) {
                        Element element = treePathHandle.resolveElement((CompilationInfo)parameter);
                        result[0] = ((Object)element.asType()).toString();
                    }
                }
            }, true);
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return result[0];
    }
}

