/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ui.NewProjectWizard;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.BasicAction;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class NewProject
extends BasicAction {
    private boolean isPreselect = false;
    private RequestProcessor.Task bodyTask;

    public NewProject() {
        super(NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Name"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/project/ui/resources/newProject.png", (boolean)false));
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newProject.png");
        this.putValue("ShortDescription", NbBundle.getMessage(NewProject.class, (String)"LBL_NewProjectAction_Tooltip"));
        this.bodyTask = new RequestProcessor("NewProjectBody").create(new Runnable(){

            @Override
            public void run() {
                NewProject.this.doPerform();
            }
        });
    }

    public static NewProject newSample() {
        NewProject np = new NewProject();
        np.setDisplayName("New Sample");
        np.isPreselect = true;
        return np;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.bodyTask.schedule(0);
        if ("waitFinished".equals(evt.getActionCommand())) {
            this.bodyTask.waitFinished();
        }
    }

    NewProjectWizard prepareWizardDescriptor(FileObject fo) {
        NewProjectWizard wizard = new NewProjectWizard(fo);
        if (this.isPreselect) {
            wizard.putProperty("PRESELECT_CATEGORY", this.getValue("PRESELECT_CATEGORY"));
            wizard.putProperty("PRESELECT_TEMPLATE", this.getValue("PRESELECT_TEMPLATE"));
        } else {
            wizard.putProperty("PRESELECT_CATEGORY", null);
            wizard.putProperty("PRESELECT_TEMPLATE", null);
        }
        FileObject folder = (FileObject)this.getValue("existingSourcesFolder");
        if (folder != null) {
            wizard.putProperty("existingSourcesFolder", folder);
        }
        return wizard;
    }

    private void doPerform() {
        File prjDir;
        Set newObjects;
        FileObject fo = FileUtil.getConfigFile((String)"Templates/Project");
        final NewProjectWizard wizard = this.prepareWizardDescriptor(fo);
        try {
            newObjects = wizard.instantiate();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return;
        }
        Preferences prefs = NbPreferences.forModule(OpenProjectListSettings.class);
        String nbPrjDirPath = prefs.get("createdProjectsFolderInWizard", null);
        prefs.remove("createdProjectsFolderInWizard");
        if (nbPrjDirPath != null && (prjDir = new File(nbPrjDirPath)).exists() && prjDir.isDirectory() && prjDir.listFiles() != null && prjDir.listFiles().length == 0) {
            prjDir.delete();
        }
        ProjectManager.getDefault().clearNonProjectCache();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectUtilities.WaitCursor.show();
                if (newObjects != null && !newObjects.isEmpty()) {
                    final LinkedList<DataObject> filesToOpen = new LinkedList<DataObject>();
                    LinkedList<Project> projectsToOpen = new LinkedList<Project>();
                    for (Object obj : newObjects) {
                        FileObject newFo;
                        DataObject newDo;
                        block12: {
                            if (obj instanceof DataObject) {
                                newDo = (DataObject)obj;
                                newFo = newDo.getPrimaryFile();
                            } else {
                                if (obj instanceof FileObject) {
                                    newFo = (FileObject)obj;
                                    try {
                                        newDo = DataObject.find((FileObject)newFo);
                                        break block12;
                                    }
                                    catch (DataObjectNotFoundException e) {
                                        ErrorManager.getDefault().notify(1, (Throwable)e);
                                        continue;
                                    }
                                }
                                ErrorManager.getDefault().log(16, "Found unrecognized object " + obj + " in result set from instantiate()");
                                continue;
                            }
                        }
                        if (newFo.isFolder()) {
                            try {
                                Project p = ProjectManager.getDefault().findProject(newFo);
                                if (p != null) {
                                    projectsToOpen.add(p);
                                    continue;
                                }
                                filesToOpen.add(newDo);
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify(1, (Throwable)e);
                            }
                            continue;
                        }
                        filesToOpen.add(newDo);
                    }
                    final Project lastProject = projectsToOpen.size() > 0 ? (Project)projectsToOpen.get(0) : null;
                    Project mainProject = null;
                    if (Templates.getDefinesMainProject((WizardDescriptor)wizard) && lastProject != null) {
                        mainProject = lastProject;
                    }
                    OpenProjectList.getDefault().open(projectsToOpen.toArray(new Project[0]), false, true, mainProject);
                    ProjectUtilities.makeProjectTabVisible();
                    ProjectTab.RP.post(new Runnable(){

                        @Override
                        public void run() {
                            if (lastProject != null) {
                                ProjectUtilities.selectAndExpandProject(lastProject);
                            }
                            for (DataObject d : filesToOpen) {
                                ProjectUtilities.openAndSelectNewObject(d);
                            }
                        }
                    }, 500);
                }
                ProjectUtilities.WaitCursor.hide();
            }
        });
    }
}

