/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.ui.add.AddAction;
import org.netbeans.modules.mercurial.ui.annotate.AnnotateAction;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.status.OpenInEditorAction;
import org.netbeans.modules.mercurial.ui.status.SyncFileNode;
import org.netbeans.modules.mercurial.ui.update.ResolveConflictsAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.NodeTableModel;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

class SyncTable
implements MouseListener,
ListSelectionListener,
AncestorListener,
PropertyChangeListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private SyncFileNode[] nodes = new SyncFileNode[0];
    private String[] tableColumns;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private static final Comparator NodeComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            Node.Property p1 = (Node.Property)o1;
            Node.Property p2 = (Node.Property)o2;
            String sk1 = (String)p1.getValue("sortkey");
            if (sk1 != null) {
                String sk2 = (String)p2.getValue("sortkey");
                return sk1.compareToIgnoreCase(sk2);
            }
            try {
                String s1 = (String)p1.getValue();
                String s2 = (String)p2.getValue();
                return s1.compareToIgnoreCase(s2);
            }
            catch (Exception e) {
                Mercurial.LOG.log(Level.INFO, null, e);
                return 0;
            }
        }
    };

    public SyncTable() {
        ResourceBundle loc = NbBundle.getBundle(SyncTable.class);
        columnLabels.put("branch", new String[]{loc.getString("CTL_VersioningView_Column_Branch_Title"), loc.getString("CTL_VersioningView_Column_Branch_Desc")});
        columnLabels.put("name", new String[]{loc.getString("CTL_VersioningView_Column_File_Title"), loc.getString("CTL_VersioningView_Column_File_Desc")});
        columnLabels.put("status", new String[]{loc.getString("CTL_VersioningView_Column_Status_Title"), loc.getString("CTL_VersioningView_Column_Status_Desc")});
        columnLabels.put("path", new String[]{loc.getString("CTL_VersioningView_Column_Path_Title"), loc.getString("CTL_VersioningView_Column_Path_Desc")});
        this.tableModel = new NodeTableModel();
        this.table = new ETable((TableModel)this.tableModel);
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new SyncTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SyncTable.class, (String)"ACSN_VersioningTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SyncTable.class, (String)"ACSD_VersioningTable"));
        this.setColumns(new String[]{"name", "status", "path"});
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.table.getActionMap().put("org.openide.actions.PopupAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncTable.this.showPopup(Utils.getPositionForPopup((JTable)SyncTable.this.table));
            }
        });
    }

    void setDefaultColumnSizes() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block6: {
                    int width;
                    block5: {
                        width = SyncTable.this.table.getWidth();
                        if (SyncTable.this.tableColumns.length != 3) break block5;
                        for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                            if ("path".equals(SyncTable.this.tableColumns[i])) {
                                SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 60 / 100);
                                continue;
                            }
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                        }
                        break block6;
                    }
                    if (SyncTable.this.tableColumns.length != 4) break block6;
                    for (int i = 0; i < SyncTable.this.tableColumns.length; ++i) {
                        if ("path".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 55 / 100);
                            continue;
                        }
                        if ("branch".equals(SyncTable.this.tableColumns[i])) {
                            SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 20 / 100);
                            continue;
                        }
                        SyncTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(width * 15 / 100);
                    }
                }
            }
        });
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("annotationsChanged".equals(evt.getPropertyName())) {
            this.refreshNodes();
        }
    }

    final void setColumns(String[] columns) {
        if (Arrays.equals(columns, this.tableColumns)) {
            return;
        }
        this.setModelProperties(columns);
        this.tableColumns = columns;
        for (int i = 0; i < columns.length; ++i) {
            ((ETableColumn)this.table.getColumnModel().getColumn(i)).setNestedComparator(NodeComparator);
        }
        this.setDefaultColumnSizes();
    }

    private void setModelProperties(String[] columns) {
        Node.Property[] properties = new Node.Property[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String[] labels = columnLabels.get(column);
            properties[i] = new ColumnDescriptor(column, String.class, labels[0], labels[1]);
        }
        this.tableModel.setProperties(properties);
    }

    void setTableModel(SyncFileNode[] nodes) {
        assert (EventQueue.isDispatchThread());
        Collection<File> selectedFiles = this.getSelectedFiles();
        this.nodes = nodes;
        this.tableModel.setNodes((Node[])nodes);
        this.setSelectedNodes(selectedFiles);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                SyncTable.this.refreshNodes();
            }
        });
    }

    void focus() {
        this.table.requestFocus();
    }

    private void refreshNodes() {
        SyncFileNode[] toRefreshNodes;
        for (SyncFileNode node : toRefreshNodes = this.nodes) {
            node.refresh();
        }
        if (toRefreshNodes.length > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyncTable.this.table.revalidate();
                    SyncTable.this.table.repaint();
                }
            });
        }
    }

    private SyncFileNode[] getSelectedNodes() {
        ArrayList<SyncFileNode> selectedNodes = new ArrayList<SyncFileNode>();
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        if (min != -1) {
            int max = selectionModel.getMaxSelectionIndex();
            for (int i = min; i <= max; ++i) {
                if (!selectionModel.isSelectedIndex(i)) continue;
                selectedNodes.add(this.nodes[this.table.convertRowIndexToModel(i)]);
            }
        }
        return selectedNodes.toArray(new SyncFileNode[selectedNodes.size()]);
    }

    private Collection<File> getSelectedFiles() {
        SyncFileNode[] selectedNodes = this.getSelectedNodes();
        HashSet<File> files = new HashSet<File>(selectedNodes.length);
        for (SyncFileNode node : selectedNodes) {
            files.add(node.getFile());
        }
        return files;
    }

    public final void setSelectedNodes(Collection<File> selectedFiles) {
        ListSelectionModel selection = this.table.getSelectionModel();
        selection.setValueIsAdjusting(true);
        selection.clearSelection();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            SyncFileNode node = this.nodes[this.table.convertRowIndexToModel(i)];
            if (!selectedFiles.contains(node.getFile())) continue;
            selection.addSelectionInterval(i, i);
        }
        selection.setValueIsAdjusting(false);
    }

    private void showPopup(final MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        if (row != -1) {
            boolean makeRowSelected = true;
            int[] selectedrows = this.table.getSelectedRows();
            for (int i = 0; i < selectedrows.length; ++i) {
                if (row != selectedrows[i]) continue;
                makeRowSelected = false;
                break;
            }
            if (makeRowSelected) {
                this.table.getSelectionModel().setSelectionInterval(row, row);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SyncTable.this.table.isShowing()) {
                    JPopupMenu menu = SyncTable.this.getPopup();
                    menu.show(SyncTable.this.table, e.getX(), e.getY());
                }
            }
        });
    }

    private void showPopup(Point p) {
        JPopupMenu menu = this.getPopup();
        menu.show(this.table, p.x, p.y);
    }

    private JPopupMenu getPopup() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(new OpenInEditorAction());
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(DiffAction.class), this.actionString("CTL_PopupMenuItem_Diff")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(AddAction.class), NbBundle.getMessage(AddAction.class, (String)"CTL_PopupMenuItem_Add")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(CommitAction.class), this.actionString("CTL_PopupMenuItem_Commit")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(ResolveConflictsAction.class), this.actionString("CTL_PopupMenuItem_ResolveConflicts")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(AnnotateAction.class), ((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(null) ? this.actionString("CTL_PopupMenuItem_HideAnnotations") : this.actionString("CTL_PopupMenuItem_ShowAnnotations")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        boolean allLocallyDeleted = true;
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        Set files = HgUtils.getCurrentContext(null).getRootFiles();
        for (File file : files) {
            FileInformation info = cache.getStatus(file);
            if (info.getStatus() == 2048 || info.getStatus() == 256) continue;
            allLocallyDeleted = false;
        }
        item = allLocallyDeleted ? menu.add((Action)new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_RevertDelete"))) : menu.add((Action)new SystemActionBridge((Action)SystemAction.get(RevertModificationsAction.class), this.actionString("CTL_PopupMenuItem_GetClean")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        ExcludeFromCommitAction exclude = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class);
        String label = exclude.getActionStatus(null) == 2 ? this.actionString("CTL_PopupMenuItem_IncludeInCommit") : this.actionString("CTL_PopupMenuItem_ExcludeFromCommit");
        item = menu.add((Action)new SystemActionBridge((Action)((Object)exclude), label));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        return menu;
    }

    private String actionString(String key) {
        ResourceBundle actionsLoc = NbBundle.getBundle(MercurialAnnotator.class);
        return actionsLoc.getString(key);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e)) {
            int row = this.table.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Action action = this.nodes[row = this.table.convertRowIndexToModel(row)].getPreferredAction();
            if (action == null || !action.isEnabled()) {
                action = new OpenInEditorAction();
            }
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        final TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.table);
        if (tc == null) {
            return;
        }
        SyncFileNode[] nodeArray = this.getSelectedNodes();
        if (SwingUtilities.isEventDispatchThread()) {
            tc.setActivatedNodes((Node[])nodeArray);
        } else {
            SwingUtilities.invokeLater(new Runnable((Node[])nodeArray){
                final /* synthetic */ Node[] val$nodeArray;
                {
                    this.val$nodeArray = nodeArray;
                }

                @Override
                public void run() {
                    tc.setActivatedNodes(this.val$nodeArray);
                }
            });
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            if (modelColumnIndex == 0) {
                SyncFileNode node = SyncTable.this.nodes[table.convertRowIndexToModel(row)];
                if (!isSelected) {
                    value = "<html>" + node.getHtmlDisplayName();
                }
                if (HgModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    String nodeName = node.getDisplayName();
                    value = isSelected ? "<html><s>" + nodeName + "</s></html>" : "<html><s>" + Mercurial.getInstance().getMercurialAnnotator().annotateNameHtml(nodeName, node.getFileInformation(), null) + "</s>";
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                String path = SyncTable.this.nodes[table.convertRowIndexToModel(row)].getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }

    private static class ColumnDescriptor
    extends PropertySupport.ReadOnly {
        public ColumnDescriptor(String name, Class type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

