/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.ui.diff.DiffSetupSource;
import org.netbeans.modules.mercurial.ui.diff.DiffStreamSource;
import org.netbeans.modules.mercurial.ui.log.DiffTreeTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.ui.log.RevisionNode;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryPanel;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class DiffResultsView
implements AncestorListener,
PropertyChangeListener,
DiffSetupSource {
    protected final SearchHistoryPanel parent;
    protected DiffTreeTable treeView;
    private JSplitPane diffView;
    protected HgProgressSupport currentTask;
    private RequestProcessor.Task currentShowDiffTask;
    protected DiffController currentDiff;
    private int currentDifferenceIndex;
    protected int currentIndex;
    private boolean dividerSet;
    protected List<RepositoryRevision> results;
    private static final RequestProcessor rp = new RequestProcessor("MercurialDiff", 1, true);
    private boolean onSelectionshowLastDifference;

    public DiffResultsView(SearchHistoryPanel parent, List<RepositoryRevision> results) {
        this.parent = parent;
        this.results = results;
        this.treeView = new DiffTreeTable(parent);
        this.treeView.setResults(results);
        this.treeView.addAncestorListener(this);
        this.diffView = new JSplitPane(0);
        this.diffView.setTopComponent((Component)((Object)this.treeView));
        this.setBottomComponent((Component)new NoContentPanel(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions")));
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.addPropertyChangeListener((PropertyChangeListener)this);
        if (!this.dividerSet) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiffResultsView.this.dividerSet = true;
                    DiffResultsView.this.diffView.setDividerLocation(0.33);
                }
            });
        }
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        ExplorerManager em = ExplorerManager.find((Component)((Object)this.treeView));
        em.removePropertyChangeListener((PropertyChangeListener)this);
        this.cancelBackgroundTasks();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            final Node[] nodes = (Node[])evt.getNewValue();
            this.currentDifferenceIndex = 0;
            if (nodes.length == 0) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            if (nodes.length > 2) {
                this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_TooManyRevisions"));
                this.parent.refreshComponents(false);
                return;
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RepositoryRevision container1 = (RepositoryRevision)nodes[0].getLookup().lookup(RepositoryRevision.class);
                    RepositoryRevision.Event r1 = (RepositoryRevision.Event)nodes[0].getLookup().lookup(RepositoryRevision.Event.class);
                    try {
                        DiffResultsView.this.currentIndex = DiffResultsView.this.treeView.getSelection()[0];
                        if (nodes.length == 1) {
                            if (container1 != null) {
                                DiffResultsView.this.showContainerDiff(container1, DiffResultsView.this.onSelectionshowLastDifference);
                            } else if (r1 != null) {
                                DiffResultsView.this.showRevisionDiff(r1, DiffResultsView.this.onSelectionshowLastDifference);
                            }
                        } else if (nodes.length == 2) {
                            RepositoryRevision.Event revOlder = null;
                            if (container1 != null) {
                                RepositoryRevision container2 = (RepositoryRevision)nodes[1].getLookup().lookup(RepositoryRevision.class);
                                r1 = DiffResultsView.this.getEventForRoots(container1, null);
                                revOlder = DiffResultsView.this.getEventForRoots(container2, r1 == null ? null : r1.getFile());
                            } else {
                                revOlder = (RepositoryRevision.Event)nodes[1].getLookup().lookup(RepositoryRevision.Event.class);
                            }
                            if (r1 == null || revOlder == null || revOlder.getFile() == null || !revOlder.isPredecessorFor(r1.getFile())) {
                                throw new Exception();
                            }
                            HgLogMessage.HgRevision revisionOlder = r1.getLogInfoHeader().getLog().getHgRevision();
                            HgLogMessage.HgRevision revisionNewer = revOlder.getLogInfoHeader().getLog().getHgRevision();
                            DiffResultsView.this.showDiff(r1, revisionNewer, revisionOlder, false);
                        }
                    }
                    catch (Exception e) {
                        DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_IllegalSelection"));
                        DiffResultsView.this.parent.refreshComponents(false);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public Collection getSetups() {
        Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
        if (nodes.length == 0) {
            return this.parent.getSetups(this.results.toArray(new RepositoryRevision[this.results.size()]), new RepositoryRevision.Event[0]);
        }
        HashSet<RepositoryRevision.Event> events = new HashSet<RepositoryRevision.Event>();
        HashSet<RepositoryRevision> revisions = new HashSet<RepositoryRevision>();
        for (Node n : nodes) {
            RevisionNode node = (RevisionNode)n;
            if (node.getEvent() != null) {
                events.add(node.getEvent());
                continue;
            }
            revisions.add(node.getContainer());
        }
        return this.parent.getSetups(revisions.toArray(new RepositoryRevision[revisions.size()]), events.toArray(new RepositoryRevision.Event[events.size()]));
    }

    @Override
    public String getSetupDisplayName() {
        return null;
    }

    protected void showDiffError(final String s) {
        Runnable inAWT = new Runnable(){

            @Override
            public void run() {
                DiffResultsView.this.setBottomComponent((Component)new NoContentPanel(s));
            }
        };
        if (EventQueue.isDispatchThread()) {
            inAWT.run();
        } else {
            EventQueue.invokeLater(inAWT);
        }
    }

    protected void setBottomComponent(Component component) {
        assert (EventQueue.isDispatchThread());
        int dl = this.diffView.getDividerLocation();
        this.diffView.setBottomComponent(component);
        this.diffView.setDividerLocation(dl);
    }

    protected HgProgressSupport createShowDiffTask(RepositoryRevision.Event header, HgLogMessage.HgRevision revision1, HgLogMessage.HgRevision revision2, boolean showLastDifference) {
        return new ShowDiffTask(header, revision1, revision2, showLastDifference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDiff(RepositoryRevision.Event header, HgLogMessage.HgRevision revision1, HgLogMessage.HgRevision revision2, boolean showLastDifference) {
        DiffResultsView diffResultsView = this;
        synchronized (diffResultsView) {
            this.cancelBackgroundTasks();
            char action = header.getChangedPath().getAction();
            this.currentTask = action == HgLogMessage.HgModStatus ? this.createShowDiffTask(header, revision1, revision2, showLastDifference) : (action == HgLogMessage.HgAddStatus ? this.createShowDiffTask(header, HgLogMessage.HgRevision.EMPTY, revision2, showLastDifference) : (action == HgLogMessage.HgDelStatus ? this.createShowDiffTask(header, revision1, HgLogMessage.HgRevision.EMPTY, showLastDifference) : (action == HgLogMessage.HgCopyStatus ? this.createShowDiffTask(header, revision1, revision2, showLastDifference) : this.createShowDiffTask(header, revision1, revision2, showLastDifference))));
            this.currentShowDiffTask = this.currentTask.start(rp, header.getLogInfoHeader().getRepositoryRoot(), NbBundle.getMessage(DiffResultsView.class, (String)"LBL_SearchHistory_Diffing"));
        }
    }

    private synchronized void cancelBackgroundTasks() {
        if (this.currentShowDiffTask != null && !this.currentShowDiffTask.isFinished()) {
            this.currentShowDiffTask.cancel();
            this.currentTask.cancel();
        }
    }

    protected void setDiffIndex(int idx, boolean showLastDifference) {
        this.currentIndex = idx;
        this.onSelectionshowLastDifference = showLastDifference;
        this.treeView.setSelection(idx);
    }

    protected void showRevisionDiff(RepositoryRevision.Event rev, boolean showLastDifference) {
        if (rev.getFile() == null) {
            return;
        }
        this.showDiff(rev, null, rev.getLogInfoHeader().getLog().getHgRevision(), showLastDifference);
    }

    protected void showContainerDiff(RepositoryRevision container, boolean showLastDifference) {
        List<RepositoryRevision.Event> revs = container.getEvents();
        RepositoryRevision.Event newest = this.getEventForRoots(container, null);
        if (newest == null) {
            newest = revs.get(0);
        }
        this.showRevisionDiff(newest, showLastDifference);
    }

    private RepositoryRevision.Event getEventForRoots(RepositoryRevision container, File preferedFile) {
        File[] roots;
        RepositoryRevision.Event event = null;
        List<RepositoryRevision.Event> revs = container.getEvents();
        block0: for (File root : roots = this.parent.getRoots()) {
            for (RepositoryRevision.Event evt : revs) {
                if (!evt.isPredecessorFor(root)) continue;
                event = evt;
                if (preferedFile != null && !root.equals(preferedFile)) continue;
                break block0;
            }
        }
        return event;
    }

    void onNextButton() {
        if (this.currentDiff != null) {
            if (++this.currentDifferenceIndex >= this.currentDiff.getDifferenceCount()) {
                if (++this.currentIndex >= this.treeView.getRowCount()) {
                    this.currentIndex = 0;
                }
                this.setDiffIndex(this.currentIndex, false);
            } else {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
                this.parent.updateActions();
            }
        } else {
            if (++this.currentIndex >= this.treeView.getRowCount()) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, false);
        }
    }

    void onPrevButton() {
        if (this.currentDiff != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    this.currentIndex = this.treeView.getRowCount() - 1;
                }
                this.setDiffIndex(this.currentIndex, true);
            } else if (this.currentDifferenceIndex < this.currentDiff.getDifferenceCount()) {
                this.currentDiff.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, this.currentDifferenceIndex);
                this.parent.updateActions();
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.treeView.getRowCount() - 1;
            }
            this.setDiffIndex(this.currentIndex, true);
        }
    }

    boolean isNextEnabled() {
        if (this.currentDiff != null) {
            return this.currentIndex < this.treeView.getRowCount() - 1 || this.currentDifferenceIndex < this.currentDiff.getDifferenceCount() - 1;
        }
        return false;
    }

    boolean isPrevEnabled() {
        return this.currentIndex > 0 || this.currentDifferenceIndex > 0;
    }

    void select(RepositoryRevision.Event revision) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(revision);
    }

    void select(RepositoryRevision container) {
        this.treeView.requestFocusInWindow();
        this.treeView.setSelection(container);
    }

    public JComponent getComponent() {
        return this.diffView;
    }

    private class ShowDiffTask
    extends HgProgressSupport {
        private final RepositoryRevision.Event header;
        private HgLogMessage.HgRevision revision1;
        private final HgLogMessage.HgRevision revision2;
        private boolean showLastDifference;

        public ShowDiffTask(RepositoryRevision.Event header, HgLogMessage.HgRevision revision1, HgLogMessage.HgRevision revision2, boolean showLastDifference) {
            this.header = header;
            this.revision1 = revision1;
            this.revision2 = revision2;
            this.showLastDifference = showLastDifference;
        }

        @Override
        public void perform() {
            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_LoadingDiff"));
            if (this.revision1 == null) {
                this.revision1 = this.header.getLogInfoHeader().getLog().getAncestor(this.header.getOriginalFile());
            }
            if (this.isCanceled()) {
                return;
            }
            final DiffStreamSource s1 = new DiffStreamSource(this.header.getOriginalFile(), this.revision1, this.revision1.getRevisionNumber());
            final DiffStreamSource s2 = new DiffStreamSource(this.header.getFile(), this.revision2, this.revision2.getRevisionNumber());
            s1.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            s2.getMIMEType();
            if (this.isCanceled()) {
                DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                return;
            }
            if (DiffResultsView.this.currentTask != this) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ShowDiffTask.this.isCanceled()) {
                            DiffResultsView.this.showDiffError(NbBundle.getMessage(DiffResultsView.class, (String)"MSG_DiffPanel_NoRevisions"));
                            return;
                        }
                        final DiffController view = DiffController.createEnhanced((StreamSource)s1, (StreamSource)s2);
                        if (DiffResultsView.this.currentTask == ShowDiffTask.this) {
                            DiffResultsView.this.currentDiff = view;
                            DiffResultsView.this.setBottomComponent(DiffResultsView.this.currentDiff.getJComponent());
                            final int dl = DiffResultsView.this.diffView.getDividerLocation();
                            if (!ShowDiffTask.this.setLocation(view)) {
                                view.addPropertyChangeListener(new PropertyChangeListener(){

                                    @Override
                                    public void propertyChange(PropertyChangeEvent evt) {
                                        view.removePropertyChangeListener((PropertyChangeListener)this);
                                        ShowDiffTask.this.setLocation(view);
                                        DiffResultsView.this.parent.updateActions();
                                    }
                                });
                            }
                            DiffResultsView.this.parent.refreshComponents(false);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DiffResultsView.this.diffView.setDividerLocation(dl);
                                }
                            });
                        }
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            });
        }

        private boolean setLocation(DiffController view) {
            boolean locationSet = false;
            if (view == DiffResultsView.this.currentDiff && view.getDifferenceCount() > 0) {
                locationSet = true;
                DiffResultsView.this.currentDifferenceIndex = this.showLastDifference ? view.getDifferenceCount() - 1 : 0;
                view.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.DifferenceIndex, DiffResultsView.this.currentDifferenceIndex);
            }
            return locationSet;
        }
    }
}

