/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.JavaRenameChanger;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

public class JavaClassRenameTransaction
extends RenameTransaction {
    public JavaClassRenameTransaction(Set<FileObject> files, String oldName, String newName) {
        super(files, oldName, newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        JavaRenameChanger renamer = new JavaRenameChanger(false, this.origName, this.newName);
        for (FileObject mappingFileObject : this.getToBeModifiedFiles()) {
            OutputStream outs = null;
            try {
                InputStream is = mappingFileObject.getInputStream();
                HibernateMapping hbMapping = null;
                try {
                    hbMapping = HibernateMapping.createGraph(is);
                }
                catch (RuntimeException ex) {
                    Logger.getLogger(JavaClassRenameTransaction.class.getName()).log(Level.WARNING, "Failed to refactor in {0}, verify if xml document is well formed", mappingFileObject.getPath());
                }
                if (hbMapping == null) continue;
                HibernateRefactoringUtil.ChangeTracker rewriteTrack = new HibernateRefactoringUtil.ChangeTracker();
                hbMapping.addPropertyChangeListener(rewriteTrack);
                renamer.refactoringImports(hbMapping);
                renamer.refactoringMyClasses(hbMapping.getMyClass());
                renamer.refactoringSubclasses(hbMapping.getSubclass());
                renamer.refactoringJoinedSubclasses(hbMapping.getJoinedSubclass());
                renamer.refactoringUnionSubclasses(hbMapping.getUnionSubclass());
                if (rewriteTrack.isChanged()) {
                    outs = mappingFileObject.getOutputStream();
                    hbMapping.write(outs);
                }
                hbMapping.removePropertyChangeListener(rewriteTrack);
            }
            catch (FileAlreadyLockedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                try {
                    if (outs == null) continue;
                    outs.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }
}

