/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimedElementSupport;
import java.io.PrintStream;
import java.util.Vector;

public class TimeContainerSupport
extends TimedElementSupport {
    protected Time simpleTime = Time.UNRESOLVED;
    protected Vector timedElementChildren = new Vector(5);

    public Time getSimpleTime() {
        return this.simpleTime;
    }

    protected void initialize() {
        super.initialize();
        if (this.currentInterval == null) {
            for (int i = 0; i < this.timedElementChildren.size(); ++i) {
                TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
                child.initialize();
            }
        }
    }

    void reset() {
        super.reset();
        for (int i = 0; i < this.timedElementChildren.size(); ++i) {
            TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.removeSyncBaseTimesUnder(this);
        }
    }

    void removeSyncBaseTimesUnder(TimeContainerSupport syncTimeContainer) {
        super.removeSyncBaseTimesUnder(syncTimeContainer);
        for (int i = 0; i < this.timedElementChildren.size(); ++i) {
            TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.removeSyncBaseTimesUnder(syncTimeContainer);
        }
    }

    void sampleAt(long simpleTime) {
        this.setSimpleTime(simpleTime);
        for (int i = 0; i < this.timedElementChildren.size(); ++i) {
            TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            if (this.seeking) {
                child.seeking = true;
                child.sample(this.simpleTime);
                child.seeking = false;
                continue;
            }
            child.sample(this.simpleTime);
        }
    }

    void dispatchEndEvent(Time currentTime) {
        super.dispatchEndEvent(currentTime);
        long time = this.currentInterval.end.value - this.currentInterval.begin.value;
        if (this.simpleDur.isResolved() && time > 0L && (time %= this.simpleDur.value) == 0L) {
            time = this.simpleDur.value;
        }
        this.endChildrenAt(time);
    }

    void dispatchOnNewInterval() {
        super.dispatchOnNewInterval();
        for (int i = 0; i < this.timedElementChildren.size(); ++i) {
            TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.initialize();
        }
    }

    void setSimpleTime(long time) {
        if (this.simpleTime == Time.UNRESOLVED) {
            this.simpleTime = new Time(time);
        } else {
            this.simpleTime.value = time;
        }
    }

    protected void onStartingRepeat(int prevIter, int curIter) {
        long time = this.currentInterval.begin.value + this.simpleDur.value * (long)(prevIter + 1);
        this.endChildrenAt(time);
        for (int i = 0; i < this.timedElementChildren.size(); ++i) {
            TimedElementSupport child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.initialize();
        }
    }

    void endChildrenAt(long time) {
        TimedElementSupport child;
        int i;
        this.setSimpleTime(time);
        for (i = 0; i < this.timedElementChildren.size(); ++i) {
            child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.end();
        }
        for (i = 0; i < this.timedElementChildren.size(); ++i) {
            child = (TimedElementSupport)this.timedElementChildren.elementAt(i);
            child.sample(this.simpleTime);
        }
    }

    void dump() {
        TimeContainerSupport.dump(this, "", System.err);
    }

    static void dump(TimedElementSupport t, String prefix, PrintStream out) {
        out.println(prefix + t);
        if (t instanceof TimeContainerSupport) {
            TimeContainerSupport tc = (TimeContainerSupport)t;
            for (int i = 0; i < tc.timedElementChildren.size(); ++i) {
                TimedElementSupport c = (TimedElementSupport)tc.timedElementChildren.elementAt(i);
                TimeContainerSupport.dump(c, prefix + "+--> ", out);
            }
        }
    }
}

