/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.openide.util.NbBundle;

public class Wrapper {
    private String serverInstanceId;
    private String sessionServerInstanceId;

    public Wrapper(String serverInstanceId) {
        this.serverInstanceId = serverInstanceId;
    }

    public Wrapper(String serverInstanceId, String sessionServerInstanceId) {
        this(serverInstanceId);
        assert ("DEV-NULL".equals(serverInstanceId));
        this.sessionServerInstanceId = sessionServerInstanceId;
    }

    public String getServerInstanceID() {
        return this.serverInstanceId;
    }

    public String getServerID() {
        if ("DEV-NULL".equals(this.serverInstanceId)) {
            return "DEV-NULL";
        }
        return POHImpl.privateGetServerId(this.serverInstanceId);
    }

    public String getSessionServerInstanceId() {
        return this.sessionServerInstanceId;
    }

    public String toString() {
        if ("DEV-NULL".equals(this.serverInstanceId)) {
            if (this.sessionServerInstanceId != null) {
                ServerInstance si = Deployment.getDefault().getServerInstance(this.sessionServerInstanceId);
                String dn = this.sessionServerInstanceId;
                try {
                    dn = si.getDisplayName();
                }
                catch (InstanceRemovedException ex) {
                    return NbBundle.getMessage(Wrapper.class, (String)"MSG_Invalid_Server");
                }
                return NbBundle.getMessage(Wrapper.class, (String)"MSG_No_Permanent_Server", (Object)dn);
            }
            return NbBundle.getMessage(Wrapper.class, (String)"MSG_No_Server");
        }
        ServerInstance si = Deployment.getDefault().getServerInstance(this.serverInstanceId);
        if (si != null) {
            try {
                return si.getDisplayName();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(Wrapper.class.getName()).log(Level.FINE, "", ex);
            }
        }
        return this.serverInstanceId;
    }

    static Wrapper findWrapperByType(String serverId, JComboBox combo) {
        for (int i = 0; i < combo.getModel().getSize(); ++i) {
            Wrapper wr = (Wrapper)combo.getModel().getElementAt(i);
            if (!serverId.equals(wr.getServerID())) continue;
            return wr;
        }
        return null;
    }

    static Wrapper findWrapperByInstance(String instanceId, JComboBox combo) {
        for (int i = 0; i < combo.getModel().getSize(); ++i) {
            Wrapper wr = (Wrapper)combo.getModel().getElementAt(i);
            if (!instanceId.equals(wr.getServerInstanceID())) continue;
            return wr;
        }
        return null;
    }

    public static ComboBoxUpdater<Wrapper> createComboBoxUpdater(final ModelHandle handle, final JComboBox combo, JLabel label) {
        return new ComboBoxUpdater<Wrapper>(combo, label){

            public Wrapper getDefaultValue() {
                return null;
            }

            public Wrapper getValue() {
                Wrapper wr = null;
                String id = handle.getRawAuxiliaryProperty("netbeans.deployment.server.id", false);
                if (id != null) {
                    wr = Wrapper.findWrapperByInstance(id, combo);
                }
                if (wr == null) {
                    POMModel model = handle.getPOMModel();
                    Properties props = model.getProject().getProperties();
                    String str = null;
                    if (props != null) {
                        str = props.getProperty("netbeans.hint.deploy.server");
                    }
                    if (str == null) {
                        str = handle.getRawAuxiliaryProperty("netbeans.deployment.server.type", true);
                    }
                    if (str != null) {
                        wr = Wrapper.findWrapperByType(str, combo);
                    }
                }
                return wr;
            }

            public void setValue(Wrapper wr) {
                if (wr == null) {
                    return;
                }
                String sID = wr.getServerID();
                String iID = wr.getServerInstanceID();
                handle.setRawAuxiliaryProperty("netbeans.deployment.server.type", null, true);
                POMModel model = handle.getPOMModel();
                if ("DEV-NULL".equals(iID)) {
                    Properties props = model.getProject().getProperties();
                    if (props != null) {
                        props.setProperty("netbeans.hint.deploy.server", null);
                        handle.markAsModified((Object)handle.getPOMModel());
                    }
                    handle.setRawAuxiliaryProperty("netbeans.deployment.server.id", null, false);
                } else {
                    Properties props = model.getProject().getProperties();
                    if (props == null) {
                        props = model.getFactory().createProperties();
                        model.getProject().setProperties(props);
                    }
                    props.setProperty("netbeans.hint.deploy.server", sID);
                    handle.markAsModified((Object)handle.getPOMModel());
                    handle.setRawAuxiliaryProperty("netbeans.deployment.server.id", iID, false);
                }
            }
        };
    }
}

