/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.openide.util.Exceptions;

public class J2EEPrerequisitesChecker
implements PrerequisitesChecker,
LateBoundPrerequisitesChecker {
    private List applicableActions = Arrays.asList("run", "run.single.deploy", "debug", "debug.single.deploy");

    public boolean checkRunConfig(RunConfig config) {
        String actionName = config.getActionName();
        if (!this.applicableActions.contains(actionName)) {
            return true;
        }
        J2eeModuleProvider provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            this.checkWarInplace(config, provider);
        }
        return true;
    }

    private void checkWarInplace(RunConfig config, J2eeModuleProvider provider) {
        if (provider instanceof WebModuleProviderImpl) {
            Iterator it = config.getGoals().iterator();
            boolean inplace = false;
            while (it.hasNext()) {
                String goal = (String)it.next();
                if (goal.indexOf(":inplace") <= -1) continue;
                inplace = true;
                break;
            }
            ((WebModuleProviderImpl)provider).getWebModuleImplementation().setWarInplace(inplace);
        }
    }

    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        String actionName = config.getActionName();
        if (!"clean".equals(actionName) && !"rebuild".equals(actionName)) {
            return true;
        }
        J2eeModuleProvider provider = (J2eeModuleProvider)config.getProject().getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null) {
            if ("DEV-NULL".equals(provider.getServerID())) {
                return true;
            }
            try {
                Deployment.getDefault().undeploy(provider, false, (Deployment.Logger)new ExecutionChecker.DLogger(con.getInputOutput().getOut()));
            }
            catch (Deployment.DeploymentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }
}

