/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.notifications;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.internal.tasks.core.notifications.FeedEntry;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    private final Dictionary<Object, Object> environment = new Hashtable<Object, Object>(System.getProperties());

    public Version getFrameworkVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.mylyn");
        if (bundle != null) {
            return bundle.getVersion();
        }
        return Version.emptyVersion;
    }

    public Version getPlatformVersion() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.platform");
        if (bundle == null) {
            bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        }
        if (bundle != null) {
            String versionString = (String)bundle.getHeaders().get("Bundle-Version");
            try {
                return new Version(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Version.emptyVersion;
    }

    public Version getRuntimeVersion() {
        Version result = this.parseRuntimeVersion(System.getProperty("java.runtime.version"));
        if (result == Version.emptyVersion) {
            result = this.parseRuntimeVersion(System.getProperty("java.version"));
        }
        return result;
    }

    public boolean matches(FeedEntry entry, IProgressMonitor monitor) {
        if (!this.matchesVersion(entry.getFilter("frameworkVersion"), this.getFrameworkVersion())) {
            return false;
        }
        if (!this.matchesVersion(entry.getFilter("platformVersion"), this.getPlatformVersion())) {
            return false;
        }
        if (!this.matchesVersion(entry.getFilter("runtimeVersion"), this.getRuntimeVersion())) {
            return false;
        }
        List<String> filterExpressions = entry.getFilters("filter");
        for (String filterExpression : filterExpressions) {
            try {
                Filter filter = FrameworkUtil.createFilter((String)filterExpression);
                if (filter.match(this.environment)) continue;
                return false;
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        List<String> requiredFeatures = entry.getFilters("requires");
        for (String requiredFeature : requiredFeatures) {
            if (this.getInstalledFeatures(monitor).contains(this.parseFeature(requiredFeature))) continue;
            return false;
        }
        List<String> conflictedFeatures = entry.getFilters("conflicts");
        for (String conflictedFeature : conflictedFeatures) {
            if (!this.getInstalledFeatures(monitor).contains(this.parseFeature(conflictedFeature))) continue;
            return false;
        }
        return true;
    }

    private int findLastNumberIndex(String versionString, int secondSeparator) {
        int lastDigit = secondSeparator;
        int i = secondSeparator + 1;
        while (i < versionString.length()) {
            if (!Character.isDigit(versionString.charAt(i))) break;
            ++lastDigit;
            ++i;
        }
        if (lastDigit == secondSeparator) {
            return secondSeparator - 1;
        }
        return lastDigit;
    }

    public Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    private boolean matchesVersion(String expectedVersionRangeExpression, Version actualVersion) {
        if (expectedVersionRangeExpression != null) {
            try {
                VersionRange versionRange = new VersionRange(expectedVersionRangeExpression);
                if (!versionRange.isIncluded(actualVersion)) {
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return true;
    }

    private String parseFeature(String requiredFeature) {
        int i = requiredFeature.indexOf(";");
        if (i != -1) {
            return requiredFeature.substring(0, i);
        }
        return requiredFeature;
    }

    private Version parseRuntimeVersion(String versionString) {
        int firstSeparator;
        if (versionString != null && (firstSeparator = versionString.indexOf(46)) != -1) {
            try {
                int secondSeparator = versionString.indexOf(46, firstSeparator + 1);
                if (secondSeparator != -1) {
                    return new Version(versionString.substring(0, this.findLastNumberIndex(versionString, secondSeparator) + 1));
                }
                return new Version(versionString.substring(0, this.findLastNumberIndex(versionString, firstSeparator) + 1));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Version.emptyVersion;
    }
}

