/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;

public class MavenProtocolHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        Artifact a;
        String path = u.getPath();
        if (!path.startsWith("/")) {
            throw new IOException(path);
        }
        String stuff = path.substring(1);
        MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
        String[] pieces = stuff.split(":");
        if (pieces.length == 4) {
            a = online.createArtifact(pieces[0], pieces[1], pieces[2], pieces[3]);
        } else if (pieces.length == 5) {
            a = online.createArtifactWithClassifier(pieces[0], pieces[1], pieces[2], pieces[3], pieces[4]);
        } else {
            throw new IOException(stuff);
        }
        try {
            online.resolve(a, Collections.singletonList(new MavenArtifactRepository("central", "http://repo1.maven.org/maven2", (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), new ArtifactRepositoryPolicy(), new ArtifactRepositoryPolicy())), online.getLocalRepository());
        }
        catch (Exception x) {
            throw new IOException(stuff + ": " + x, x);
        }
        File f = a.getFile();
        if (!f.isFile()) {
            throw new IOException("failed to download " + stuff);
        }
        Logger.getLogger(MavenProtocolHandler.class.getName()).log(Level.FINE, "resolved {0} -> {1}", new Object[]{stuff, f});
        return f.toURI().toURL().openConnection();
    }
}

