/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.resolution.ModelResolver;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogger;
import org.codehaus.plexus.logging.BaseLoggerManager;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.maven.embedder.EmbedderConfiguration;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.NBRepositoryModelResolver;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;

public final class EmbedderFactory {
    private static final String PROP_COMMANDLINE_PATH = "commandLineMavenPath";
    private static final java.util.logging.Logger LOG = java.util.logging.Logger.getLogger(EmbedderFactory.class.getName());
    private static MavenEmbedder project;
    private static MavenEmbedder online;

    private EmbedderFactory() {
    }

    public static synchronized void resetCachedEmbedders() {
        project = null;
        online = null;
    }

    public static File getDefaultMavenHome() {
        return InstalledFileLocator.getDefault().locate("maven", "org.netbeans.modules.maven.embedder", false);
    }

    private static Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven");
    }

    public static File getMavenHome() {
        String str = EmbedderFactory.getPreferences().get(PROP_COMMANDLINE_PATH, null);
        if (str != null) {
            return FileUtil.normalizeFile((File)new File(str));
        }
        return EmbedderFactory.getDefaultMavenHome();
    }

    public static void setMavenHome(File path) {
        if (path == null || path.equals(EmbedderFactory.getDefaultMavenHome())) {
            EmbedderFactory.getPreferences().remove(PROP_COMMANDLINE_PATH);
        } else {
            EmbedderFactory.getPreferences().put(PROP_COMMANDLINE_PATH, FileUtil.normalizeFile((File)path).getAbsolutePath());
        }
        EmbedderFactory.resetCachedEmbedders();
    }

    private static File getSettingsXml() {
        return new File(EmbedderFactory.getMavenHome(), "conf/settings.xml");
    }

    private static <T> void addComponentDescriptor(DefaultPlexusContainer container, Class<T> roleClass, Class<? extends T> implementationClass, String roleHint) {
        ComponentDescriptor componentDescriptor = new ComponentDescriptor();
        componentDescriptor.setRoleClass(roleClass);
        componentDescriptor.setImplementationClass(implementationClass.asSubclass(roleClass));
        componentDescriptor.setRoleHint(roleHint);
        container.addComponentDescriptor(componentDescriptor);
    }

    @NonNull
    public static MavenEmbedder createProjectLikeEmbedder() throws PlexusContainerException {
        String mavenCoreRealmId = "plexus.core";
        ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
        DefaultPlexusContainer pc = new DefaultPlexusContainer(dpcreq);
        pc.setLoggerManager((LoggerManager)new NbLoggerManager());
        EmbedderFactory.addComponentDescriptor(pc, RepositoryConnectorFactory.class, OfflineConnector.class, "offline");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        EmbedderConfiguration configuration = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.fillEnvVars(props), true, EmbedderFactory.getSettingsXml());
        try {
            return new MavenEmbedder(configuration);
        }
        catch (ComponentLookupException ex) {
            throw new PlexusContainerException(ex.toString(), (Throwable)ex);
        }
    }

    private static void rethrowThreadDeath(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        Throwable t2 = t.getCause();
        if (t2 != null) {
            EmbedderFactory.rethrowThreadDeath(t2);
        }
    }

    @NonNull
    public static synchronized MavenEmbedder getProjectEmbedder() {
        if (project == null) {
            try {
                project = EmbedderFactory.createProjectLikeEmbedder();
            }
            catch (PlexusContainerException ex) {
                EmbedderFactory.rethrowThreadDeath(ex);
                throw new IllegalStateException(ex);
            }
        }
        return project;
    }

    @NonNull
    public static synchronized MavenEmbedder getOnlineEmbedder() {
        if (online == null) {
            try {
                online = EmbedderFactory.createOnlineEmbedder();
            }
            catch (PlexusContainerException ex) {
                EmbedderFactory.rethrowThreadDeath(ex);
                throw new IllegalStateException(ex);
            }
        }
        return online;
    }

    @NonNull
    static MavenEmbedder createOnlineEmbedder() throws PlexusContainerException {
        String mavenCoreRealmId = "plexus.core";
        ContainerConfiguration dpcreq = new DefaultContainerConfiguration().setClassWorld(new ClassWorld("plexus.core", EmbedderFactory.class.getClassLoader())).setName("maven");
        DefaultPlexusContainer pc = new DefaultPlexusContainer(dpcreq);
        pc.setLoggerManager((LoggerManager)new NbLoggerManager());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        EmbedderConfiguration req = new EmbedderConfiguration((PlexusContainer)pc, EmbedderFactory.fillEnvVars(props), false, EmbedderFactory.getSettingsXml());
        try {
            return new MavenEmbedder(req);
        }
        catch (ComponentLookupException ex) {
            throw new PlexusContainerException(ex.toString(), (Throwable)ex);
        }
    }

    public static ArtifactRepository createRemoteRepository(MavenEmbedder embedder, String url, String id) {
        embedder.setUpLegacySupport();
        ArtifactRepositoryFactory fact = embedder.lookupComponent(ArtifactRepositoryFactory.class);
        assert (fact != null) : "ArtifactRepositoryFactory component not found in maven";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, "always", "warn");
        return fact.createArtifactRepository(id, url, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshotsPolicy, releasesPolicy);
    }

    public static List<Model> createModelLineage(File pom, MavenEmbedder embedder) throws ModelBuildingException {
        ModelBuilder mb = embedder.lookupComponent(ModelBuilder.class);
        assert (mb != null) : "ModelBuilder component not found in maven";
        DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
        req.setPomFile(pom);
        req.setProcessPlugins(false);
        req.setValidationLevel(0);
        req.setModelResolver((ModelResolver)new NBRepositoryModelResolver(embedder));
        req.setSystemProperties(embedder.getSystemProperties());
        ModelBuildingResult res = mb.build((ModelBuildingRequest)req);
        ArrayList<Model> toRet = new ArrayList<Model>();
        for (String id : res.getModelIds()) {
            Model m = res.getRawModel(id);
            toRet.add(m);
        }
        return toRet;
    }

    public static Properties fillEnvVars(Properties properties) {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (Utilities.isWindows()) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            properties.setProperty("env." + key, entry.getValue());
        }
        return properties;
    }

    public static final class OfflineConnector
    implements RepositoryConnectorFactory {
        public RepositoryConnector newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
            throw new AssertionError();
        }

        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    }

    private static class NbLoggerManager
    extends BaseLoggerManager {
        private NbLoggerManager() {
        }

        protected Logger createLogger(String name) {
            int level = this.levelOf(LOG).intValue();
            return new NbLogger(level <= Level.FINEST.intValue() ? 0 : (level <= Level.FINER.intValue() ? 1 : (level <= Level.FINE.intValue() ? 2 : 5)), name);
        }

        private Level levelOf(java.util.logging.Logger log) {
            Level lvl = log.getLevel();
            if (lvl != null) {
                return lvl;
            }
            java.util.logging.Logger par = log.getParent();
            if (par != null) {
                return this.levelOf(par);
            }
            return Level.INFO;
        }

        private static class NbLogger
        extends AbstractLogger {
            NbLogger(int threshold, String name) {
                super(threshold, name);
                LOG.log(Level.FINEST, "created Plexus logger {0} at threshold {1}", new Object[]{name, threshold});
            }

            private java.util.logging.Logger logger() {
                return java.util.logging.Logger.getLogger(LOG.getName() + "." + this.getName());
            }

            public void debug(String m, Throwable t) {
                this.logger().log(Level.FINEST, m, t);
            }

            public void info(String m, Throwable t) {
                this.logger().log(Level.FINER, m, t);
            }

            public void warn(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void error(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public void fatalError(String m, Throwable t) {
                this.logger().log(Level.FINE, m, t);
            }

            public Logger getChildLogger(String name) {
                return new NbLogger(this.getThreshold(), this.getName() + "." + name);
            }
        }
    }
}

