/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.results.memory.PresoObjLivenessCCTNode;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class LivenessMemoryResultsSnapshot
extends MemoryResultsSnapshot {
    private static final String MEMORY_LIVENESS_MSG = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.memory.Bundle").getString("LivenessMemoryResultsSnapshot_MemoryLivenessMsg");
    private float[] avgObjectAge;
    private int[] maxSurvGen;
    private int[] nTotalAllocObjects;
    private long[] nTrackedAllocObjects;
    private int[] nTrackedLiveObjects;
    private long[] trackedLiveObjectsSize;
    private int currentEpoch;
    private int nInstrClasses;
    private int nTotalTracked;
    private int nTrackedItems;
    private long maxValue;
    private long nTotalTrackedBytes;

    public LivenessMemoryResultsSnapshot() {
    }

    public LivenessMemoryResultsSnapshot(long beginTime, long timeTaken, MemoryCCTProvider provider, ProfilerClient client) throws ClientUtils.TargetAppOrVMTerminated {
        super(beginTime, timeTaken, provider, client);
    }

    public float[] getAvgObjectAge() {
        return this.avgObjectAge;
    }

    public int[] getMaxSurvGen() {
        return this.maxSurvGen;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public int getNAlloc() {
        return this.nInstrClasses;
    }

    public int getNInstrClasses() {
        return this.nInstrClasses;
    }

    public long getNTotalTracked() {
        return this.nTotalTracked;
    }

    public long getNTotalTrackedBytes() {
        return this.nTotalTrackedBytes;
    }

    public long[] getNTrackedAllocObjects() {
        return this.nTrackedAllocObjects;
    }

    public int getNTrackedItems() {
        return this.nTrackedItems;
    }

    public int[] getNTrackedLiveObjects() {
        return this.nTrackedLiveObjects;
    }

    public long[] getTrackedLiveObjectsSize() {
        return this.trackedLiveObjectsSize;
    }

    public int[] getnTotalAllocObjects() {
        return this.nTotalAllocObjects;
    }

    @Override
    public void performInit(ProfilerClient client, MemoryCCTProvider provider) throws ClientUtils.TargetAppOrVMTerminated {
        int i;
        MemoryCCTProvider.ObjectNumbersContainer onc = provider.getLivenessObjectNumbers();
        int len = onc.nTrackedAllocObjects.length;
        this.nTrackedAllocObjects = new long[len];
        System.arraycopy(onc.nTrackedAllocObjects, 0, this.nTrackedAllocObjects, 0, len);
        len = onc.nTrackedLiveObjects.length;
        this.nTrackedLiveObjects = new int[len];
        System.arraycopy(onc.nTrackedLiveObjects, 0, this.nTrackedLiveObjects, 0, len);
        len = onc.trackedLiveObjectsSize.length;
        this.trackedLiveObjectsSize = new long[len];
        System.arraycopy(onc.trackedLiveObjectsSize, 0, this.trackedLiveObjectsSize, 0, len);
        len = onc.avgObjectAge.length;
        this.avgObjectAge = new float[len];
        System.arraycopy(onc.avgObjectAge, 0, this.avgObjectAge, 0, len);
        len = onc.maxSurvGen.length;
        this.maxSurvGen = new int[len];
        System.arraycopy(onc.maxSurvGen, 0, this.maxSurvGen, 0, len);
        this.nInstrClasses = onc.nInstrClasses;
        int[] tmp = client.getAllocatedObjectsCountResults();
        len = tmp.length;
        this.nTotalAllocObjects = new int[len];
        System.arraycopy(tmp, 0, this.nTotalAllocObjects, 0, len);
        this.nTrackedItems = Math.min(this.nTrackedAllocObjects.length, this.nTrackedLiveObjects.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.trackedLiveObjectsSize.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.avgObjectAge.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.maxSurvGen.length);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nInstrClasses);
        this.nTrackedItems = Math.min(this.nTrackedItems, this.nTotalAllocObjects.length);
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.nTrackedAllocObjects[i] != -1L) continue;
            this.nTotalAllocObjects[i] = 0;
        }
        this.maxValue = 0L;
        this.nTotalTrackedBytes = 0L;
        this.nTotalTracked = 0;
        for (i = 0; i < this.nTrackedItems; ++i) {
            if (this.maxValue < this.trackedLiveObjectsSize[i]) {
                this.maxValue = this.trackedLiveObjectsSize[i];
            }
            this.nTotalTrackedBytes += this.trackedLiveObjectsSize[i];
            this.nTotalTracked += this.nTrackedLiveObjects[i];
        }
        this.currentEpoch = provider.getCurrentEpoch();
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        int i;
        super.readFromStream(in);
        int len = in.readInt();
        this.nTrackedAllocObjects = new long[len];
        for (i = 0; i < len; ++i) {
            this.nTrackedAllocObjects[i] = in.readLong();
        }
        len = in.readInt();
        this.nTrackedLiveObjects = new int[len];
        for (i = 0; i < len; ++i) {
            this.nTrackedLiveObjects[i] = in.readInt();
        }
        len = in.readInt();
        this.maxSurvGen = new int[len];
        for (i = 0; i < len; ++i) {
            this.maxSurvGen[i] = in.readInt();
        }
        len = in.readInt();
        this.trackedLiveObjectsSize = new long[len];
        for (i = 0; i < len; ++i) {
            this.trackedLiveObjectsSize[i] = in.readLong();
        }
        len = in.readInt();
        this.avgObjectAge = new float[len];
        for (i = 0; i < len; ++i) {
            this.avgObjectAge[i] = in.readFloat();
        }
        this.nInstrClasses = in.readInt();
        len = in.readInt();
        this.nTotalAllocObjects = new int[len];
        for (i = 0; i < len; ++i) {
            this.nTotalAllocObjects[i] = in.readInt();
        }
        this.nTrackedItems = in.readInt();
        this.maxValue = in.readLong();
        this.nTotalTrackedBytes = in.readLong();
        this.nTotalTracked = in.readInt();
        this.currentEpoch = in.readInt();
    }

    @Override
    public String toString() {
        return MessageFormat.format(MEMORY_LIVENESS_MSG, super.toString());
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        int i;
        super.writeToStream(out);
        out.writeInt(this.nTrackedAllocObjects.length);
        for (i = 0; i < this.nTrackedAllocObjects.length; ++i) {
            out.writeLong(this.nTrackedAllocObjects[i]);
        }
        out.writeInt(this.nTrackedLiveObjects.length);
        for (i = 0; i < this.nTrackedLiveObjects.length; ++i) {
            out.writeInt(this.nTrackedLiveObjects[i]);
        }
        out.writeInt(this.maxSurvGen.length);
        for (i = 0; i < this.maxSurvGen.length; ++i) {
            out.writeInt(this.maxSurvGen[i]);
        }
        out.writeInt(this.trackedLiveObjectsSize.length);
        for (i = 0; i < this.trackedLiveObjectsSize.length; ++i) {
            out.writeLong(this.trackedLiveObjectsSize[i]);
        }
        out.writeInt(this.avgObjectAge.length);
        for (i = 0; i < this.avgObjectAge.length; ++i) {
            out.writeFloat(this.avgObjectAge[i]);
        }
        out.writeInt(this.nInstrClasses);
        out.writeInt(this.nTotalAllocObjects.length);
        for (i = 0; i < this.nTotalAllocObjects.length; ++i) {
            out.writeInt(this.nTotalAllocObjects[i]);
        }
        out.writeInt(this.nTrackedItems);
        out.writeLong(this.maxValue);
        out.writeLong(this.nTotalTrackedBytes);
        out.writeInt(this.nTotalTracked);
        out.writeInt(this.currentEpoch);
    }

    @Override
    protected PresoObjAllocCCTNode createPresentationCCT(RuntimeMemoryCCTNode rootNode, int classId, boolean dontShowZeroLiveObjAllocPaths) {
        return PresoObjLivenessCCTNode.createPresentationCCTFromSnapshot(this, rootNode, this.getClassName(classId), this.currentEpoch, dontShowZeroLiveObjAllocPaths);
    }

    @Override
    void debugValues() {
        super.debugValues();
        LOGGER.log(Level.FINEST, "nTrackedAllocObjects.length: {0}", this.debugLength(this.nTrackedAllocObjects));
        LOGGER.log(Level.FINEST, "nTrackedLiveObjects.length: {0}", this.debugLength(this.nTrackedLiveObjects));
        LOGGER.log(Level.FINEST, "maxSurvGen.length: {0}", this.debugLength(this.maxSurvGen));
        LOGGER.log(Level.FINEST, "trackedLiveObjectsSize.length: {0}", this.debugLength(this.trackedLiveObjectsSize));
        LOGGER.log(Level.FINEST, "avgObjectAge.length: {0}", this.debugLength(this.avgObjectAge));
        LOGGER.log(Level.FINEST, "nInstrClasses: {0}", this.nInstrClasses);
        LOGGER.log(Level.FINEST, "nTotalAllocObjects.length: {0}", this.debugLength(this.nTotalAllocObjects));
        LOGGER.log(Level.FINEST, "nTrackedItems: {0}", this.nTrackedItems);
        LOGGER.log(Level.FINEST, "maxValue: {0}", this.maxValue);
        LOGGER.log(Level.FINEST, "nTotalTrackedBytes: {0}", this.nTotalTrackedBytes);
        LOGGER.log(Level.FINEST, "nTotalTracked: {0}", this.nTotalTracked);
        LOGGER.log(Level.FINEST, "currentEpoch: {0}", this.currentEpoch);
    }
}

