/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.visitor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.schema.model.visitor.DeepSchemaVisitor;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;

public final class FindSubstitutions {
    private FindSubstitutions() {
    }

    public static Set<GlobalElement> resolveSubstitutions(SchemaModel model, String namespaceUri, String localName) {
        GlobalElement element = model.resolve(namespaceUri, localName, GlobalElement.class);
        if (element == null) {
            return Collections.emptySet();
        }
        return FindSubstitutions.resolveSubstitutions(model, element);
    }

    static Set<GlobalElement> resolveSubstitutions(SchemaModel model, GlobalElement substitutionGroupHead) {
        Schema startSchema = model.getSchema();
        Collection<Schema> schemasToSearch = FindSubstitutions.getSelfAndReferencedSchemas(startSchema);
        Visitor visitor = new Visitor(substitutionGroupHead);
        for (Schema schema : schemasToSearch) {
            schema.accept(visitor);
        }
        return Collections.unmodifiableSet(visitor.substitutions);
    }

    private static Collection<Schema> getSelfAndReferencedSchemas(Schema startSchema) {
        HashSet<Schema> referencedSchemas = new HashSet<Schema>();
        referencedSchemas.add(startSchema);
        FindSubstitutions.collectReferencedSchemas(startSchema, referencedSchemas);
        return referencedSchemas;
    }

    private static void collectReferencedSchemas(Schema start, Set<Schema> schemas) {
        Collection<SchemaModelReference> referencedSchemas = start.getSchemaReferences();
        for (SchemaModelReference reference : referencedSchemas) {
            try {
                SchemaModel referencedModel = reference.resolveReferencedModel();
                Schema referencedSchema = referencedModel.getSchema();
                if (!schemas.add(referencedSchema)) continue;
                FindSubstitutions.collectReferencedSchemas(referencedSchema, schemas);
            }
            catch (CatalogModelException ex) {}
        }
    }

    private static class Visitor
    extends DeepSchemaVisitor {
        private final Set<GlobalElement> substitutions = new LinkedHashSet<GlobalElement>();
        private final GlobalElement substitutionGroupBase;

        private Visitor(GlobalElement substitutionGroupBase) {
            this.substitutionGroupBase = substitutionGroupBase;
        }

        @Override
        public void visit(ElementReference element) {
            NamedComponentReference<GlobalElement> reference = element.getRef();
            if (!reference.isBroken()) {
                this.addIfInSubstitutionGroup((GlobalElement)reference.get());
            }
            super.visit(element);
        }

        @Override
        public void visit(GlobalElement element) {
            this.addIfInSubstitutionGroup(element);
            super.visit(element);
        }

        private void addIfInSubstitutionGroup(GlobalElement potentialSubstitute) {
            GlobalElement referencedSubstitutionGroup;
            boolean hasResolvableSubGroup;
            NamedComponentReference<GlobalElement> substitutionGroupReference = potentialSubstitute.getSubstitutionGroup();
            boolean bl = hasResolvableSubGroup = substitutionGroupReference != null && !substitutionGroupReference.isBroken();
            if (hasResolvableSubGroup && this.substitutionGroupBase.equals(referencedSubstitutionGroup = (GlobalElement)substitutionGroupReference.get())) {
                this.substitutions.add(potentialSubstitute);
            }
        }
    }
}

