/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.api;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.client.tools.api.Log;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class DebugProjectPanel
extends JPanel {
    private static final String WEB_PROJECT = "org.netbeans.modules.web.project.WebProject";
    private static final String RAILS_PROJECT = "org.netbeans.modules.ruby.railsprojects.RailsProject";
    private static final String PHP_PROJECT = "org.netbeans.modules.php.project";
    private String serverDebugMsg;
    private String serverDebugMsgWithMnemonic;
    private Project project;
    private boolean ffBrowserSupported;
    private boolean ieBrowserSupported;
    private ButtonGroup browserButtonGroup;
    private JRadioButton clientServerRadioButton;
    private JLabel debugProjectLabel;
    private JCheckBox doNotShowAgain;
    private JLabel extensionInstallLabel;
    private JRadioButton firefoxRadioButton;
    private JRadioButton ieRadioButton;
    private JLabel jLabel1;
    private ButtonGroup serverClientButtonGroup;
    private JRadioButton serverOnlyRadioButton;

    public DebugProjectPanel(Project project) {
        this.project = project;
        this.initComponentMessages(project);
        this.initComponents();
        this.ffBrowserSupported = WebClientToolsProjectUtils.isFirefoxSupported();
        this.ieBrowserSupported = WebClientToolsProjectUtils.isInternetExplorerSupported();
        this.adjustBrowserRadioButtons(true);
        this.clientServerRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DebugProjectPanel.this.adjustBrowserRadioButtons(false);
            }
        });
    }

    private void initComponentMessages(Project project) {
        String keyMnem;
        String key;
        Project p = (Project)project.getLookup().lookup(Project.class);
        p = p != null ? p : project;
        String className = p.getClass().getName();
        if (className.startsWith(PHP_PROJECT)) {
            key = "DebugProjectPanel_PhpMessage";
            keyMnem = "DebugProjectPanel_PhpMessageMnemonic";
        } else if (className.startsWith(WEB_PROJECT)) {
            key = "DebugProjectPanel_WebMessage";
            keyMnem = "DebugProjectPanel_WebMessageMnemonic";
        } else if (className.startsWith(RAILS_PROJECT)) {
            key = "DebugProjectPanel_RailsMessage";
            keyMnem = "DebugProjectPanel_RailsMessageMnemonic";
        } else {
            key = "DebugProjectPanel_GenericMessage";
            keyMnem = "DebugProjectPanel_GenericMessageMnemonic";
        }
        this.serverDebugMsg = NbBundle.getMessage(DebugProjectPanel.class, (String)key);
        this.serverDebugMsgWithMnemonic = NbBundle.getMessage(DebugProjectPanel.class, (String)keyMnem);
    }

    private void adjustBrowserRadioButtons(boolean init) {
        if (init) {
            boolean isFirefox = WebClientToolsProjectUtils.isFirefox(this.project);
            ButtonModel bm = isFirefox ? this.firefoxRadioButton.getModel() : this.ieRadioButton.getModel();
            this.browserButtonGroup.setSelected(bm, true);
            if (!this.ffBrowserSupported && !this.ieBrowserSupported) {
                this.serverClientButtonGroup.setSelected(this.serverOnlyRadioButton.getModel(), true);
                this.clientServerRadioButton.setEnabled(false);
            } else {
                boolean clientSelected = WebClientToolsProjectUtils.getClientDebugProperty(this.project);
                ButtonModel model = clientSelected ? this.clientServerRadioButton.getModel() : this.serverOnlyRadioButton.getModel();
                this.serverClientButtonGroup.setSelected(model, true);
            }
        }
        this.firefoxRadioButton.setEnabled(this.clientServerRadioButton.isSelected() && this.ffBrowserSupported);
        this.ieRadioButton.setEnabled(this.clientServerRadioButton.isSelected() && this.ieBrowserSupported);
    }

    public ActionListener getPanelCloseHandler(final Object okButton) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == okButton) {
                    boolean clientDebugEnabled = DebugProjectPanel.this.clientServerRadioButton.isSelected();
                    boolean showDialog = !DebugProjectPanel.this.doNotShowAgain.isSelected();
                    WebClientToolsProjectUtils.Browser browser = DebugProjectPanel.this.firefoxRadioButton.isSelected() ? WebClientToolsProjectUtils.Browser.FIREFOX : WebClientToolsProjectUtils.Browser.INTERNET_EXPLORER;
                    WebClientToolsProjectUtils.setProjectProperties(DebugProjectPanel.this.project, true, clientDebugEnabled, browser);
                    Preferences projectPrefs = WebClientToolsProjectUtils.getPreferencesForProject(DebugProjectPanel.this.project);
                    projectPrefs.putBoolean("dialogShowDebugPanel", showDialog);
                    try {
                        projectPrefs.flush();
                    }
                    catch (BackingStoreException ex) {
                        Log.getLogger().log(Level.WARNING, "Could not save preferences", ex);
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.serverClientButtonGroup = new ButtonGroup();
        this.browserButtonGroup = new ButtonGroup();
        this.debugProjectLabel = new JLabel();
        this.serverOnlyRadioButton = new JRadioButton();
        this.clientServerRadioButton = new JRadioButton();
        this.firefoxRadioButton = new JRadioButton();
        this.ieRadioButton = new JRadioButton();
        this.extensionInstallLabel = new JLabel();
        this.doNotShowAgain = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.debugProjectLabel.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.debugProjectLabel.text"));
        this.serverClientButtonGroup.add(this.serverOnlyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.serverOnlyRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.serverOnlyRadioButton.text", (Object[])new Object[]{this.serverDebugMsgWithMnemonic}));
        this.serverClientButtonGroup.add(this.clientServerRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.clientServerRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.clientServerRadioButton.text", (Object[])new Object[]{this.serverDebugMsg}));
        this.browserButtonGroup.add(this.firefoxRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.firefoxRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.firefoxRadioButton.text"));
        this.browserButtonGroup.add(this.ieRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.ieRadioButton, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.ieRadioButton.text"));
        this.extensionInstallLabel.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.extensionInstallLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.doNotShowAgain, (String)NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.doNotShowAgain.text"));
        this.jLabel1.setText(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.jLabel1.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel1)).addComponent(this.doNotShowAgain).addComponent(this.debugProjectLabel).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.clientServerRadioButton).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ieRadioButton).addComponent(this.firefoxRadioButton).addComponent(this.extensionInstallLabel))).addComponent(this.serverOnlyRadioButton)))).addContainerGap(40, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.debugProjectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverOnlyRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clientServerRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.firefoxRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ieRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extensionInstallLabel, -2, 16, -2).addGap(18, 18, 18).addComponent(this.doNotShowAgain).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.serverOnlyRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.serverOnlyRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.clientServerRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.clientServerRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.firefoxRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.firefoxRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.ieRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.ieRadioButton.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
        this.doNotShowAgain.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebugProjectPanel.class, (String)"DebugProjectPanel.doNotShowAgain.AccessibleContext.accessibleDescription", (Object[])new Object[0]));
    }
}

