/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.server.api.providers;

import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.oauth.server.spi.OAuthConsumer;
import com.sun.jersey.oauth.server.spi.OAuthProvider;
import com.sun.jersey.oauth.server.spi.OAuthToken;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;

@Provider
public class DefaultOAuthProvider
implements OAuthProvider {
    private static final ConcurrentHashMap<String, Consumer> consumerByConsumerKey = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Token> accessTokenByTokenString = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Token> requestTokenByTokenString = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> verifierByTokenString = new ConcurrentHashMap();

    @Override
    public Consumer getConsumer(String consumerKey) {
        return consumerByConsumerKey.get(consumerKey);
    }

    public Consumer registerConsumer(String owner, MultivaluedMap<String, String> attributes) {
        Consumer c = new Consumer(this.newUUIDString(), this.newUUIDString(), owner, (Map)attributes);
        consumerByConsumerKey.put(c.getKey(), c);
        return c;
    }

    public Set<Consumer> getConsumers(String owner) {
        HashSet<Consumer> result = new HashSet<Consumer>();
        for (Consumer consumer : consumerByConsumerKey.values()) {
            if (!consumer.getOwner().equals(owner)) continue;
            result.add(consumer);
        }
        return result;
    }

    public Set<Token> getAccessTokens(String principalName) {
        HashSet<Token> tokens = new HashSet<Token>();
        for (Token token : accessTokenByTokenString.values()) {
            if (!principalName.equals(token.getPrincipal().getName())) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public String authorizeToken(Token token, Principal userPrincipal, Set<String> roles) {
        Token authorized = token.authorize(userPrincipal, roles);
        requestTokenByTokenString.put(token.getToken(), authorized);
        String verifier = this.newUUIDString();
        verifierByTokenString.put(token.getToken(), verifier);
        return verifier;
    }

    public void revokeAccessToken(String token, String principalName) {
        Token t = (Token)this.getAccessToken(token);
        if (t != null && t.getPrincipal().getName().equals(principalName)) {
            accessTokenByTokenString.remove(token);
        }
    }

    protected String newUUIDString() {
        String tmp = UUID.randomUUID().toString();
        return tmp.replaceAll("-", "");
    }

    @Override
    public Token getRequestToken(String token) {
        return requestTokenByTokenString.get(token);
    }

    @Override
    public OAuthToken newRequestToken(String consumerKey, String callbackUrl, Map<String, List<String>> attributes) {
        Token rt = new Token(this.newUUIDString(), this.newUUIDString(), consumerKey, callbackUrl, attributes);
        requestTokenByTokenString.put(rt.getToken(), rt);
        return rt;
    }

    @Override
    public OAuthToken newAccessToken(OAuthToken requestToken, String verifier) {
        Token token;
        if (verifier == null || !verifier.equals(verifierByTokenString.remove(requestToken.getToken()))) {
            return null;
        }
        Token token2 = token = requestToken == null ? null : requestTokenByTokenString.remove(requestToken.getToken());
        if (token == null) {
            return null;
        }
        Token at = new Token(this.newUUIDString(), this.newUUIDString(), token);
        accessTokenByTokenString.put(at.getToken(), at);
        return at;
    }

    @Override
    public OAuthToken getAccessToken(String token) {
        return accessTokenByTokenString.get(token);
    }

    protected static MultivaluedMap<String, String> newImmutableMultiMap(Map<String, List<String>> source) {
        if (source == null) {
            return ImmutableMultiMap.EMPTY;
        }
        return new ImmutableMultiMap(source);
    }

    private static class ImmutableMultiMap
    extends MultivaluedMapImpl {
        public static final ImmutableMultiMap EMPTY = new ImmutableMultiMap();

        private ImmutableMultiMap() {
        }

        ImmutableMultiMap(Map<String, List<String>> source) {
            for (Map.Entry<String, List<String>> e : source.entrySet()) {
                super.put((Object)e.getKey(), e.getValue() == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList(e.getValue())));
            }
        }

        public List<String> put(String k, List<String> v) {
            throw new UnsupportedOperationException();
        }

        public Set<Map.Entry<String, List<String>>> entrySet() {
            return Collections.unmodifiableSet(super.entrySet());
        }

        public Set<String> keySet() {
            return Collections.unmodifiableSet(super.keySet());
        }

        public List<String> remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map<? extends String, ? extends List<String>> map) {
            throw new UnsupportedOperationException();
        }

        public Collection<List<String>> values() {
            return Collections.unmodifiableCollection(super.values());
        }
    }

    public class Token
    implements OAuthToken {
        private final String token;
        private final String secret;
        private final String consumerKey;
        private final String callbackUrl;
        private final Principal principal;
        private final Set<String> roles;
        private final MultivaluedMap<String, String> attribs;

        protected Token(String token, String secret, String consumerKey, String callbackUrl, Principal principal, Set<String> roles, MultivaluedMap<String, String> attributes) {
            this.token = token;
            this.secret = secret;
            this.consumerKey = consumerKey;
            this.callbackUrl = callbackUrl;
            this.principal = principal;
            this.roles = roles;
            this.attribs = attributes;
        }

        public Token(String token, String secret, String consumerKey, String callbackUrl, Map<String, List<String>> attributes) {
            this(token, secret, consumerKey, callbackUrl, null, Collections.emptySet(), DefaultOAuthProvider.newImmutableMultiMap(attributes));
        }

        public Token(String token, String secret, Token requestToken) {
            this(token, secret, requestToken.getConsumer().getKey(), null, requestToken.principal, requestToken.roles, (MultivaluedMap<String, String>)ImmutableMultiMap.EMPTY);
        }

        @Override
        public String getToken() {
            return this.token;
        }

        @Override
        public String getSecret() {
            return this.secret;
        }

        @Override
        public OAuthConsumer getConsumer() {
            return DefaultOAuthProvider.this.getConsumer(this.consumerKey);
        }

        @Override
        public MultivaluedMap<String, String> getAttributes() {
            return this.attribs;
        }

        @Override
        public Principal getPrincipal() {
            return this.principal;
        }

        @Override
        public boolean isInRole(String role) {
            return this.roles.contains(role);
        }

        public String getCallbackUrl() {
            return this.callbackUrl;
        }

        protected Token authorize(Principal principal, Set<String> roles) {
            return new Token(this.token, this.secret, this.consumerKey, this.callbackUrl, principal, roles == null ? Collections.emptySet() : new HashSet<String>(roles), this.attribs);
        }
    }

    public static class Consumer
    implements OAuthConsumer {
        private final String key;
        private final String secret;
        private final String owner;
        private final MultivaluedMap<String, String> attribs;

        private Consumer(String key, String secret, String owner, Map<String, List<String>> attributes) {
            this.key = key;
            this.secret = secret;
            this.owner = owner;
            this.attribs = DefaultOAuthProvider.newImmutableMultiMap(attributes);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getSecret() {
            return this.secret;
        }

        public String getOwner() {
            return this.owner;
        }

        public MultivaluedMap<String, String> getAttributes() {
            return this.attribs;
        }

        @Override
        public Principal getPrincipal() {
            return null;
        }

        @Override
        public boolean isInRole(String role) {
            return false;
        }
    }
}

