/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.BaseHelper;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.LayerXmlHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaMELibsConfigurationHelper
extends BaseHelper {
    public static final String TEMPLATE_LIB_DESCR = "libdescriptemplate.xml";
    public static final String VOLUME_CLASS = "classpath";
    public static final String VOLUME_SRC = "src";
    public static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIB_EXTRACT_RELEASE = "release/";
    public static final String LIB_EXTRACT_PATH_LIBS = "release/libs/";
    public static final String LIB_EXTRACT_SOURCES = "release/sources/";
    public static final String LIB_EXTRACT_DOCS = "release/docs/";
    public static final String FILE_PROTOCOL = "file";
    private static final String LAYER_RESOURCE = "resource";
    private static final String LAYER_TAG_LIBRARIES_ROOT = "org-netbeans-api-project-libraries";
    private static final String LAYER_TAG_LIBRARIES = "Libraries";
    private static final String LAYER_TAG_RESOURCE_OPEN = "<resource>";
    private static final String LAYER_TAG_RESOURCE_CLOSE = "</resource>";
    private static final String LAYER_XPATH_LIBRARIES_ROOT = "./folder[@name=\"org-netbeans-api-project-libraries\"]";
    private static final String LAYER_XPATH_LIBRARIES = "./folder[@name=\"Libraries\"]";
    private static final String TPL_TOKEN_NAME = "NAME";
    private static final String TPL_TOKEN_BUNDLE = "BUNDLE";
    private static final String TPL_TOKEN_CLASSPATH = "CLASSPATH";
    private static final String TPL_TOKEN_SRC = "SRC";
    private static final String TPL_TOKEN_JAVADOC = "JAVADOC";

    public static void configureJavaMELibs(Project project, WizardDescriptor wizard) throws IOException {
        List libDisplayNames;
        List libNames;
        List libraries = (List)wizard.getProperty("libraries");
        if (!JavaMELibsConfigurationHelper.haveLibsToConfigure(libraries, libNames = (List)wizard.getProperty("libNames"), libDisplayNames = (List)wizard.getProperty("libDisplayNames"))) {
            return;
        }
        assert (wizard.getProperty("bundle") != null && wizard.getProperty("layer") != null && wizard.getProperty("codeBaseName") != null) : "Some properties necessary for lib configuration are absent";
        Iterator itLib = libraries.iterator();
        Iterator itName = libNames.iterator();
        Iterator itDName = libDisplayNames.iterator();
        while (itLib.hasNext()) {
            Library library = (Library)itLib.next();
            String name = (String)itName.next();
            String displayName = (String)itDName.next();
            JavaMELibsConfigurationHelper.configureLibrary(library, name, displayName, project, wizard);
        }
    }

    private static void configureLibrary(Library library, String name, String displayName, Project project, WizardDescriptor wizard) throws IOException {
        FileObject template = JavaMELibsConfigurationHelper.getTemplate(TEMPLATE_LIB_DESCR);
        Map<String, String> tokens = JavaMELibsConfigurationHelper.getTokens(library, name, project, wizard);
        JavaMELibsConfigurationHelper.configureLibXml(template, tokens, name, project, wizard);
        JavaMELibsConfigurationHelper.configureLayerXml(name, project, wizard);
        JavaMELibsConfigurationHelper.configureBundle(name, displayName, project, wizard);
    }

    private static void configureLibXml(FileObject template, Map<String, String> tokens, String libName, Project project, WizardDescriptor wizard) throws IOException {
        String codeNameBase = ((String)wizard.getProperty("codeBaseName")).replace('.', '/');
        String xmlPath = "src/" + codeNameBase + "/" + libName + ".xml";
        JavaMELibsConfigurationHelper.doCopyFile(project.getProjectDirectory(), xmlPath, template, tokens);
    }

    private static void configureBundle(String libName, String libDisplayName, Project project, WizardDescriptor wizard) throws IOException {
        String bundlePath = "src/" + (String)wizard.getProperty("bundle");
        FileObject prjDir = project.getProjectDirectory();
        FileObject bundleFO = FileUtil.createData((FileObject)prjDir, (String)bundlePath);
        EditableProperties ep = JavaMELibsConfigurationHelper.loadProperties(bundleFO);
        ep.setProperty(libName, libDisplayName);
        JavaMELibsConfigurationHelper.storeProperties(bundleFO, ep);
    }

    private static void configureLayerXml(String libName, Project project, WizardDescriptor wizard) throws IOException {
        String codeNameBase = ((String)wizard.getProperty("codeBaseName")).replace('.', '/');
        String layerXmlPath = "src/" + codeNameBase + "/" + "layer.xml";
        FileObject prjDir = project.getProjectDirectory();
        FileObject layerXmlFO = FileUtil.createData((FileObject)prjDir, (String)layerXmlPath);
        try {
            Document doc = LayerXmlHelper.parseXmlDocument(layerXmlFO);
            Element docRoot = doc.getDocumentElement();
            XPath xpath = XPathFactory.newInstance().newXPath();
            Node fsNode = LayerXmlHelper.goToFilesystemNode(doc, xpath, docRoot);
            Node libsAreaNode = JavaMELibsConfigurationHelper.goToLibsRootNode(doc, xpath, fsNode);
            Node libsNode = JavaMELibsConfigurationHelper.goToLibsNode(doc, xpath, libsAreaNode);
            Element library = doc.createElement("folder");
            library.setAttribute("name", libName + ".xml");
            library.setAttribute("url", libName + ".xml");
            libsNode.appendChild(library);
            LayerXmlHelper.saveXmlDocument(doc, layerXmlFO);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static Node goToLibsRootNode(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
        String expression = LAYER_XPATH_LIBRARIES_ROOT;
        Node libsAreaNode = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
        if (libsAreaNode == null) {
            Element libsAreaElement = doc.createElement("folder");
            libsAreaElement.setAttribute("name", LAYER_TAG_LIBRARIES_ROOT);
            parent.appendChild(libsAreaElement);
            libsAreaNode = libsAreaElement;
        }
        return libsAreaNode;
    }

    private static Node goToLibsNode(Document doc, XPath xpath, Node parent) throws XPathExpressionException {
        String expression = LAYER_XPATH_LIBRARIES;
        Node libsNode = (Node)xpath.evaluate(expression, parent, XPathConstants.NODE);
        if (libsNode == null) {
            Element libsElement = doc.createElement("folder");
            libsElement.setAttribute("name", LAYER_TAG_LIBRARIES);
            parent.appendChild(libsElement);
            libsNode = libsElement;
        }
        return libsNode;
    }

    private static Map<String, String> getTokens(Library library, String libName, Project project, WizardDescriptor wizard) throws IOException {
        HashMap<String, String> retval = new HashMap<String, String>();
        retval.put(TPL_TOKEN_NAME, libName);
        String bundle = ((String)wizard.getProperty("bundle")).replace('/', '.');
        retval.put(TPL_TOKEN_BUNDLE, bundle);
        Iterator<URL> it = library.getContent(VOLUME_CLASS).iterator();
        retval.put(TPL_TOKEN_CLASSPATH, JavaMELibsConfigurationHelper.getTokenSubstitution(it, LIB_EXTRACT_PATH_LIBS, libName, project, wizard));
        it = library.getContent(VOLUME_SRC).iterator();
        retval.put(TPL_TOKEN_SRC, JavaMELibsConfigurationHelper.getTokenSubstitution(it, LIB_EXTRACT_SOURCES, libName, project, wizard));
        it = library.getContent(VOLUME_JAVADOC).iterator();
        retval.put(TPL_TOKEN_JAVADOC, JavaMELibsConfigurationHelper.getTokenSubstitution(it, LIB_EXTRACT_DOCS, libName, project, wizard));
        return retval;
    }

    private static String getTokenSubstitution(Iterator<URL> it, String pathPrefix, String libName, Project project, WizardDescriptor wizard) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            URL originalURL = it.next();
            String archiveName = JavaMELibsConfigurationHelper.addArchiveToCopy(originalURL, pathPrefix, project, libName);
            if (archiveName == null) continue;
            String codeNameBase = (String)wizard.getProperty("codeBaseName");
            String urlToString = JavaMELibsConfigurationHelper.transformURL(codeNameBase, pathPrefix, archiveName);
            sb.append(LAYER_TAG_RESOURCE_OPEN);
            sb.append(urlToString);
            sb.append(LAYER_TAG_RESOURCE_CLOSE);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String addArchiveToCopy(URL originalURL, String pathPrefix, Project project, String libName) throws IOException {
        FileObject folderToZip;
        String archName = null;
        URL archivURL = FileUtil.getArchiveFile((URL)originalURL);
        if (archivURL != null && FileUtil.isArchiveFile((URL)archivURL)) {
            FileObject archiv = URLMapper.findFileObject((URL)archivURL);
            if (archiv != null) {
                archName = archiv.getNameExt();
                JavaMELibsConfigurationHelper.doCopyFile(project.getProjectDirectory(), pathPrefix + archName, archiv, null);
            }
        } else if (FILE_PROTOCOL.equals(originalURL.getProtocol()) && (folderToZip = URLMapper.findFileObject((URL)originalURL)) != null) {
            archName = libName + ".zip";
            pathPrefix = pathPrefix + archName;
            JavaMELibsConfigurationHelper.doZipAndCopyFolder(project, pathPrefix + archName, folderToZip);
        }
        return archName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doZipAndCopyFolder(Project project, String target, FileObject source) throws IOException {
        ArrayList files = Collections.list(source.getChildren(true));
        if (files.isEmpty()) {
            return;
        }
        FileObject prjDir = project.getProjectDirectory();
        assert (prjDir != null);
        FileObject zipedTarget = prjDir.getFileObject(target);
        if (zipedTarget == null) {
            zipedTarget = FileUtil.createData((FileObject)prjDir, (String)target);
        }
        assert (zipedTarget != null);
        FileLock fLock = null;
        OutputStream os = null;
        try {
            fLock = zipedTarget.lock();
            os = zipedTarget.getOutputStream(fLock);
            JavaMELibsConfigurationHelper.createZipFile(os, source, files);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (fLock != null) {
                fLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(OutputStream target, FileObject root, Collection<? extends FileObject> files) throws IOException {
        ZipOutputStream str = null;
        try {
            str = new ZipOutputStream(target);
            for (FileObject fileObject : files) {
                String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fileObject);
                if (fileObject.isFolder()) {
                    if (fileObject.getChildren().length > 0) continue;
                    if (!relativePath.endsWith("/")) {
                        relativePath = relativePath + "/";
                    }
                }
                ZipEntry entry = new ZipEntry(relativePath);
                str.putNextEntry(entry);
                if (fileObject.isData()) {
                    InputStream in = null;
                    try {
                        in = fileObject.getInputStream();
                        FileUtil.copy((InputStream)in, (OutputStream)str);
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                str.closeEntry();
            }
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
    }

    private static String transformURL(String cnb, String pathPrefix, String archiveName) {
        StringBuffer sb = new StringBuffer();
        sb.append("jar:nbinst://").append(cnb).append("/");
        sb.append(pathPrefix).append(archiveName).append("!/");
        return sb.toString();
    }

    private static boolean haveLibsToConfigure(List<Library> libraries, List<String> libNames, List<String> libDisplayNames) {
        if (libraries == null || libNames == null || libDisplayNames == null) {
            return false;
        }
        assert (libraries.size() == libNames.size() && libraries.size() == libDisplayNames.size() && libDisplayNames.size() == libNames.size()) : "libraries data is not consistent";
        return libraries.size() != 0;
    }
}

