/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.helpers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.apisupport.project.ui.wizard.spi.ModuleTypePanel;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataObject;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

public class BaseHelper {
    public static final String EXAMPLE_BASE_NAME = "org.<yourorghere>.";
    public static final String SYSTEM_USER = "user.name";
    public static final String NULL = "null";
    public static final String UTF_8 = "UTF-8";
    public static final String XML_EXTENSION = ".xml";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String JAVA_EXTENSION = ".java";
    public static final String RESOURCES = "resources";
    public static final String DESCRIPTORS = "descriptors";
    public static final String PRODUCERS = "producers";
    public static final String SRC = "src/";
    public static final String BUNDLE_PROPERTIES = "Bundle.properties";
    public static final String LAYER_XML = "layer.xml";
    private static final String TEMPLATES_LAYER_FOLDER = "Templates/MobilityCustomComponent-files/";
    private static final String TPL_ENGINE = "freemarker";
    private static final String TPL_TOKEN_NAME_LOWER = "name";
    private static final String TPL_TOKEN_USER = "user";
    private static final String TPL_TOKEN_DATE = "date";
    private static final String TPL_TOKEN_TIME = "time";
    private static final String TPL_TOKEN_NAME_AND_EXT = "nameAndExt";
    private static final String TPL_TOKEN_ENCODING = "encoding";

    public static String getDefaultCodeNameBase(String projectName) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableProperties loadProperties(FileObject propsFO) throws IOException {
        InputStream propsIS = propsFO.getInputStream();
        EditableProperties props = new EditableProperties(true);
        try {
            props.load(propsIS);
        }
        finally {
            propsIS.close();
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(FileObject propsFO, EditableProperties props) throws IOException {
        FileLock lock = propsFO.lock();
        try {
            OutputStream os = propsFO.getOutputStream(lock);
            try {
                props.store(os);
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public static FileObject getTemplate(String name) {
        FileObject f = FileUtil.getConfigFile((String)(TEMPLATES_LAYER_FOLDER + name));
        assert (f != null) : name;
        return f;
    }

    public static FileObject doCopyFile(FileObject folder, String targetPath, FileObject content, Map<String, String> tokens) throws IOException {
        FileObject target = FileUtil.createData((FileObject)folder, (String)targetPath);
        if (tokens == null) {
            BaseHelper.copyByteAfterByte(content, target);
        } else {
            BaseHelper.copyAndSubstituteTokens(content, target, tokens);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyByteAfterByte(FileObject source, FileObject target) throws IOException {
        InputStream is = source.getInputStream();
        try {
            BaseHelper.copyByteAfterByte(is, target);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyByteAfterByte(File source, FileObject target) throws IOException {
        FileInputStream is = new FileInputStream(source);
        try {
            BaseHelper.copyByteAfterByte(is, target);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyByteAfterByte(String source, FileObject target) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(source.getBytes(UTF_8));
        try {
            BaseHelper.copyByteAfterByte(is, target);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyByteAfterByte(InputStream is, FileObject target) throws IOException {
        OutputStream out = target.getOutputStream();
        try {
            FileUtil.copy((InputStream)is, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    public static String normalizeCNB(String value) {
        StringTokenizer tk = new StringTokenizer(value.toLowerCase(Locale.ENGLISH), ".", true);
        StringBuffer normalizedCNB = new StringBuffer();
        boolean delimExpected = false;
        while (tk.hasMoreTokens()) {
            String namePart = tk.nextToken();
            if (!delimExpected) {
                if (namePart.equals(".")) continue;
                for (int i = 0; i < namePart.length(); ++i) {
                    char c = namePart.charAt(i);
                    if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) continue;
                    normalizedCNB.append(c);
                }
            } else if (namePart.equals(".")) {
                normalizedCNB.append(namePart);
            }
            delimExpected = !delimExpected;
        }
        return normalizedCNB.toString().replaceAll("\\.$", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyAndSubstituteTokens(FileObject content, FileObject target, Map<String, String> tokens) throws IOException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine engine = scriptEngineManager.getEngineByName(TPL_ENGINE);
        assert (engine != null) : scriptEngineManager.getEngineFactories();
        Bindings bindings = engine.getContext().getBindings(100);
        String basename = target.getName();
        for (CreateFromTemplateAttributesProvider provider : Lookup.getDefault().lookupAll(CreateFromTemplateAttributesProvider.class)) {
            DataObject d;
            Map map = provider.attributesFor(d = DataObject.find((FileObject)content), d.getFolder(), basename);
            if (map == null) continue;
            bindings.putAll(map);
        }
        bindings.put(TPL_TOKEN_NAME_LOWER, basename.replaceFirst("\\.[^./]+$", ""));
        bindings.put(TPL_TOKEN_USER, System.getProperty(SYSTEM_USER));
        Date d = new Date();
        bindings.put(TPL_TOKEN_DATE, DateFormat.getDateInstance().format(d));
        bindings.put(TPL_TOKEN_TIME, DateFormat.getTimeInstance().format(d));
        bindings.put(TPL_TOKEN_NAME_AND_EXT, target.getNameExt());
        bindings.putAll(tokens);
        Charset targetEnc = FileEncodingQuery.getEncoding((FileObject)target);
        Charset sourceEnc = FileEncodingQuery.getEncoding((FileObject)content);
        bindings.put(TPL_TOKEN_ENCODING, targetEnc.name());
        Writer w = new OutputStreamWriter(target.getOutputStream(), targetEnc);
        try {
            IndentEngine format = IndentEngine.find((String)content.getMIMEType());
            if (format != null) {
                PlainDocument doc = new PlainDocument();
                doc.putProperty("stream", content);
                w = format.createWriter((Document)doc, 0, w);
            }
            engine.getContext().setWriter(w);
            engine.getContext().setAttribute(FileObject.class.getName(), content, 100);
            engine.getContext().setAttribute("javax.script.filename", content.getNameExt(), 100);
            InputStreamReader is = new InputStreamReader(content.getInputStream(), sourceEnc);
            try {
                engine.eval(is);
            }
            catch (ScriptException x) {
                throw (IOException)new IOException(x.toString()).initCause(x);
            }
            finally {
                ((Reader)is).close();
            }
        }
        finally {
            w.close();
        }
    }

    public static boolean isSuiteComponent(WizardDescriptor wizard) {
        return ModuleTypePanel.isSuiteComponent((WizardDescriptor)wizard);
    }

    public static boolean isStandalone(WizardDescriptor wizard) {
        return ModuleTypePanel.isStandalone((WizardDescriptor)wizard);
    }

    public static boolean isNetBeansOrg(WizardDescriptor wizard) {
        return ModuleTypePanel.isNetBeansOrg((WizardDescriptor)wizard);
    }

    public static String getSuiteRoot(WizardDescriptor wizard) {
        return ModuleTypePanel.getSuiteRoot((WizardDescriptor)wizard);
    }

    public static String getActivePlatform(WizardDescriptor wizard) {
        return ModuleTypePanel.getActivePlatformId((WizardDescriptor)wizard);
    }
}

