/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.git;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.git.Bundle;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HudsonGitSCM
implements HudsonSCM {
    private static final Logger LOG = Logger.getLogger(HudsonGitSCM.class.getName());

    public HudsonSCM.Configuration forFolder(File folder) {
        if (!new File(folder, ".git").isDirectory()) {
            return null;
        }
        final URI origin = HudsonGitSCM.getRemoteOrigin(folder.toURI(), null);
        final String replacement = origin != null ? HudsonGitSCM.roReplacement(origin.toString()) : folder.getAbsolutePath();
        return new HudsonSCM.Configuration(){

            public void configure(Document doc) {
                Element root = doc.getDocumentElement();
                Element configXmlSCM = (Element)root.appendChild(doc.createElement("scm"));
                configXmlSCM.setAttribute("class", "hudson.plugins.git.GitSCM");
                configXmlSCM.appendChild(doc.createElement("source")).appendChild(doc.createTextNode(replacement != null ? replacement : origin.toString()));
                HudsonSCM.Helper.addTrigger((Document)doc);
            }

            public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems() {
                if (origin == null) {
                    return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withWarning((String)Bundle.warning_local_repo(replacement));
                }
                if (replacement != null) {
                    return ProjectHudsonJobCreatorFactory.ConfigurationStatus.withWarning((String)Bundle.ro_replacement(origin, replacement));
                }
                return null;
            }
        };
    }

    public String translateWorkspacePath(HudsonJob job, String workspacePath, File localRoot) {
        return null;
    }

    public List<? extends HudsonJobChangeItem> parseChangeSet(HudsonJobBuild build) {
        Element changeSet;
        try {
            changeSet = XMLUtil.findElement((Element)new ConnectionBuilder().job(build.getJob()).url(build.getUrl() + "api/xml?tree=changeSet[items[id,author[fullName],msg,paths[file,editType]]]").parseXML().getDocumentElement(), (String)"changeSet", null);
        }
        catch (IOException x) {
            LOG.log(Level.WARNING, "could not parse changelog for {0}: {1}", new Object[]{build, x});
            return Collections.emptyList();
        }
        class GitItem
        implements HudsonJobChangeItem {
            final Element itemXML;

            GitItem(Element itemXML) {
                this.itemXML = itemXML;
            }

            public String getUser() {
                return Utilities.xpath((String)"author/fullName", (Element)this.itemXML);
            }

            public String getMessage() {
                return Utilities.xpath((String)"msg", (Element)this.itemXML);
            }

            public Collection<? extends HudsonJobChangeItem.HudsonJobChangeFile> getFiles() {
                class GitFile
                implements HudsonJobChangeItem.HudsonJobChangeFile {
                    final Element fileXML;

                    GitFile(Element fileXML) {
                        this.fileXML = fileXML;
                    }

                    public String getName() {
                        return Utilities.xpath((String)"file", (Element)this.fileXML);
                    }

                    public HudsonJobChangeItem.HudsonJobChangeFile.EditType getEditType() {
                        return HudsonJobChangeItem.HudsonJobChangeFile.EditType.valueOf((String)Utilities.xpath((String)"editType", (Element)this.fileXML));
                    }

                    public OutputListener hyperlink() {
                        return null;
                    }
                }
                ArrayList<GitFile> files = new ArrayList<GitFile>();
                NodeList nl = this.itemXML.getElementsByTagName("path");
                for (int i = 0; i < nl.getLength(); ++i) {
                    files.add(new GitFile((Element)nl.item(i)));
                }
                return files;
            }
        }
        ArrayList<GitItem> items = new ArrayList<GitItem>();
        NodeList nl = changeSet.getElementsByTagName("item");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element itemXML = (Element)nl.item(i);
            Element idE = XMLUtil.findElement((Element)itemXML, (String)"id", null);
            if (idE == null || !XMLUtil.findText((Node)idE).matches("[0-9a-f]{40}")) {
                return null;
            }
            items.add(new GitItem(itemXML));
        }
        if (items.isEmpty()) {
            return null;
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    static URI getRemoteOrigin(URI repository, @NullAllowed HudsonJob job) {
        assert (repository.toString().endsWith("/"));
        URI cfg = repository.resolve(".git/config");
        String origin = null;
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(HudsonGitSCM.class.getClassLoader());
        try {
            ConnectionBuilder cb = new ConnectionBuilder();
            if (job != null) {
                cb = cb.job(job);
            }
            InputStream is = cb.url(cfg.toURL()).connection().getInputStream();
            try {
                Ini ini = new Ini(is);
                Profile.Section section = (Profile.Section)ini.get((Object)"remote \"origin\"");
                if (section != null) {
                    origin = (String)section.get((Object)"url");
                }
            }
            finally {
                is.close();
            }
        }
        catch (InvalidFileFormatException x) {
            LOG.log(Level.FINE, "{0} was malformed, perhaps no workspace: {1}", new Object[]{cfg, x});
            URI is = null;
            return is;
        }
        catch (FileNotFoundException x) {
            LOG.log(Level.FINE, "{0} not found", cfg);
            URI is = null;
            return is;
        }
        catch (Exception x) {
            LOG.log(Level.WARNING, "Could not parse " + cfg, x);
            URI is = null;
            return is;
        }
        finally {
            Thread.currentThread().setContextClassLoader(l);
        }
        if (origin == null) {
            LOG.log(Level.FINE, "{0} does not specify remote under name ''origin''", cfg);
            return null;
        }
        Matcher m = Pattern.compile("([^@:/]+@[^/:]+):(.+)").matcher(origin);
        if (m.matches()) {
            origin = "ssh://" + m.group(1) + "/" + m.group(2);
        }
        try {
            return new URI(origin);
        }
        catch (URISyntaxException x) {
            LOG.log(Level.FINE, "could not load origin from {0}: {1}", new Object[]{cfg, x});
            return null;
        }
    }

    @CheckForNull
    static String roReplacement(String url) {
        String prefix = "ssh://git@github.com/";
        if (url.startsWith(prefix)) {
            return "git://github.com/" + url.substring(prefix.length());
        }
        Matcher m = Pattern.compile("ssh://.+@git[.]((?:kenai[.]com|java[.]net).+)").matcher(url);
        if (m.matches()) {
            return "git://" + m.group(1);
        }
        return null;
    }
}

