/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteServices;
import org.netbeans.modules.debugger.jpda.visual.breakpoints.AWTComponentBreakpointImpl;
import org.netbeans.modules.debugger.jpda.visual.ui.ScreenshotComponent;
import org.openide.util.Exceptions;

public class VisualDebuggerListener
extends DebuggerManagerAdapter {
    private static final Logger logger = Logger.getLogger(VisualDebuggerListener.class.getName());
    private static final Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> componentsAndStackTraces = new WeakHashMap<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>>();
    private Collection<Breakpoint> trackComponentBreakpoints = new ArrayList<Breakpoint>();

    public void engineAdded(DebuggerEngine engine) {
        final JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA.visual");
        boolean uploadAgent = p.getBoolean("UploadAgent", true);
        logger.log(Level.FINE, "engineAdded({0}), debugger = {1}, uploadAgent = {2}", new Object[]{engine, debugger, uploadAgent});
        if (debugger != null && uploadAgent) {
            final AtomicBoolean inited = new AtomicBoolean(false);
            final MethodBreakpoint[] mb = new MethodBreakpoint[]{MethodBreakpoint.create((String)"java.awt.EventQueue", (String)"getNextEvent"), MethodBreakpoint.create((String)"com.sun.javafx.tk.quantum.QuantumToolkit", (String)"pulse")};
            mb[0].setBreakpointType(1);
            mb[0].setSuspend(1);
            mb[0].setHidden(true);
            mb[0].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[0]);
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[1]);
                        if (inited.compareAndSet(false, true)) {
                            VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.AWT);
                        }
                    }
                    event.resume();
                }
            });
            mb[1].setBreakpointType(1);
            mb[1].setSuspend(1);
            mb[1].setHidden(true);
            mb[1].addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    if (debugger.equals(event.getDebugger())) {
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[0]);
                        DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)mb[1]);
                        if (inited.compareAndSet(false, true)) {
                            VisualDebuggerListener.this.initDebuggerRemoteService(event.getThread(), RemoteServices.ServiceType.FX);
                        }
                    }
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[0]);
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb[1]);
        }
        boolean trackComponentChanges = p.getBoolean("TrackComponentChanges", true);
        if (debugger != null && trackComponentChanges) {
            MethodBreakpoint cmb = MethodBreakpoint.create((String)"java.awt.Component", (String)"createHierarchyEvents");
            cmb.setHidden(true);
            cmb.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    VisualDebuggerListener.componentParentChanged(debugger, event, RemoteServices.ServiceType.AWT);
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)cmb);
            this.trackComponentBreakpoints.add((Breakpoint)cmb);
            MethodBreakpoint mb = MethodBreakpoint.create((String)"javafx.scene.Node", (String)"setParent");
            mb.setHidden(true);
            mb.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent event) {
                    VisualDebuggerListener.componentParentChanged(debugger, event, RemoteServices.ServiceType.FX);
                    event.resume();
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
            this.trackComponentBreakpoints.add((Breakpoint)mb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initDebuggerRemoteService(JPDAThread thread, RemoteServices.ServiceType sType) {
        JPDAThreadImpl t;
        block35: {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "initDebuggerRemoteService({0})", thread);
            }
            t = (JPDAThreadImpl)thread;
            Lock writeLock = t.accessLock.writeLock();
            writeLock.lock();
            try {
                ClassObjectReference cor = null;
                try {
                    cor = RemoteServices.uploadBasicClasses(t, sType);
                }
                catch (PropertyVetoException pvex) {
                    Exceptions.printStackTrace((Throwable)pvex);
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    InvocationExceptionTranslated iextr = new InvocationExceptionTranslated(ex, t.getDebugger());
                    iextr.setPreferredThread(t);
                    iextr.getMessage();
                    iextr.getLocalizedMessage();
                    iextr.getCause();
                    iextr.getStackTrace();
                    Exceptions.printStackTrace((Throwable)iextr);
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Uploaded class = {0}", cor);
                }
                if (cor == null) {
                    return;
                }
                ThreadReference tr = t.getThreadReference();
                if (sType == RemoteServices.ServiceType.FX) {
                    VisualDebuggerListener.setFxDebug(tr.virtualMachine(), tr);
                }
                ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)cor);
                Method startMethod = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"startAccessLoop", (String)"()V");
                try {
                    t.notifyMethodInvoking();
                    ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)tr, (Method)startMethod, (List)Collections.EMPTY_LIST, (int)1);
                }
                catch (VMDisconnectedExceptionWrapper vmd) {
                    t.notifyMethodInvokeDone();
                    ObjectReferenceWrapper.enableCollection((ObjectReference)cor);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    break block35;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    t.notifyMethodInvokeDone();
                    ObjectReferenceWrapper.enableCollection((ObjectReference)cor);
                }
            }
            catch (InternalExceptionWrapper iex) {
            }
            catch (ClassNotPreparedExceptionWrapper cnpex) {
                Exceptions.printStackTrace((Throwable)cnpex);
            }
            catch (ObjectCollectedExceptionWrapper collex) {
            }
            catch (UnsupportedOperationExceptionWrapper uex) {
                logger.log(Level.INFO, uex.getLocalizedMessage(), uex);
            }
            catch (VMDisconnectedExceptionWrapper vmd) {
            }
            finally {
                writeLock.unlock();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                logger.fine("The RemoteServiceClass is there: " + RemoteServices.getClass(t.getThreadReference().virtualMachine(), "org.netbeans.modules.debugger.jpda.visual.remote.RemoteService"));
            }
            catch (Exception ex) {
                logger.log(Level.FINE, "", ex);
            }
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        ScreenshotComponent.closeScreenshots(engine);
        JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
        logger.fine("engineRemoved(" + engine + "), debugger = " + debugger);
        if (debugger != null) {
            this.stopDebuggerRemoteService(debugger);
        }
        if (!this.trackComponentBreakpoints.isEmpty()) {
            Iterator<Breakpoint> it = this.trackComponentBreakpoints.iterator();
            while (it.hasNext()) {
                DebuggerManager.getDebuggerManager().removeBreakpoint(it.next());
                it.remove();
            }
        }
    }

    private void stopDebuggerRemoteService(JPDADebugger d) {
        ClassObjectReference serviceClass = RemoteServices.getServiceClass(d);
        if (serviceClass == null) {
            return;
        }
        try {
            serviceClass.enableCollection();
        }
        catch (VMDisconnectedException vdex) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaComponentInfo.Stack getStackOf(JPDADebugger debugger, ObjectReference component) {
        Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
        synchronized (map) {
            Map<ObjectReference, JavaComponentInfo.Stack> cs = componentsAndStackTraces.get(debugger);
            if (cs != null) {
                return cs.get(component);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void componentParentChanged(JPDADebugger debugger, JPDABreakpointEvent event, RemoteServices.ServiceType serviceType) {
        ObjectReference component = null;
        ObjectReference[] parentPtr = null;
        try {
            if (RemoteServices.ServiceType.AWT.equals((Object)serviceType)) {
                parentPtr = new ObjectReference[]{null};
                component = AWTComponentBreakpointImpl.getComponentOfParentChanged(event, parentPtr);
            } else {
                JPDAThread t = event.getThread();
                JDIVariable v = (JDIVariable)t.getCallStack(0, 1)[0].getThisVariable();
                component = (ObjectReference)v.getJDIValue();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (component != null) {
            JavaComponentInfo.Stack stack;
            if (parentPtr != null && parentPtr[0] == null) {
                Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> ex = componentsAndStackTraces;
                synchronized (ex) {
                    Map<ObjectReference, JavaComponentInfo.Stack> componentAndStackTrace = componentsAndStackTraces.get(debugger);
                    if (componentAndStackTrace != null) {
                        componentAndStackTrace.remove(component);
                    }
                }
                return;
            }
            try {
                stack = new JavaComponentInfo.Stack(event.getThread().getCallStack());
            }
            catch (AbsentInformationException ex) {
                return;
            }
            Map<JPDADebugger, Map<ObjectReference, JavaComponentInfo.Stack>> map = componentsAndStackTraces;
            synchronized (map) {
                Map<ObjectReference, JavaComponentInfo.Stack> componentAndStackTrace = componentsAndStackTraces.get(debugger);
                if (componentAndStackTrace == null) {
                    componentAndStackTrace = new HashMap<ObjectReference, JavaComponentInfo.Stack>();
                    componentsAndStackTraces.put(debugger, componentAndStackTrace);
                }
                componentAndStackTrace.put(component, stack);
            }
        }
    }

    private static void setFxDebug(VirtualMachine vm, ThreadReference tr) {
        ClassType sysPropClass = VisualDebuggerListener.getClass(vm, tr, "com.sun.javafx.runtime.SystemProperties");
        try {
            Field debugFld = ReferenceTypeWrapper.fieldByName((ReferenceType)sysPropClass, (String)"isDebug");
            sysPropClass.setValue(debugFld, VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
        }
        catch (VMDisconnectedExceptionWrapper vmdex) {
        }
        catch (InternalExceptionWrapper iex) {
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static ClassType getClass(VirtualMachine vm, ThreadReference tr, String name) {
        ReferenceType t = VisualDebuggerListener.getType(vm, tr, name);
        if (t instanceof ClassType) {
            return (ClassType)t;
        }
        logger.log(Level.WARNING, "{0} is not a class but {1}", new Object[]{name, t});
        return null;
    }

    private static ReferenceType getType(VirtualMachine vm, ThreadReference tr, String name) {
        try {
            List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
            if (!classList.isEmpty()) {
                return (ReferenceType)classList.iterator().next();
            }
            List classClassList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)"java.lang.Class");
            if (classClassList.isEmpty()) {
                throw new IllegalStateException("Cannot load class Class");
            }
            ClassType cls = (ClassType)classClassList.iterator().next();
            Method m = ClassTypeWrapper.concreteMethodByName((ClassType)cls, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            StringReference mirrorOfName = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (String)name);
            try {
                cls.invokeMethod(tr, m, Collections.singletonList(mirrorOfName), 1);
                List classList2 = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
                if (!classList2.isEmpty()) {
                    return (ReferenceType)classList2.iterator().next();
                }
            }
            catch (InvalidTypeException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (ClassNotLoadedException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (IncompatibleThreadStateException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
            catch (InvocationException ex) {
                logger.log(Level.FINE, "Cannot load class " + name, ex);
            }
        }
        catch (ClassNotPreparedExceptionWrapper ex) {
            logger.log(Level.FINE, "Not prepared class ", ex);
        }
        catch (UnsupportedOperationExceptionWrapper uoex) {
        }
        catch (InternalExceptionWrapper iex) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return null;
    }
}

