/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ArrayReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ArrayTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ClassTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.MethodWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeComponentWrapper;
import org.netbeans.modules.debugger.jpda.jdi.TypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.visual.JavaComponentInfo;
import org.netbeans.modules.debugger.jpda.visual.RemoteAWTScreenshot;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class RemoteServices {
    private static final Logger logger = Logger.getLogger(RemoteServices.class.getName());
    private static final String REMOTE_CLASSES_ZIPFILE = "/org/netbeans/modules/debugger/jpda/visual/resources/debugger-remote.zip";
    private static final Map<JPDADebugger, ClassObjectReference> remoteServiceClasses = new WeakHashMap<JPDADebugger, ClassObjectReference>();
    private static final RequestProcessor AUTORESUME_AFTER_SUSPEND_RP = new RequestProcessor("Autoresume after suspend", 1);
    private static final Set<PropertyChangeListener> serviceListeners = new WeakSet();
    private static final Map<JPDAThread, RequestProcessor.Task> tasksByThreads = new WeakHashMap<JPDAThread, RequestProcessor.Task>();

    private RemoteServices() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServiceListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            serviceListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireServiceClass(JPDADebuggerImpl debugger) {
        PropertyChangeListener[] listeners;
        PropertyChangeEvent pche = new PropertyChangeEvent(RemoteServices.class, "serviceClass", null, debugger);
        Set<PropertyChangeListener> set = serviceListeners;
        synchronized (set) {
            listeners = serviceListeners.toArray(new PropertyChangeListener[0]);
        }
        for (PropertyChangeListener l : listeners) {
            l.propertyChange(pche);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference uploadBasicClasses(JPDAThreadImpl t, ServiceType sType) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, IOException, PropertyVetoException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper, ClassNotPreparedExceptionWrapper {
        ThreadReference tawt = t.getThreadReference();
        VirtualMachine vm = tawt.virtualMachine();
        ReferenceType threadType = tawt.referenceType();
        Method getContextCl = ClassTypeWrapper.concreteMethodByName((ClassType)((ClassType)threadType), (String)"getContextClassLoader", (String)"()Ljava/lang/ClassLoader;");
        t.notifyMethodInvoking();
        try {
            ObjectReference cl = (ObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)tawt, (ThreadReference)tawt, (Method)getContextCl, (List)Collections.EMPTY_LIST, (int)1);
            List<RemoteClass> remoteClasses = RemoteServices.getRemoteClasses();
            ClassObjectReference basicClass = null;
            for (RemoteClass rc : remoteClasses) {
                List classesByName;
                String className = rc.name;
                if (basicClass != null || className.indexOf(36) >= 0) continue;
                if ((sType != ServiceType.AWT || !className.contains("AWT")) && (sType != ServiceType.FX || !className.contains("FX")) || (classesByName = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)className)).isEmpty()) break;
                basicClass = ReferenceTypeWrapper.classObject((ReferenceType)((ReferenceType)classesByName.get(0)));
                break;
            }
            if (basicClass == null) {
                ClassType classLoaderClass = null;
                if (cl != null) {
                    classLoaderClass = (ClassType)ObjectReferenceWrapper.referenceType((ObjectReference)cl);
                } else {
                    classLoaderClass = RemoteServices.getClass(vm, ClassLoader.class.getName());
                    Method getSystemClassLoader = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"getSystemClassLoader", (String)"()Ljava/lang/ClassLoader;");
                    cl = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)classLoaderClass, (ThreadReference)tawt, (Method)getSystemClassLoader, (List)Collections.EMPTY_LIST, (int)1);
                }
                for (RemoteClass rc : remoteClasses) {
                    String className = rc.name;
                    if ((sType != ServiceType.AWT || !className.contains("AWT")) && (sType != ServiceType.FX || !className.contains("FX"))) continue;
                    ClassObjectReference theUploadedClass = null;
                    ArrayReference byteArray = RemoteServices.createTargetBytes(vm, rc.bytes);
                    StringReference nameMirror = null;
                    try {
                        Method defineClass = ClassTypeWrapper.concreteMethodByName((ClassType)classLoaderClass, (String)"defineClass", (String)"(Ljava/lang/String;[BII)Ljava/lang/Class;");
                        boolean uploaded = false;
                        while (!uploaded) {
                            nameMirror = VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (String)className);
                            try {
                                ObjectReferenceWrapper.disableCollection((ObjectReference)nameMirror);
                                uploaded = true;
                            }
                            catch (ObjectCollectedExceptionWrapper ocex) {}
                        }
                        uploaded = false;
                        while (!uploaded) {
                            theUploadedClass = (ClassObjectReference)ObjectReferenceWrapper.invokeMethod((ObjectReference)cl, (ThreadReference)tawt, (Method)defineClass, Arrays.asList(nameMirror, byteArray, vm.mirrorOf(0), vm.mirrorOf(rc.bytes.length)), (int)1);
                            if (basicClass == null && rc.name.indexOf(36) < 0) {
                                try {
                                    ObjectReferenceWrapper.disableCollection((ObjectReference)theUploadedClass);
                                    basicClass = theUploadedClass;
                                    uploaded = true;
                                }
                                catch (ObjectCollectedExceptionWrapper ocex) {}
                                continue;
                            }
                            uploaded = true;
                        }
                    }
                    catch (Throwable throwable) {
                        ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                        if (nameMirror != null) {
                            ObjectReferenceWrapper.enableCollection(nameMirror);
                        }
                        throw throwable;
                    }
                    ObjectReferenceWrapper.enableCollection((ObjectReference)byteArray);
                    if (nameMirror == null) continue;
                    ObjectReferenceWrapper.enableCollection((ObjectReference)nameMirror);
                }
            }
            if (basicClass != null) {
                ClassType theClass = RemoteServices.getClass(vm, Class.class.getName());
                Method newInstance = ClassTypeWrapper.concreteMethodByName((ClassType)theClass, (String)"newInstance", (String)"()Ljava/lang/Object;");
                ObjectReference newInstanceOfBasicClass = (ObjectReference)ObjectReferenceWrapper.invokeMethod(basicClass, (ThreadReference)tawt, (Method)newInstance, (List)Collections.EMPTY_LIST, (int)1);
                Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
                synchronized (map) {
                    remoteServiceClasses.put((JPDADebugger)t.getDebugger(), basicClass);
                }
                RemoteServices.fireServiceClass(t.getDebugger());
            }
            ClassObjectReference classObjectReference = basicClass;
            return classObjectReference;
        }
        finally {
            t.notifyMethodInvokeDone();
        }
    }

    private static void runOnBreakpoint(JPDAThread awtThread, String bpClass, String bpMethod, Runnable runnable, CountDownLatch latch) {
        MethodBreakpoint mb = MethodBreakpoint.create((String)bpClass, (String)bpMethod);
        JPDADebuggerImpl dbg = ((JPDAThreadImpl)awtThread).getDebugger();
        PropertyChangeListener[] listenerPtr = new PropertyChangeListener[]{null};
        mb.setBreakpointType(1);
        mb.setSuspend(1);
        mb.setHidden(true);
        mb.addJPDABreakpointListener(new JPDABreakpointListener((JPDADebugger)dbg, mb, listenerPtr, awtThread, runnable, latch){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            final /* synthetic */ JPDAThread val$awtThread;
            final /* synthetic */ Runnable val$runnable;
            final /* synthetic */ CountDownLatch val$latch;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
                this.val$awtThread = jPDAThread;
                this.val$runnable = runnable;
                this.val$latch = countDownLatch;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void breakpointReached(JPDABreakpointEvent event) {
                try {
                    if (!this.val$dbg.equals(event.getDebugger())) return;
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                    PropertyChangeListener listener = this.val$listenerPtr[0];
                    if (listener != null) {
                        this.val$dbg.removePropertyChangeListener("state", listener);
                        this.val$listenerPtr[0] = null;
                    }
                    try {
                        ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvoking();
                        this.val$runnable.run();
                        return;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        return;
                    }
                    finally {
                        ((JPDAThreadImpl)this.val$awtThread).notifyMethodInvokeDone();
                    }
                }
                finally {
                    event.resume();
                    this.val$latch.countDown();
                }
            }
        });
        PropertyChangeListener listener = new PropertyChangeListener((JPDADebugger)dbg, mb, listenerPtr){
            final /* synthetic */ JPDADebugger val$dbg;
            final /* synthetic */ MethodBreakpoint val$mb;
            final /* synthetic */ PropertyChangeListener[] val$listenerPtr;
            {
                this.val$dbg = jPDADebugger;
                this.val$mb = methodBreakpoint;
                this.val$listenerPtr = propertyChangeListenerArray;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.val$dbg.getState() == 4) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.val$mb);
                    this.val$dbg.removePropertyChangeListener("state", (PropertyChangeListener)this);
                    this.val$listenerPtr[0] = null;
                }
            }
        };
        dbg.addPropertyChangeListener("state", listener);
        listenerPtr[0] = listener;
        if (dbg.getState() != 4) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
        } else {
            dbg.removePropertyChangeListener("state", listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOnStoppedThread(JPDAThread thread, Runnable run, ServiceType sType) throws PropertyVetoException {
        block31: {
            JPDAThreadImpl t = (JPDAThreadImpl)thread;
            boolean wasSuspended = true;
            Lock lock = t.accessLock.writeLock();
            lock.lock();
            try {
                RequestProcessor.Task autoresumeTask;
                ThreadReference threadReference = t.getThreadReference();
                wasSuspended = t.isSuspended();
                if (!t.isSuspended() || !threadReference.isAtBreakpoint()) {
                    // empty if block
                }
                if (!t.isSuspended()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    lock.unlock();
                    lock = null;
                    switch (sType) {
                        case AWT: {
                            ClassObjectReference serviceClassObject;
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", "calledInAWT", run, latch);
                            VirtualMachine vm = ((JPDAThreadImpl)thread).getThreadReference().virtualMachine();
                            Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
                            synchronized (map) {
                                serviceClassObject = remoteServiceClasses.get(((JPDAThreadImpl)thread).getDebugger());
                            }
                            try {
                                ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                                Field awtAccess = ReferenceTypeWrapper.fieldByName((ReferenceType)serviceClass, (String)"awtAccess");
                                ClassTypeWrapper.setValue((ClassType)serviceClass, (Field)awtAccess, (Value)VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (boolean)true));
                            }
                            catch (InternalExceptionWrapper iex) {
                            }
                            catch (VMDisconnectedExceptionWrapper vmdex) {
                            }
                            catch (Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            break;
                        }
                        case FX: {
                            RemoteServices.runOnBreakpoint(thread, "org.netbeans.modules.debugger.jpda.visual.remote.RemoteFXService", "access", run, latch);
                        }
                    }
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    break block31;
                }
                if (!wasSuspended) {
                    AutoresumeTask resumeTask = new AutoresumeTask(t);
                    autoresumeTask = AUTORESUME_AFTER_SUSPEND_RP.create((Runnable)resumeTask);
                    Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                    synchronized (map) {
                        tasksByThreads.put(thread, autoresumeTask);
                    }
                }
                Map<JPDAThread, RequestProcessor.Task> map = tasksByThreads;
                synchronized (map) {
                    autoresumeTask = tasksByThreads.get(thread);
                }
                t.notifyMethodInvoking();
                if (autoresumeTask != null) {
                    autoresumeTask.schedule(Integer.MAX_VALUE);
                }
                try {
                    run.run();
                }
                finally {
                    t.notifyMethodInvokeDone();
                    if (autoresumeTask != null) {
                        autoresumeTask.schedule(500);
                    }
                }
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
    }

    public static List<RemoteListener> getAttachedListeners(final JavaComponentInfo ci, final boolean combineAllTypes) throws PropertyVetoException {
        final ArrayList<RemoteListener> rlisteners = new ArrayList<RemoteListener>();
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference component = ci.getComponent();
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            @Override
            public void run() {
                if (ci instanceof RemoteAWTScreenshot.AWTComponentInfo) {
                    RemoteServices.retrieveAttachedListeners(thread, component, rlisteners, combineAllTypes);
                } else {
                    RemoteServices.retrieveAttachedFXListeners(thread, component, rlisteners);
                }
            }
        }, ci instanceof RemoteAWTScreenshot.AWTComponentInfo ? ServiceType.AWT : ServiceType.FX);
        return rlisteners;
    }

    private static void retrieveAttachedListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners, boolean combineAllTypes) {
        ThreadReference t = thread.getThreadReference();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            HashMap<ObjectReference, RemoteListener> listenersByInstance = null;
            if (combineAllTypes) {
                listenersByInstance = new HashMap<ObjectReference, RemoteListener>();
            }
            for (Method m : visibleMethods) {
                String listenerType;
                Value result;
                block17: {
                    String name = TypeComponentWrapper.name((TypeComponent)m);
                    if (!name.startsWith("get") || !name.endsWith("Listeners") || MethodWrapper.argumentTypeNames((Method)m).size() > 0) continue;
                    try {
                        result = ObjectReferenceWrapper.invokeMethod((ObjectReference)component, (ThreadReference)t, (Method)m, (List)Collections.EMPTY_LIST, (int)1);
                    }
                    catch (ClassNotLoadedException cnlex) {
                        continue;
                    }
                    catch (InvocationException iex) {
                        Exceptions.printStackTrace((Throwable)iex);
                        continue;
                    }
                    listenerType = null;
                    try {
                        Type returnType = MethodWrapper.returnType((Method)m);
                        if (!(returnType instanceof ArrayType)) break block17;
                        ArrayType art = (ArrayType)returnType;
                        listenerType = ArrayTypeWrapper.componentTypeName((ArrayType)art);
                    }
                    catch (ClassNotLoadedException ex) {
                        continue;
                    }
                }
                if (listenerType == null) continue;
                ArrayReference array = (ArrayReference)result;
                List listeners = ArrayReferenceWrapper.getValues((ArrayReference)array);
                for (Value v : listeners) {
                    RemoteListener rl;
                    if (combineAllTypes && (rl = (RemoteListener)listenersByInstance.get((ObjectReference)v)) != null) {
                        rl.addType(listenerType);
                        continue;
                    }
                    rl = new RemoteListener(listenerType, (ObjectReference)v);
                    if (combineAllTypes) {
                        listenersByInstance.put((ObjectReference)v, rl);
                    }
                    rlisteners.add(rl);
                }
            }
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
        }
        catch (InternalExceptionWrapper iex) {
        }
        catch (VMDisconnectedExceptionWrapper vdex) {
        }
        catch (IncompatibleThreadStateException itsex) {
            Exceptions.printStackTrace((Throwable)itsex);
        }
        catch (InvalidTypeException itex) {
            Exceptions.printStackTrace((Throwable)itex);
        }
    }

    private static void retrieveAttachedFXListeners(JPDAThreadImpl thread, ObjectReference component, List<RemoteListener> rlisteners) {
        ThreadReference t = thread.getThreadReference();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            for (Method m : visibleMethods) {
                String listenerType;
                Value result;
                block15: {
                    String name;
                    block14: {
                        name = TypeComponentWrapper.name((TypeComponent)m);
                        if (!name.startsWith("getOn") || MethodWrapper.argumentTypeNames((Method)m).size() > 0) continue;
                        try {
                            result = ObjectReferenceWrapper.invokeMethod((ObjectReference)component, (ThreadReference)t, (Method)m, (List)Collections.EMPTY_LIST, (int)1);
                            if (result == null) {
                            }
                            break block14;
                        }
                        catch (ClassNotLoadedException cnlex) {
                        }
                        catch (InvocationException iex) {
                            Exceptions.printStackTrace((Throwable)iex);
                        }
                        continue;
                    }
                    listenerType = null;
                    try {
                        Type returnType = MethodWrapper.returnType((Method)m);
                        if (!TypeWrapper.name((Type)returnType).equals("javafx.event.EventHandler")) break block15;
                        listenerType = name.substring(5);
                    }
                    catch (ClassNotLoadedException ex) {
                        continue;
                    }
                }
                if (listenerType == null) continue;
                RemoteListener rl = new RemoteListener(listenerType, (ObjectReference)result);
                rlisteners.add(rl);
            }
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
        }
        catch (InternalExceptionWrapper iex) {
        }
        catch (VMDisconnectedExceptionWrapper vdex) {
        }
        catch (IncompatibleThreadStateException itsex) {
            Exceptions.printStackTrace((Throwable)itsex);
        }
        catch (InvalidTypeException itex) {
            Exceptions.printStackTrace((Throwable)itex);
        }
    }

    public static List<ReferenceType> getAttachableListeners(JavaComponentInfo ci) {
        ObjectReference component = ci.getComponent();
        ArrayList<ReferenceType> listenerClasses = new ArrayList<ReferenceType>();
        try {
            ReferenceType clazz = ObjectReferenceWrapper.referenceType((ObjectReference)component);
            List visibleMethods = ReferenceTypeWrapper.visibleMethods((ReferenceType)clazz);
            for (Method m : visibleMethods) {
                Type t;
                List argTypes;
                String name = TypeComponentWrapper.name((TypeComponent)m);
                if (!name.startsWith("add") || !name.endsWith("Listener")) continue;
                try {
                    argTypes = MethodWrapper.argumentTypes((Method)m);
                }
                catch (ClassNotLoadedException ex) {
                    continue;
                }
                if (argTypes.size() != 1 || !((t = (Type)argTypes.get(0)) instanceof ReferenceType)) continue;
                ReferenceType rt = (ReferenceType)t;
                String lname = ReferenceTypeWrapper.name((ReferenceType)rt);
                int i = lname.lastIndexOf(46);
                i = i < 0 ? 0 : ++i;
                int ii = lname.lastIndexOf(36, i);
                if (ii > i) {
                    i = ii + 1;
                }
                System.err.println("  getAttachableListeners() '" + name.substring(3) + "' should equal to '" + lname.substring(i) + "', lname = " + lname + ", i = " + i);
                if (!name.substring(3).equals(lname.substring(i))) continue;
                listenerClasses.add(rt);
            }
        }
        catch (ClassNotPreparedExceptionWrapper cnpex) {
        }
        catch (ObjectCollectedExceptionWrapper ocex) {
        }
        catch (InternalExceptionWrapper iex) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            // empty catch block
        }
        return listenerClasses;
    }

    public static ObjectReference attachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final LoggingListenerCallBack listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final ObjectReference[] listenerPtr = new ObjectReference[]{null};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                ThreadReference t = thread.getThreadReference();
                ObjectReference component = ci.getComponent();
                MethodBreakpoint mb = MethodBreakpoint.create((String)"org.netbeans.modules.debugger.jpda.visual.remote.RemoteAWTService", (String)"calledWithEventsData");
                mb.setBreakpointType(1);
                mb.setSuspend(1);
                mb.setHidden(true);
                mb.addJPDABreakpointListener(new JPDABreakpointListener(){

                    /*
                     * Exception decompiling
                     */
                    public void breakpointReached(JPDABreakpointEvent event) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)mb);
                Map map = remoteServiceClasses;
                synchronized (map) {
                    serviceClassObject = (ClassObjectReference)remoteServiceClasses.get(thread.getDebugger());
                }
                try {
                    ObjectReference theListener;
                    ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                    Method addLoggingListener = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"addLoggingListener", (String)"(Ljava/awt/Component;Ljava/lang/Class;)Ljava/lang/Object;");
                    listenerPtr[0] = theListener = (ObjectReference)ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)t, (Method)addLoggingListener, Arrays.asList(component, listenerClass), (int)1);
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    Exceptions.printStackTrace((Throwable)cnpex);
                }
                catch (InternalExceptionWrapper iex) {
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                }
                catch (VMDisconnectedExceptionWrapper vmdex) {
                    // empty catch block
                }
            }
        }, ServiceType.AWT);
        return listenerPtr[0];
    }

    public static boolean detachLoggingListener(final JavaComponentInfo ci, final ClassObjectReference listenerClass, final ObjectReference listener) throws PropertyVetoException {
        final JPDAThreadImpl thread = ci.getThread();
        final boolean[] retPtr = new boolean[]{false};
        RemoteServices.runOnStoppedThread((JPDAThread)thread, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassObjectReference serviceClassObject;
                ObjectReference component = ci.getComponent();
                ThreadReference t = thread.getThreadReference();
                Map map = remoteServiceClasses;
                synchronized (map) {
                    serviceClassObject = (ClassObjectReference)remoteServiceClasses.get(thread.getDebugger());
                }
                try {
                    ClassType serviceClass = (ClassType)ClassObjectReferenceWrapper.reflectedType((ClassObjectReference)serviceClassObject);
                    Method removeLoggingListener = ClassTypeWrapper.concreteMethodByName((ClassType)serviceClass, (String)"removeLoggingListener", (String)"(Ljava/awt/Component;Ljava/lang/Class;Ljava/lang/Object;)Z");
                    BooleanValue success = (BooleanValue)ClassTypeWrapper.invokeMethod((ClassType)serviceClass, (ThreadReference)t, (Method)removeLoggingListener, Arrays.asList(component, listenerClass, listener), (int)1);
                    retPtr[0] = success.value();
                }
                catch (InvalidTypeException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotLoadedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IncompatibleThreadStateException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ClassNotPreparedExceptionWrapper cnpex) {
                    Exceptions.printStackTrace((Throwable)cnpex);
                }
                catch (InternalExceptionWrapper iex) {
                }
                catch (ObjectCollectedExceptionWrapper ocex) {
                    Exceptions.printStackTrace((Throwable)ocex);
                }
                catch (VMDisconnectedExceptionWrapper vmdex) {
                    // empty catch block
                }
            }
        }, ServiceType.AWT);
        return retPtr[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassObjectReference getServiceClass(JPDADebugger debugger) {
        Map<JPDADebugger, ClassObjectReference> map = remoteServiceClasses;
        synchronized (map) {
            return remoteServiceClasses.get(debugger);
        }
    }

    static ClassType getClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        return (ClassType)clazz;
    }

    static ArrayType getArrayClass(VirtualMachine vm, String name) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        List classList = VirtualMachineWrapper.classesByName((VirtualMachine)vm, (String)name);
        ReferenceType clazz = null;
        for (ReferenceType c : classList) {
            if (ReferenceTypeWrapper.classLoader((ReferenceType)c) != null) continue;
            clazz = c;
            break;
        }
        return (ArrayType)clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RemoteClass> getRemoteClasses() throws IOException {
        InputStream in = RemoteServices.class.getResourceAsStream(REMOTE_CLASSES_ZIPFILE);
        try {
            ZipEntry ze;
            ZipInputStream zin = new ZipInputStream(in);
            ArrayList<RemoteClass> rcl = new ArrayList<RemoteClass>();
            while ((ze = zin.getNextEntry()) != null) {
                int r;
                int baseEnd;
                String name;
                int baseStart;
                String fileName = ze.getName();
                if (!fileName.endsWith(".class") || (baseStart = (name = fileName.substring(0, fileName.length() - ".class".length())).lastIndexOf(47)) < 0) continue;
                if ((baseEnd = name.indexOf(36, ++baseStart)) < 0) {
                    baseEnd = name.length();
                }
                RemoteClass rc = new RemoteClass();
                rc.name = name.replace('/', '.');
                int l = (int)ze.getSize();
                byte[] bytes = new byte[l];
                for (int num = 0; num < l; num += r) {
                    r = zin.read(bytes, num, l - num);
                    if (r >= 0) continue;
                    Exceptions.printStackTrace((Throwable)new IllegalStateException("Can not read full content of " + name + " entry. Length = " + l + ", read num = " + num));
                    break;
                }
                RemoteClass.access$102(rc, bytes);
                rcl.add(rc);
            }
            ArrayList<RemoteClass> arrayList = rcl;
            return arrayList;
        }
        finally {
            in.close();
        }
    }

    private static ArrayReference createTargetBytes(VirtualMachine vm, byte[] bytes) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper, UnsupportedOperationExceptionWrapper {
        ArrayType bytesArrayClass = RemoteServices.getArrayClass(vm, "byte[]");
        ArrayReference array = null;
        boolean disabledCollection = false;
        while (!disabledCollection) {
            array = ArrayTypeWrapper.newInstance((ArrayType)bytesArrayClass, (int)bytes.length);
            try {
                ObjectReferenceWrapper.disableCollection((ObjectReference)array);
                disabledCollection = true;
            }
            catch (ObjectCollectedExceptionWrapper ocex) {}
        }
        ArrayList<ByteValue> values = new ArrayList<ByteValue>(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            values.add(VirtualMachineWrapper.mirrorOf((VirtualMachine)vm, (byte)bytes[i]));
        }
        ArrayReferenceWrapper.setValues((ArrayReference)array, values);
        return array;
    }

    private static class AutoresumeTask
    implements Runnable,
    PropertyChangeListener {
        private static final int WAIT_TIME = 500;
        private volatile JPDAThreadImpl t;

        public AutoresumeTask(JPDAThreadImpl t) {
            this.t = t;
            t.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JPDAThreadImpl thread = this.t;
            if (thread == null) {
                return;
            }
            if ("suspended".equals(evt.getPropertyName()) && !"methodInvoke".equals(evt.getPropagationId())) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                logger.fine("AutoresumeTask: autoresume canceled, thread changed suspended state: suspended = " + thread.isSuspended());
                Map map = tasksByThreads;
                synchronized (map) {
                    tasksByThreads.remove(thread);
                }
                this.t = null;
            }
        }

        @Override
        public void run() {
            JPDAThreadImpl thread = this.t;
            this.t = null;
            if (thread != null) {
                thread.removePropertyChangeListener((PropertyChangeListener)this);
                thread.resume();
            }
        }
    }

    public static interface LoggingListenerCallBack {
        public void eventsData(JavaComponentInfo var1, String[] var2, String[] var3);
    }

    public static class RemoteListener {
        private String type;
        private List<String> allTypesList;
        private String[] allTypes;
        private ObjectReference l;

        public RemoteListener(String type, ObjectReference l) {
            this.type = type;
            this.l = l;
        }

        public String getType() {
            return this.type;
        }

        public void setAllTypes(String[] allTypes) {
            this.allTypes = allTypes;
        }

        private void addType(String listenerType) {
            if (this.allTypesList == null) {
                this.allTypesList = new ArrayList<String>();
                this.allTypesList.add(this.type);
            }
            this.allTypesList.add(listenerType);
        }

        public String[] getTypes() {
            if (this.allTypes == null) {
                this.allTypes = this.allTypesList != null ? this.allTypesList.toArray(new String[0]) : new String[]{this.type};
            }
            return this.allTypes;
        }

        public ObjectReference getListener() {
            return this.l;
        }

        public String toString() {
            return "RemoteListener(" + this.type + ")[" + this.l + "]";
        }
    }

    private static class RemoteClass {
        private String name;
        private byte[] bytes;

        private RemoteClass() {
        }

        static /* synthetic */ byte[] access$102(RemoteClass x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }
    }

    public static enum ServiceType {
        AWT,
        FX;

    }
}

