/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class UseSuperTypePanel
extends JPanel
implements CustomRefactoringPanel {
    private final UseSuperTypeRefactoring refactoring;
    private JLabel label;
    private JScrollPane listScrollPane;
    private JList superTypeList;

    public UseSuperTypePanel(UseSuperTypeRefactoring refactoring) {
        this.refactoring = refactoring;
        this.initComponents();
        TreePathHandle subType = refactoring.getTypeElement();
        String title = null;
        String className = RetoucheUtils.getSimpleName(subType);
        title = NbBundle.getMessage(UseSuperTypePanel.class, (String)"LBL_UseSyperTypeTitle", (Object)className);
        this.setName(title);
        this.superTypeList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, ((ElementHandle)value).getBinaryName(), index, isSelected, cellHasFocus);
                if (value instanceof ElementHandle) {
                    Icon i = ElementIcons.getElementIcon((ElementKind)((ElementHandle)value).getKind(), Collections.singleton(Modifier.PUBLIC));
                    this.setIcon(i);
                }
                return this;
            }
        });
        this.superTypeList.setModel(new DefaultComboBoxModel<ElementHandle<TypeElement>>(refactoring.getCandidateSuperTypes()));
        this.superTypeList.setSelectionMode(0);
        this.superTypeList.setSelectedIndex(0);
    }

    @Override
    public void requestFocus() {
        this.superTypeList.requestFocus();
    }

    public void initialize() {
    }

    public Component getComponent() {
        return this;
    }

    public ElementHandle getSuperType() {
        return (ElementHandle)this.superTypeList.getSelectedValue();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.listScrollPane = new JScrollPane();
        this.superTypeList = new JList();
        this.setMaximumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(300, 200));
        this.setLayout(new GridBagLayout());
        this.label.setLabelFor(this.superTypeList);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getBundle(UseSuperTypePanel.class).getString("LBL_UseSuperType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.label, gridBagConstraints);
        this.label.getAccessibleContext().setAccessibleDescription("N/A");
        this.superTypeList.setSelectionMode(0);
        this.listScrollPane.setViewportView(this.superTypeList);
        this.superTypeList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UseSuperTypePanel.class, (String)"ACSD_SupertypeToUse"));
        this.superTypeList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UseSuperTypePanel.class, (String)"ACSD_SupertypeToUseDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.listScrollPane, gridBagConstraints);
    }
}

