/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementHeaders;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EncapsulateFieldPanel
extends JPanel
implements CustomRefactoringPanel {
    private DefaultTableModel model;
    private TreePathHandle selectedObjects;
    private Collection<TreePathHandle> fields;
    private ChangeListener parent;
    private String classname;
    private static boolean ALWAYS_USE_ACCESSORS = true;
    private static int FIELD_ACCESS_INDEX = 3;
    private static int METHOD_ACCESS_INDEX = 0;
    private static final String ENCAPSULATE_FIELDS_JAVADOC_PREF = "ENCAPSULATE_FIELDS_JAVADOC";
    private static final String ENCAPSULATE_FIELDS_SORT_PREF = "ENCAPSULATE_FIELDS_SORT";
    private static final String[] modifierNames = new String[]{"public", "protected", "<default>", "private"};
    private static final String[] columnNames = new String[]{EncapsulateFieldPanel.getString("LBL_ColField"), "    ", EncapsulateFieldPanel.getString("LBL_ColGetter"), "    ", EncapsulateFieldPanel.getString("LBL_ColSetter")};
    private static final int MOD_PUBLIC_INDEX = 0;
    private static final int MOD_PROTECTED_INDEX = 1;
    private static final int MOD_DEFAULT_INDEX = 2;
    private static final int MOD_PRIVATE_INDEX = 3;
    private static final Class[] columnTypes = new Class[]{MemberInfo.class, Boolean.class, AccessorInfo.class, Boolean.class, AccessorInfo.class};
    private boolean initialized = false;
    private JButton jButtonSelectAll;
    private JButton jButtonSelectGetters;
    private JButton jButtonSelectNone;
    private JButton jButtonSelectSetters;
    private JCheckBox jCheckAccess;
    private JComboBox jComboAccess;
    private JComboBox jComboField;
    private JComboBox jComboInsertPoint;
    private JComboBox jComboJavadoc;
    private JComboBox jComboSort;
    private JLabel jLblAccessVis;
    private JLabel jLblFieldVis;
    private JLabel jLblInsertPoint;
    private JLabel jLblJavadoc;
    private JLabel jLblSort;
    private JLabel jLblTitle;
    private JScrollPane jScrollField;
    private JTable jTableFields;

    public EncapsulateFieldPanel(TreePathHandle selectedObject, Collection<TreePathHandle> fields, ChangeListener parent) {
        String title = EncapsulateFieldPanel.getString("LBL_TitleEncapsulateFields");
        this.selectedObjects = selectedObject;
        this.parent = parent;
        this.fields = fields;
        this.model = new TabM(columnNames, 0);
        this.initComponents();
        this.setName(title);
        this.jCheckAccess.setSelected(ALWAYS_USE_ACCESSORS);
        this.jComboAccess.setSelectedIndex(METHOD_ACCESS_INDEX);
        this.jComboField.setSelectedIndex(FIELD_ACCESS_INDEX);
        this.jTableFields.setDefaultRenderer(MemberInfo.class, new EncapsulateMemberInfoTableCellRenderer());
        this.jTableFields.setDefaultRenderer(AccessorInfo.class, new AccessorInfoRenderer());
        JavaSource js = JavaSource.forFileObject((FileObject)this.selectedObjects.getFileObject());
        this.jTableFields.setDefaultEditor(AccessorInfo.class, new AccessorInfoTableEditor(js));
        this.jScrollField.setBackground(this.jTableFields.getBackground());
        this.jScrollField.getViewport().setBackground(this.jTableFields.getBackground());
        this.jTableFields.setRowHeight(18);
        this.jTableFields.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        if (UIManager.getColor("control") != null) {
            this.jTableFields.setGridColor(UIManager.getColor("control"));
        }
        EncapsulateFieldPanel.initEnumCombo(this.jComboSort, SortBy.values()[RefactoringModule.getOption(ENCAPSULATE_FIELDS_SORT_PREF, SortBy.PAIRS.ordinal())]);
        EncapsulateFieldPanel.initEnumCombo(this.jComboJavadoc, Javadoc.values()[RefactoringModule.getOption(ENCAPSULATE_FIELDS_JAVADOC_PREF, Javadoc.DEFAULT.ordinal())]);
    }

    public Component getComponent() {
        return this;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        JavaSource js = JavaSource.forFileObject((FileObject)this.selectedObjects.getFileObject());
        try {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController javac) throws Exception {
                    javac.toPhase(JavaSource.Phase.RESOLVED);
                    EncapsulateFieldPanel.this.initialize(javac);
                }
            }, true);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void initialize(CompilationController javac) {
        TreePath selectedPath = this.selectedObjects.resolve((CompilationInfo)javac);
        Element selectedElm = javac.getTrees().getElement(selectedPath);
        int tableSelection = 0;
        for (VariableElement field : this.initFields(selectedPath, (CompilationInfo)javac)) {
            TreePath fieldTPath = javac.getTrees().getPath(field);
            boolean createGetter = this.fields != null ? this.fields.contains(TreePathHandle.create((Element)field, (CompilationInfo)javac)) : selectedElm == field;
            boolean createSetter = createGetter && !field.getModifiers().contains((Object)Modifier.FINAL);
            String getName = EncapsulateFieldRefactoringPlugin.computeGetterName(field);
            String setName = EncapsulateFieldRefactoringPlugin.computeSetterName(field);
            this.model.addRow(new Object[]{MemberInfo.create(fieldTPath, (CompilationInfo)javac), createGetter ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createGetter((CompilationInfo)javac, field, getName), createSetter ? Boolean.TRUE : Boolean.FALSE, AccessorInfo.createSetter((CompilationInfo)javac, field, setName)});
            if (!createGetter) continue;
            tableSelection = this.model.getRowCount() - 1;
        }
        this.packRows(this.jTableFields);
        this.setColumnWidth(1);
        this.setColumnWidth(3);
        this.jTableFields.changeSelection(tableSelection, 0, false, false);
        this.jTableFields.invalidate();
        this.jTableFields.repaint();
        this.model.addTableModelListener(new TableModelListener(){
            boolean isUpdating = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void tableChanged(TableModelEvent e) {
                if (this.isUpdating) {
                    return;
                }
                int col = e.getColumn();
                int row = e.getFirstRow();
                if (col == 1 || col == 3) {
                    AccessorInfo ai;
                    Boolean value = (Boolean)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                    if (value.booleanValue() && (ai = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(row, col + 1)) != null) {
                        ai.reset();
                    }
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.fireTableCellUpdated(row, col + 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                AccessorInfo value = (AccessorInfo)EncapsulateFieldPanel.this.model.getValueAt(row, col);
                if (!(this.isUpdating || value != null && value.name != null && value.name.length() != 0)) {
                    try {
                        this.isUpdating = true;
                        EncapsulateFieldPanel.this.model.setValueAt(Boolean.FALSE, row, col - 1);
                    }
                    finally {
                        this.isUpdating = false;
                    }
                }
                EncapsulateFieldPanel.this.parent.stateChanged(null);
            }
        });
        this.initInsertPoints(selectedPath, (CompilationInfo)javac);
        this.initialized = true;
    }

    private void setColumnWidth(int a) {
        TableColumn col = this.jTableFields.getColumnModel().getColumn(a);
        JCheckBox box = new JCheckBox();
        int width = (int)box.getPreferredSize().getWidth();
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        col.setMaxWidth(width);
        col.setResizable(false);
    }

    private int getMinimumRowHeight(JTable table, int rowIndex) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getMinimumSize().height;
            height = Math.max(height, h);
        }
        return height;
    }

    private void packRows(JTable table) {
        int max = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            int h = this.getMinimumRowHeight(table, r);
            if (h <= max) continue;
            max = h;
        }
        table.setRowHeight(max);
        table.getTableHeader().setPreferredSize(new Dimension(table.getTableHeader().getPreferredSize().width, max));
    }

    protected DefaultTableModel getTableModel() {
        return this.model;
    }

    private void initComponents() {
        this.jLblTitle = new JLabel();
        this.jButtonSelectAll = new JButton();
        this.jButtonSelectNone = new JButton();
        this.jButtonSelectGetters = new JButton();
        this.jButtonSelectSetters = new JButton();
        this.jLblInsertPoint = new JLabel();
        this.jComboInsertPoint = new JComboBox();
        this.jLblSort = new JLabel();
        this.jComboSort = new JComboBox();
        this.jLblJavadoc = new JLabel();
        this.jComboJavadoc = new JComboBox();
        this.jLblFieldVis = new JLabel();
        this.jComboField = new JComboBox();
        this.jLblAccessVis = new JLabel();
        this.jComboAccess = new JComboBox();
        this.jCheckAccess = new JCheckBox();
        this.jScrollField = new JScrollPane();
        this.jTableFields = new JTable();
        this.jLblTitle.setLabelFor(this.jTableFields);
        Mnemonics.setLocalizedText((JLabel)this.jLblTitle, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldList"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectAll, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.text"));
        this.jButtonSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectAllActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectNone, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.text"));
        this.jButtonSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectNoneActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectGetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.text"));
        this.jButtonSelectGetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectGettersActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonSelectSetters, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.text"));
        this.jButtonSelectSetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EncapsulateFieldPanel.this.jButtonSelectSettersActionPerformed(evt);
            }
        });
        this.jLblInsertPoint.setLabelFor(this.jComboInsertPoint);
        Mnemonics.setLocalizedText((JLabel)this.jLblInsertPoint, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblInsertPoint.text"));
        this.jLblSort.setLabelFor(this.jComboSort);
        Mnemonics.setLocalizedText((JLabel)this.jLblSort, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblSort.text"));
        this.jLblJavadoc.setLabelFor(this.jComboJavadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLblJavadoc, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jLblJavadoc.text"));
        this.jLblFieldVis.setLabelFor(this.jComboField);
        Mnemonics.setLocalizedText((JLabel)this.jLblFieldVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_FieldVis"));
        this.jComboField.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jLblAccessVis.setLabelFor(this.jComboAccess);
        Mnemonics.setLocalizedText((JLabel)this.jLblAccessVis, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessVis"));
        this.jComboAccess.setModel(new DefaultComboBoxModel<String>(modifierNames));
        this.jCheckAccess.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckAccess, (String)NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"LBL_AccessorsEven"));
        this.jTableFields.setModel(this.model);
        this.jTableFields.setCellSelectionEnabled(true);
        this.jTableFields.setSelectionMode(0);
        this.jTableFields.getTableHeader().setReorderingAllowed(false);
        this.jScrollField.setViewportView(this.jTableFields);
        this.jTableFields.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_jTableFields"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckAccess).addComponent(this.jLblTitle).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLblAccessVis).addComponent(this.jLblFieldVis).addComponent(this.jLblInsertPoint).addComponent(this.jLblSort).addComponent(this.jLblJavadoc)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jComboInsertPoint, -2, -1, -2).addComponent(this.jComboSort, -2, -1, -2).addComponent(this.jComboJavadoc, -2, -1, -2).addComponent(this.jComboField, -2, -1, -2).addComponent(this.jComboAccess, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollField, -1, 575, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonSelectSetters).addComponent(this.jButtonSelectNone).addComponent(this.jButtonSelectAll).addComponent(this.jButtonSelectGetters)))).addContainerGap()));
        layout.linkSize(0, this.jButtonSelectAll, this.jButtonSelectGetters, this.jButtonSelectNone, this.jButtonSelectSetters);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButtonSelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectNone).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectGetters).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonSelectSetters)).addComponent(this.jScrollField, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblInsertPoint).addComponent(this.jComboInsertPoint, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblSort).addComponent(this.jComboSort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblJavadoc).addComponent(this.jComboJavadoc, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblFieldVis).addComponent(this.jComboField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLblAccessVis).addComponent(this.jComboAccess, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckAccess).addContainerGap()));
        this.jButtonSelectAll.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectAll.acsd"));
        this.jButtonSelectNone.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectNone.acsd"));
        this.jButtonSelectGetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectGetters.acsd"));
        this.jButtonSelectSetters.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jButtonSelectSetters.acsd"));
        this.jComboInsertPoint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboInsertPoint.acsd"));
        this.jComboSort.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboSort.acsd"));
        this.jComboJavadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"EncapsulateFieldPanel.jComboJavadoc.acsd"));
        this.jComboField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_fieldModifiers"));
        this.jComboAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_methodAcc"));
        this.jCheckAccess.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"ACSD_useAccessors"));
    }

    private void jButtonSelectAllActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 1, 3);
    }

    private void jButtonSelectNoneActionPerformed(ActionEvent evt) {
        this.makeSelection(false, 1, 3);
    }

    private void jButtonSelectGettersActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 1);
    }

    private void jButtonSelectSettersActionPerformed(ActionEvent evt) {
        this.makeSelection(true, 3);
    }

    private static String getString(String key) {
        return NbBundle.getMessage(EncapsulateFieldPanel.class, (String)key);
    }

    private static <E extends Enum<E>> void initEnumCombo(JComboBox combo, E defValue) {
        Vector enumList = new Vector(EnumSet.allOf(defValue.getClass()));
        Collections.sort(enumList, (Comparator)((Object)defValue));
        combo.setModel(new DefaultComboBoxModel(enumList));
        combo.setSelectedItem(defValue);
    }

    private void makeSelection(boolean state, int ... columns) {
        for (int row = 0; row < this.model.getRowCount(); ++row) {
            for (int col : columns) {
                boolean value = (Boolean)this.model.getValueAt(row, col);
                if (state == value) continue;
                this.model.setValueAt(state, row, col);
            }
        }
    }

    private List<VariableElement> initFields(TreePath selectedField, CompilationInfo javac) {
        Element elm = javac.getTrees().getElement(selectedField);
        TypeElement encloser = null;
        encloser = ElementKind.FIELD == elm.getKind() ? (TypeElement)elm.getEnclosingElement() : (TypeElement)elm;
        ArrayList<VariableElement> result = new ArrayList<VariableElement>();
        for (Element element : encloser.getEnclosedElements()) {
            if (ElementKind.FIELD != element.getKind()) continue;
            result.add((VariableElement)element);
        }
        this.classname = encloser.getQualifiedName().toString();
        String title = " - " + this.classname;
        this.setName(this.getName() + title);
        return result;
    }

    private void initInsertPoints(TreePath selectedField, CompilationInfo javac) {
        Element elm = javac.getTrees().getElement(selectedField);
        TypeElement encloser = null;
        encloser = ElementKind.FIELD == elm.getKind() ? (TypeElement)elm.getEnclosingElement() : (TypeElement)elm;
        ArrayList<InsertPoint> result = new ArrayList<InsertPoint>();
        int idx = 0;
        TreePath encloserPath = javac.getTrees().getPath(encloser);
        ClassTree encloserTree = (ClassTree)encloserPath.getLeaf();
        for (Tree tree : encloserTree.getMembers()) {
            Element member;
            if (tree.getKind() == Tree.Kind.METHOD && (member = javac.getTrees().getElement(new TreePath(encloserPath, tree))) != null && !javac.getElementUtilities().isSynthetic(member)) {
                InsertPoint ip = new InsertPoint(idx + 1, NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldInsertPointMethod", (Object)MemberInfo.create(member, javac).getHtmlText()));
                result.add(ip);
            }
            ++idx;
        }
        this.jComboInsertPoint.addItem(InsertPoint.DEFAULT);
        if (!result.isEmpty()) {
            this.jComboInsertPoint.addItem(new InsertPoint(((InsertPoint)result.get(0)).index - 1, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.first")));
            this.jComboInsertPoint.addItem(new InsertPoint(((InsertPoint)result.get(result.size() - 1)).index, EncapsulateFieldPanel.getString("EncapsulateFieldPanel.jComboInsertPoint.last")));
            for (InsertPoint insertPoint : result) {
                this.jComboInsertPoint.addItem(insertPoint);
            }
        }
        this.jComboInsertPoint.setSelectedItem(InsertPoint.DEFAULT);
    }

    public Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> getAllFields() {
        ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> result = new ArrayList<EncapsulateFieldsRefactoring.EncapsulateFieldInfo>();
        Vector<Vector> rows = this.model.getDataVector();
        for (List list : rows) {
            String setterName;
            String getterName = (Boolean)list.get(1) != false ? ((AccessorInfo)list.get((int)2)).name : null;
            String string = setterName = (Boolean)list.get(3) != false ? ((AccessorInfo)list.get((int)4)).name : null;
            if (getterName == null && setterName == null) continue;
            MemberInfo mi = (MemberInfo)list.get(0);
            result.add(new EncapsulateFieldsRefactoring.EncapsulateFieldInfo((TreePathHandle)mi.getElementHandle(), "".equals(getterName) ? null : getterName, "".equals(setterName) ? null : setterName));
        }
        return result;
    }

    public boolean isCheckAccess() {
        ALWAYS_USE_ACCESSORS = this.jCheckAccess.isSelected();
        return ALWAYS_USE_ACCESSORS;
    }

    public Set<Modifier> getFieldModifiers() {
        FIELD_ACCESS_INDEX = this.jComboField.getSelectedIndex();
        Modifier mod = this.getModifier(FIELD_ACCESS_INDEX);
        if (mod == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(mod);
    }

    public Set<Modifier> getMethodModifiers() {
        METHOD_ACCESS_INDEX = this.jComboAccess.getSelectedIndex();
        Modifier mod = this.getModifier(METHOD_ACCESS_INDEX);
        if (mod == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(mod);
    }

    private Modifier getModifier(int index) {
        switch (index) {
            case 3: {
                return Modifier.PRIVATE;
            }
            case 2: {
                return null;
            }
            case 1: {
                return Modifier.PROTECTED;
            }
            case 0: {
                return Modifier.PUBLIC;
            }
        }
        throw new IllegalStateException("unknown index: " + index);
    }

    public InsertPoint getInsertPoint() {
        return (InsertPoint)this.jComboInsertPoint.getSelectedItem();
    }

    public SortBy getSortBy() {
        SortBy sortby = (SortBy)this.jComboSort.getSelectedItem();
        RefactoringModule.setOption(ENCAPSULATE_FIELDS_SORT_PREF, sortby.ordinal());
        return sortby;
    }

    public Javadoc getJavadoc() {
        Javadoc javadoc = (Javadoc)this.jComboJavadoc.getSelectedItem();
        RefactoringModule.setOption(ENCAPSULATE_FIELDS_JAVADOC_PREF, javadoc.ordinal());
        return javadoc;
    }

    String getClassname() {
        return this.classname;
    }

    private static final class AccessorInfoTableEditor
    extends DefaultCellEditor
    implements Task<CompilationController> {
        private AccessorInfo ai;
        private JavaSource js;

        public AccessorInfoTableEditor(JavaSource js) {
            super(new JTextField());
            this.js = js;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.ai = (AccessorInfo)value;
            String cellEditorValue = this.ai == null ? null : this.ai.name;
            return super.getTableCellEditorComponent(table, cellEditorValue, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            AccessorInfo retVal;
            String cellEditorValue = (String)super.getCellEditorValue();
            if (cellEditorValue == null || cellEditorValue.length() == 0) {
                if (this.ai != null && this.ai.name != null && this.ai.name.length() > 0) {
                    this.ai.name = null;
                    this.ai.accessor = null;
                    this.ai.accessorToolTip = null;
                }
                retVal = this.ai;
            } else {
                if (!cellEditorValue.equals(this.ai.name)) {
                    this.computeNewValue();
                }
                retVal = this.ai;
            }
            return retVal;
        }

        private void computeNewValue() {
            try {
                this.js.runUserActionTask((Task)this, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public void run(CompilationController javac) throws Exception {
            AccessorInfo desc = this.ai;
            if (desc == null) {
                return;
            }
            desc.setName((CompilationInfo)javac, ((String)super.getCellEditorValue()).trim());
        }
    }

    private static final class AccessorInfoRenderer
    extends UIUtilities.JavaElementTableCellRenderer {
        private AccessorInfoRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o;
            AccessorInfo ai = (AccessorInfo)value;
            String newValue = ai == null ? null : (ai.accessor == null ? ai.name : ai.accessor);
            Component renderer = super.getTableCellRendererComponent(table, newValue, isSelected, hasFocus, row, column);
            String toolTip = ai != null && table.isCellEditable(row, column) ? ai.accessorToolTip : null;
            boolean isEnabled = (Boolean)table.getModel().getValueAt(row, column - 1);
            this.setEnabled(isEnabled);
            if (isEnabled && ai != null && !ai.isGetter && ((MemberInfo)table.getValueAt(row, 0)).getModifiers().contains((Object)Modifier.FINAL) && (o = UIManager.getDefaults().get("nb.errorForeground")) instanceof Color) {
                this.setBorder(BorderFactory.createLineBorder((Color)o));
                String warning = NbBundle.getMessage(EncapsulateFieldPanel.class, (String)"MSG_EncapsulateFieldFinalFieldWarning");
                toolTip = toolTip == null ? warning : String.format("<html>%s<br>%s</html>", warning, toolTip);
            }
            this.setToolTipText(toolTip);
            return renderer;
        }
    }

    private static final class EncapsulateMemberInfoTableCellRenderer
    extends UIUtilities.JavaElementTableCellRenderer {
        private EncapsulateMemberInfoTableCellRenderer() {
        }

        @Override
        protected String extractText(Object value) {
            String s = super.extractText(value);
            s = s != null && value instanceof MemberInfo && ((MemberInfo)value).getModifiers().contains((Object)Modifier.FINAL) ? s + " : final" : s;
            return s;
        }
    }

    public static final class InsertPoint {
        public static final InsertPoint DEFAULT = new InsertPoint(Integer.MIN_VALUE, EncapsulateFieldPanel.access$1100("EncapsulateFieldPanel.jComboInsertPoint.default"));
        private int index;
        private String description;

        private InsertPoint(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Javadoc implements Comparator<Javadoc>
    {
        DEFAULT("EncapsulateFieldPanel.jComboJavadoc.createDefault"),
        NONE("EncapsulateFieldPanel.jComboJavadoc.none"),
        COPY("EncapsulateFieldPanel.jComboJavadoc.copy");

        private final String displayName;

        private Javadoc(String key) {
            this.displayName = EncapsulateFieldPanel.getString(key);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(Javadoc o1, Javadoc o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    public static enum SortBy implements Comparator<SortBy>
    {
        PAIRS("EncapsulateFieldPanel.jComboSort.pairs"),
        ALPHABETICALLY("EncapsulateFieldPanel.jComboSort.alphabetically"),
        GETTERS_FIRST("EncapsulateFieldPanel.jComboSort.gettersFirst");

        private final String displayName;

        private SortBy(String key) {
            this.displayName = EncapsulateFieldPanel.getString(key);
        }

        public String toString() {
            return this.displayName;
        }

        @Override
        public int compare(SortBy o1, SortBy o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static final class AccessorInfo {
        String defaultName;
        MemberInfo<ElementHandle<ExecutableElement>> defaultAccessor;
        String name;
        String accessorToolTip;
        String defaultAccessorToolTip;
        MemberInfo<ElementHandle<ExecutableElement>> accessor;
        private ElementHandle<VariableElement> fieldHandle;
        private boolean isGetter;

        private AccessorInfo() {
        }

        public static AccessorInfo createGetter(CompilationInfo javac, VariableElement field, String proposedName) {
            ExecutableElement getter = EncapsulateFieldRefactoringPlugin.findMethod(javac, (TypeElement)field.getEnclosingElement(), proposedName, Collections.emptyList(), true);
            return AccessorInfo.create(javac, field, getter, proposedName, true);
        }

        public static AccessorInfo createSetter(CompilationInfo javac, VariableElement field, String proposedName) {
            ExecutableElement setter = EncapsulateFieldRefactoringPlugin.findMethod(javac, (TypeElement)field.getEnclosingElement(), proposedName, Collections.singletonList(field), true);
            return AccessorInfo.create(javac, field, setter, proposedName, false);
        }

        private static AccessorInfo create(CompilationInfo javac, VariableElement field, ExecutableElement method, String proposedName, boolean isGetter) {
            AccessorInfo ai = new AccessorInfo();
            ai.name = ai.defaultName = proposedName;
            ai.defaultAccessor = method != null ? MemberInfo.create(method, javac) : null;
            ai.accessor = ai.defaultAccessor;
            ai.defaultAccessorToolTip = method != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)ElementHeaders.getHeader((Element)method.getEnclosingElement(), (CompilationInfo)javac, (String)"%name%")) : null;
            ai.accessorToolTip = ai.defaultAccessorToolTip;
            ai.isGetter = isGetter;
            ai.fieldHandle = ElementHandle.create((Element)field);
            return ai;
        }

        public void reset() {
            this.name = this.defaultName;
            this.accessor = this.defaultAccessor;
            this.accessorToolTip = this.defaultAccessorToolTip;
        }

        public void setName(CompilationInfo javac, String s) {
            this.name = s;
            VariableElement field = (VariableElement)this.fieldHandle.resolve(javac);
            ExecutableElement method = null;
            method = this.isGetter ? EncapsulateFieldRefactoringPlugin.findMethod(javac, (TypeElement)field.getEnclosingElement(), s, Collections.emptyList(), true) : EncapsulateFieldRefactoringPlugin.findMethod(javac, (TypeElement)field.getEnclosingElement(), s, Collections.singletonList(field), true);
            MemberInfo<ElementHandle<ExecutableElement>> memberInfo = this.accessor = method != null ? MemberInfo.create(method, javac) : null;
            this.accessorToolTip = method != null ? NbBundle.getMessage(EncapsulateFieldPanel.class, (String)(this.isGetter ? "MSG_EncapsulateFieldDeclaredGetter" : "MSG_EncapsulateFieldDeclaredSetter"), (Object)ElementHeaders.getHeader((Element)method.getEnclosingElement(), (CompilationInfo)javac, (String)"%name%")) : null;
        }
    }

    private static class TabM
    extends DefaultTableModel {
        public TabM(Object[] columnNames, int rowCount) {
            super(columnNames, rowCount);
        }

        public Class getColumnClass(int columnIndex) {
            return columnTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            if (column == 1 || column == 3) {
                return true;
            }
            return (Boolean)this.getValueAt(row, column - 1);
        }
    }
}

